/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.StringUtilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import java.io.File;

public class Problem
implements IElementObject {
    public static final String INTERNAL_VALIDATOR_NAME = "pc2.jar edu.csus.ecs.pc2.validator.Validator";
    private static final long serialVersionUID = 1708763261096488240L;
    public static final int DEFAULT_TIMEOUT_SECONDS = 30;
    private String displayName = null;
    private ElementId elementId = null;
    private int number;
    private String dataFileName = null;
    private String answerFileName = null;
    private String[] testCaseDataFilenames = new String[0];
    private String[] testCaseAnswerFilenames = new String[0];
    private boolean active = true;
    private boolean readInputDataFromSTDIN = false;
    private int timeOutInSeconds = 30;
    private boolean validatedProblem = false;
    private boolean usingPC2Validator = false;
    private int whichPC2Validator = 0;
    private String validatorCommandLine;
    private String validatorProgramName;
    private boolean internationalJudgementReadMethod = true;
    private String executionPrepCommand = null;
    private boolean ccsMode = false;
    private boolean ignoreSpacesOnValidation = false;
    private boolean showValidationToJudges = false;
    private boolean hideOutputWindow = false;
    private boolean showCompareWindow = false;
    private boolean computerJudged = false;
    private boolean manualReview = false;
    private boolean prelimaryNotification = false;
    private String shortName = "";
    private String letter = null;
    private String colorName;
    private String colorRGB;
    private boolean usingExternalDataFiles = false;
    private String externalDataFileLocation = null;
    private State state = State.ENABLED;

    public Problem(String displayName) {
        this.displayName = displayName;
        this.elementId = new ElementId(displayName);
        this.setSiteNumber(0);
    }

    public Problem copy(String newDisplayName) {
        Problem clone = new Problem(newDisplayName);
        clone.setSiteNumber(this.getSiteNumber());
        clone.setDisplayName(newDisplayName);
        clone.setNumber(this.getNumber());
        clone.setDataFileName(StringUtilities.cloneString(this.dataFileName));
        clone.setAnswerFileName(StringUtilities.cloneString(this.answerFileName));
        clone.setActive(this.isActive());
        clone.setReadInputDataFromSTDIN(this.isReadInputDataFromSTDIN());
        clone.setTimeOutInSeconds(this.getTimeOutInSeconds());
        clone.setValidatedProblem(this.isValidatedProblem());
        clone.setUsingPC2Validator(this.isUsingPC2Validator());
        clone.setWhichPC2Validator(this.getWhichPC2Validator());
        clone.setValidatorCommandLine(StringUtilities.cloneString(this.validatorCommandLine));
        clone.setValidatorProgramName(StringUtilities.cloneString(this.validatorProgramName));
        clone.setInternationalJudgementReadMethod(this.isInternationalJudgementReadMethod());
        clone.setIgnoreSpacesOnValidation(this.isIgnoreSpacesOnValidation());
        clone.setShowValidationToJudges(this.isShowValidationToJudges());
        clone.setHideOutputWindow(this.isHideOutputWindow());
        clone.setShowCompareWindow(this.isShowCompareWindow());
        clone.setComputerJudged(this.isComputerJudged());
        clone.setManualReview(this.isManualReview());
        clone.setPrelimaryNotification(this.isPrelimaryNotification());
        clone.letter = StringUtilities.cloneString(this.letter);
        clone.shortName = StringUtilities.cloneString(this.shortName);
        if (this.getNumberTestCases() > 1) {
            int i = 0;
            while (i < this.getNumberTestCases()) {
                String datafile = StringUtilities.cloneString(this.getDataFileName(i + 1));
                String answerfile = StringUtilities.cloneString(this.getAnswerFileName(i + 1));
                clone.addTestCaseFilenames(datafile, answerfile);
                ++i;
            }
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Problem) {
            Problem otherProblem = (Problem)obj;
            return this.elementId.equals(otherProblem.elementId);
        }
        throw new ClassCastException("expected a Problem found: " + obj.getClass().getName());
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getAnswerFileName() {
        return this.answerFileName;
    }

    public String getAnswerFileName(int testCaseNumber) {
        if (testCaseNumber == 1 && this.testCaseAnswerFilenames.length == 0) {
            return this.answerFileName;
        }
        return this.testCaseAnswerFilenames[testCaseNumber - 1];
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public String getDataFileName(int testCaseNumber) {
        if (testCaseNumber == 1 && this.testCaseDataFilenames.length == 0) {
            return this.dataFileName;
        }
        return this.testCaseDataFilenames[testCaseNumber - 1];
    }

    public boolean isIgnoreSpacesOnValidation() {
        return this.ignoreSpacesOnValidation;
    }

    public boolean isInternationalJudgementReadMethod() {
        return this.internationalJudgementReadMethod;
    }

    public boolean isReadInputDataFromSTDIN() {
        return this.readInputDataFromSTDIN;
    }

    public boolean isShowValidationToJudges() {
        return this.showValidationToJudges;
    }

    public int getTimeOutInSeconds() {
        return this.timeOutInSeconds;
    }

    public boolean isUsingPC2Validator() {
        return this.usingPC2Validator;
    }

    public boolean isValidatedProblem() {
        return this.validatedProblem;
    }

    public String getValidatorCommandLine() {
        return this.validatorCommandLine;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setAnswerFileName(String answerFileName) {
        this.answerFileName = answerFileName;
    }

    public void setDataFileName(String dataFileName) {
        this.dataFileName = dataFileName;
    }

    public void setElementId(ElementId elementId) {
        this.elementId = elementId;
    }

    public void setIgnoreSpacesOnValidation(boolean ignoreSpacesOnValidation) {
        this.ignoreSpacesOnValidation = ignoreSpacesOnValidation;
    }

    public void setInternationalJudgementReadMethod(boolean internationalJudgementReadMethod) {
        this.internationalJudgementReadMethod = internationalJudgementReadMethod;
    }

    public void setReadInputDataFromSTDIN(boolean readInputDataFromSTDIN) {
        this.readInputDataFromSTDIN = readInputDataFromSTDIN;
    }

    public void setShowValidationToJudges(boolean showValidationToJudges) {
        this.showValidationToJudges = showValidationToJudges;
    }

    public void setTimeOutInSeconds(int timeOutInSeconds) {
        this.timeOutInSeconds = timeOutInSeconds;
    }

    public void setUsingPC2Validator(boolean usingPC2Validator) {
        this.usingPC2Validator = usingPC2Validator;
    }

    public void setValidatedProblem(boolean validated) {
        this.validatedProblem = validated;
    }

    public void setValidatorCommandLine(String validatorCommandLine) {
        this.validatorCommandLine = validatorCommandLine;
    }

    public boolean isHideOutputWindow() {
        return this.hideOutputWindow;
    }

    public void setHideOutputWindow(boolean hideOutputWindow) {
        this.hideOutputWindow = hideOutputWindow;
    }

    public String getValidatorProgramName() {
        return this.validatorProgramName;
    }

    public void setValidatorProgramName(String validatorProgramName) {
        this.validatorProgramName = validatorProgramName;
    }

    protected int getNumber() {
        return this.number;
    }

    protected void setNumber(int number) {
        this.number = number;
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    @Override
    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    @Override
    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    public int getWhichPC2Validator() {
        return this.whichPC2Validator;
    }

    public void setWhichPC2Validator(int whichPC2Validator) {
        this.whichPC2Validator = whichPC2Validator;
    }

    public int hashCode() {
        return this.getElementId().toString().hashCode();
    }

    public boolean isSameAs(Problem problem) {
        block47: {
            block46: {
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        block39: {
                                            block38: {
                                                block37: {
                                                    block36: {
                                                        block35: {
                                                            block34: {
                                                                block33: {
                                                                    block32: {
                                                                        block31: {
                                                                            block30: {
                                                                                block29: {
                                                                                    block28: {
                                                                                        block27: {
                                                                                            block26: {
                                                                                                block25: {
                                                                                                    try {
                                                                                                        if (problem != null) break block25;
                                                                                                        return false;
                                                                                                    }
                                                                                                    catch (Exception e) {
                                                                                                        StaticLog.getLog().log(Log.WARNING, "Exception comparing Problem " + e.getMessage(), e);
                                                                                                        e.printStackTrace(System.err);
                                                                                                        return false;
                                                                                                    }
                                                                                                }
                                                                                                if (StringUtilities.stringSame(this.displayName, problem.getDisplayName())) break block26;
                                                                                                return false;
                                                                                            }
                                                                                            if (this.isActive() == problem.isActive()) break block27;
                                                                                            return false;
                                                                                        }
                                                                                        if (this.timeOutInSeconds == problem.getTimeOutInSeconds()) break block28;
                                                                                        return false;
                                                                                    }
                                                                                    if (StringUtilities.stringSame(this.dataFileName, problem.getDataFileName())) break block29;
                                                                                    return false;
                                                                                }
                                                                                if (StringUtilities.stringSame(this.answerFileName, problem.getAnswerFileName())) break block30;
                                                                                return false;
                                                                            }
                                                                            if (!this.readInputDataFromSTDIN != problem.isReadInputDataFromSTDIN()) break block31;
                                                                            return false;
                                                                        }
                                                                        if (this.validatedProblem == problem.isValidatedProblem()) break block32;
                                                                        return false;
                                                                    }
                                                                    if (this.usingPC2Validator == problem.isUsingPC2Validator()) break block33;
                                                                    return false;
                                                                }
                                                                if (this.whichPC2Validator == problem.getWhichPC2Validator()) break block34;
                                                                return false;
                                                            }
                                                            if (StringUtilities.stringSame(this.validatorProgramName, problem.getValidatorProgramName())) break block35;
                                                            return false;
                                                        }
                                                        if (StringUtilities.stringSame(this.validatorCommandLine, problem.getValidatorCommandLine())) break block36;
                                                        return false;
                                                    }
                                                    if (this.ignoreSpacesOnValidation == problem.isIgnoreSpacesOnValidation()) break block37;
                                                    return false;
                                                }
                                                if (this.showValidationToJudges == problem.isShowValidationToJudges()) break block38;
                                                return false;
                                            }
                                            if (this.hideOutputWindow == problem.isHideOutputWindow()) break block39;
                                            return false;
                                        }
                                        if (this.showCompareWindow == problem.isShowCompareWindow()) break block40;
                                        return false;
                                    }
                                    if (this.computerJudged == problem.isComputerJudged()) break block41;
                                    return false;
                                }
                                if (this.manualReview == problem.isManualReview()) break block42;
                                return false;
                            }
                            if (this.prelimaryNotification == problem.isPrelimaryNotification()) break block43;
                            return false;
                        }
                        if (this.getSiteNumber() == problem.getSiteNumber()) break block44;
                        return false;
                    }
                    if (StringUtilities.stringSame(this.shortName, problem.getShortName())) break block45;
                    return false;
                }
                if (StringUtilities.stringSame(this.externalDataFileLocation, problem.getExternalDataFileLocation())) break block46;
                return false;
            }
            if (this.usingExternalDataFiles == problem.usingExternalDataFiles) break block47;
            return false;
        }
        return StringUtilities.stringSame(this.shortName, problem.getShortName());
    }

    public boolean isShowCompareWindow() {
        return this.showCompareWindow;
    }

    public void setShowCompareWindow(boolean showCompareWindow) {
        this.showCompareWindow = showCompareWindow;
    }

    public boolean isComputerJudged() {
        return this.computerJudged;
    }

    public void setComputerJudged(boolean computerJudged) {
        this.computerJudged = computerJudged;
    }

    public boolean isManualReview() {
        return this.manualReview;
    }

    public void setManualReview(boolean manualReview) {
        this.manualReview = manualReview;
    }

    public boolean isPrelimaryNotification() {
        return this.prelimaryNotification;
    }

    public void setPrelimaryNotification(boolean prelimaryNotification) {
        this.prelimaryNotification = prelimaryNotification;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public boolean isValidShortName(String name) {
        boolean invalidName = name == null || name.contains(File.separator) || name.contains(":") || name.contains("/") || name.contains("\\");
        return !invalidName;
    }

    public boolean isValidShortName() {
        return this.isValidShortName(this.shortName);
    }

    public String getLetter() {
        return this.letter;
    }

    public void setLetter(String letter) {
        this.letter = letter;
    }

    public void addTestCaseFilenames(String datafile, String answerfile) {
        String[] newArray;
        if (datafile != null) {
            newArray = StringUtilities.appendString(this.testCaseDataFilenames, datafile);
            this.testCaseDataFilenames = newArray;
        }
        if (answerfile != null) {
            newArray = StringUtilities.appendString(this.testCaseAnswerFilenames, answerfile);
            this.testCaseAnswerFilenames = newArray;
        }
    }

    public void removeAllTestCaseFilenames() {
        this.testCaseDataFilenames = new String[0];
        this.testCaseAnswerFilenames = new String[0];
    }

    public int getNumberTestCases() {
        if (this.testCaseDataFilenames != null && this.testCaseDataFilenames.length > 0) {
            return this.testCaseDataFilenames.length;
        }
        if (this.getAnswerFileName() != null && this.getDataFileName() != null) {
            return 1;
        }
        return 0;
    }

    public String getExecutionPrepCommand() {
        return this.executionPrepCommand;
    }

    public void setExecutionPrepCommand(String executionPrepCommand) {
        this.executionPrepCommand = executionPrepCommand;
    }

    public boolean isCcsMode() {
        return this.ccsMode;
    }

    public void setCcsMode(boolean ccsMode) {
        this.ccsMode = ccsMode;
    }

    public void setColorName(String colorName) {
        this.colorName = colorName;
    }

    public String getColorName() {
        return this.colorName;
    }

    public void setColorRGB(String colorRGB) {
        this.colorRGB = colorRGB;
    }

    public String getColorRGB() {
        return this.colorRGB;
    }

    public boolean isUsingExternalDataFiles() {
        return this.usingExternalDataFiles;
    }

    public void setUsingExternalDataFiles(boolean usingExternalDataFiles) {
        this.usingExternalDataFiles = usingExternalDataFiles;
    }

    public void setExternalDataFileLocation(String externalDataFileLocation) {
        this.externalDataFileLocation = externalDataFileLocation;
    }

    public String getExternalDataFileLocation() {
        return this.externalDataFileLocation;
    }

    public File locateJudgesDataFile(int dataSetNumber) {
        return this.locateDataFile(this.getDataFileName(dataSetNumber));
    }

    public File locateJudgesAnswerFile(int dataSetNumber) {
        return this.locateDataFile(this.getDataFileName(dataSetNumber));
    }

    public String getCCSfileDirectory() {
        if (this.getExternalDataFileLocation() == null) {
            return null;
        }
        return String.valueOf(this.getExternalDataFileLocation()) + File.separator + "data" + File.separator + "secret";
    }

    private File locateDataFile(String filename) {
        String directoryName = this.getExternalDataFileLocation();
        if (directoryName == null) {
            return null;
        }
        File dir = new File(directoryName);
        if (!dir.isDirectory()) {
            return null;
        }
        String name = String.valueOf(this.getCCSfileDirectory()) + File.separator + filename;
        File file = new File(name);
        if (file.isFile()) {
            return file;
        }
        name = String.valueOf(directoryName) + File.separator + filename;
        file = new File(name);
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setElementId(Problem problem) {
        problem.elementId = this.elementId;
    }

    public static enum State {
        ENABLED,
        PAUSED,
        DISABLED;

    }
}

