/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.playback.ReplayEvent;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;

public class PlaybackInfo
implements IElementObject {
    private static final long serialVersionUID = -2365609088747285735L;
    private String displayName = null;
    private ElementId elementId = null;
    private boolean active = true;
    private boolean started = false;
    private Date dateStarted = null;
    private Vector<ReplayEvent> playbackList = new Vector();
    private int sequenceNumber = 0;
    private int minimumPlaybackRecords = 0;
    private String filename = "";
    private int waitBetweenEventsMS = 200;

    public PlaybackInfo(String displayName, ReplayEvent[] events) {
        this.displayName = displayName;
        this.elementId = new ElementId(displayName);
        this.setSiteNumber(0);
        if (events != null) {
            this.setPlaybackList(events);
        }
    }

    public PlaybackInfo(ReplayEvent[] events) {
        this("Playback", events);
    }

    public PlaybackInfo() {
        this("Playback", null);
    }

    public boolean isActive() {
        return this.active;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof PlaybackInfo) {
            PlaybackInfo otherLanguage = (PlaybackInfo)obj;
            return this.elementId.equals(otherLanguage.elementId);
        }
        throw new ClassCastException("expected an PlaybackInfo found: " + obj.getClass().getName());
    }

    public String toString() {
        return String.valueOf(this.displayName) + " started " + this.isActive() + " seq " + this.sequenceNumber + " file " + this.filename;
    }

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    @Override
    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    @Override
    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    public boolean isSameAs(PlaybackInfo language) {
        block3: {
            try {
                if (this.displayName.equals(language.getDisplayName())) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return this.isActive() == language.isActive();
    }

    public int hashCode() {
        return this.elementId.hashCode();
    }

    int getTotalPlayback() {
        return this.playbackList.size();
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int incrementSequenceNumber() {
        ++this.sequenceNumber;
        return this.sequenceNumber;
    }

    public Date getDateStarted() {
        return this.dateStarted;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        if (!this.isStarted() && started) {
            this.dateStarted = new Date();
        }
        this.started = started;
    }

    public ReplayEvent[] getReplayList() {
        return this.playbackList.toArray(new ReplayEvent[this.playbackList.size()]);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setPlaybackList(Vector<ReplayEvent> playbackList) {
        this.playbackList = playbackList;
    }

    public void setPlaybackList(ReplayEvent[] list) {
        this.playbackList = new Vector();
        this.playbackList.addAll(Arrays.asList(list));
        this.minimumPlaybackRecords = list.length;
    }

    public void setMinimumPlaybackRecords(int minimumPlaybackRecords) {
        this.minimumPlaybackRecords = minimumPlaybackRecords;
    }

    public int getMinimumPlaybackRecords() {
        return this.minimumPlaybackRecords;
    }

    public void rewind() {
        this.sequenceNumber = 0;
    }

    public int getWaitBetweenEventsMS() {
        return this.waitBetweenEventsMS;
    }

    public void setWaitBetweenEventsMS(int waitBetweenEventsMS) {
        this.waitBetweenEventsMS = waitBetweenEventsMS;
    }

    public PlaybackInfo cloneShallow() {
        PlaybackInfo info = new PlaybackInfo();
        info.displayName = this.displayName;
        info.elementId = this.elementId;
        info.sequenceNumber = this.sequenceNumber;
        info.minimumPlaybackRecords = this.minimumPlaybackRecords;
        info.filename = new String(this.filename);
        info.active = this.active;
        info.started = this.started;
        info.dateStarted = this.dateStarted;
        if (this.dateStarted != null) {
            info.dateStarted = new Date(this.dateStarted.getTime());
        }
        return info;
    }
}

