/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IGetDate;
import edu.csus.ecs.pc2.core.model.Run;
import java.util.Date;

public class Notification
implements IElementObject,
IGetDate {
    private static final long serialVersionUID = 945222497478556335L;
    private long timeSent;
    private int siteNumber;
    private long time = new Date().getTime();
    private int number;
    private ClientId senderClientId;
    private ClientId submitter;
    private ElementId problemId;
    private ElementId elementId;
    private ClientId whoDelivered;
    private int whenDelivered;
    private long elapsedMS;
    private boolean deleted = false;

    public Notification(Run run, ClientId whoSent, long timeSent, long elapsedMS) {
        this.submitter = run.getSubmitter();
        this.problemId = run.getProblemId();
        this.senderClientId = whoSent;
        this.timeSent = timeSent;
        this.elapsedMS = elapsedMS;
        this.elementId = new ElementId("Notif-" + this.getKey());
    }

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    @Override
    public int getSiteNumber() {
        return this.siteNumber;
    }

    @Override
    public void setSiteNumber(int siteNumber) {
        this.siteNumber = siteNumber;
    }

    public String getKey() {
        return String.valueOf(this.submitter.getTripletKey()) + " " + this.problemId.toString();
    }

    public Date getSendDate() {
        return new Date(this.timeSent);
    }

    public void updateDeliveryConfirmation(ClientId id, int timeDelivered) {
        this.whoDelivered = id;
        this.whenDelivered = timeDelivered;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public static long getSerialversionuid() {
        return 945222497478556335L;
    }

    public long getTimeSent() {
        return this.timeSent;
    }

    public ElementId getProblemId() {
        return this.problemId;
    }

    public ClientId getWhoDelivered() {
        return this.whoDelivered;
    }

    public int getWhenDelivered() {
        return this.whenDelivered;
    }

    public long getElapsedMS() {
        return this.elapsedMS;
    }

    public ClientId getSubmitter() {
        return this.submitter;
    }

    public ClientId getSenderClientId() {
        return this.senderClientId;
    }

    public void setElapsedMS(long elapsedMS) {
        this.elapsedMS = elapsedMS;
    }

    @Override
    public Date getDate() {
        return new Date(this.time);
    }

    @Override
    public void setDate(Date date) {
        this.time = 0L;
        if (date != null) {
            this.time = date.getTime();
        }
    }
}

