/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.ClarificationComparator;
import edu.csus.ecs.pc2.core.list.ContestTimeComparator;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import javax.swing.JOptionPane;

public class InternalDump {
    private String editorNameFullPath = "/windows/vi.bat";
    private IInternalContest contest;

    public InternalDump(IInternalContest contest) {
        this.contest = contest;
    }

    protected void viewFile(String dumpFileName) {
        String editorName = this.editorNameFullPath;
        File f = new File(editorName);
        if (!f.exists()) {
            Log log = new Log("viewFile");
            MultipleFileViewer multipleFileViewer = new MultipleFileViewer(log);
            multipleFileViewer.addFilePane("Internal Dump", dumpFileName);
            FrameUtilities.centerFrameFullScreenHeight(multipleFileViewer);
            multipleFileViewer.setVisible(true);
        } else {
            String command = String.valueOf(editorName) + " " + dumpFileName;
            try {
                Runtime.getRuntime().exec(command);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Unable to run command " + command + " " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void viewContestData() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.SSS");
        String filename = "dump" + simpleDateFormat.format(new Date()) + ".log";
        if (this.generateReportFile(filename) != null) {
            this.viewFile(filename);
        }
    }

    public String generateReportFile(String filename) {
        try {
            Run[] hostName22;
            PrintWriter log = new PrintWriter(new FileOutputStream(filename, false), true);
            log.println(new VersionInfo().getSystemName());
            log.println("Date: " + new Date());
            log.println(new VersionInfo().getSystemVersionInfo());
            Vector<Account> allAccounts = new Vector<Account>();
            log.println();
            log.println("-- Accounts --");
            ClientType.Type[] typeArray = ClientType.Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClientType.Type ctype = typeArray[n2];
                if (this.contest.getAccounts(ctype).size() > 0) {
                    log.println("Accounts " + ctype.toString() + " there are " + this.contest.getAccounts(ctype).size());
                    Vector<Account> accounts = this.contest.getAccounts(ctype);
                    allAccounts.addAll(accounts);
                    int i22 = 0;
                    while (i22 < accounts.size()) {
                        Account account = accounts.elementAt(i22);
                        log.println("   " + account + " Site " + account.getClientId().getSiteNumber() + " id=" + account.getElementId());
                        ++i22;
                    }
                }
                ++n2;
            }
            Account[] accountList = allAccounts.toArray(new Account[allAccounts.size()]);
            Arrays.sort(accountList, new AccountComparator());
            log.println();
            log.println("-- " + accountList.length + " Accounts --");
            int i = 0;
            while (i < accountList.length) {
                Account account = accountList[i];
                log.println("   " + account + " Site " + account.getClientId().getSiteNumber() + " id=" + account.getElementId());
                ++i;
            }
            log.println();
            log.println("-- " + this.contest.getSites().length + " sites --");
            Site[] sites = this.contest.getSites();
            Arrays.sort(sites, new SiteComparatorBySiteNumber());
            IElementObject[] i22 = sites;
            int accounts = sites.length;
            int n3 = 0;
            while (n3 < accounts) {
                Site site1 = i22[n3];
                hostName22 = site1.getConnectionInfo().getProperty("IP_KEY");
                String portStr = site1.getConnectionInfo().getProperty("PORT_KEY");
                log.println("Site " + site1.getSiteNumber() + " " + (String)hostName22 + ":" + portStr + " " + site1.getDisplayName() + "/" + site1.getPassword() + " id=" + site1.getElementId());
                ++n3;
            }
            log.println();
            log.println("-- " + this.contest.getProblems().length + " problems --");
            i22 = this.contest.getProblems();
            accounts = i22.length;
            n3 = 0;
            while (n3 < accounts) {
                IElementObject problem = i22[n3];
                log.println("  Problem " + problem + " id=" + ((Problem)problem).getElementId());
                ++n3;
            }
            log.println();
            log.println("-- " + this.contest.getLanguages().length + " languages --");
            i22 = this.contest.getLanguages();
            accounts = i22.length;
            n3 = 0;
            while (n3 < accounts) {
                IElementObject language = i22[n3];
                log.println("  Language " + language + " id=" + ((Language)language).getElementId());
                ++n3;
            }
            log.println();
            Run[] runs = this.contest.getRuns();
            Arrays.sort(runs, new RunComparator());
            log.println("-- " + runs.length + " runs --");
            hostName22 = runs;
            int i22 = runs.length;
            accounts = 0;
            while (accounts < i22) {
                Run run = hostName22[accounts];
                log.println("  Run " + run);
                ++accounts;
            }
            log.println();
            Clarification[] clarifications = this.contest.getClarifications();
            Arrays.sort(clarifications, new ClarificationComparator());
            log.println("-- " + clarifications.length + " clarifications --");
            Clarification[] clarificationArray = clarifications;
            int hostName22 = clarifications.length;
            i22 = 0;
            while (i22 < hostName22) {
                Clarification clarification = clarificationArray[i22];
                log.println("  " + clarification);
                ++i22;
            }
            log.println();
            ContestTime[] contestTimes = this.contest.getContestTimes();
            Arrays.sort(contestTimes, new ContestTimeComparator());
            log.println("-- " + contestTimes.length + " Contest Times --");
            Object[] objectArray = contestTimes;
            int n4 = contestTimes.length;
            hostName22 = 0;
            while (hostName22 < n4) {
                ContestTime contestTime = objectArray[hostName22];
                if (this.contest.getSiteNumber() == contestTime.getSiteNumber()) {
                    log.print("  * ");
                } else {
                    log.print("    ");
                }
                String state = "STOPPED";
                if (contestTime.isContestRunning()) {
                    state = "STARTED";
                }
                log.println("  Site " + contestTime.getSiteNumber() + " " + state + " " + contestTime.getElapsedTimeStr() + " " + contestTime.getRemainingTimeStr() + " " + contestTime.getContestLengthStr());
                ++hostName22;
            }
            log.println();
            log.println("-- Logins -- ");
            objectArray = ClientType.Type.values();
            n4 = objectArray.length;
            hostName22 = 0;
            while (hostName22 < n4) {
                ContestTime ctype = objectArray[hostName22];
                ClientId[] clientIds = this.contest.getAllLoggedInClients((ClientType.Type)((Object)ctype));
                if (clientIds.length > 0) {
                    log.println("Logged in " + ((Enum)((Object)ctype)).toString());
                    ClientId[] clientIdArray = clientIds;
                    int n5 = clientIds.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ClientId clientId = clientIdArray[n6];
                        ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(clientId);
                        log.println("   " + clientId + " on " + connectionHandlerID);
                        ++n6;
                    }
                }
                ++hostName22;
            }
            log.println();
            ConnectionHandlerID[] connectionHandlerIDs = this.contest.getConnectionHandleIDs();
            log.println("-- " + connectionHandlerIDs.length + " Connections --");
            ConnectionHandlerID[] connectionHandlerIDArray = connectionHandlerIDs;
            int n7 = connectionHandlerIDs.length;
            n4 = 0;
            while (n4 < n7) {
                ConnectionHandlerID connectionHandlerID = connectionHandlerIDArray[n4];
                log.println("  " + connectionHandlerID);
                ++n4;
            }
            log.println();
            log.println("*end*");
            log.close();
            log = null;
            return filename;
        }
        catch (Exception e) {
            StaticLog.log("Exception logged ", e);
            e.printStackTrace();
            return null;
        }
    }

    public String getEditorNameFullPath() {
        return this.editorNameFullPath;
    }

    public void setEditorNameFullPath(String editorNameFullPath) {
        this.editorNameFullPath = editorNameFullPath;
    }
}

