/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.PermissionGroup;
import edu.csus.ecs.pc2.core.exception.ClarificationUnavailableException;
import edu.csus.ecs.pc2.core.exception.ContestSecurityException;
import edu.csus.ecs.pc2.core.exception.ProfileCloneException;
import edu.csus.ecs.pc2.core.exception.RunUnavailableException;
import edu.csus.ecs.pc2.core.exception.UnableToUncheckoutRunException;
import edu.csus.ecs.pc2.core.list.AccountList;
import edu.csus.ecs.pc2.core.list.BalloonSettingsList;
import edu.csus.ecs.pc2.core.list.CategoryDisplayList;
import edu.csus.ecs.pc2.core.list.CategoryList;
import edu.csus.ecs.pc2.core.list.ClarificationList;
import edu.csus.ecs.pc2.core.list.ClientSettingsList;
import edu.csus.ecs.pc2.core.list.ConnectionHandlerList;
import edu.csus.ecs.pc2.core.list.ContestTimeList;
import edu.csus.ecs.pc2.core.list.EventFeedDefinitionsList;
import edu.csus.ecs.pc2.core.list.GroupDisplayList;
import edu.csus.ecs.pc2.core.list.GroupList;
import edu.csus.ecs.pc2.core.list.JudgementDisplayList;
import edu.csus.ecs.pc2.core.list.JudgementList;
import edu.csus.ecs.pc2.core.list.LanguageDisplayList;
import edu.csus.ecs.pc2.core.list.LanguageList;
import edu.csus.ecs.pc2.core.list.LoginList;
import edu.csus.ecs.pc2.core.list.NotificationList;
import edu.csus.ecs.pc2.core.list.PlaybackInfoList;
import edu.csus.ecs.pc2.core.list.ProblemDisplayList;
import edu.csus.ecs.pc2.core.list.ProblemList;
import edu.csus.ecs.pc2.core.list.ProfilesList;
import edu.csus.ecs.pc2.core.list.RunFilesList;
import edu.csus.ecs.pc2.core.list.RunList;
import edu.csus.ecs.pc2.core.list.RunResultsFileList;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.BalloonDeliveryInfo;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.BalloonSettingsEvent;
import edu.csus.ecs.pc2.core.model.Category;
import edu.csus.ecs.pc2.core.model.CategoryEvent;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClarificationAnswer;
import edu.csus.ecs.pc2.core.model.ClarificationEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientSettingsEvent;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.CloneException;
import edu.csus.ecs.pc2.core.model.ConfigurationIO;
import edu.csus.ecs.pc2.core.model.ConnectionEvent;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.EventFeedDefinition;
import edu.csus.ecs.pc2.core.model.EventFeedDefinitionEvent;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.FinalizeData;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.GroupEvent;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IBalloonSettingsListener;
import edu.csus.ecs.pc2.core.model.ICategoryListener;
import edu.csus.ecs.pc2.core.model.IChangePasswordListener;
import edu.csus.ecs.pc2.core.model.IClarificationListener;
import edu.csus.ecs.pc2.core.model.IClientSettingsListener;
import edu.csus.ecs.pc2.core.model.IConnectionListener;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IEventFeedDefinitionListener;
import edu.csus.ecs.pc2.core.model.IGroupListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IJudgementListener;
import edu.csus.ecs.pc2.core.model.ILanguageListener;
import edu.csus.ecs.pc2.core.model.ILoginListener;
import edu.csus.ecs.pc2.core.model.IMessageListener;
import edu.csus.ecs.pc2.core.model.INotificationListener;
import edu.csus.ecs.pc2.core.model.IPlayBackEventListener;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.IProfileListener;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.ISiteListener;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementEvent;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LanguageEvent;
import edu.csus.ecs.pc2.core.model.LoginEvent;
import edu.csus.ecs.pc2.core.model.MessageEvent;
import edu.csus.ecs.pc2.core.model.Notification;
import edu.csus.ecs.pc2.core.model.NotificationEvent;
import edu.csus.ecs.pc2.core.model.PasswordChangeEvent;
import edu.csus.ecs.pc2.core.model.PlayBackEvent;
import edu.csus.ecs.pc2.core.model.PlaybackInfo;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.ProblemDataFilesList;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.ProfileChangeStatus;
import edu.csus.ecs.pc2.core.model.ProfileEvent;
import edu.csus.ecs.pc2.core.model.ReplaySetting;
import edu.csus.ecs.pc2.core.model.ReplaySettingEvent;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.model.RunExecutionStatus;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.model.SiteEvent;
import edu.csus.ecs.pc2.core.model.SiteList;
import edu.csus.ecs.pc2.core.model.playback.PlaybackManager;
import edu.csus.ecs.pc2.core.security.FileSecurity;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.core.security.ISecurityMessageListener;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.SecurityMessageHandler;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.profile.ProfileCloneSettings;
import edu.csus.ecs.pc2.profile.ProfileLoadException;
import edu.csus.ecs.pc2.profile.ProfileManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class InternalContest
implements IInternalContest {
    private ClientId localClientId = null;
    private Vector<IRunListener> runListenerList = new Vector();
    private Vector<IClarificationListener> clarificationListenerList = new Vector();
    private Vector<IProblemListener> problemListenerList = new Vector();
    private Vector<ICategoryListener> categoryListenerList = new Vector();
    private Vector<INotificationListener> notificationListenerList = new Vector();
    private Vector<ILanguageListener> languageListenerList = new Vector();
    private Vector<IPlayBackEventListener> playBackEventListenerList = new Vector();
    private Vector<IProfileListener> profileListenerList = new Vector();
    private Vector<IChangePasswordListener> changePasswordListenerList = new Vector();
    private Vector<ILoginListener> loginListenerList = new Vector();
    private Vector<IContestTimeListener> contestTimeListenerList = new Vector();
    private Vector<IJudgementListener> judgementListenerList = new Vector();
    private Vector<ISiteListener> siteListenerList = new Vector();
    private Vector<IConnectionListener> connectionListenerList = new Vector();
    private Vector<IClientSettingsListener> clientSettingsListenerList = new Vector();
    private Vector<IContestInformationListener> contestInformationListenerList = new Vector();
    private Vector<IBalloonSettingsListener> balloonSettingsListenerList = new Vector();
    private Vector<IGroupListener> groupListenerList = new Vector();
    private Vector<IMessageListener> messageListenerList = new Vector();
    private Vector<IEventFeedDefinitionListener> eventFeedDefinitionListenerList = new Vector();
    private Hashtable<ElementId, ClientId> runCheckOutList = new Hashtable(200);
    private Hashtable<ElementId, ClientId> clarCheckOutList = new Hashtable(200);
    private AccountList accountList = new AccountList();
    private BalloonSettingsList balloonSettingsList = new BalloonSettingsList();
    private Vector<IAccountListener> accountListenerList = new Vector();
    private GroupList groupList = new GroupList();
    private Problem generalProblem = null;
    private LoginList localLoginList = new LoginList();
    private LoginList remoteLoginList = new LoginList();
    private ConnectionHandlerList localConnectionHandlerList = new ConnectionHandlerList();
    private ConnectionHandlerList remoteConnectionHandlerList = new ConnectionHandlerList();
    private ContestTimeList contestTimeList = new ContestTimeList();
    private RunList runList = new RunList();
    private RunFilesList runFilesList = new RunFilesList();
    private RunResultsFileList runResultFilesList = new RunResultsFileList();
    private ClarificationList clarificationList = new ClarificationList();
    private SiteList siteList = new SiteList();
    private ClientSettingsList clientSettingsList = new ClientSettingsList();
    private ContestInformation contestInformation = new ContestInformation();
    private int siteNumber = 1;
    private ProblemList problemList = new ProblemList();
    private CategoryList categoryList = new CategoryList();
    private NotificationList notificationList = new NotificationList();
    private ProblemDataFilesList problemDataFilesList = new ProblemDataFilesList();
    private ProblemDisplayList problemDisplayList = new ProblemDisplayList();
    private CategoryDisplayList categoryDisplayList = new CategoryDisplayList();
    private LanguageList languageList = new LanguageList();
    private PlaybackInfoList playbackInfoList = new PlaybackInfoList();
    private ProfilesList profileList = new ProfilesList();
    private LanguageDisplayList languageDisplayList = new LanguageDisplayList();
    private JudgementDisplayList judgementDisplayList = new JudgementDisplayList();
    private GroupDisplayList groupDisplayList = new GroupDisplayList();
    private JudgementList judgementList = new JudgementList();
    private SecurityMessageHandler securityMessageHandler;
    private Profile profile = null;
    private String contestIdentifier = null;
    private ConfigurationIO configurationIO = null;
    private IStorage storage = null;
    private String contestPassword = null;
    private ProfileCloneSettings profileCloneSettings = null;
    private FinalizeData finalizeData = null;
    private ReplaySetting replaySettingTemp = null;
    private PlaybackManager playbackManager = new PlaybackManager();
    private EventFeedDefinitionsList eventFeedDefinitionsList = null;

    private Site createFakeSite(int nextSiteNumber) {
        Site site = new Site("Site " + nextSiteNumber, nextSiteNumber);
        Properties props = new Properties();
        props.put("IP_KEY", "localhost");
        int port = 50002 + (nextSiteNumber - 1) * 1000;
        props.put("PORT_KEY", "" + port);
        site.setConnectionInfo(props);
        site.setPassword("site" + nextSiteNumber);
        return site;
    }

    @Override
    public void initializeSubmissions(int siteNum) {
        try {
            this.initializeSubmissions(siteNum, true);
        }
        catch (Exception e) {
            this.logException("Trouble loading clarifications from disk ", e);
        }
    }

    public void initializeSubmissions(int siteNum, boolean uncheckoutSubmissions) throws IOException, ClassNotFoundException, FileSecurityException {
        this.configurationIO = new ConfigurationIO(this.storage);
        this.runList = new RunList(this.storage);
        this.runList.loadFromDisk(siteNum);
        this.runFilesList = new RunFilesList(this.storage);
        this.runResultFilesList = new RunResultsFileList(this.storage);
        this.clarificationList = new ClarificationList(this.storage);
        this.notificationList = new NotificationList(this.storage);
        this.clarificationList.loadFromDisk(siteNum);
        this.notificationList.loadFromDisk(siteNum);
        if (uncheckoutSubmissions) {
            this.resetRunStatus(siteNum);
            this.clarificationList.loadFromDisk(siteNum);
            Clarification[] clarList = this.clarificationList.getList();
            int i = 0;
            while (i < clarList.length) {
                if (clarList[i].getState().equals((Object)Clarification.ClarificationStates.BEING_ANSWERED)) {
                    StaticLog.info("Changing Clarification " + clarList[i].getElementId() + " from BEING_ANSWERED by " + clarList[i].getWhoCheckedItOutId() + "to NEW");
                    this.clarificationList.uncheckoutClarification(clarList[i]);
                }
                ++i;
            }
        }
    }

    private void resetRunStatus(int siteNum) {
        try {
            Run[] runs = this.runList.getList();
            int i = 0;
            while (i < runs.length) {
                Run.RunStates status = runs[i].getStatus();
                if (status.equals((Object)Run.RunStates.BEING_COMPUTER_JUDGED)) {
                    status = Run.RunStates.QUEUED_FOR_COMPUTER_JUDGEMENT;
                } else if (status.equals((Object)Run.RunStates.BEING_JUDGED)) {
                    status = runs[i].getComputerJudgementRecord() == null ? Run.RunStates.NEW : Run.RunStates.MANUAL_REVIEW;
                } else if (status.equals((Object)Run.RunStates.BEING_RE_JUDGED)) {
                    status = Run.RunStates.JUDGED;
                }
                if (!runs[i].getStatus().equals((Object)status)) {
                    StaticLog.info("Changing Run " + runs[i].getElementId() + " from " + (Object)((Object)runs[i].getStatus()) + "to NEW");
                    this.runList.updateRunStatus(runs[i], status);
                }
                ++i;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            StaticLog.getLog().log(Log.INFO, "startup: no runs found on disk.");
        }
        catch (IOException e) {
            this.logException(e);
        }
        catch (ClassNotFoundException e) {
            this.logException(e);
        }
        catch (FileSecurityException e) {
            this.logException(e);
        }
    }

    @Override
    public void initializeStartupData(int siteNum) {
        if (this.siteList.size() == 0) {
            Site site = this.createFakeSite(1);
            site.setActive(true);
            this.siteList.add(site);
            this.contestInformation.setContestTitle("Default Contest Title");
            if (this.getGeneralProblem() == null) {
                this.setGeneralProblem(new Problem("General"));
            }
        }
        if (this.getContestTime(siteNum) == null) {
            ContestTime contestTime = new ContestTime();
            contestTime.setSiteNumber(siteNum);
            this.addContestTime(contestTime);
        }
        if (this.getAccounts(ClientType.Type.ADMINISTRATOR) == null || this.getAccounts(ClientType.Type.ADMINISTRATOR, siteNum).size() == 0) {
            this.generateNewAccounts(ClientType.Type.ADMINISTRATOR.toString(), 1, true);
        }
    }

    @Override
    public void addRunListener(IRunListener runListener) {
        this.runListenerList.addElement(runListener);
    }

    @Override
    public void removeRunListener(IRunListener runListener) {
        this.runListenerList.removeElement(runListener);
    }

    @Override
    public void addClarificationListener(IClarificationListener clarificationListener) {
        this.clarificationListenerList.addElement(clarificationListener);
    }

    @Override
    public void removeClarificationListener(IClarificationListener clarificationListener) {
        this.clarificationListenerList.remove(clarificationListener);
    }

    @Override
    public void addContestTimeListener(IContestTimeListener contestTimeListener) {
        this.contestTimeListenerList.addElement(contestTimeListener);
    }

    @Override
    public void removeContestTimeListener(IContestTimeListener contestTimeListener) {
        this.contestTimeListenerList.removeElement(contestTimeListener);
    }

    @Override
    public void addJudgementListener(IJudgementListener judgementListener) {
        this.judgementListenerList.addElement(judgementListener);
    }

    @Override
    public void removeJudgementListener(IJudgementListener judgementListener) {
        this.judgementListenerList.remove(judgementListener);
    }

    @Override
    public void addMessageListener(IMessageListener messageListener) {
        this.messageListenerList.addElement(messageListener);
    }

    @Override
    public void removeMessageListener(IMessageListener messageListener) {
        this.messageListenerList.removeElement(messageListener);
    }

    private void fireRunListener(RunEvent runEvent) {
        int i = 0;
        while (i < this.runListenerList.size()) {
            if (runEvent.getAction() == RunEvent.Action.ADDED) {
                this.runListenerList.elementAt(i).runAdded(runEvent);
            } else if (runEvent.getAction() == RunEvent.Action.DELETED) {
                this.runListenerList.elementAt(i).runRemoved(runEvent);
            } else if (runEvent.getAction() == RunEvent.Action.REFRESH_ALL) {
                this.runListenerList.elementAt(i).refreshRuns(runEvent);
            } else {
                this.runListenerList.elementAt(i).runChanged(runEvent);
            }
            ++i;
        }
    }

    private void fireContestTimeListener(ContestTimeEvent contestTimeEvent) {
        int i = 0;
        while (i < this.contestTimeListenerList.size()) {
            if (contestTimeEvent.getAction() == ContestTimeEvent.Action.ADDED) {
                this.contestTimeListenerList.elementAt(i).contestTimeAdded(contestTimeEvent);
            } else if (contestTimeEvent.getAction() == ContestTimeEvent.Action.DELETED) {
                this.contestTimeListenerList.elementAt(i).contestTimeRemoved(contestTimeEvent);
            } else if (contestTimeEvent.getAction() == ContestTimeEvent.Action.CLOCK_STARTED) {
                this.contestTimeListenerList.elementAt(i).contestStarted(contestTimeEvent);
            } else if (contestTimeEvent.getAction() == ContestTimeEvent.Action.CLOCK_STOPPED) {
                this.contestTimeListenerList.elementAt(i).contestStopped(contestTimeEvent);
            } else if (contestTimeEvent.getAction() == ContestTimeEvent.Action.CHANGED) {
                this.contestTimeListenerList.elementAt(i).contestTimeChanged(contestTimeEvent);
            } else if (contestTimeEvent.getAction() == ContestTimeEvent.Action.REFRESH_ALL) {
                this.contestTimeListenerList.elementAt(i).refreshAll(contestTimeEvent);
            } else {
                this.contestTimeListenerList.elementAt(i).contestTimeChanged(contestTimeEvent);
            }
            ++i;
        }
    }

    private void fireProblemListener(ProblemEvent problemEvent) {
        int i = 0;
        while (i < this.problemListenerList.size()) {
            if (problemEvent.getAction() == ProblemEvent.Action.ADDED) {
                this.problemListenerList.elementAt(i).problemAdded(problemEvent);
            } else if (problemEvent.getAction() == ProblemEvent.Action.DELETED) {
                this.problemListenerList.elementAt(i).problemRemoved(problemEvent);
            } else if (problemEvent.getAction() == ProblemEvent.Action.REFRESH_ALL) {
                this.problemListenerList.elementAt(i).problemRefreshAll(problemEvent);
            } else {
                this.problemListenerList.elementAt(i).problemChanged(problemEvent);
            }
            ++i;
        }
    }

    private void fireEventFeedDefinitionListener(EventFeedDefinitionEvent eventFeedDefinitionEvent) {
        int i = 0;
        while (i < this.problemListenerList.size()) {
            if (eventFeedDefinitionEvent.getAction() == EventFeedDefinitionEvent.Action.ADDED) {
                this.eventFeedDefinitionListenerList.elementAt(i).eventFeedDefinitionAdded(eventFeedDefinitionEvent);
            } else if (eventFeedDefinitionEvent.getAction() == EventFeedDefinitionEvent.Action.DELETED) {
                this.eventFeedDefinitionListenerList.elementAt(i).eventFeedDefinitionRemoved(eventFeedDefinitionEvent);
            } else if (eventFeedDefinitionEvent.getAction() == EventFeedDefinitionEvent.Action.REFRESH_ALL) {
                this.eventFeedDefinitionListenerList.elementAt(i).eventFeedDefinitionRefreshAll(eventFeedDefinitionEvent);
            } else {
                this.eventFeedDefinitionListenerList.elementAt(i).eventFeedDefinitionChanged(eventFeedDefinitionEvent);
            }
            ++i;
        }
    }

    private void fireCategoryListener(Category category, CategoryEvent.Action action) {
        CategoryEvent categoryEvent = new CategoryEvent(action, category);
        int i = 0;
        while (i < this.categoryListenerList.size()) {
            if (categoryEvent.getAction() == CategoryEvent.Action.ADDED) {
                this.categoryListenerList.elementAt(i).categoryAdded(categoryEvent);
            } else if (categoryEvent.getAction() == CategoryEvent.Action.DELETED) {
                this.categoryListenerList.elementAt(i).categoryRemoved(categoryEvent);
            } else if (categoryEvent.getAction() == CategoryEvent.Action.REFRESH_ALL) {
                this.categoryListenerList.elementAt(i).categoryRefreshAll(categoryEvent);
            } else {
                this.categoryListenerList.elementAt(i).categoryChanged(categoryEvent);
            }
            ++i;
        }
    }

    private void fireNotificationListener(Notification notification, NotificationEvent.Action added) {
        NotificationEvent notificationEvent = new NotificationEvent(NotificationEvent.Action.CHANGED, notification);
        int i = 0;
        while (i < this.notificationListenerList.size()) {
            if (notificationEvent.getAction() == NotificationEvent.Action.ADDED) {
                this.notificationListenerList.elementAt(i).notificationAdded(notificationEvent);
            } else if (notificationEvent.getAction() == NotificationEvent.Action.DELETED) {
                this.notificationListenerList.elementAt(i).notificationRemoved(notificationEvent);
            } else if (notificationEvent.getAction() == NotificationEvent.Action.REFRESH_ALL) {
                this.notificationListenerList.elementAt(i).notificationRefreshAll(notificationEvent);
            } else {
                this.notificationListenerList.elementAt(i).notificationChanged(notificationEvent);
            }
            ++i;
        }
    }

    private void fireLanguageListener(LanguageEvent languageEvent) {
        int i = 0;
        while (i < this.languageListenerList.size()) {
            if (languageEvent.getAction() == LanguageEvent.Action.ADDED) {
                this.languageListenerList.elementAt(i).languageAdded(languageEvent);
            } else if (languageEvent.getAction() == LanguageEvent.Action.DELETED) {
                this.languageListenerList.elementAt(i).languageRemoved(languageEvent);
            } else if (languageEvent.getAction() == LanguageEvent.Action.REFRESH_ALL) {
                this.languageListenerList.elementAt(i).languageRefreshAll(languageEvent);
            } else if (languageEvent.getAction() == LanguageEvent.Action.ADDED_LANGUAGES) {
                this.languageListenerList.elementAt(i).languagesAdded(languageEvent);
            } else if (languageEvent.getAction() == LanguageEvent.Action.CHANGED_LANGUAGES) {
                this.languageListenerList.elementAt(i).languagesChanged(languageEvent);
            } else {
                this.languageListenerList.elementAt(i).languageChanged(languageEvent);
            }
            ++i;
        }
    }

    private void firePlaybackInfosListener(PlayBackEvent.Action action, PlaybackInfo playbackInfo) {
        PlayBackEvent playBackEvent = new PlayBackEvent(action, playbackInfo);
        int i = 0;
        while (i < this.playBackEventListenerList.size()) {
            if (playBackEvent.getAction() == PlayBackEvent.Action.ADDED) {
                this.playBackEventListenerList.elementAt(i).playbackAdded(playBackEvent);
            } else if (playBackEvent.getAction() == PlayBackEvent.Action.RESET_REPLAY) {
                this.playBackEventListenerList.elementAt(i).playbackChanged(playBackEvent);
            } else if (playBackEvent.getAction() == PlayBackEvent.Action.START_REPLAY) {
                this.playBackEventListenerList.elementAt(i).playbackChanged(playBackEvent);
            } else if (playBackEvent.getAction() == PlayBackEvent.Action.STOP_REPLAY) {
                this.playBackEventListenerList.elementAt(i).playbackChanged(playBackEvent);
            } else if (playBackEvent.getAction() == PlayBackEvent.Action.REFRESH_ALL) {
                this.playBackEventListenerList.elementAt(i).playbackRefreshAll(playBackEvent);
            } else {
                this.playBackEventListenerList.elementAt(i).playbackChanged(playBackEvent);
            }
            ++i;
        }
    }

    private void fireLoginListener(LoginEvent loginEvent) {
        int i = 0;
        while (i < this.loginListenerList.size()) {
            if (loginEvent.getAction() == LoginEvent.Action.NEW_LOGIN) {
                this.loginListenerList.elementAt(i).loginAdded(loginEvent);
            } else if (loginEvent.getAction() == LoginEvent.Action.LOGOFF) {
                this.loginListenerList.elementAt(i).loginRemoved(loginEvent);
            } else if (loginEvent.getAction() == LoginEvent.Action.LOGIN_DENIED) {
                this.loginListenerList.elementAt(i).loginDenied(loginEvent);
            } else if (loginEvent.getAction() == LoginEvent.Action.REFRESH_ALL) {
                this.loginListenerList.elementAt(i).loginRefreshAll(loginEvent);
            } else {
                throw new UnsupportedOperationException("Unknown login action " + (Object)((Object)loginEvent.getAction()));
            }
            ++i;
        }
    }

    private void fireJudgementListener(JudgementEvent judgementEvent) {
        int i = 0;
        while (i < this.judgementListenerList.size()) {
            if (judgementEvent.getAction() == JudgementEvent.Action.ADDED) {
                this.judgementListenerList.elementAt(i).judgementAdded(judgementEvent);
            } else if (judgementEvent.getAction() == JudgementEvent.Action.DELETED) {
                this.judgementListenerList.elementAt(i).judgementRemoved(judgementEvent);
            } else if (judgementEvent.getAction() == JudgementEvent.Action.REFRESH_ALL) {
                this.judgementListenerList.elementAt(i).judgementRefreshAll(judgementEvent);
            } else {
                this.judgementListenerList.elementAt(i).judgementChanged(judgementEvent);
            }
            ++i;
        }
    }

    private void fireSiteListener(SiteEvent siteEvent) {
        int i = 0;
        while (i < this.siteListenerList.size()) {
            if (siteEvent.getAction() == SiteEvent.Action.ADDED) {
                this.siteListenerList.elementAt(i).siteAdded(siteEvent);
            } else if (siteEvent.getAction() == SiteEvent.Action.DELETED) {
                this.siteListenerList.elementAt(i).siteRemoved(siteEvent);
            } else if (siteEvent.getAction() == SiteEvent.Action.CHANGED) {
                this.siteListenerList.elementAt(i).siteChanged(siteEvent);
            } else if (siteEvent.getAction() == SiteEvent.Action.LOGIN) {
                this.siteListenerList.elementAt(i).siteLoggedOn(siteEvent);
            } else if (siteEvent.getAction() == SiteEvent.Action.LOGOFF) {
                this.siteListenerList.elementAt(i).siteLoggedOff(siteEvent);
            } else if (siteEvent.getAction() == SiteEvent.Action.REFRESH_ALL) {
                this.siteListenerList.elementAt(i).sitesRefreshAll(siteEvent);
            } else if (siteEvent.getAction() == SiteEvent.Action.STATUS_CHANGE) {
                this.siteListenerList.elementAt(i).siteProfileStatusChanged(siteEvent);
            } else {
                this.siteListenerList.elementAt(i).siteAdded(siteEvent);
            }
            ++i;
        }
    }

    private void fireConnectionListener(ConnectionEvent connectionEvent) {
        int i = 0;
        while (i < this.connectionListenerList.size()) {
            if (connectionEvent.getAction() == ConnectionEvent.Action.ESTABLISHED) {
                this.connectionListenerList.elementAt(i).connectionEstablished(connectionEvent);
            } else if (connectionEvent.getAction() == ConnectionEvent.Action.DROPPED) {
                this.connectionListenerList.elementAt(i).connectionDropped(connectionEvent);
            } else if (connectionEvent.getAction() == ConnectionEvent.Action.REFRESH_ALL) {
                this.connectionListenerList.elementAt(i).connectionRefreshAll(connectionEvent);
            } else {
                throw new UnsupportedOperationException("Unknown connection action " + (Object)((Object)connectionEvent.getAction()));
            }
            ++i;
        }
    }

    private void fireBalloonSettingsListener(BalloonSettingsEvent balloonSettingsEvent) {
        int i = 0;
        while (i < this.balloonSettingsListenerList.size()) {
            if (balloonSettingsEvent.getAction() == BalloonSettingsEvent.Action.ADDED) {
                this.balloonSettingsListenerList.elementAt(i).balloonSettingsAdded(balloonSettingsEvent);
            } else if (balloonSettingsEvent.getAction() == BalloonSettingsEvent.Action.DELETED) {
                this.balloonSettingsListenerList.elementAt(i).balloonSettingsRemoved(balloonSettingsEvent);
            } else if (balloonSettingsEvent.getAction() == BalloonSettingsEvent.Action.REFRESH_ALL) {
                this.balloonSettingsListenerList.elementAt(i).balloonSettingsRefreshAll(balloonSettingsEvent);
            } else {
                this.balloonSettingsListenerList.elementAt(i).balloonSettingsChanged(balloonSettingsEvent);
            }
            ++i;
        }
    }

    private void fireMessageListener(MessageEvent messageEvent) {
        int i = 0;
        while (i < this.messageListenerList.size()) {
            if (messageEvent.getAction() == MessageEvent.Action.ADDED) {
                this.messageListenerList.elementAt(i).messageAdded(messageEvent);
            } else if (messageEvent.getAction() == MessageEvent.Action.DELETED) {
                this.messageListenerList.elementAt(i).messageRemoved(messageEvent);
            }
            ++i;
        }
    }

    @Override
    public void addLocalLogin(ClientId inClientId, ConnectionHandlerID connectionHandlerID) {
        this.localLoginList.add(inClientId, connectionHandlerID);
        LoginEvent loginEvent = new LoginEvent(LoginEvent.Action.NEW_LOGIN, inClientId, connectionHandlerID, "New");
        this.fireLoginListener(loginEvent);
    }

    @Override
    public void addRemoteLogin(ClientId inClientId, ConnectionHandlerID connectionHandlerID) {
        this.remoteLoginList.add(inClientId, connectionHandlerID);
        LoginEvent loginEvent = new LoginEvent(LoginEvent.Action.NEW_LOGIN, inClientId, connectionHandlerID, "New");
        this.fireLoginListener(loginEvent);
    }

    @Override
    public void addLogin(ClientId inClientId, ConnectionHandlerID connectionHandlerID) {
        if (inClientId.getSiteNumber() == this.siteNumber) {
            this.localLoginList.add(inClientId, connectionHandlerID);
        } else {
            this.remoteLoginList.add(inClientId, connectionHandlerID);
        }
        LoginEvent loginEvent = new LoginEvent(LoginEvent.Action.NEW_LOGIN, inClientId, connectionHandlerID, "New");
        this.fireLoginListener(loginEvent);
    }

    @Override
    public void loginDenied(ClientId clientId, ConnectionHandlerID connectionHandlerID, String message) {
        LoginEvent loginEvent = new LoginEvent(LoginEvent.Action.LOGIN_DENIED, clientId, connectionHandlerID, message);
        this.fireLoginListener(loginEvent);
    }

    @Override
    public void addLanguage(Language language) {
        this.languageDisplayList.add(language);
        this.languageList.add(language);
        LanguageEvent languageEvent = new LanguageEvent(LanguageEvent.Action.ADDED, language);
        this.fireLanguageListener(languageEvent);
    }

    @Override
    public void addProblem(Problem problem) {
        this.problemDisplayList.add(problem);
        this.problemList.add(problem);
        ProblemEvent problemEvent = new ProblemEvent(ProblemEvent.Action.ADDED, problem);
        this.fireProblemListener(problemEvent);
    }

    @Override
    public void addCategory(Category category) {
        this.categoryDisplayList.add(category);
        this.categoryList.add(category);
        this.fireCategoryListener(category, CategoryEvent.Action.ADDED);
    }

    @Override
    public void addNotification(Notification notification) throws IOException, ClassNotFoundException, FileSecurityException {
        this.notificationList.add(notification);
        this.fireNotificationListener(notification, NotificationEvent.Action.ADDED);
    }

    @Override
    public void addJudgement(Judgement judgement) {
        this.judgementDisplayList.add(judgement);
        this.judgementList.add(judgement);
        JudgementEvent judgementEvent = new JudgementEvent(JudgementEvent.Action.ADDED, judgement);
        this.fireJudgementListener(judgementEvent);
    }

    @Override
    public void addSite(Site site) {
        this.siteList.add(site);
        SiteEvent siteEvent = new SiteEvent(SiteEvent.Action.ADDED, site);
        this.fireSiteListener(siteEvent);
    }

    @Override
    public void updateSite(Site site) {
        this.siteList.update(site);
        SiteEvent siteEvent = new SiteEvent(SiteEvent.Action.CHANGED, site);
        this.fireSiteListener(siteEvent);
    }

    @Override
    public void updateSiteStatus(Site site, Profile inProfile, ProfileChangeStatus.Status status) {
        SiteEvent siteEvent = new SiteEvent(SiteEvent.Action.STATUS_CHANGE, site, inProfile, status);
        this.fireSiteListener(siteEvent);
    }

    @Override
    public void addAccount(Account account) {
        this.accountList.add(account);
        AccountEvent accountEvent = new AccountEvent(AccountEvent.Action.ADDED, account);
        this.fireAccountListener(accountEvent);
    }

    @Override
    public void addAccounts(Account[] accounts) {
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            this.accountList.add(account);
            ++n2;
        }
        AccountEvent accountEvent = new AccountEvent(AccountEvent.Action.ADDED_ACCOUNTS, accounts);
        this.fireAccountListener(accountEvent);
    }

    @Override
    public Judgement[] getJudgements() {
        return this.judgementDisplayList.getList();
    }

    @Override
    public Run acceptRun(Run run, RunFiles runFiles) throws IOException, ClassNotFoundException, FileSecurityException {
        run.setElapsedMS(this.getContestTime().getElapsedMS());
        run.setSiteNumber(this.getSiteNumber());
        Run newRun = this.runList.addNewRun(run);
        if (runFiles != null) {
            this.runFilesList.add(newRun, runFiles);
        }
        this.addRun(newRun);
        return newRun;
    }

    @Override
    public Clarification acceptClarification(Clarification clarification) {
        clarification.setElapsedMS(this.getContestTime().getElapsedMS());
        clarification.setSiteNumber(this.getSiteNumber());
        try {
            Clarification newClarification = this.clarificationList.addNewClarification(clarification);
            this.addClarification(clarification);
            return newClarification;
        }
        catch (IOException e) {
            this.logException(e);
        }
        catch (ClassNotFoundException e) {
            this.logException(e);
        }
        catch (FileSecurityException e) {
            this.logException(e);
        }
        return null;
    }

    @Override
    public void answerClarification(Clarification clarification, String answer, ClientId whoAnsweredIt, boolean sendToAll) {
        if (this.clarificationList.get(clarification) != null) {
            try {
                ClarificationAnswer clarificationAnswer = new ClarificationAnswer(answer, whoAnsweredIt, sendToAll, this.getContestTime());
                Clarification answerClarification = this.clarificationList.updateClarification(clarification, Clarification.ClarificationStates.ANSWERED, clarificationAnswer);
                ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.ANSWERED_CLARIFICATION, answerClarification);
                clarificationEvent.setWhoModifiedClarification(whoAnsweredIt);
                this.fireClarificationListener(clarificationEvent);
            }
            catch (IOException e) {
                this.logException(e);
            }
            catch (ClassNotFoundException e) {
                this.logException(e);
            }
            catch (FileSecurityException e) {
                this.logException(e);
            }
        } else {
            try {
                this.clarificationList.add(clarification);
                Clarification updatedClarification = this.clarificationList.get(clarification);
                ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.ANSWERED_CLARIFICATION, updatedClarification);
                clarificationEvent.setWhoModifiedClarification(whoAnsweredIt);
                this.fireClarificationListener(clarificationEvent);
            }
            catch (IOException e) {
                this.logException(e);
            }
            catch (ClassNotFoundException e) {
                this.logException(e);
            }
            catch (FileSecurityException e) {
                this.logException(e);
            }
        }
    }

    @Override
    public void updateClarification(Clarification clarification, ClientId whoChangedIt) {
        try {
            this.clarificationList.updateClarification(clarification);
            ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.CHANGED, this.clarificationList.get(clarification));
            if (whoChangedIt != null) {
                clarificationEvent.setWhoModifiedClarification(whoChangedIt);
            }
            clarificationEvent.setSentToClientId(whoChangedIt);
            this.fireClarificationListener(clarificationEvent);
        }
        catch (IOException e) {
            this.logException(e);
        }
        catch (ClassNotFoundException e) {
            this.logException(e);
        }
        catch (FileSecurityException e) {
            this.logException(e);
        }
    }

    @Override
    public void clarificationNotAvailable(Clarification clar) {
        ClarificationEvent clarEvent = new ClarificationEvent(ClarificationEvent.Action.CLARIFICATION_NOT_AVAILABLE, clar);
        this.fireClarificationListener(clarEvent);
    }

    @Override
    public void addRun(Run run) throws IOException, ClassNotFoundException, FileSecurityException {
        this.runList.add(run);
        RunEvent runEvent = new RunEvent(RunEvent.Action.ADDED, run, null, null);
        this.fireRunListener(runEvent);
    }

    @Override
    public void addRun(Run run, RunFiles runFiles, ClientId whoCheckedOutRunId) throws IOException, ClassNotFoundException, FileSecurityException {
        this.runList.add(run);
        this.runFilesList.add(run, runFiles);
        RunEvent runEvent = new RunEvent(RunEvent.Action.CHECKEDOUT_RUN, run, runFiles, null);
        runEvent.setSentToClientId(whoCheckedOutRunId);
        this.fireRunListener(runEvent);
    }

    @Override
    public void addRun(Run run, RunFiles runFiles) throws IOException, ClassNotFoundException, FileSecurityException {
        this.runList.add(run);
        this.runFilesList.add(run, runFiles);
        RunEvent runEvent = new RunEvent(RunEvent.Action.ADDED, run, runFiles, null);
        this.fireRunListener(runEvent);
    }

    @Override
    public void availableRun(Run run) throws IOException, ClassNotFoundException, FileSecurityException {
        this.runList.add(run);
        RunEvent runEvent = new RunEvent(RunEvent.Action.RUN_AVAILABLE, run, null, null);
        this.fireRunListener(runEvent);
    }

    @Override
    public Vector<Account> generateNewAccounts(String clientTypeName, int count, boolean active) {
        return this.generateNewAccounts(clientTypeName, count, 1, active);
    }

    @Override
    public Vector<Account> generateNewAccounts(String clientTypeName, int count, int startNumber, boolean active) {
        ClientType.Type type = ClientType.Type.valueOf(clientTypeName.toUpperCase());
        Vector<Account> newAccounts = this.accountList.generateNewAccounts(type, count, startNumber, AccountList.PasswordType.JOE, this.siteNumber, active);
        int i = 0;
        while (i < newAccounts.size()) {
            Account account = newAccounts.elementAt(i);
            AccountEvent accountEvent = new AccountEvent(AccountEvent.Action.ADDED, account);
            this.fireAccountListener(accountEvent);
            ++i;
        }
        return newAccounts;
    }

    @Override
    public void generateNewSites(int count, boolean active) {
        int numSites = this.siteList.size();
        int i = 0;
        while (i < count) {
            int nextSiteNumber = i + numSites + 1;
            Site site = new Site("Site " + nextSiteNumber, nextSiteNumber);
            site.setPassword("site" + nextSiteNumber);
            site.setActive(active);
            this.addSite(site);
            ++i;
        }
    }

    @Override
    public void addAccountListener(IAccountListener accountListener) {
        this.accountListenerList.addElement(accountListener);
    }

    @Override
    public void removeAccountListener(IAccountListener accountListener) {
        this.accountListenerList.removeElement(accountListener);
    }

    private void fireAccountListener(AccountEvent accountEvent) {
        int i = 0;
        while (i < this.accountListenerList.size()) {
            if (accountEvent.getAction() == AccountEvent.Action.ADDED) {
                this.accountListenerList.elementAt(i).accountAdded(accountEvent);
            } else if (accountEvent.getAction() == AccountEvent.Action.ADDED_ACCOUNTS) {
                this.accountListenerList.elementAt(i).accountsAdded(accountEvent);
            } else if (accountEvent.getAction() == AccountEvent.Action.CHANGED_ACCOUNTS) {
                this.accountListenerList.elementAt(i).accountsModified(accountEvent);
            } else if (accountEvent.getAction() == AccountEvent.Action.REFRESH_ALL) {
                this.accountListenerList.elementAt(i).accountsRefreshAll(accountEvent);
            } else {
                this.accountListenerList.elementAt(i).accountModified(accountEvent);
            }
            ++i;
        }
    }

    @Override
    public Problem[] getProblems() {
        return this.problemDisplayList.getList();
    }

    @Override
    public Category[] getCategories() {
        return this.categoryDisplayList.getList();
    }

    @Override
    public Language[] getLanguages() {
        return this.languageDisplayList.getList();
    }

    @Override
    public ClientId getClientId() {
        return this.localClientId;
    }

    @Override
    public void setClientId(ClientId clientId) {
        this.localClientId = clientId;
        try {
            this.securityMessageHandler = new SecurityMessageHandler(clientId);
        }
        catch (Exception e) {
            this.logException("Trouble establishing SecurityMessageHandler", e);
        }
        if (this.isAllowed(this.localClientId, Permission.Type.ALLOWED_TO_FETCH_RUN) && !this.runFilesList.isWriteToDisk() && !this.runFilesList.isCacheRunFiles()) {
            this.runFilesList.setCacheRunFiles(true);
        }
    }

    @Override
    public Log getSecurityAlertLog() {
        return this.securityMessageHandler.getLog();
    }

    @Override
    public Site[] getSites() {
        return this.siteList.getList();
    }

    @Override
    public String getTitle() {
        ClientId id = this.getClientId();
        if (id == null) {
            return "(Client not logged in)";
        }
        String titleCase = id.getClientType().toString();
        titleCase = String.valueOf(titleCase.charAt(0)) + titleCase.substring(1);
        return String.valueOf(titleCase) + " " + id.getClientNumber() + " (Site " + id.getSiteNumber() + ")";
    }

    @Override
    public void addProblemListener(IProblemListener problemListener) {
        this.problemListenerList.addElement(problemListener);
    }

    @Override
    public void removeProblemListener(IProblemListener problemListener) {
        this.problemListenerList.remove(problemListener);
    }

    @Override
    public void addCategoryListener(ICategoryListener categoryListener) {
        this.categoryListenerList.addElement(categoryListener);
    }

    @Override
    public void removeCategoryListener(ICategoryListener categoryListener) {
        this.categoryListenerList.remove(categoryListener);
    }

    @Override
    public void addLanguageListener(ILanguageListener languageListener) {
        this.languageListenerList.addElement(languageListener);
    }

    @Override
    public void removeLanguageListener(ILanguageListener languageListener) {
        this.languageListenerList.remove(languageListener);
    }

    @Override
    public void addPlayBackEventListener(IPlayBackEventListener playBackEventListener) {
        this.playBackEventListenerList.addElement(playBackEventListener);
    }

    @Override
    public void removePlayBackEventListener(IPlayBackEventListener playBackEventListener) {
        this.playBackEventListenerList.remove(playBackEventListener);
    }

    @Override
    public void addChangePasswordListener(IChangePasswordListener changePasswordListener) {
        this.changePasswordListenerList.add(changePasswordListener);
    }

    @Override
    public void removeChangePasswordListener(IChangePasswordListener changePasswordListener) {
        this.changePasswordListenerList.remove(changePasswordListener);
    }

    @Override
    public void addLoginListener(ILoginListener loginListener) {
        this.loginListenerList.addElement(loginListener);
    }

    @Override
    public void removeLoginListener(ILoginListener loginListener) {
        this.loginListenerList.remove(loginListener);
    }

    @Override
    public void addSiteListener(ISiteListener siteListener) {
        this.siteListenerList.add(siteListener);
    }

    @Override
    public void removeSiteListener(ISiteListener siteListener) {
        this.siteListenerList.remove(siteListener);
    }

    @Override
    public void addConnectionListener(IConnectionListener connectionListener) {
        this.connectionListenerList.addElement(connectionListener);
    }

    @Override
    public void removeConnectionListener(IConnectionListener connectionListener) {
        this.connectionListenerList.remove(connectionListener);
    }

    @Override
    public void addBalloonSettingsListener(IBalloonSettingsListener balloonSettingsListener) {
        this.balloonSettingsListenerList.addElement(balloonSettingsListener);
    }

    @Override
    public void removeBalloonSettingsListener(IBalloonSettingsListener balloonSettingsListener) {
        this.balloonSettingsListenerList.remove(balloonSettingsListener);
    }

    @Override
    public Run getRun(ElementId id) {
        return this.runList.get(id);
    }

    @Override
    public Clarification getClarification(ElementId id) {
        return this.clarificationList.get(id);
    }

    @Override
    public Vector<Account> getAccounts(ClientType.Type type, int inSiteNumber) {
        return this.accountList.getAccounts(type, inSiteNumber);
    }

    @Override
    public Vector<Account> getAccounts(ClientType.Type type) {
        return this.accountList.getAccounts(type);
    }

    @Override
    public boolean isValidLoginAndPassword(ClientId inClientId, String password) {
        return this.accountList.isValidLoginAndPassword(inClientId, password);
    }

    @Override
    public ClientId getLoginClientId(ConnectionHandlerID connectionHandlerID) {
        ClientId clientId = this.localLoginList.getClientId(connectionHandlerID);
        if (clientId == null) {
            clientId = this.remoteLoginList.getClientId(connectionHandlerID);
        }
        return clientId;
    }

    @Override
    public boolean isLoggedIn() {
        return this.localClientId != null;
    }

    @Override
    public boolean isRemoteLoggedIn(ClientId clientId) {
        return this.remoteLoginList.isLoggedIn(clientId);
    }

    @Override
    public boolean isLocalLoggedIn(ClientId clientId) {
        return this.localLoginList.isLoggedIn(clientId);
    }

    @Override
    public Date getLocalLoggedInDate(ClientId clientId) {
        return this.localLoginList.getLoggedInDate(clientId);
    }

    @Override
    public ConnectionHandlerID getConnectionHandleID(ClientId sourceId) {
        ConnectionHandlerID connectionHandlerID = this.localLoginList.getConnectionHandleID(sourceId);
        if (connectionHandlerID == null) {
            connectionHandlerID = this.remoteLoginList.getConnectionHandleID(sourceId);
        }
        return connectionHandlerID;
    }

    @Override
    public ClientId getClientId(ConnectionHandlerID connectionHandlerID) {
        return this.localLoginList.getClientId(connectionHandlerID);
    }

    @Override
    public boolean isConnected(ConnectionHandlerID connectionHandlerID) {
        return this.localConnectionHandlerList.get(connectionHandlerID) != null;
    }

    @Override
    public boolean isConnectedToRemoteSite(ConnectionHandlerID connectionHandlerID) {
        return this.remoteConnectionHandlerList.get(connectionHandlerID) != null;
    }

    @Override
    public ConnectionHandlerID[] getConnectionHandleIDs() {
        ConnectionHandlerID[] localList = this.localConnectionHandlerList.getList();
        ConnectionHandlerID[] remoteList = this.remoteConnectionHandlerList.getList();
        if (localList.length > 0 && remoteList.length > 0) {
            ConnectionHandlerID[] allConnections = new ConnectionHandlerID[localList.length + remoteList.length];
            System.arraycopy(localList, 0, allConnections, 0, localList.length);
            System.arraycopy(remoteList, 0, allConnections, localList.length, remoteList.length);
            return allConnections;
        }
        if (localList.length > 0) {
            return localList;
        }
        return remoteList;
    }

    @Override
    public void removeRemoteLogin(ClientId sourceId) {
        if (this.isRemoteLoggedIn(sourceId)) {
            this.remoteLoginList.remove(sourceId);
        }
        ConnectionHandlerID connectionHandlerID = this.getConnectionHandleID(sourceId);
        LoginEvent loginEvent = new LoginEvent(LoginEvent.Action.LOGOFF, sourceId, connectionHandlerID, "Remote Logoff");
        this.fireLoginListener(loginEvent);
    }

    @Override
    public void removeLogin(ClientId sourceId) {
        if (this.isLocalLoggedIn(sourceId)) {
            this.localLoginList.remove(sourceId);
        } else {
            this.remoteLoginList.remove(sourceId);
        }
        ConnectionHandlerID connectionHandlerID = this.getConnectionHandleID(sourceId);
        LoginEvent loginEvent = new LoginEvent(LoginEvent.Action.LOGOFF, sourceId, connectionHandlerID, "Logoff");
        this.fireLoginListener(loginEvent);
    }

    @Override
    public int getSiteNumber() {
        return this.siteNumber;
    }

    @Override
    public void setSiteNumber(int number) {
        this.siteNumber = number;
    }

    @Override
    public boolean isAllowed(Permission.Type type) {
        return this.isAllowed(this.getClientId(), type);
    }

    @Override
    public boolean isAllowed(ClientId clientId, Permission.Type type) {
        Account account = this.getAccount(clientId);
        if (account == null) {
            ClientType.Type clientType = clientId.getClientType();
            if (clientType.equals((Object)ClientType.Type.SERVER)) {
                return new PermissionGroup().getPermissionList(clientType).isAllowed(type);
            }
            return false;
        }
        return account.isAllowed(type);
    }

    @Override
    public ContestTime getContestTime() {
        return this.getContestTime(this.getSiteNumber());
    }

    @Override
    public ContestTime getContestTime(int inSiteNumber) {
        return this.contestTimeList.get(inSiteNumber);
    }

    @Override
    public ContestTime[] getContestTimes() {
        return this.contestTimeList.getList();
    }

    @Override
    public void startContest(int inSiteNumber) {
        ContestTime contestTime = this.getContestTime(inSiteNumber);
        if (contestTime == null) {
            throw new SecurityException("Unable to start clock site " + inSiteNumber + " not found");
        }
        contestTime.startContestClock();
        ContestTimeEvent contestTimeEvent = new ContestTimeEvent(ContestTimeEvent.Action.CLOCK_STARTED, contestTime, inSiteNumber);
        this.fireContestTimeListener(contestTimeEvent);
    }

    @Override
    public void stopContest(int inSiteNumber) {
        ContestTime contestTime = this.getContestTime(inSiteNumber);
        if (contestTime == null) {
            throw new SecurityException("Unable to stop clock site " + inSiteNumber + " not found");
        }
        contestTime.stopContestClock();
        ContestTimeEvent contestTimeEvent = new ContestTimeEvent(ContestTimeEvent.Action.CLOCK_STOPPED, contestTime, inSiteNumber);
        this.fireContestTimeListener(contestTimeEvent);
    }

    @Override
    public void addContestTime(ContestTime contestTime) {
        if (contestTime == null) {
            throw new IllegalArgumentException("contestTime is null");
        }
        if (this.contestTimeList.get(contestTime.getSiteNumber()) == null) {
            this.contestTimeList.add(contestTime);
            ContestTimeEvent contestTimeEvent = new ContestTimeEvent(ContestTimeEvent.Action.ADDED, contestTime, contestTime.getSiteNumber());
            this.fireContestTimeListener(contestTimeEvent);
        }
    }

    @Override
    public ClientId[] getLocalLoggedInClients(ClientType.Type type) {
        Enumeration<ClientId> localClients = this.localLoginList.getClients(type);
        Vector<ClientId> v = new Vector<ClientId>();
        while (localClients.hasMoreElements()) {
            ClientId element = localClients.nextElement();
            v.addElement(element);
        }
        return v.toArray(new ClientId[v.size()]);
    }

    @Override
    public ClientId[] getRemoteLoggedInClients(ClientType.Type type) {
        Enumeration<ClientId> remoteClients = this.remoteLoginList.getClients(type);
        Vector<ClientId> v = new Vector<ClientId>();
        while (remoteClients.hasMoreElements()) {
            ClientId element = remoteClients.nextElement();
            v.addElement(element);
        }
        return v.toArray(new ClientId[v.size()]);
    }

    @Override
    public ClientId[] getAllLoggedInClients(ClientType.Type type) {
        ClientId element;
        Enumeration<ClientId> localClients = this.localLoginList.getClients(type);
        Enumeration<ClientId> remoteClients = this.remoteLoginList.getClients(type);
        Vector<ClientId> v = new Vector<ClientId>();
        while (localClients.hasMoreElements()) {
            element = localClients.nextElement();
            v.addElement(element);
        }
        while (remoteClients.hasMoreElements()) {
            element = remoteClients.nextElement();
            v.addElement(element);
        }
        return v.toArray(new ClientId[v.size()]);
    }

    @Override
    public Run[] getRuns() {
        return this.runList.getList();
    }

    @Override
    public void runUpdated(Run run, JudgementRecord judgementRecord, RunResultFiles runResultFiles, ClientId whoUpdatedRun) throws IOException, ClassNotFoundException, FileSecurityException {
        boolean manualReview = this.getProblem(run.getProblemId()).isManualReview();
        this.runList.updateRun(run, judgementRecord, manualReview);
        Run newRun = this.runList.get(run.getElementId());
        RunEvent runEvent = new RunEvent(RunEvent.Action.CHANGED, newRun, null, null);
        runEvent.setWhoModifiedRun(whoUpdatedRun);
        this.fireRunListener(runEvent);
    }

    @Override
    public void updateRunStatus(Run run, RunExecutionStatus status, ClientId whoUpdatedRun) {
        RunEvent.Action action = null;
        switch (status) {
            case EXECUTING: {
                action = RunEvent.Action.RUN_EXECUTING;
                break;
            }
            case VALIDATING: {
                action = RunEvent.Action.RUN_VALIDATING;
                break;
            }
            default: {
                action = RunEvent.Action.RUN_COMPILING;
            }
        }
        RunEvent runEvent = new RunEvent(action, run, null, null);
        runEvent.setWhoModifiedRun(whoUpdatedRun);
        this.fireRunListener(runEvent);
    }

    @Override
    public void runNotAvailable(Run run) {
        RunEvent runEvent = new RunEvent(RunEvent.Action.RUN_NOT_AVAILABLE, run, null, null);
        this.fireRunListener(runEvent);
    }

    @Override
    public Run checkoutRun(Run run, ClientId whoChangedRun, boolean reCheckoutRun, boolean computerJudge) throws RunUnavailableException, IOException, ClassNotFoundException, FileSecurityException {
        Hashtable<ElementId, ClientId> hashtable = this.runCheckOutList;
        synchronized (hashtable) {
            boolean canBeCheckedOut;
            ClientId clientId = this.runCheckOutList.get(run.getElementId());
            if (clientId != null) {
                throw new RunUnavailableException("Client " + clientId + " already checked out run " + run.getNumber() + " (site " + run.getSiteNumber() + ")");
            }
            Run newRun = this.runList.get(run.getElementId());
            if (newRun == null) {
                throw new RunUnavailableException("Run " + run.getNumber() + " (site " + run.getSiteNumber() + ") not found");
            }
            boolean bl = canBeCheckedOut = newRun.getStatus().equals((Object)Run.RunStates.NEW) || newRun.getStatus().equals((Object)Run.RunStates.QUEUED_FOR_COMPUTER_JUDGEMENT) || newRun.getStatus().equals((Object)Run.RunStates.MANUAL_REVIEW);
            if (reCheckoutRun && run.isJudged()) {
                canBeCheckedOut = true;
            }
            if (canBeCheckedOut) {
                this.runCheckOutList.put(newRun.getElementId(), whoChangedRun);
                newRun.setStatus(Run.RunStates.BEING_JUDGED);
                if (reCheckoutRun) {
                    newRun.setStatus(Run.RunStates.BEING_RE_JUDGED);
                }
                this.runList.updateRun(newRun);
                return this.runList.get(run.getElementId());
            }
            throw new RunUnavailableException("Client " + clientId + " can not checked out run " + run.getNumber() + " (site " + run.getSiteNumber() + ")");
        }
    }

    @Override
    public void updateRun(Run run, ClientId whoChangedRun) throws IOException, ClassNotFoundException, FileSecurityException {
        this.updateRun(run, null, whoChangedRun, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRun(Run run, RunFiles runFiles, ClientId whoChangedRun, RunResultFiles[] runResultFiles) throws IOException, ClassNotFoundException, FileSecurityException {
        Hashtable<ElementId, ClientId> hashtable;
        boolean unCheckoutRun = false;
        boolean checkOutRun = false;
        switch (run.getStatus()) {
            case CHECKED_OUT: 
            case BEING_JUDGED: 
            case BEING_RE_JUDGED: 
            case HOLD: {
                checkOutRun = true;
                break;
            }
            case NEW: 
            case REJUDGE: 
            case JUDGED: {
                unCheckoutRun = true;
            }
        }
        if (checkOutRun) {
            hashtable = this.runCheckOutList;
            synchronized (hashtable) {
                this.runCheckOutList.put(run.getElementId(), whoChangedRun);
            }
        }
        if (unCheckoutRun) {
            hashtable = this.runCheckOutList;
            synchronized (hashtable) {
                ClientId clientId = this.runCheckOutList.get(run.getElementId());
                if (clientId != null) {
                    this.runCheckOutList.remove(run.getElementId());
                }
            }
        }
        this.runList.updateRun(run);
        if (this.runFilesList.isCacheRunFiles()) {
            this.runFilesList.add(run, runFiles);
        }
        RunEvent runEvent = new RunEvent(RunEvent.Action.CHANGED, this.runList.get(run), runFiles, runResultFiles);
        runEvent.setWhoModifiedRun(whoChangedRun);
        if (run.getStatus().equals((Object)Run.RunStates.BEING_JUDGED) || run.getStatus().equals((Object)Run.RunStates.BEING_RE_JUDGED)) {
            runEvent.setDetailedAction(RunEvent.Action.CHECKEDOUT_RUN);
        }
        if (checkOutRun) {
            runEvent.setSentToClientId(whoChangedRun);
        }
        this.fireRunListener(runEvent);
    }

    @Override
    public RunFiles getRunFiles(Run run) throws IOException, ClassNotFoundException, FileSecurityException {
        return this.runFilesList.getRunFiles(run);
    }

    @Override
    public boolean isRunFilesPresent(Run run) throws IOException, ClassNotFoundException, FileSecurityException {
        return this.runFilesList.isRunFilesPresent(run);
    }

    @Override
    public void addRunJudgement(Run run, JudgementRecord judgementRecord, RunResultFiles runResultFiles, ClientId whoJudgedItId) throws IOException, ClassNotFoundException, FileSecurityException {
        Exception ex;
        Run theRun = this.runList.get(run);
        ClientId whoCheckedOut = this.runCheckOutList.get(run.getElementId());
        ClientId whoChangedItId = judgementRecord.getJudgerClientId();
        if (whoCheckedOut == null && !whoChangedItId.getClientType().equals((Object)ClientType.Type.ADMINISTRATOR)) {
            ex = new Exception("addRunJudgement - not in checkedout list, whoCheckedOut is null ");
            this.logException("Odd that. ", ex);
        } else if (!whoChangedItId.equals(whoCheckedOut) && !whoChangedItId.getClientType().equals((Object)ClientType.Type.ADMINISTRATOR)) {
            ex = new Exception("addRunJudgement - who checked out and who it is differ ");
            this.logException(ex);
        }
        boolean manualReview = this.getProblem(theRun.getProblemId()).isManualReview();
        this.runList.updateRun(theRun, judgementRecord, manualReview);
        this.runResultFilesList.add(theRun, judgementRecord, runResultFiles);
        if (whoCheckedOut != null) {
            this.runCheckOutList.remove(run.getElementId());
        }
        theRun = this.runList.get(run);
        RunEvent runEvent = new RunEvent(RunEvent.Action.CHANGED, theRun, null, null);
        this.fireRunListener(runEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRunCheckOut(Run run, ClientId fromId) throws UnableToUncheckoutRunException, IOException, ClassNotFoundException, FileSecurityException {
        ClientId whoCheckedOut = this.runCheckOutList.get(run.getElementId());
        if (whoCheckedOut == null) {
            throw new UnableToUncheckoutRunException(fromId + " can not checkout " + run + " not checked out");
        }
        boolean userCheckedOutRun = fromId.equals(whoCheckedOut);
        if (this.isAdministrator(fromId) && this.isAllowed(fromId, Permission.Type.EDIT_RUN)) {
            userCheckedOutRun = true;
        }
        if (!userCheckedOutRun) {
            throw new UnableToUncheckoutRunException(fromId + " can not checkout " + run + " checked out to " + whoCheckedOut);
        }
        Run theRun = this.getRun(run.getElementId());
        if (theRun.getStatus().equals((Object)Run.RunStates.BEING_JUDGED)) {
            if (theRun.getComputerJudgementRecord() == null) {
                run.setStatus(Run.RunStates.NEW);
            } else {
                run.setStatus(Run.RunStates.MANUAL_REVIEW);
            }
        } else if (theRun.getStatus().equals((Object)Run.RunStates.BEING_RE_JUDGED)) {
            run.setStatus(Run.RunStates.JUDGED);
        }
        Hashtable<ElementId, ClientId> hashtable = this.runCheckOutList;
        synchronized (hashtable) {
            this.runCheckOutList.remove(run.getElementId());
        }
        this.runList.updateRun(run);
        theRun = this.runList.get(run);
        RunEvent runEvent = new RunEvent(RunEvent.Action.RUN_AVAILABLE, theRun, null, null);
        this.fireRunListener(runEvent);
    }

    protected boolean isAdministrator(ClientId clientId) {
        return clientId.getClientType().equals((Object)ClientType.Type.ADMINISTRATOR);
    }

    @Override
    public ClientId getRunCheckedOutBy(Run run) {
        return this.runCheckOutList.get(run.getElementId());
    }

    @Override
    public ElementId[] getRunIdsCheckedOutBy(ClientId judgeID) {
        Vector<ElementId> v = new Vector<ElementId>();
        Enumeration<ElementId> runIDs = this.runCheckOutList.keys();
        while (runIDs.hasMoreElements()) {
            ElementId runId = runIDs.nextElement();
            ClientId cID = this.runCheckOutList.get(runId);
            if (!cID.equals(judgeID)) continue;
            v.addElement(runId);
        }
        return v.toArray(new ElementId[v.size()]);
    }

    @Override
    public Clarification[] getClarifications() {
        return this.clarificationList.getList();
    }

    @Override
    public void passwordChanged(boolean success, ClientId clientId, String message) {
        PasswordChangeEvent.Action action = PasswordChangeEvent.Action.PASSWORD_NOT_CHANGED;
        if (success) {
            action = PasswordChangeEvent.Action.PASSWORD_CHANGED;
        }
        PasswordChangeEvent passwordChangeEvent = new PasswordChangeEvent(clientId, action, message);
        this.firePasswordChangeListener(passwordChangeEvent);
    }

    private void firePasswordChangeListener(PasswordChangeEvent passwordChangeEvent) {
        int i = 0;
        while (i < this.changePasswordListenerList.size()) {
            if (passwordChangeEvent.getAction() == PasswordChangeEvent.Action.PASSWORD_CHANGED) {
                this.changePasswordListenerList.elementAt(i).passwordChanged(passwordChangeEvent);
            } else if (passwordChangeEvent.getAction() == PasswordChangeEvent.Action.PASSWORD_NOT_CHANGED) {
                this.changePasswordListenerList.elementAt(i).passwordNotChanged(passwordChangeEvent);
            } else {
                throw new IllegalArgumentException("Unhandled  ");
            }
            ++i;
        }
    }

    @Override
    public void updateLanguage(Language language) {
        this.languageList.update(language);
        this.languageDisplayList.update(language);
        LanguageEvent languageEvent = new LanguageEvent(LanguageEvent.Action.CHANGED, language);
        this.fireLanguageListener(languageEvent);
    }

    @Override
    public void updateProblem(Problem problem) {
        this.problemList.update(problem);
        this.problemDisplayList.update(problem);
        ProblemEvent problemEvent = new ProblemEvent(ProblemEvent.Action.CHANGED, problem);
        this.fireProblemListener(problemEvent);
    }

    @Override
    public void updateCategory(Category category) {
        this.categoryList.update(category);
        this.categoryDisplayList.update(category);
        this.fireCategoryListener(category, CategoryEvent.Action.CHANGED);
    }

    @Override
    public void updateContestTime(ContestTime contestTime, int inSiteNumber) {
        if (contestTime == null) {
            throw new IllegalArgumentException("contestTime is null");
        }
        if (inSiteNumber != contestTime.getSiteNumber()) {
            throw new IllegalArgumentException("contestTime site number (" + contestTime + ") does not match " + inSiteNumber);
        }
        this.contestTimeList.update(contestTime);
        ContestTimeEvent contestTimeEvent = new ContestTimeEvent(ContestTimeEvent.Action.CHANGED, contestTime, contestTime.getSiteNumber());
        this.fireContestTimeListener(contestTimeEvent);
    }

    @Override
    public void updateContestTime(ContestTime contestTime) {
        if (contestTime == null) {
            throw new IllegalArgumentException("contestTime is null");
        }
        this.contestTimeList.update(contestTime);
        ContestTimeEvent contestTimeEvent = new ContestTimeEvent(ContestTimeEvent.Action.CHANGED, contestTime, contestTime.getSiteNumber());
        this.fireContestTimeListener(contestTimeEvent);
    }

    @Override
    public void updateJudgement(Judgement judgement) {
        this.judgementDisplayList.update(judgement);
        this.judgementList.update(judgement);
        JudgementEvent judgementEvent = new JudgementEvent(JudgementEvent.Action.CHANGED, judgement);
        this.fireJudgementListener(judgementEvent);
    }

    @Override
    public void changeSite(Site site) {
        this.siteList.update(site);
        SiteEvent siteEvent = new SiteEvent(SiteEvent.Action.CHANGED, site);
        this.fireSiteListener(siteEvent);
    }

    @Override
    public void updateAccount(Account account) {
        this.accountList.update(account);
        AccountEvent accountEvent = new AccountEvent(AccountEvent.Action.CHANGED, account);
        this.fireAccountListener(accountEvent);
    }

    @Override
    public void updateAccounts(Account[] accounts) {
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            this.accountList.update(account);
            ++n2;
        }
        AccountEvent accountEvent = new AccountEvent(AccountEvent.Action.CHANGED_ACCOUNTS, accounts);
        this.fireAccountListener(accountEvent);
    }

    @Override
    public Language getLanguage(ElementId elementId) {
        return (Language)this.languageList.get(elementId);
    }

    @Override
    public ContestTime getContestTime(ElementId elementId) {
        return this.contestTimeList.get(elementId);
    }

    @Override
    public Problem getProblem(ElementId elementId) {
        if (this.generalProblem != null && this.generalProblem.getElementId().equals(elementId)) {
            return this.generalProblem;
        }
        Problem problem = (Problem)this.problemList.get(elementId);
        if (problem == null) {
            problem = this.getCategory(elementId);
        }
        return problem;
    }

    @Override
    public Category getCategory(ElementId elementId) {
        return (Category)this.categoryList.get(elementId);
    }

    @Override
    public Judgement getJudgement(ElementId elementId) {
        return (Judgement)this.judgementList.get(elementId);
    }

    @Override
    public Account getAccount(ClientId inClientId) {
        return this.accountList.getAccount(inClientId);
    }

    @Override
    public Site getSite(int number) {
        Site[] sites;
        Site[] siteArray = sites = this.siteList.getList();
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            Site site = siteArray[n2];
            if (site.getSiteNumber() == number) {
                return site;
            }
            ++n2;
        }
        return null;
    }

    private void fireClarificationListener(ClarificationEvent clarificationEvent) {
        int i = 0;
        while (i < this.clarificationListenerList.size()) {
            if (clarificationEvent.getAction() == ClarificationEvent.Action.ADDED) {
                this.clarificationListenerList.elementAt(i).clarificationAdded(clarificationEvent);
            } else if (clarificationEvent.getAction() == ClarificationEvent.Action.REFRESH_ALL) {
                this.clarificationListenerList.elementAt(i).refreshClarfications(clarificationEvent);
            } else if (clarificationEvent.getAction() == ClarificationEvent.Action.DELETED) {
                this.clarificationListenerList.elementAt(i).clarificationRemoved(clarificationEvent);
            } else {
                this.clarificationListenerList.elementAt(i).clarificationChanged(clarificationEvent);
            }
            ++i;
        }
    }

    @Override
    public void addClarification(Clarification clarification) throws IOException, ClassNotFoundException, FileSecurityException {
        this.clarificationList.add(clarification);
        ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.ADDED, clarification);
        this.fireClarificationListener(clarificationEvent);
    }

    @Override
    public void addClarification(Clarification clarification, ClientId whoCheckedOutId) throws IOException, ClassNotFoundException, FileSecurityException {
        this.clarificationList.add(clarification);
        ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.CHECKEDOUT_CLARIFICATION, clarification);
        clarificationEvent.setSentToClientId(whoCheckedOutId);
        this.fireClarificationListener(clarificationEvent);
    }

    @Override
    public void removeClarification(Clarification clarification) throws IOException, ClassNotFoundException, FileSecurityException {
        this.clarificationList.delete(clarification);
        ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.DELETED, clarification);
        this.fireClarificationListener(clarificationEvent);
    }

    @Override
    public void changeClarification(Clarification clarification) throws IOException, ClassNotFoundException, FileSecurityException {
        this.clarificationList.updateClarification(clarification);
        ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.CHANGED, clarification);
        this.fireClarificationListener(clarificationEvent);
    }

    @Override
    public void connectionEstablished(ConnectionHandlerID connectionHandlerID) {
        this.connectionEstablished(connectionHandlerID, new Date());
    }

    @Override
    public void connectionEstablished(ConnectionHandlerID connectionHandlerID, Date connectDate) {
        this.localConnectionHandlerList.add(connectionHandlerID, connectDate);
        ConnectionEvent connectionEvent = new ConnectionEvent(ConnectionEvent.Action.ESTABLISHED, connectionHandlerID);
        this.fireConnectionListener(connectionEvent);
    }

    @Override
    public void connectionDropped(ConnectionHandlerID connectionHandlerID) {
        if (connectionHandlerID != null) {
            this.localConnectionHandlerList.remove(connectionHandlerID);
        }
        ConnectionEvent connectionEvent = new ConnectionEvent(ConnectionEvent.Action.DROPPED, connectionHandlerID);
        this.fireConnectionListener(connectionEvent);
    }

    @Override
    public ConnectionHandlerID[] getConnectionHandlerIDs() {
        return this.localConnectionHandlerList.getList();
    }

    @Override
    public Clarification[] getClarifications(ClientId clientId) {
        Vector<Clarification> clientClarifications = new Vector<Clarification>();
        Enumeration<Clarification> enumeration = this.clarificationList.getClarList();
        while (enumeration.hasMoreElements()) {
            Clarification clarification = enumeration.nextElement();
            if (!clarification.isSendToAll() && !clientId.equals(clarification.getSubmitter())) continue;
            clientClarifications.add(clarification);
        }
        return clientClarifications.toArray(new Clarification[clientClarifications.size()]);
    }

    @Override
    public Run[] getRuns(ClientId clientId) {
        Vector<Run> clientRuns = new Vector<Run>();
        Enumeration<Run> enumeration = this.runList.getRunList();
        while (enumeration.hasMoreElements()) {
            Run run = enumeration.nextElement();
            if (!clientId.equals(run.getSubmitter())) continue;
            clientRuns.add(run);
        }
        return clientRuns.toArray(new Run[clientRuns.size()]);
    }

    @Override
    public void addProblem(Problem problem, ProblemDataFiles problemDataFiles) {
        this.problemDisplayList.add(problem);
        this.problemList.add(problem);
        if (problemDataFiles != null) {
            this.problemDataFilesList.add(problemDataFiles);
        }
        ProblemEvent problemEvent = new ProblemEvent(ProblemEvent.Action.ADDED, problem, problemDataFiles);
        this.fireProblemListener(problemEvent);
    }

    @Override
    public void updateProblem(Problem problem, ProblemDataFiles problemDataFiles) {
        this.problemList.update(problem);
        this.problemDataFilesList.update(problemDataFiles);
        this.problemDisplayList.update(problem);
        ProblemEvent problemEvent = new ProblemEvent(ProblemEvent.Action.CHANGED, problem, problemDataFiles);
        this.fireProblemListener(problemEvent);
    }

    @Override
    public ProblemDataFiles getProblemDataFile(Problem problem) {
        return (ProblemDataFiles)this.problemDataFilesList.get(problem);
    }

    @Override
    public ProblemDataFiles[] getProblemDataFiles() {
        return this.problemDataFilesList.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelClarificationCheckOut(Clarification clarification, ClientId whoCancelledIt) throws IOException, ClassNotFoundException, FileSecurityException {
        this.clarificationList.updateClarification(clarification, Clarification.ClarificationStates.NEW, whoCancelledIt);
        Hashtable<ElementId, ClientId> hashtable = this.clarCheckOutList;
        synchronized (hashtable) {
            this.clarCheckOutList.remove(clarification.getElementId());
        }
        Clarification theClarification = this.clarificationList.get(clarification);
        ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.CLARIFICATION_AVAILABLE, theClarification);
        this.fireClarificationListener(clarificationEvent);
    }

    private void fireClientSettingsListener(ClientSettingsEvent clientSettingsEvent) {
        int i = 0;
        while (i < this.clientSettingsListenerList.size()) {
            if (clientSettingsEvent.getAction() == ClientSettingsEvent.Action.ADDED) {
                this.clientSettingsListenerList.elementAt(i).clientSettingsAdded(clientSettingsEvent);
            } else if (clientSettingsEvent.getAction() == ClientSettingsEvent.Action.DELETED) {
                this.clientSettingsListenerList.elementAt(i).clientSettingsRemoved(clientSettingsEvent);
            } else if (clientSettingsEvent.getAction() == ClientSettingsEvent.Action.REFRESH_ALL) {
                this.clientSettingsListenerList.elementAt(i).clientSettingsRefreshAll(clientSettingsEvent);
            } else {
                this.clientSettingsListenerList.elementAt(i).clientSettingsChanged(clientSettingsEvent);
            }
            ++i;
        }
    }

    @Override
    public void addClientSettings(ClientSettings clientSettings) {
        this.clientSettingsList.add(clientSettings);
        ClientSettingsEvent clientSettingsEvent = new ClientSettingsEvent(ClientSettingsEvent.Action.ADDED, clientSettings.getClientId(), clientSettings);
        this.fireClientSettingsListener(clientSettingsEvent);
    }

    @Override
    public ClientSettings getClientSettings() {
        return this.clientSettingsList.get(this.getClientId());
    }

    @Override
    public ClientSettings getClientSettings(ClientId clientId) {
        return this.clientSettingsList.get(clientId);
    }

    @Override
    public ClientSettings[] getClientSettingsList() {
        return this.clientSettingsList.getList();
    }

    @Override
    public void updateClientSettings(ClientSettings clientSettings) {
        this.clientSettingsList.update(clientSettings);
        ClientSettingsEvent clientSettingsEvent = new ClientSettingsEvent(ClientSettingsEvent.Action.CHANGED, clientSettings.getClientId(), clientSettings);
        this.fireClientSettingsListener(clientSettingsEvent);
    }

    @Override
    public void addClientSettingsListener(IClientSettingsListener clientSettingsListener) {
        this.clientSettingsListenerList.addElement(clientSettingsListener);
    }

    @Override
    public void removeClientSettingsListener(IClientSettingsListener clientSettingsListener) {
        this.clientSettingsListenerList.remove(clientSettingsListener);
    }

    private void fireContestInformationListener(ContestInformationEvent contestInformationEvent) {
        int i = 0;
        while (i < this.contestInformationListenerList.size()) {
            if (contestInformationEvent.getAction() == ContestInformationEvent.Action.ADDED) {
                this.contestInformationListenerList.elementAt(i).contestInformationAdded(contestInformationEvent);
            } else if (contestInformationEvent.getAction() == ContestInformationEvent.Action.DELETED) {
                this.contestInformationListenerList.elementAt(i).contestInformationRemoved(contestInformationEvent);
            } else if (contestInformationEvent.getAction() == ContestInformationEvent.Action.REFRESH_ALL) {
                this.contestInformationListenerList.elementAt(i).contestInformationRefreshAll(contestInformationEvent);
            } else if (contestInformationEvent.getAction() == ContestInformationEvent.Action.CHANGED_FINALIZED) {
                this.contestInformationListenerList.elementAt(i).finalizeDataChanged(contestInformationEvent);
            } else {
                this.contestInformationListenerList.elementAt(i).contestInformationChanged(contestInformationEvent);
            }
            ++i;
        }
    }

    @Override
    public void addContestInformation(ContestInformation inContestInformation) {
        this.contestInformation = inContestInformation;
        ContestInformationEvent contestInformationEvent = new ContestInformationEvent(ContestInformationEvent.Action.ADDED, this.contestInformation);
        this.fireContestInformationListener(contestInformationEvent);
    }

    @Override
    public void updateContestInformation(ContestInformation inContestInformation) {
        this.contestInformation = inContestInformation;
        ContestInformationEvent contestInformationEvent = new ContestInformationEvent(ContestInformationEvent.Action.CHANGED, this.contestInformation);
        this.fireContestInformationListener(contestInformationEvent);
    }

    @Override
    public void addContestInformationListener(IContestInformationListener contestInformationListener) {
        this.contestInformationListenerList.addElement(contestInformationListener);
    }

    @Override
    public void removeContestInformationListener(IContestInformationListener contestInformationListener) {
        this.contestInformationListenerList.remove(contestInformationListener);
    }

    @Override
    public ContestInformation getContestInformation() {
        return this.contestInformation;
    }

    @Override
    public void setJudgementList(Judgement[] judgements) {
        Judgement judgement;
        Judgement[] judgementArray = this.judgementDisplayList.getList();
        int n = judgementArray.length;
        int n2 = 0;
        while (n2 < n) {
            judgement = judgementArray[n2];
            JudgementEvent judgementEvent = new JudgementEvent(JudgementEvent.Action.DELETED, judgement);
            this.fireJudgementListener(judgementEvent);
            ++n2;
        }
        this.judgementDisplayList = new JudgementDisplayList();
        judgementArray = judgements;
        n = judgements.length;
        n2 = 0;
        while (n2 < n) {
            judgement = judgementArray[n2];
            Judgement judgementFromList = (Judgement)this.judgementList.get(judgement.getElementId());
            if (judgementFromList == null) {
                this.judgementList.add(judgement);
            }
            this.judgementDisplayList.add(judgement);
            JudgementEvent judgementEvent = new JudgementEvent(JudgementEvent.Action.ADDED, judgement);
            this.fireJudgementListener(judgementEvent);
            ++n2;
        }
    }

    @Override
    public void removeJudgement(Judgement judgement) {
        int idx = this.judgementDisplayList.indexOf(judgement);
        if (idx != -1) {
            this.judgementDisplayList.remove(idx);
            JudgementEvent judgementEvent = new JudgementEvent(JudgementEvent.Action.DELETED, judgement);
            this.fireJudgementListener(judgementEvent);
        }
    }

    @Override
    public int getMaxRetryMSecs() {
        return 700;
    }

    @Override
    public int getMaxConnectionRetries() {
        return 5;
    }

    @Override
    public void addBalloonSettings(BalloonSettings balloonSettings) {
        this.balloonSettingsList.add(balloonSettings);
        BalloonSettingsEvent balloonSettingsEvent = new BalloonSettingsEvent(BalloonSettingsEvent.Action.ADDED, balloonSettings);
        this.fireBalloonSettingsListener(balloonSettingsEvent);
    }

    @Override
    public void updateBalloonSettings(BalloonSettings balloonSettings) {
        this.balloonSettingsList.update(balloonSettings);
        BalloonSettingsEvent balloonSettingsEvent = new BalloonSettingsEvent(BalloonSettingsEvent.Action.CHANGED, balloonSettings);
        this.fireBalloonSettingsListener(balloonSettingsEvent);
    }

    @Override
    public BalloonSettings getBalloonSettings(int siteNum) {
        BalloonSettings[] balloonSettingsArray = this.balloonSettingsList.getList();
        int n = balloonSettingsArray.length;
        int n2 = 0;
        while (n2 < n) {
            BalloonSettings balloonSettings = balloonSettingsArray[n2];
            if (siteNum == balloonSettings.getSiteNumber()) {
                return balloonSettings;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public BalloonSettings[] getBalloonSettings() {
        return this.balloonSettingsList.getList();
    }

    @Override
    public BalloonSettings getBalloonSettings(ElementId elementId) {
        return this.balloonSettingsList.get(elementId);
    }

    @Override
    public void addGroup(Group group) {
        this.groupDisplayList.add(group);
        this.groupList.add(group);
        GroupEvent groupEvent = new GroupEvent(GroupEvent.Action.ADDED, group);
        this.fireGroupListener(groupEvent);
    }

    private void fireGroupListener(GroupEvent groupEvent) {
        int i = 0;
        while (i < this.groupListenerList.size()) {
            if (groupEvent.getAction() == GroupEvent.Action.ADDED) {
                this.groupListenerList.elementAt(i).groupAdded(groupEvent);
            } else if (groupEvent.getAction() == GroupEvent.Action.DELETED) {
                this.groupListenerList.elementAt(i).groupRemoved(groupEvent);
            } else if (groupEvent.getAction() == GroupEvent.Action.REFRESH_ALL) {
                this.groupListenerList.elementAt(i).groupRefreshAll(groupEvent);
            } else if (groupEvent.getAction() == GroupEvent.Action.ADDED_GROUPS) {
                this.groupListenerList.elementAt(i).groupRefreshAll(groupEvent);
            } else if (groupEvent.getAction() == GroupEvent.Action.CHANGED_GROUPS) {
                this.groupListenerList.elementAt(i).groupRefreshAll(groupEvent);
            } else {
                this.groupListenerList.elementAt(i).groupChanged(groupEvent);
            }
            ++i;
        }
    }

    @Override
    public void removeGroup(Group group) {
        int idx = this.groupDisplayList.indexOf(group);
        if (idx != -1) {
            this.groupDisplayList.remove(idx);
            GroupEvent groupEvent = new GroupEvent(GroupEvent.Action.DELETED, group);
            this.fireGroupListener(groupEvent);
        }
    }

    @Override
    public void updateGroup(Group group) {
        this.groupList.update(group);
        this.groupDisplayList.update(group);
        GroupEvent groupEvent = new GroupEvent(GroupEvent.Action.CHANGED, group);
        this.fireGroupListener(groupEvent);
    }

    @Override
    public Group[] getGroups() {
        return this.groupDisplayList.getList();
    }

    @Override
    public void addGroupListener(IGroupListener groupListener) {
        this.groupListenerList.addElement(groupListener);
    }

    @Override
    public void removeGroupListener(IGroupListener groupListener) {
        this.groupListenerList.remove(groupListener);
    }

    @Override
    public Group getGroup(ElementId elementId) {
        return (Group)this.groupList.get(elementId);
    }

    @Override
    public Problem getGeneralProblem() {
        return this.generalProblem;
    }

    @Override
    public void setGeneralProblem(Problem generalProblem) {
        this.generalProblem = generalProblem;
    }

    @Override
    public Clarification checkoutClarification(Clarification clar, ClientId whoChangedClar) throws ClarificationUnavailableException, IOException, ClassNotFoundException, FileSecurityException {
        Hashtable<ElementId, ClientId> hashtable = this.clarCheckOutList;
        synchronized (hashtable) {
            ClientId clientId = this.clarCheckOutList.get(clar.getElementId());
            if (clientId != null) {
                throw new ClarificationUnavailableException("Client " + clientId + " already checked out clar " + clar.getNumber() + " (site " + clar.getSiteNumber() + ")");
            }
            Clarification newClar = this.clarificationList.get(clar.getElementId());
            if (newClar == null) {
                throw new ClarificationUnavailableException("Run " + clar.getNumber() + " (site " + clar.getSiteNumber() + ") not found");
            }
            if (newClar.getState().equals((Object)Clarification.ClarificationStates.NEW)) {
                this.clarCheckOutList.put(newClar.getElementId(), whoChangedClar);
                newClar.setState(Clarification.ClarificationStates.BEING_ANSWERED);
                newClar.setWhoCheckedItOutId(whoChangedClar);
                this.clarificationList.updateClarification(newClar);
                return this.clarificationList.get(clar.getElementId());
            }
            throw new ClarificationUnavailableException("Client " + clientId + " can not checked out clar " + clar.getNumber() + " (site " + clar.getSiteNumber() + ")");
        }
    }

    @Override
    public void newSecurityMessage(ClientId clientId, String message, String eventName, ContestSecurityException contestSecurityException) {
        this.securityMessageHandler.newMessage(clientId, eventName, message, contestSecurityException);
    }

    @Override
    public void addSecurityMessageListener(ISecurityMessageListener securityMessageListener) {
        this.securityMessageHandler.addSecurityMessageListener(securityMessageListener);
    }

    @Override
    public void removeSecurityMessageListener(ISecurityMessageListener securityMessageListener) {
        this.securityMessageHandler.addSecurityMessageListener(securityMessageListener);
    }

    @Override
    public RunResultFiles[] getRunResultFiles(Run run) throws IOException, ClassNotFoundException, FileSecurityException {
        return this.runResultFilesList.getRunResultFiles(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetSubmissionData() {
        Hashtable<ElementId, ClientId> hashtable = this.runCheckOutList;
        synchronized (hashtable) {
            this.runCheckOutList = new Hashtable();
        }
        try {
            this.runList.clear();
        }
        catch (IOException e) {
            this.logException(e);
        }
        catch (ClassNotFoundException e) {
            this.logException(e);
        }
        catch (FileSecurityException e) {
            this.logException(e);
        }
        this.runFilesList.clearCache();
        this.runResultFilesList.clear();
        Hashtable<ElementId, ClientId> e = this.clarCheckOutList;
        synchronized (e) {
            this.clarCheckOutList = new Hashtable();
        }
        try {
            this.clarificationList.clear();
        }
        catch (IOException e2) {
            this.logException(e2);
        }
        catch (ClassNotFoundException e3) {
            this.logException(e3);
        }
        catch (FileSecurityException e4) {
            this.logException(e4);
        }
    }

    @Override
    public void resetConfigurationData() {
        this.groupList = new GroupList();
        this.groupDisplayList = new GroupDisplayList();
        this.accountList = new AccountList();
        this.judgementDisplayList = new JudgementDisplayList();
        this.judgementList = new JudgementList();
        this.problemList = new ProblemList();
        this.problemDataFilesList = new ProblemDataFilesList();
        this.problemDisplayList = new ProblemDisplayList();
        this.languageList = new LanguageList();
        this.languageDisplayList = new LanguageDisplayList();
        this.contestTimeList = new ContestTimeList();
        this.contestInformation = new ContestInformation();
        this.clientSettingsList = new ClientSettingsList();
        this.balloonSettingsList = new BalloonSettingsList();
        this.generalProblem = null;
        this.categoryList = new CategoryList();
        this.categoryDisplayList = new CategoryDisplayList();
        this.siteList = new SiteList();
        this.profileList = new ProfilesList();
        this.profileCloneSettings = null;
    }

    @Override
    public boolean isSendAdditionalRunStatusMessages() {
        return this.contestInformation.isSendAdditionalRunStatusInformation();
    }

    @Override
    public void deleteProblem(Problem problem) {
        this.problemDisplayList.removeElement(problem);
        this.problemList.delete(problem);
        this.problemDataFilesList.delete(problem);
        ProblemEvent problemEvent = new ProblemEvent(ProblemEvent.Action.DELETED, problem);
        this.fireProblemListener(problemEvent);
    }

    @Override
    public void deleteCategory(Category category) {
        this.categoryDisplayList.removeElement(category);
        this.categoryList.delete(category);
        this.fireCategoryListener(category, CategoryEvent.Action.DELETED);
    }

    @Override
    public void deleteLanguage(Language language) {
        this.languageDisplayList.removeElement(language);
        this.languageList.delete(language);
        LanguageEvent languageEvent = new LanguageEvent(LanguageEvent.Action.DELETED, language);
        this.fireLanguageListener(languageEvent);
    }

    @Override
    public boolean contestIdMatches(String identifier) {
        if (this.profile == null) {
            return false;
        }
        return this.profile.matchesIdentifier(identifier);
    }

    @Override
    public String getContestIdentifier() {
        if (this.profile != null) {
            return this.profile.getContestId();
        }
        return this.contestIdentifier;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public Profile getProfile(ElementId id) {
        return (Profile)this.profileList.get(id);
    }

    @Override
    public void setProfile(Profile profile) {
        this.profile = profile;
        if (this.profileList.size() == 0) {
            this.addProfile(profile);
        } else {
            this.updateProfile(profile);
        }
        this.setContestIdentifier(profile.getContestId());
    }

    @Override
    public void setContestIdentifier(String contestId) {
        this.contestIdentifier = contestId;
    }

    @Override
    public Profile addProfile(Profile theProfile) {
        this.profileList.add(theProfile);
        ProfileEvent profileEvent = new ProfileEvent(ProfileEvent.Action.ADDED, theProfile);
        this.fireProfileListener(profileEvent);
        return theProfile;
    }

    private void fireProfileListener(ProfileEvent profileEvent) {
        int i = 0;
        while (i < this.profileListenerList.size()) {
            if (profileEvent.getAction() == ProfileEvent.Action.ADDED) {
                this.profileListenerList.elementAt(i).profileAdded(profileEvent);
            } else if (profileEvent.getAction() == ProfileEvent.Action.DELETED) {
                this.profileListenerList.elementAt(i).profileRemoved(profileEvent);
            } else if (profileEvent.getAction() == ProfileEvent.Action.REFRESH_ALL) {
                this.profileListenerList.elementAt(i).profileRefreshAll(profileEvent);
            } else {
                this.profileListenerList.elementAt(i).profileChanged(profileEvent);
            }
            ++i;
        }
    }

    @Override
    public void addProfileListener(IProfileListener profileListener) {
        this.profileListenerList.add(profileListener);
    }

    @Override
    public void deleteProfile(Profile theProfile) {
        this.profileList.delete(theProfile);
        ProfileEvent profileEvent = new ProfileEvent(ProfileEvent.Action.DELETED, theProfile);
        this.fireProfileListener(profileEvent);
    }

    @Override
    public Profile[] getProfiles() {
        return this.profileList.getList();
    }

    @Override
    public void removeProfileListener(IProfileListener profileListener) {
        this.profileListenerList.remove(profileListener);
    }

    @Override
    public Profile updateProfile(Profile theProfile) {
        this.profileList.update(theProfile);
        ProfileEvent profileEvent = new ProfileEvent(ProfileEvent.Action.CHANGED, theProfile);
        this.fireProfileListener(profileEvent);
        return theProfile;
    }

    @Override
    public boolean storeConfiguration(Log log) throws IOException, ClassNotFoundException, FileSecurityException {
        return this.configurationIO.store(this, log);
    }

    public boolean readConfiguration(int siteNum, Log log, boolean uncheckoutSubmissions) throws IOException, ClassNotFoundException, FileSecurityException {
        String settingsFilename = this.configurationIO.getFileName();
        if (!new File(settingsFilename).exists()) {
            throw new FileNotFoundException("Profile/config file missing " + settingsFilename);
        }
        boolean loadedConfiguration = this.configurationIO.loadFromDisk(siteNum, this, log);
        this.initializeSubmissions(siteNum, uncheckoutSubmissions);
        ContestTime contestTime = this.getContestTime(siteNum);
        if (contestTime == null) {
            contestTime = new ContestTime(siteNum);
            this.addContestTime(contestTime);
        }
        return loadedConfiguration;
    }

    @Override
    public boolean readConfiguration(int siteNum, Log log) throws IOException, ClassNotFoundException, FileSecurityException {
        return this.readConfiguration(siteNum, log, true);
    }

    @Override
    public void setStorage(IStorage storage) {
        this.storage = storage;
        this.configurationIO = new ConfigurationIO(storage);
    }

    @Override
    public void setupDefaultCategories() {
        if (this.getCategories().length == 0) {
            String[] catNames;
            String[] stringArray = catNames = new String[]{"General"};
            int n = catNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.addCategory(new Category(name));
                ++n2;
            }
        }
    }

    @Override
    public String getContestPassword() {
        return this.contestPassword;
    }

    @Override
    public void setContestPassword(String contestPassword) {
        this.contestPassword = contestPassword;
    }

    @Override
    public IStorage getStorage() {
        return this.storage;
    }

    @Override
    public IInternalContest clone(IInternalContest contest, Profile newProfile, ProfileCloneSettings settings) throws ProfileCloneException {
        ProfileCloneException exception;
        String profilePath = newProfile.getProfilePath();
        try {
            new File(profilePath).mkdirs();
        }
        catch (Exception e) {
            throw new ProfileCloneException("Unable to create profile dir " + profilePath, e);
        }
        if (!new File(profilePath).isDirectory()) {
            throw new ProfileCloneException("Unable to use profile dir " + profilePath);
        }
        String databaseDirectoryName = String.valueOf(profilePath) + File.separator + "db." + contest.getSiteNumber();
        try {
            new File(databaseDirectoryName).mkdirs();
        }
        catch (Exception e) {
            throw new ProfileCloneException("Unable to create DB dir " + profilePath, e);
        }
        String logDirectoryName = String.valueOf(profilePath) + File.separator + "logs";
        try {
            new File(logDirectoryName).mkdirs();
        }
        catch (Exception e) {
            throw new ProfileCloneException("Unable to create log dir " + profilePath, e);
        }
        FileSecurity fileSecurity = new FileSecurity(databaseDirectoryName);
        try {
            fileSecurity.saveSecretKey(settings.getContestPassword());
        }
        catch (Exception e) {
            throw new ProfileCloneException(e);
        }
        contest.setStorage(fileSecurity);
        contest.setProfileCloneSettings(settings);
        if (contest.getAccounts(ClientType.Type.SERVER) == null) {
            contest.addAccount(this.getAccount(this.getClientId()));
        }
        contest.setClientId(this.getClientId());
        contest.setSiteNumber(this.getClientId().getSiteNumber());
        if (contest.getAccounts(ClientType.Type.ADMINISTRATOR) != null) {
            ClientId adminId = new ClientId(this.getClientId().getSiteNumber(), ClientType.Type.ADMINISTRATOR, 1);
            Account account = this.getAccount(adminId);
            if (account != null) {
                contest.addAccount(account);
            } else {
                contest.generateNewAccounts(ClientType.Type.ADMINISTRATOR.toString(), 1, true);
            }
            ClientSettings clientSettings = this.getClientSettings(adminId);
            if (clientSettings != null) {
                contest.addClientSettings(clientSettings);
            }
        }
        IElementObject[] iElementObjectArray = this.getSites();
        int clientSettings = iElementObjectArray.length;
        int account = 0;
        while (account < clientSettings) {
            Site site = iElementObjectArray[account];
            contest.updateSite(site);
            ++account;
        }
        newProfile.setName(settings.getName());
        newProfile.setDescription(settings.getDescription());
        contest.setProfile(newProfile);
        iElementObjectArray = this.getProfiles();
        clientSettings = iElementObjectArray.length;
        account = 0;
        while (account < clientSettings) {
            IElementObject profile2 = iElementObjectArray[account];
            if (!((Profile)profile2).equals(newProfile)) {
                contest.addProfile((Profile)profile2);
            }
            ++account;
        }
        contest.setContestPassword(new String(settings.getContestPassword()));
        if (settings.isResetContestTimes()) {
            iElementObjectArray = this.getContestTimes();
            clientSettings = iElementObjectArray.length;
            account = 0;
            while (account < clientSettings) {
                IElementObject contestTime = iElementObjectArray[account];
                ContestTime contestTime2 = this.clone((ContestTime)contestTime);
                if (settings.isResetContestTimes()) {
                    contestTime2.setElapsedMins(0L);
                }
                contest.updateContestTime(contestTime2);
                ++account;
            }
        }
        if (settings.isCopyAccounts()) {
            IElementObject account2;
            if (settings.isCopyGroups()) {
                iElementObjectArray = this.getGroups();
                clientSettings = iElementObjectArray.length;
                account = 0;
                while (account < clientSettings) {
                    IElementObject group = iElementObjectArray[account];
                    contest.addGroup((Group)group);
                    ++account;
                }
            }
            contest.addAccounts(this.getAccounts());
            iElementObjectArray = this.getAccounts();
            clientSettings = iElementObjectArray.length;
            account = 0;
            while (account < clientSettings) {
                account2 = iElementObjectArray[account];
                ClientSettings clientSettings2 = this.getClientSettings(((Account)account2).getClientId());
                if (clientSettings2 != null) {
                    contest.addClientSettings(clientSettings2);
                }
                ++account;
            }
            if (!settings.isCopyGroups()) {
                iElementObjectArray = contest.getAccounts();
                clientSettings = iElementObjectArray.length;
                account = 0;
                while (account < clientSettings) {
                    account2 = iElementObjectArray[account];
                    ((Account)account2).setGroupId(null);
                    ++account;
                }
            }
        } else {
            contest.generateNewAccounts(ClientType.Type.ADMINISTRATOR.toString(), 1, true);
        }
        if (settings.isCopyContestSettings()) {
            this.cloneContestSettings(contest, settings);
        }
        if (settings.isCopyJudgements()) {
            contest.setJudgementList(this.getJudgements());
        }
        if (contest.getJudgements().length == 0) {
            Judgement judgement = new Judgement("Yes");
            contest.addJudgement(judgement);
        }
        if (settings.isCopyLanguages()) {
            iElementObjectArray = this.getLanguages();
            clientSettings = iElementObjectArray.length;
            account = 0;
            while (account < clientSettings) {
                IElementObject language = iElementObjectArray[account];
                contest.addLanguage((Language)language);
                ++account;
            }
        }
        if (settings.isCopyProblems()) {
            iElementObjectArray = this.getProblems();
            clientSettings = iElementObjectArray.length;
            account = 0;
            while (account < clientSettings) {
                IElementObject problem = iElementObjectArray[account];
                ProblemDataFiles problemDataFiles = this.getProblemDataFile((Problem)problem);
                contest.addProblem((Problem)problem, problemDataFiles);
                ++account;
            }
            contest.setGeneralProblem(this.getGeneralProblem());
        } else {
            contest.setGeneralProblem(new Problem("General"));
        }
        if (settings.isCopyCategories()) {
            iElementObjectArray = this.getCategories();
            clientSettings = iElementObjectArray.length;
            account = 0;
            while (account < clientSettings) {
                IElementObject category = iElementObjectArray[account];
                contest.addCategory((Category)category);
                ++account;
            }
        } else {
            contest.setupDefaultCategories();
        }
        if (settings.isCopyRuns()) {
            if (settings.isCopyProblems() && settings.isCopyLanguages() && settings.isCopyAccounts()) {
                this.cloneRunsAndRunFiles(contest, newProfile);
            } else {
                if (!settings.isCopyAccounts()) {
                    throw new ProfileCloneException("Can not copy runs if accounts not copied too");
                }
                if (!settings.isCopyProblems()) {
                    throw new ProfileCloneException("Can not copy runs if problems not copied too");
                }
                throw new ProfileCloneException("Can not copy runs if languages not copied too");
            }
        }
        if (settings.isCopyClarifications()) {
            if (settings.isCopyProblems() && settings.isCopyAccounts()) {
                this.cloneClarifications(contest, newProfile);
            } else {
                if (!settings.isCopyProblems()) {
                    throw new ProfileCloneException("Can not copy clarifications if problems not copied too");
                }
                throw new ProfileCloneException("Can not copy runs if accounts not copied too");
            }
        }
        ContestInformation newContestInformation = settings.isCopyContestSettings() ? this.getContestInformation() : new ContestInformation();
        newContestInformation.setContestTitle(settings.getContestTitle());
        contest.updateContestInformation(newContestInformation);
        Log tempLog = new Log("profileClone");
        try {
            contest.storeConfiguration(tempLog);
        }
        catch (IOException e) {
            tempLog.log(Log.SEVERE, "Exception storing new config for " + newProfile.getName(), e);
            throw new ProfileCloneException("Exception storing new config for " + newProfile.getName(), e);
        }
        catch (ClassNotFoundException e) {
            tempLog.log(Log.SEVERE, "Exception storing new config for " + newProfile.getName(), e);
            throw new ProfileCloneException("Exception storing new config for " + newProfile.getName(), e);
        }
        catch (FileSecurityException e) {
            tempLog.log(Log.SEVERE, "Exception storing new config for " + newProfile.getName(), e);
            throw new ProfileCloneException("Exception storing new config for " + newProfile.getName(), e);
        }
        tempLog = null;
        try {
            ProfileManager profileManager = new ProfileManager();
            profileManager.mergeProfiles(this);
            profileManager.store(this.getProfiles(), this.getProfile());
        }
        catch (IOException e) {
            exception = new ProfileCloneException("Unable to store profiles in profiles.properties");
            exception.setStackTrace(e.getStackTrace());
            throw exception;
        }
        catch (ProfileLoadException e) {
            exception = new ProfileCloneException("Unable to merge profiles");
            exception.setStackTrace(e.getStackTrace());
            throw exception;
        }
        return contest;
    }

    private ContestTime clone(ContestTime contestTime) {
        ContestTime time = new ContestTime(contestTime.getSiteNumber());
        time.setContestLengthSecs(contestTime.getContestLengthSecs());
        time.setElapsedSecs(time.getElapsedSecs());
        time.setHaltContestAtTimeZero(contestTime.isHaltContestAtTimeZero());
        return time;
    }

    @Override
    public Account[] getAccounts() {
        return this.accountList.getList();
    }

    private void cloneContestSettings(IInternalContest contest, ProfileCloneSettings settings) {
        IElementObject[] iElementObjectArray = contest.getClientSettingsList();
        int n = iElementObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSettings clientSettings = iElementObjectArray[n2];
            if (settings.isCopyProblems()) {
                contest.addClientSettings(clientSettings);
            } else {
                clientSettings.setBalloonList(new Hashtable<String, BalloonDeliveryInfo>());
                clientSettings.setAutoJudgeFilter(new Filter());
            }
            ++n2;
        }
        iElementObjectArray = this.getBalloonSettings();
        n = iElementObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            IElementObject balloonSettings = iElementObjectArray[n2];
            contest.addBalloonSettings((BalloonSettings)balloonSettings);
            ++n2;
        }
    }

    @Override
    public ProfileCloneSettings getProfileCloneSettings() {
        return this.profileCloneSettings;
    }

    @Override
    public ProfileCloneSettings setProfileCloneSettings(ProfileCloneSettings inProfileCloneSettings) {
        this.profileCloneSettings = inProfileCloneSettings;
        return this.profileCloneSettings;
    }

    @Override
    public void cloneClarifications(IInternalContest targetContest, Profile newProfile) throws ProfileCloneException {
        this.clarificationList.clone(targetContest.getStorage());
    }

    @Override
    public void cloneRunsAndRunFiles(IInternalContest targetContest, Profile newProfile) throws ProfileCloneException {
        this.runList.clone(targetContest.getStorage());
        this.runFilesList.clone(targetContest.getStorage());
        this.runResultFilesList.clone(targetContest.getStorage());
    }

    private void logException(String message, Exception e) {
        if (StaticLog.getLog() != null) {
            StaticLog.getLog().log(Log.WARNING, message, e);
        } else {
            System.err.println(message);
            e.printStackTrace(System.err);
        }
    }

    private void logException(Exception e) {
        if (StaticLog.getLog() != null) {
            StaticLog.getLog().log(Log.WARNING, "Exception", e);
        } else {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void removeAllListeners() {
        this.accountListenerList.removeAllElements();
        this.balloonSettingsListenerList.removeAllElements();
        this.categoryListenerList.removeAllElements();
        this.changePasswordListenerList.removeAllElements();
        this.clarificationListenerList.removeAllElements();
        this.clientSettingsListenerList.removeAllElements();
        this.connectionListenerList.removeAllElements();
        this.contestInformationListenerList.removeAllElements();
        this.contestTimeListenerList.removeAllElements();
        this.groupListenerList.removeAllElements();
        this.judgementListenerList.removeAllElements();
        this.languageListenerList.removeAllElements();
        this.loginListenerList.removeAllElements();
        this.problemListenerList.removeAllElements();
        this.profileListenerList.removeAllElements();
        this.runListenerList.removeAllElements();
        this.siteListenerList.removeAllElements();
        this.messageListenerList.removeAllElements();
    }

    @Override
    public void fireAllRefreshEvents() {
        ProfileEvent profileEvent = new ProfileEvent(ProfileEvent.Action.REFRESH_ALL, null);
        this.fireProfileListener(profileEvent);
        RunEvent runEvent = new RunEvent(RunEvent.Action.REFRESH_ALL, null, null, null);
        this.fireRunListener(runEvent);
        ContestTimeEvent contestTimeEvent = new ContestTimeEvent(ContestTimeEvent.Action.REFRESH_ALL, this.getContestTime(), this.getSiteNumber());
        this.fireContestTimeListener(contestTimeEvent);
        ProblemEvent problemEvent = new ProblemEvent(ProblemEvent.Action.REFRESH_ALL, null);
        this.fireProblemListener(problemEvent);
        LanguageEvent languageEvent = new LanguageEvent(LanguageEvent.Action.REFRESH_ALL, this.getLanguages());
        this.fireLanguageListener(languageEvent);
        LoginEvent loginEvent = new LoginEvent(LoginEvent.Action.REFRESH_ALL, null, null);
        this.fireLoginListener(loginEvent);
        JudgementEvent judgementEvent = new JudgementEvent(JudgementEvent.Action.REFRESH_ALL, null);
        this.fireJudgementListener(judgementEvent);
        SiteEvent siteEvent = new SiteEvent(SiteEvent.Action.REFRESH_ALL, null);
        this.fireSiteListener(siteEvent);
        ConnectionEvent connectionEvent = new ConnectionEvent(ConnectionEvent.Action.REFRESH_ALL, null);
        this.fireConnectionListener(connectionEvent);
        BalloonSettingsEvent balloonSettingsEvent = new BalloonSettingsEvent(BalloonSettingsEvent.Action.REFRESH_ALL, null);
        this.fireBalloonSettingsListener(balloonSettingsEvent);
        AccountEvent accountEvent = new AccountEvent(AccountEvent.Action.REFRESH_ALL, this.getAccounts());
        this.fireAccountListener(accountEvent);
        ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.REFRESH_ALL, null);
        this.fireClarificationListener(clarificationEvent);
        ClientSettingsEvent clientSettingsEvent = new ClientSettingsEvent(ClientSettingsEvent.Action.REFRESH_ALL, null, null);
        this.fireClientSettingsListener(clientSettingsEvent);
        ContestInformationEvent contestInformationEvent = new ContestInformationEvent(ContestInformationEvent.Action.REFRESH_ALL, null);
        this.fireContestInformationListener(contestInformationEvent);
        GroupEvent groupEvent = new GroupEvent(GroupEvent.Action.REFRESH_ALL, this.getGroups());
        this.fireGroupListener(groupEvent);
        this.fireCategoryListener(null, CategoryEvent.Action.REFRESH_ALL);
    }

    @Override
    public void cloneAllLoginAndConnections(IInternalContest newContest) throws CloneException {
        Serializable connectionHandlerID;
        ClientId clientId;
        CloneException ex = null;
        Serializable[] serializableArray = this.localLoginList.getClientIdList();
        int n = serializableArray.length;
        int n2 = 0;
        while (n2 < n) {
            clientId = serializableArray[n2];
            try {
                newContest.addLocalLogin(clientId, this.localLoginList.getConnectionHandleID(clientId));
            }
            catch (Exception e) {
                ex = new CloneException(e.getMessage(), e.getCause());
            }
            ++n2;
        }
        serializableArray = this.remoteLoginList.getClientIdList();
        n = serializableArray.length;
        n2 = 0;
        while (n2 < n) {
            clientId = serializableArray[n2];
            try {
                newContest.addRemoteLogin(clientId, this.remoteLoginList.getConnectionHandleID(clientId));
            }
            catch (Exception e) {
                ex = new CloneException(e.getMessage(), e.getCause());
            }
            ++n2;
        }
        serializableArray = this.localConnectionHandlerList.getList();
        n = serializableArray.length;
        n2 = 0;
        while (n2 < n) {
            connectionHandlerID = serializableArray[n2];
            try {
                newContest.connectionEstablished((ConnectionHandlerID)connectionHandlerID, this.localConnectionHandlerList.get((ConnectionHandlerID)connectionHandlerID));
            }
            catch (Exception e) {
                ex = new CloneException(e.getMessage(), e.getCause());
            }
            ++n2;
        }
        serializableArray = this.remoteConnectionHandlerList.getList();
        n = serializableArray.length;
        n2 = 0;
        while (n2 < n) {
            connectionHandlerID = serializableArray[n2];
            try {
                newContest.connectionEstablished((ConnectionHandlerID)connectionHandlerID, this.remoteConnectionHandlerList.get((ConnectionHandlerID)connectionHandlerID));
            }
            catch (Exception e) {
                ex = new CloneException(e.getMessage(), e.getCause());
            }
            ++n2;
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public void addMessage(MessageEvent.Area area, ClientId source, ClientId destination, String message) {
        MessageEvent messageEvent = new MessageEvent(MessageEvent.Action.ADDED, area, message, source, destination);
        this.fireMessageListener(messageEvent);
    }

    @Override
    public void updateRunFiles(Run run, RunFiles runFiles) throws IOException, ClassNotFoundException, FileSecurityException {
        this.runFilesList.add(run, runFiles);
    }

    @Override
    public FinalizeData getFinalizeData() {
        return this.finalizeData;
    }

    @Override
    public void setFinalizeData(FinalizeData data) {
        this.finalizeData = data;
        ContestInformationEvent event = new ContestInformationEvent(data);
        this.fireContestInformationListener(event);
    }

    @Override
    public Notification[] getNotifications() {
        return this.notificationList.getList();
    }

    @Override
    public void addNotificationListener(INotificationListener notificationListener) {
        this.notificationListenerList.add(notificationListener);
    }

    @Override
    public void removeNotificationListener(INotificationListener notificationListener) {
        this.notificationListenerList.remove(notificationListener);
    }

    @Override
    public Notification getNotification(ElementId elementId) {
        return this.notificationList.get(elementId);
    }

    @Override
    public void updateNotification(Notification notification) throws IOException, ClassNotFoundException, FileSecurityException {
        this.notificationList.updateNotification(notification);
    }

    @Override
    public Notification getNotification(ClientId submitter, ElementId problemId) {
        return this.notificationList.get(submitter, problemId);
    }

    @Override
    public Notification acceptNotification(Notification notification) {
        notification.setElapsedMS(this.getContestTime().getElapsedMS());
        notification.setSiteNumber(this.getSiteNumber());
        try {
            Notification newNotif = this.notificationList.addNewNotification(notification);
            this.addNotification(newNotif);
            return newNotif;
        }
        catch (IOException e) {
            this.logException(e);
        }
        catch (ClassNotFoundException e) {
            this.logException(e);
        }
        catch (FileSecurityException e) {
            this.logException(e);
        }
        return null;
    }

    @Override
    public void addReplaySetting(ReplaySetting replaySetting) {
        this.replaySettingTemp = replaySetting;
        this.fireReplaySettingListener(ReplaySettingEvent.Action.ADDED, replaySetting);
    }

    @Override
    public void deleteReplaySetting(ReplaySetting replaySetting) {
        this.fireReplaySettingListener(ReplaySettingEvent.Action.DELETED, replaySetting);
        this.replaySettingTemp = null;
    }

    @Override
    public void updateReplaySetting(ReplaySetting replaySetting) {
        this.replaySettingTemp = replaySetting;
        this.fireReplaySettingListener(ReplaySettingEvent.Action.CHANGED, replaySetting);
    }

    private void fireReplaySettingListener(ReplaySettingEvent.Action action, ReplaySetting replaySetting) {
    }

    @Override
    public ReplaySetting[] getReplaySettings() {
        if (this.replaySettingTemp == null) {
            this.replaySettingTemp = new ReplaySetting("Sample Replay Title");
        }
        if (this.replaySettingTemp == null) {
            return new ReplaySetting[0];
        }
        ReplaySetting[] list = new ReplaySetting[]{this.replaySettingTemp};
        return list;
    }

    @Override
    public void addPlaybackInfo(PlaybackInfo playbackInfo) {
        this.playbackInfoList.add(playbackInfo);
        this.firePlaybackInfosListener(PlayBackEvent.Action.ADDED, playbackInfo);
    }

    @Override
    public void deletePlaybackInfo(PlaybackInfo playbackInfo) {
        this.playbackInfoList.delete(playbackInfo);
        this.firePlaybackInfosListener(PlayBackEvent.Action.DELETE, playbackInfo);
    }

    @Override
    public void updatePlaybackInfo(PlaybackInfo playbackInfo) {
        this.playbackInfoList.update(playbackInfo);
        this.firePlaybackInfosListener(PlayBackEvent.Action.REFRESH_ALL, playbackInfo);
    }

    @Override
    public void resetPlaybackInfo(PlaybackInfo playbackInfo) {
        playbackInfo.rewind();
        this.firePlaybackInfosListener(PlayBackEvent.Action.RESET_REPLAY, playbackInfo);
    }

    @Override
    public void stopReplayPlaybackInfo(PlaybackInfo playbackInfo) {
        this.playbackInfoList.delete(playbackInfo);
        this.firePlaybackInfosListener(PlayBackEvent.Action.STOP_REPLAY, playbackInfo);
    }

    @Override
    public void startReplayPlaybackInfo(PlaybackInfo playbackInfo) {
        this.playbackInfoList.delete(playbackInfo);
        this.firePlaybackInfosListener(PlayBackEvent.Action.START_REPLAY, playbackInfo);
    }

    @Override
    public PlaybackInfo[] getPlaybackInfos() {
        return this.playbackInfoList.getList();
    }

    @Override
    public PlaybackInfo getPlaybackInfo(ElementId elementId) {
        return (PlaybackInfo)this.playbackInfoList.get(elementId);
    }

    @Override
    public PlaybackManager getPlaybackManager() {
        return this.playbackManager;
    }

    @Override
    public void setPlaybackManager(PlaybackManager playbackManager) {
        this.playbackManager = playbackManager;
    }

    @Override
    public Account autoRegisterTeam(String displayName, String[] memberNames, String password) {
        Account account = this.accountList.assignNewTeam(this.siteNumber, displayName, memberNames, password);
        this.addAccount(account);
        return account;
    }

    @Override
    public EventFeedDefinition[] getEventFeedDefinitions() {
        return this.eventFeedDefinitionsList.getList();
    }

    @Override
    public void addEventFeedDefinition(EventFeedDefinition eventFeedDefinition) {
        this.eventFeedDefinitionsList.add(eventFeedDefinition);
        EventFeedDefinitionEvent eventFeedDefinitionEvent = new EventFeedDefinitionEvent(EventFeedDefinitionEvent.Action.ADDED, eventFeedDefinition);
        this.fireEventFeedDefinitionListener(eventFeedDefinitionEvent);
    }

    @Override
    public void deleteEventFeedDefinition(EventFeedDefinition eventFeedDefinition) {
        this.eventFeedDefinitionsList.delete(eventFeedDefinition);
        EventFeedDefinitionEvent eventFeedDefinitionEvent = new EventFeedDefinitionEvent(EventFeedDefinitionEvent.Action.DELETED, eventFeedDefinition);
        this.fireEventFeedDefinitionListener(eventFeedDefinitionEvent);
    }

    @Override
    public void updateEventFeedDefinition(EventFeedDefinition eventFeedDefinition) {
        this.eventFeedDefinitionsList.update(eventFeedDefinition);
        EventFeedDefinitionEvent problemEvent = new EventFeedDefinitionEvent(EventFeedDefinitionEvent.Action.CHANGED, eventFeedDefinition);
        this.fireEventFeedDefinitionListener(problemEvent);
    }

    @Override
    public EventFeedDefinition getEventFeedDefinition(ElementId elementId) {
        return (EventFeedDefinition)this.eventFeedDefinitionsList.get(elementId);
    }

    @Override
    public void addLanguages(Language[] languages) {
        Language[] languageArray = languages;
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = languageArray[n2];
            this.languageDisplayList.add(language);
            this.languageList.add(language);
            ++n2;
        }
        LanguageEvent languageEvent = new LanguageEvent(LanguageEvent.Action.ADDED_LANGUAGES, languages);
        this.fireLanguageListener(languageEvent);
    }

    @Override
    public void updateLanguages(Language[] languages) {
        Language[] languageArray = languages;
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = languageArray[n2];
            this.languageList.update(language);
            this.languageDisplayList.update(language);
            ++n2;
        }
        LanguageEvent languageEvent = new LanguageEvent(LanguageEvent.Action.CHANGED_LANGUAGES, languages);
        this.fireLanguageListener(languageEvent);
    }

    @Override
    public void addGroups(Group[] groups) {
        Group[] groupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            this.groupDisplayList.add(group);
            this.groupList.add(group);
            ++n2;
        }
        GroupEvent groupEvent = new GroupEvent(GroupEvent.Action.ADDED_GROUPS, groups);
        this.fireGroupListener(groupEvent);
    }

    @Override
    public void updateGroups(Group[] groups) {
        Group[] groupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            this.groupList.update(group);
            this.groupDisplayList.update(group);
            ++n2;
        }
        GroupEvent groupEvent = new GroupEvent(GroupEvent.Action.CHANGED_GROUPS, groups);
        this.fireGroupListener(groupEvent);
    }
}

