/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;

public class Group
implements IElementObject {
    private static final long serialVersionUID = -9039235537777735642L;
    private ElementId elementId;
    private int groupId;
    private String displayName;
    private ElementId site;
    private boolean displayOnScoreboard = true;

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    @Override
    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    @Override
    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String groupTitle) {
        this.displayName = groupTitle;
    }

    public ElementId getSite() {
        return this.site;
    }

    public void setSite(ElementId site) {
        this.site = site;
    }

    public String toString() {
        return this.displayName;
    }

    public Group(String displayName) {
        this.displayName = displayName;
        this.elementId = new ElementId(displayName);
        this.setSiteNumber(0);
    }

    public int hashCode() {
        return this.elementId.hashCode();
    }

    public boolean isDisplayOnScoreboard() {
        return this.displayOnScoreboard;
    }

    public void setDisplayOnScoreboard(boolean displayOnScoreboard) {
        this.displayOnScoreboard = displayOnScoreboard;
    }

    private boolean stringSame(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1.equals(s2);
    }

    public boolean isSameAs(Group newGroup) {
        block15: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    try {
                                        if (newGroup != null) break block9;
                                        return false;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        return false;
                                    }
                                }
                                if (this.stringSame(this.displayName, newGroup.getDisplayName())) break block10;
                                return false;
                            }
                            if (this.getSiteNumber() == newGroup.getSiteNumber()) break block11;
                            return false;
                        }
                        if (this.groupId == newGroup.getGroupId()) break block12;
                        return false;
                    }
                    if (this.isDisplayOnScoreboard() == newGroup.isDisplayOnScoreboard()) break block13;
                    return false;
                }
                if (this.site == null || newGroup.getSite() == null) break block14;
                if (!newGroup.getSite().equals(this.site)) {
                    return false;
                }
                break block15;
            }
            if (newGroup.getSite() == null && this.site == null) break block15;
            return false;
        }
        return true;
    }

    public void updateFrom(Group newGroup) {
        this.groupId = newGroup.getGroupId();
        this.displayName = newGroup.getDisplayName();
        this.site = newGroup.getSite();
        this.displayOnScoreboard = newGroup.displayOnScoreboard;
    }
}

