/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.list.ClientIdComparator;
import edu.csus.ecs.pc2.core.list.ProblemComparator;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import java.io.Serializable;
import java.util.Arrays;

public class FilterFormatter {
    public static final String LANGUAGES_SPECIFIER = "%L";
    public static final String NUMBER_LANGUAGES_SPECIFIER = "%#L";
    public static final String PROBLEMS_SPECIFIER = "%P";
    public static final String NUMBER_PROBLEMS_SPECIFIER = "%#P";
    public static final String JUDGMENTS_SPECIFIER = "%J";
    public static final String NUMBER_JUDGEMENTS_SPECIFIER = "%#J";
    public static final String NUMBER_ACCOUNTS_SPECIFIER = "%#T";
    public static final String ACCOUNT_SPECIFIER = "%T";
    public static final String SHORT_ACCOUNT_NAMES_SPECIFIER = "%n";
    public static final String TEAM_LIST_SPECIFIER = "%t";
    public static final String TEAM_LONG_LIST_SPECIFIER = "%C";
    public static final String START_TIME_RANGE_SPECIFIER = "%s";
    public static final String END_TIME_RANGE_SPECIFIER = "%e";

    private String replaceString(String origString, String beforeString, String afterString) {
        if (origString == null) {
            return origString;
        }
        int startIdx = origString.lastIndexOf(beforeString);
        if (startIdx == -1) {
            return origString;
        }
        StringBuffer buf = new StringBuffer(origString);
        while (startIdx != -1) {
            buf.replace(startIdx, startIdx + beforeString.length(), afterString);
            startIdx = origString.lastIndexOf(beforeString, startIdx - 1);
        }
        return buf.toString();
    }

    public String format(String specifiers, IInternalContest contest, Filter filter) {
        String num;
        String outString = specifiers;
        String formatSpecifier = "%O";
        if (outString.lastIndexOf(formatSpecifier) > -1) {
            String filterOnStr = "Off";
            if (filter.isFilterOn()) {
                filterOnStr = "On";
            }
            outString = this.replaceString(outString, formatSpecifier, filterOnStr);
        }
        if (outString.lastIndexOf(formatSpecifier = PROBLEMS_SPECIFIER) > -1) {
            outString = this.replaceString(outString, formatSpecifier, this.getProblemList(contest, filter));
        }
        if (outString.lastIndexOf(formatSpecifier = JUDGMENTS_SPECIFIER) > -1) {
            outString = this.replaceString(outString, formatSpecifier, this.getJudgementsList(contest, filter));
        }
        if (outString.lastIndexOf(formatSpecifier = LANGUAGES_SPECIFIER) > -1) {
            outString = this.replaceString(outString, formatSpecifier, this.getLanguagesList(contest, filter));
        }
        if (outString.lastIndexOf(formatSpecifier = ACCOUNT_SPECIFIER) > -1) {
            outString = this.replaceString(outString, formatSpecifier, this.getAccountsList(contest, filter));
        }
        if (outString.lastIndexOf(formatSpecifier = SHORT_ACCOUNT_NAMES_SPECIFIER) > -1) {
            outString = this.replaceString(outString, formatSpecifier, this.getAccountShortNamesList(contest, filter));
        }
        if (outString.lastIndexOf(formatSpecifier = NUMBER_LANGUAGES_SPECIFIER) > -1) {
            num = String.valueOf(filter.getLanguageIdList().length);
            outString = this.replaceString(outString, formatSpecifier, num);
        }
        if (outString.lastIndexOf(formatSpecifier = NUMBER_PROBLEMS_SPECIFIER) > -1) {
            num = String.valueOf(filter.getProblemIdList().length);
            outString = this.replaceString(outString, formatSpecifier, num);
        }
        if (outString.lastIndexOf(formatSpecifier = NUMBER_JUDGEMENTS_SPECIFIER) > -1) {
            num = String.valueOf(filter.getJudgementIdList().length);
            outString = this.replaceString(outString, formatSpecifier, num);
        }
        if (outString.lastIndexOf(formatSpecifier = NUMBER_ACCOUNTS_SPECIFIER) > -1) {
            num = String.valueOf(filter.getAccountList().length);
            outString = this.replaceString(outString, formatSpecifier, num);
        }
        if (outString.lastIndexOf(formatSpecifier = TEAM_LONG_LIST_SPECIFIER) > -1) {
            outString = this.replaceString(outString, formatSpecifier, this.getClientsLongList(filter.getAccountList()));
        }
        if (outString.lastIndexOf(formatSpecifier = TEAM_LIST_SPECIFIER) > -1) {
            outString = this.replaceString(outString, formatSpecifier, this.getClientsShortList(filter.getAccountList()));
        }
        if (outString.lastIndexOf(formatSpecifier = START_TIME_RANGE_SPECIFIER) > -1) {
            outString = this.replaceString(outString, formatSpecifier, "" + filter.getStartElapsedTime());
        }
        if (outString.lastIndexOf(formatSpecifier = END_TIME_RANGE_SPECIFIER) > -1) {
            outString = this.replaceString(outString, formatSpecifier, "" + filter.getEndElapsedTime());
        }
        return outString;
    }

    private String getJudgementsList(IInternalContest contest, Filter filter) {
        StringBuffer sb = new StringBuffer();
        ElementId[] elementIds = filter.getJudgementIdList();
        if (elementIds.length < 2) {
            if (elementIds.length == 1) {
                sb.append(contest.getJudgement(elementIds[0]));
            }
        } else {
            ElementId[] elementIdArray = elementIds;
            int n = elementIds.length;
            int n2 = 0;
            while (n2 < n) {
                ElementId elementId = elementIdArray[n2];
                sb.append(contest.getJudgement(elementId) + ", ");
                ++n2;
            }
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    private String getAccountsList(IInternalContest contest, Filter filter) {
        StringBuffer sb = new StringBuffer();
        ClientId[] clientIds = filter.getAccountList();
        if (clientIds.length < 2) {
            if (clientIds.length == 1) {
                sb.append(contest.getAccount(clientIds[0]));
            }
        } else {
            Arrays.sort(clientIds, new ClientIdComparator());
            ClientId[] clientIdArray = clientIds;
            int n = clientIds.length;
            int n2 = 0;
            while (n2 < n) {
                ClientId clientId = clientIdArray[n2];
                sb.append(contest.getAccount(clientId) + ", ");
                ++n2;
            }
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    private String getAccountShortNamesList(IInternalContest contest, Filter filter) {
        StringBuffer sb = new StringBuffer();
        ClientId[] clientIds = filter.getAccountList();
        if (clientIds.length < 2) {
            if (clientIds.length == 1) {
                sb.append(clientIds[0].getName());
            }
        } else {
            Arrays.sort(clientIds, new ClientIdComparator());
            ClientId[] clientIdArray = clientIds;
            int n = clientIds.length;
            int n2 = 0;
            while (n2 < n) {
                ClientId clientId = clientIdArray[n2];
                sb.append(String.valueOf(clientId.getName()) + ", ");
                ++n2;
            }
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    private String getLanguagesList(IInternalContest contest, Filter filter) {
        StringBuffer sb = new StringBuffer();
        ElementId[] elementIds = filter.getLanguageIdList();
        if (elementIds.length < 2) {
            if (elementIds.length == 1) {
                sb.append(contest.getLanguage(elementIds[0]));
            }
        } else {
            ElementId[] elementIdArray = elementIds;
            int n = elementIds.length;
            int n2 = 0;
            while (n2 < n) {
                ElementId elementId = elementIdArray[n2];
                sb.append(contest.getLanguage(elementId) + ", ");
                ++n2;
            }
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    private String getProblemList(IInternalContest contest, Filter filter) {
        StringBuffer sb = new StringBuffer();
        ElementId[] elementIds = filter.getProblemIdList();
        if (elementIds.length < 2) {
            if (elementIds.length == 1) {
                sb.append(contest.getProblem(elementIds[0]));
            }
        } else {
            Problem[] problems = new Problem[elementIds.length];
            int i = 0;
            Serializable[] serializableArray = elementIds;
            int n = elementIds.length;
            int n2 = 0;
            while (n2 < n) {
                ElementId elementId = serializableArray[n2];
                problems[i] = contest.getProblem(elementId);
                ++i;
                ++n2;
            }
            Arrays.sort(problems, new ProblemComparator(contest));
            serializableArray = problems;
            n = problems.length;
            n2 = 0;
            while (n2 < n) {
                Serializable problem = serializableArray[n2];
                sb.append(problem + ", ");
                ++n2;
            }
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    public String getClientsLongList(ClientId[] clientIds) {
        ClientId clientId = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (clientIds.length < 1) {
            return "";
        }
        Arrays.sort(clientIds, new ClientIdComparator());
        int i = 0;
        while (i < clientIds.length - 1) {
            clientId = clientIds[i];
            stringBuffer.append(String.valueOf(clientId.getClientNumber()) + "s" + clientId.getSiteNumber() + ",");
            ++i;
        }
        clientId = clientIds[clientIds.length - 1];
        stringBuffer.append(String.valueOf(clientId.getClientNumber()) + "s" + clientId.getSiteNumber());
        return stringBuffer.toString();
    }

    public String getClientsShortList(ClientId[] clientIds) {
        ClientId clientId = null;
        if (clientIds.length == 0) {
            return "";
        }
        Arrays.sort(clientIds, new ClientIdComparator());
        StringBuffer stringBuffer = new StringBuffer();
        ClientId lastClientId = clientIds[0];
        stringBuffer.append("Site " + lastClientId.getSiteNumber() + " team " + lastClientId.getClientNumber());
        boolean inRange = false;
        int i = 1;
        while (i < clientIds.length) {
            clientId = clientIds[i];
            if (lastClientId.getSiteNumber() != clientId.getSiteNumber()) {
                if (inRange) {
                    stringBuffer.append(lastClientId.getClientNumber());
                    inRange = false;
                }
                stringBuffer.append(" Site " + clientId.getSiteNumber() + " team " + clientId.getClientNumber());
            } else if (lastClientId.getSiteNumber() == clientId.getSiteNumber() && lastClientId.getClientNumber() + 1 == clientId.getClientNumber()) {
                if (!inRange) {
                    stringBuffer.append("-");
                    inRange = true;
                }
            } else {
                if (inRange) {
                    stringBuffer.append(lastClientId.getClientNumber());
                }
                stringBuffer.append("," + clientId.getClientNumber());
                inRange = false;
            }
            lastClientId = clientId;
            ++i;
        }
        if (inRange) {
            stringBuffer.append(clientId.getClientNumber());
        }
        return stringBuffer.toString();
    }
}

