/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.StringUtilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;

public class EventFeedDefinition
implements IElementObject {
    private static final long serialVersionUID = 5529479138590675584L;
    private int port;
    private String name;
    private boolean active = false;
    private ElementId elementId = null;
    private int siteNumber;
    private boolean frozen = false;

    public EventFeedDefinition(String name) {
        this.name = name;
        this.elementId = new ElementId(name);
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    @Override
    public int getSiteNumber() {
        return this.siteNumber;
    }

    @Override
    public void setSiteNumber(int siteNumber) {
        this.siteNumber = siteNumber;
    }

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    public String getDisplayName() {
        return this.name;
    }

    public void setDisplayName(String displayName) {
        this.name = displayName;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public boolean isSameAs(EventFeedDefinition definition) {
        block11: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            try {
                                if (definition != null) break block7;
                                return false;
                            }
                            catch (Exception e) {
                                StaticLog.getLog().log(Log.WARNING, "Exception comparing Problem " + e.getMessage(), e);
                                e.printStackTrace(System.err);
                                return false;
                            }
                        }
                        if (this.port == definition.getPort()) break block8;
                        return false;
                    }
                    if (this.siteNumber == definition.getSiteNumber()) break block9;
                    return false;
                }
                if (StringUtilities.stringSame(this.name, definition.getDisplayName())) break block10;
                return false;
            }
            if (this.frozen == definition.isFrozen()) break block11;
            return false;
        }
        return this.active == definition.isActive();
    }
}

