/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.DateUtilities;
import edu.csus.ecs.pc2.core.StringUtilities;
import edu.csus.ecs.pc2.core.list.AccountList;
import edu.csus.ecs.pc2.core.list.JudgementNotificationsList;
import edu.csus.ecs.pc2.core.model.NotificationSetting;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;

public class ContestInformation
implements Serializable {
    private static final long serialVersionUID = -7333255582657988200L;
    public static final int DEFAULT_FREEZE_MINUTES = 60;
    private String contestTitle = "Programming Contest";
    private String contestURL;
    private TeamDisplayMask teamDisplayMode = TeamDisplayMask.LOGIN_NAME_ONLY;
    private String judgesDefaultAnswer = "No response, read problem statement";
    private boolean preliminaryJudgementsUsedByBoard = false;
    private boolean preliminaryJudgementsTriggerNotifications = false;
    private boolean sendAdditionalRunStatusInformation = false;
    private String judgeCDPBasePath = null;
    private String adminCDPBasePath = null;
    private boolean ccsTestMode = false;
    private long maxFileSize = 512000L;
    private JudgementNotificationsList judgementNotificationsList = new JudgementNotificationsList();
    private String externalYamlPath = null;
    private String rsiCommand = null;
    private int lastRunNumberSubmitted = 0;
    private Properties scoringProperties = new Properties();
    private boolean enableAutoRegistration = false;
    private AccountList.PasswordType autoRegistrationPasswordType = AccountList.PasswordType.RANDOM;
    private Date startDate;
    private boolean autoStartContest = false;
    private String freezeTime;
    private String contestShortName;

    public String getContestTitle() {
        return this.contestTitle;
    }

    public void setContestTitle(String contestTitle) {
        this.contestTitle = contestTitle;
    }

    public String getContestURL() {
        return this.contestURL;
    }

    public void setContestURL(String contestURL) {
        this.contestURL = contestURL;
    }

    public TeamDisplayMask getTeamDisplayMode() {
        return this.teamDisplayMode;
    }

    public void setTeamDisplayMode(TeamDisplayMask teamDisplayMask) {
        this.teamDisplayMode = teamDisplayMask;
    }

    public String getJudgesDefaultAnswer() {
        return this.judgesDefaultAnswer;
    }

    public void setJudgesDefaultAnswer(String judgesDefaultAnswer) {
        if (judgesDefaultAnswer != null && judgesDefaultAnswer.trim().length() > 0) {
            this.judgesDefaultAnswer = judgesDefaultAnswer.trim();
        }
    }

    public boolean isSameAs(ContestInformation contestInformation) {
        block38: {
            block37: {
                block36: {
                    block35: {
                        block34: {
                            block33: {
                                block32: {
                                    block31: {
                                        block30: {
                                            block29: {
                                                block28: {
                                                    block27: {
                                                        block26: {
                                                            block25: {
                                                                block24: {
                                                                    block23: {
                                                                        block22: {
                                                                            block21: {
                                                                                try {
                                                                                    if (this.contestTitle != null) break block21;
                                                                                    if (contestInformation.getContestTitle() != null) {
                                                                                        return false;
                                                                                    }
                                                                                    break block22;
                                                                                }
                                                                                catch (Exception e) {
                                                                                    e.printStackTrace(System.err);
                                                                                    return false;
                                                                                }
                                                                            }
                                                                            if (this.contestTitle.equals(contestInformation.getContestTitle())) break block22;
                                                                            return false;
                                                                        }
                                                                        if (this.judgesDefaultAnswer.equals(contestInformation.getJudgesDefaultAnswer())) break block23;
                                                                        return false;
                                                                    }
                                                                    if (this.teamDisplayMode.equals((Object)contestInformation.getTeamDisplayMode())) break block24;
                                                                    return false;
                                                                }
                                                                if (this.preliminaryJudgementsTriggerNotifications == contestInformation.isPreliminaryJudgementsTriggerNotifications()) break block25;
                                                                return false;
                                                            }
                                                            if (this.preliminaryJudgementsUsedByBoard == contestInformation.isPreliminaryJudgementsUsedByBoard()) break block26;
                                                            return false;
                                                        }
                                                        if (this.sendAdditionalRunStatusInformation == contestInformation.isSendAdditionalRunStatusInformation()) break block27;
                                                        return false;
                                                    }
                                                    if (this.maxFileSize == contestInformation.getMaxFileSize()) break block28;
                                                    return false;
                                                }
                                                if (this.scoringProperties.equals(contestInformation.getScoringProperties())) break block29;
                                                return false;
                                            }
                                            if (this.ccsTestMode == contestInformation.isCcsTestMode()) break block30;
                                            return false;
                                        }
                                        if (StringUtilities.stringSame(this.externalYamlPath, contestInformation.externalYamlPath)) break block31;
                                        return false;
                                    }
                                    if (StringUtilities.stringSame(this.rsiCommand, contestInformation.rsiCommand)) break block32;
                                    return false;
                                }
                                if (this.enableAutoRegistration == contestInformation.isEnableAutoRegistration()) break block33;
                                return false;
                            }
                            if (DateUtilities.dateSame(this.startDate, contestInformation.startDate)) break block34;
                            return false;
                        }
                        if (this.autoStartContest == contestInformation.autoStartContest) break block35;
                        return false;
                    }
                    if (StringUtilities.stringSame(this.freezeTime, contestInformation.freezeTime)) break block36;
                    return false;
                }
                if (StringUtilities.stringSame(this.contestShortName, contestInformation.contestShortName)) break block37;
                return false;
            }
            if (StringUtilities.stringSame(this.judgeCDPBasePath, contestInformation.getJudgeCDPBasePath())) break block38;
            return false;
        }
        return StringUtilities.stringSame(this.adminCDPBasePath, contestInformation.getAdminCDPBasePath());
    }

    public void setPreliminaryJudgementsUsedByBoard(boolean preliminaryJudgementsUsedByBoard) {
        this.preliminaryJudgementsUsedByBoard = preliminaryJudgementsUsedByBoard;
    }

    public boolean isPreliminaryJudgementsUsedByBoard() {
        return this.preliminaryJudgementsUsedByBoard;
    }

    public void setPreliminaryJudgementsTriggerNotifications(boolean preliminaryJudgementsTriggerNotifications) {
        this.preliminaryJudgementsTriggerNotifications = preliminaryJudgementsTriggerNotifications;
    }

    public boolean isPreliminaryJudgementsTriggerNotifications() {
        return this.preliminaryJudgementsTriggerNotifications;
    }

    public boolean isSendAdditionalRunStatusInformation() {
        return this.sendAdditionalRunStatusInformation;
    }

    public void setSendAdditionalRunStatusInformation(boolean sendAdditionalRunStatusInformation) {
        this.sendAdditionalRunStatusInformation = sendAdditionalRunStatusInformation;
    }

    public JudgementNotificationsList getJudgementNotificationsList() {
        return this.judgementNotificationsList;
    }

    public void setJudgementNotificationsList(JudgementNotificationsList judgementNotificationsList) {
        this.judgementNotificationsList = judgementNotificationsList;
    }

    public void updateJudgementNotification(NotificationSetting notificationSetting) {
        this.judgementNotificationsList.update(notificationSetting);
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public Properties getScoringProperties() {
        return this.scoringProperties;
    }

    public void setScoringProperties(Properties scoringProperties) {
        this.scoringProperties = scoringProperties;
    }

    public boolean isCcsTestMode() {
        return this.ccsTestMode;
    }

    public void setCcsTestMode(boolean ccsTestMode) {
        this.ccsTestMode = ccsTestMode;
    }

    public void setRsiCommand(String rsiCommand) {
        this.rsiCommand = rsiCommand;
    }

    public String getRsiCommand() {
        return this.rsiCommand;
    }

    public void setExternalYamlPath(String externalYamlPath) {
        this.externalYamlPath = externalYamlPath;
    }

    public String getExternalYamlPath() {
        return this.externalYamlPath;
    }

    public void setLastRunNumberSubmitted(int lastRunNumberSubmitted) {
        this.lastRunNumberSubmitted = lastRunNumberSubmitted;
    }

    public int getLastRunNumberSubmitted() {
        return this.lastRunNumberSubmitted;
    }

    public boolean isEnableAutoRegistration() {
        return this.enableAutoRegistration;
    }

    public void setEnableAutoRegistration(boolean enableAutoRegistration) {
        this.enableAutoRegistration = enableAutoRegistration;
    }

    public AccountList.PasswordType getAutoRegistrationPasswordType() {
        return this.autoRegistrationPasswordType;
    }

    public void setAutoRegistrationPasswordType(AccountList.PasswordType autoRegistrationPasswordType) {
        this.autoRegistrationPasswordType = autoRegistrationPasswordType;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public boolean isAutoStartContest() {
        return this.autoStartContest;
    }

    public void setAutoStartContest(boolean autoStartContest) {
        this.autoStartContest = autoStartContest;
    }

    public String getFreezeTime() {
        return this.freezeTime;
    }

    public void setFreezeTime(String freezeTime) {
        this.freezeTime = freezeTime;
    }

    public String getContestShortName() {
        return this.contestShortName;
    }

    public void setContestShortName(String contestShortName) {
        this.contestShortName = contestShortName;
    }

    public void setJudgeCDPBasePath(String judgeCDPBasePath) {
        this.judgeCDPBasePath = judgeCDPBasePath;
    }

    public String getJudgeCDPBasePath() {
        return this.judgeCDPBasePath;
    }

    public void setAdminCDPBasePath(String adminCDPBasePath) {
        this.adminCDPBasePath = adminCDPBasePath;
    }

    public String getAdminCDPBasePath() {
        return this.adminCDPBasePath;
    }

    public static enum TeamDisplayMask {
        NONE,
        LOGIN_NAME_ONLY,
        DISPLAY_NAME_ONLY,
        NUMBERS_AND_NAME,
        ALIAS;

    }
}

