/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Category;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Pluralize;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.model.Site;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ContestComparison {
    public static final String NEW_LINE = System.getProperty("line.separator");
    private List<IElementObject> list = new ArrayList<IElementObject>();

    public String comparisonList(IInternalContest contestOne, IInternalContest contestTwo) {
        ContestInformation ciTwo;
        StringBuffer buffer = new StringBuffer();
        ContestInformation ciOne = contestOne.getContestInformation();
        if (!ciOne.isSameAs(ciTwo = contestTwo.getContestInformation())) {
            buffer.append("Replace Contest Information" + NEW_LINE);
        }
        buffer.append(this.addComment("Site", contestOne.getSites().length, contestTwo.getSites().length));
        buffer.append(this.addComment("Problem", contestOne.getProblems().length, contestTwo.getProblems().length));
        int[] contestOneCounts = this.getDataFileCounts(contestOne);
        int[] contestTwoCounts = this.getDataFileCounts(contestTwo);
        String[] countTitles = new String[]{"Total Files", "Input files", "Answer files"};
        int i = 0;
        while (i < contestTwoCounts.length) {
            buffer.append(this.addComment(countTitles[i], contestOneCounts[i], contestTwoCounts[i]));
            ++i;
        }
        buffer.append(this.addComment("Language", contestOne.getLanguages().length, contestTwo.getLanguages().length));
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType.Type type = typeArray[n2];
            String accountTypeName = type.toString().toLowerCase();
            int countOne = contestOne.getAccounts(type).size();
            int countTwo = contestTwo.getAccounts(type).size();
            if (accountTypeName.equalsIgnoreCase("ALL")) {
                accountTypeName = "Account";
            }
            buffer.append(this.addComment(accountTypeName, countOne, countTwo));
            ++n2;
        }
        buffer.append(this.addComment("Group", contestOne.getGroups().length, contestTwo.getGroups().length));
        buffer.append(this.addComment("Clar. category", contestOne.getCategories().length, contestTwo.getCategories().length));
        buffer.append(this.addComment("Judgement", contestOne.getJudgements().length, contestTwo.getJudgements().length));
        ClientSettings[] settings = contestOne.getClientSettingsList();
        ClientSettings[] settingsTwo = contestTwo.getClientSettingsList();
        int autoJudgeSettingsOne = this.getAutoJudgeSettings(settings);
        int autoJudgeSettingsTow = this.getAutoJudgeSettings(settingsTwo);
        buffer.append(this.addComment("AJ Settings", autoJudgeSettingsOne, autoJudgeSettingsTow));
        return buffer.toString();
    }

    protected int getAutoJudgeSettings(ClientSettings[] settings) {
        int ajCount = 0;
        ClientSettings[] clientSettingsArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSettings clientSettings = clientSettingsArray[n2];
            Filter filter = clientSettings.getAutoJudgeFilter();
            int numberProblems = filter.getProblemIdList().length;
            if (numberProblems > 0) {
                ++ajCount;
            }
            ++n2;
        }
        return ajCount;
    }

    private int[] getDataFileCounts(IInternalContest aContest) {
        int[] outCounts = new int[3];
        Problem[] problems = aContest.getProblems();
        if (problems.length > 0) {
            int ansCount = 0;
            int datCount = 0;
            Problem[] problemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                Problem problem = problemArray[n2];
                ProblemDataFiles pdfiles = aContest.getProblemDataFile(problem);
                if (pdfiles != null) {
                    ansCount += pdfiles.getJudgesAnswerFiles().length;
                    datCount += pdfiles.getJudgesDataFiles().length;
                }
                ++n2;
            }
            outCounts[1] = datCount;
            outCounts[2] = ansCount;
        }
        return outCounts;
    }

    private String addComment(String name, int sizeOne, int sizeTwo) {
        String message = "";
        if (sizeTwo == sizeOne && sizeOne + sizeTwo > 0) {
            message = String.valueOf(message) + "Replace all " + sizeOne + " " + Pluralize.pluralize(name, sizeOne) + NEW_LINE;
        } else if (sizeTwo < sizeOne) {
            int diff = sizeOne - sizeTwo;
            if (sizeTwo != 0) {
                message = String.valueOf(message) + "Replace " + sizeTwo + " " + Pluralize.pluralize(name, sizeOne) + NEW_LINE;
                message = String.valueOf(message) + "Keep/ignore last " + diff + " " + Pluralize.pluralize(name, diff) + NEW_LINE;
            }
        } else if (sizeTwo > sizeOne) {
            int diff = sizeTwo - sizeOne;
            if (sizeOne > 0) {
                message = String.valueOf(message) + "Replace " + sizeOne + " " + Pluralize.pluralize(name, sizeOne) + NEW_LINE;
            }
            message = String.valueOf(message) + "Add " + diff + " " + Pluralize.pluralize(name, diff) + NEW_LINE;
        }
        return message;
    }

    public IElementObject[] getItems() {
        return this.list.toArray(new IElementObject[this.list.size()]);
    }

    public void add(IElementObject element) {
        this.list.add(element);
    }

    public void remove(IElementObject element) {
        this.list.remove(element);
    }

    private void addSummaryEntry(StringBuffer buf, String entryName) {
        buf.append(entryName);
        buf.append(NEW_LINE);
    }

    private void addSummaryEntry(StringBuffer buf, int count, String prefix, String entryName) {
        if (count > 0) {
            buf.append(count);
            String pluralized = Pluralize.pluralize(entryName, count);
            if (prefix.length() > 0) {
                buf.append(' ');
                buf.append(prefix);
            }
            buf.append(' ');
            buf.append(pluralized);
            buf.append(NEW_LINE);
        }
    }

    private void addSummaryEntry(StringBuffer sb, int count, String entryName) {
        this.addSummaryEntry(sb, count, "", entryName);
    }

    public String getContestLoadSummaryShorter(IInternalContest newContest) throws Exception {
        Language[] languages = newContest.getLanguages();
        Problem[] problems = newContest.getProblems();
        Site[] sites = newContest.getSites();
        Category[] categories = newContest.getCategories();
        ClientSettings[] settings = newContest.getClientSettingsList();
        StringBuffer sb = new StringBuffer();
        this.addSummaryEntry(sb, sites.length, "site");
        this.addSummaryEntry(sb, problems.length, "problem");
        if (problems.length > 0) {
            int ansCount = 0;
            int datCount = 0;
            int numberExternalDataFileProblems = 0;
            Problem[] problemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                Problem problem = problemArray[n2];
                ProblemDataFiles pdfiles = newContest.getProblemDataFile(problem);
                if (pdfiles != null) {
                    ansCount += pdfiles.getJudgesAnswerFiles().length;
                    datCount += pdfiles.getJudgesDataFiles().length;
                }
                if (problem.isUsingExternalDataFiles()) {
                    ++numberExternalDataFileProblems;
                }
                ++n2;
            }
            if (datCount > 0) {
                this.addSummaryEntry(sb, datCount, "input data file");
            } else if (numberExternalDataFileProblems == problems.length) {
                sb.append("All data files are external");
            }
            if (ansCount > 0) {
                this.addSummaryEntry(sb, ansCount, "answer data file");
            } else if (numberExternalDataFileProblems == problems.length) {
                sb.append("All answer files are external");
            }
        }
        this.addSummaryEntry(sb, languages.length, "language");
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n3 = 0;
        while (n3 < n) {
            ClientType.Type type = typeArray[n3];
            Vector<Account> accounts = newContest.getAccounts(type);
            String accountTypeName = type.toString().toLowerCase();
            this.addSummaryEntry(sb, accounts.size(), accountTypeName, " account");
            ++n3;
        }
        this.addSummaryEntry(sb, categories.length, "clar", "category");
        this.addSummaryEntry(sb, settings.length, "AJ setting");
        return sb.toString();
    }

    public String getContestLoadSummary(IInternalContest newContest) throws Exception {
        int externalDataProblemCount;
        Language[] languages = newContest.getLanguages();
        Problem[] problems = newContest.getProblems();
        Site[] sites = newContest.getSites();
        Category[] categories = newContest.getCategories();
        ClientSettings[] settings = newContest.getClientSettingsList();
        StringBuffer sb = new StringBuffer();
        this.addSummaryEntry(sb, sites.length, "site");
        this.addSummaryEntry(sb, problems.length, "problem");
        long totalBytes = 0L;
        int ansCount = 0;
        int datCount = 0;
        if (problems.length > 0) {
            int totalProblems = problems.length;
            externalDataProblemCount = 0;
            Problem[] problemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                ProblemDataFiles pdfiles;
                Problem problem = problemArray[n2];
                if (problem.isUsingExternalDataFiles()) {
                    ++externalDataProblemCount;
                }
                if ((pdfiles = newContest.getProblemDataFile(problem)) != null) {
                    SerializedFile serializedFile;
                    ansCount += pdfiles.getJudgesAnswerFiles().length;
                    datCount += pdfiles.getJudgesDataFiles().length;
                    SerializedFile[] serializedFileArray = pdfiles.getJudgesAnswerFiles();
                    int n3 = serializedFileArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        serializedFile = serializedFileArray[n4];
                        totalBytes += (long)serializedFile.getBuffer().length;
                        ++n4;
                    }
                    serializedFileArray = pdfiles.getJudgesDataFiles();
                    n3 = serializedFileArray.length;
                    n4 = 0;
                    while (n4 < n3) {
                        serializedFile = serializedFileArray[n4];
                        totalBytes += (long)serializedFile.getBuffer().length;
                        ++n4;
                    }
                }
                if (totalProblems == externalDataProblemCount) {
                    System.out.println("All external data files (" + totalProblems + ")");
                } else if (externalDataProblemCount == 0) {
                    System.out.println("All internal/loaded data files (" + totalProblems + ")");
                }
                ++n2;
            }
            this.addSummaryEntry(sb, datCount, "input data file");
            this.addSummaryEntry(sb, ansCount, "answer data file");
        } else {
            this.addSummaryEntry(sb, "No problems to be added");
        }
        this.addSummaryEntry(sb, languages.length, "language");
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        externalDataProblemCount = 0;
        while (externalDataProblemCount < n) {
            ClientType.Type type = typeArray[externalDataProblemCount];
            Vector<Account> accounts = newContest.getAccounts(type);
            String accountTypeName = type.toString().toLowerCase();
            this.addSummaryEntry(sb, accounts.size(), accountTypeName, " account");
            ++externalDataProblemCount;
        }
        this.addSummaryEntry(sb, categories.length, "clar", "category");
        this.addSummaryEntry(sb, settings.length, "AJ setting");
        if (problems.length > 0) {
            int totalFiles = ansCount + datCount;
            if (totalBytes == 0L) {
                sb.append("NO file/data contents loaded for any Problems (external files)");
                sb.append(NEW_LINE);
            } else {
                long meg = totalBytes / 1000L / 1000L;
                sb.append("Will load " + totalBytes + " bytes (" + meg + " Meg) from " + totalFiles + " files");
                sb.append(NEW_LINE);
            }
        }
        return sb.toString();
    }
}

