/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ContestTime;
import java.io.Serializable;
import java.util.Date;

public class ClarificationAnswer
implements Serializable {
    private static final long serialVersionUID = 6355584858957926890L;
    private boolean sendToAll = false;
    private ClientId answerClient;
    private Date date = new Date();
    private long elapsedMS;
    private String answer;

    public ClarificationAnswer(String answer, ClientId answerClient, boolean sendToAll, ContestTime contestTime) {
        if (answer == null) {
            throw new IllegalArgumentException("answer can not be null");
        }
        if (contestTime == null) {
            throw new IllegalArgumentException("contestTime can not be null");
        }
        this.answer = answer;
        this.answerClient = answerClient;
        this.sendToAll = sendToAll;
        this.setDate(contestTime);
    }

    protected void setDate(ContestTime contestTime) {
        this.date = new Date();
        this.elapsedMS = contestTime.getElapsedMS();
    }

    public boolean isSendToAll() {
        return this.sendToAll;
    }

    public ClientId getAnswerClient() {
        return this.answerClient;
    }

    public Date getDate() {
        return this.date;
    }

    public long getElapsedMS() {
        return this.elapsedMS;
    }

    public String getAnswer() {
        return this.answer;
    }
}

