/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.list;

import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;

public class RunResultsFileList
implements Serializable {
    private static final long serialVersionUID = -8277112546999332502L;
    private boolean writeToDisk = false;
    public static final String EXTENSION = ".files";
    private RunResultFiles singleRunResultFiles = null;
    private IStorage storage;

    public RunResultsFileList() {
        this.writeToDisk = false;
    }

    public RunResultsFileList(IStorage storage) {
        this.storage = storage;
        this.writeToDisk = true;
    }

    protected String stripChar(String s, char ch) {
        int idx = s.indexOf(ch);
        if (idx > -1) {
            StringBuffer sb = new StringBuffer(s);
            idx = sb.indexOf(String.valueOf(ch));
            while (idx > -1) {
                sb.deleteCharAt(idx);
                idx = sb.indexOf(String.valueOf(ch));
            }
            return sb.toString();
        }
        return s;
    }

    private String stripChars(String s) {
        return this.stripChar(s, ' ');
    }

    private String getFileName(int siteNumber, int runNumber, JudgementRecord judgementRecord) {
        String name = "s" + siteNumber + "r" + runNumber + "." + this.stripChars(judgementRecord.getElementId().toString()) + EXTENSION;
        if (this.storage != null) {
            return String.valueOf(this.storage.getDirectoryName()) + File.separator + name;
        }
        return name;
    }

    public String getFileName(Run run, JudgementRecord judgementRecord) {
        return this.getFileName(run.getSiteNumber(), run.getNumber(), judgementRecord);
    }

    public RunResultFiles add(Run run, JudgementRecord judgementRecord, RunResultFiles runFiles) throws IOException, ClassNotFoundException, FileSecurityException {
        if (this.writeToDisk) {
            String filename = this.getFileName(run, judgementRecord);
            if (this.storage.store(filename, runFiles)) {
                return runFiles;
            }
            return null;
        }
        this.singleRunResultFiles = runFiles;
        return this.singleRunResultFiles;
    }

    private RunResultFiles getRunResultFiles(int siteNumber, int runNumber, JudgementRecord judgementRecord) throws IOException, ClassNotFoundException, FileSecurityException {
        if (this.writeToDisk) {
            String filename = this.getFileName(siteNumber, runNumber, judgementRecord);
            Serializable obj = this.storage.load(filename);
            return (RunResultFiles)obj;
        }
        return null;
    }

    public RunResultFiles getRunResultFiles(Run run, JudgementRecord judgementRecord) throws IOException, ClassNotFoundException, FileSecurityException {
        if (this.writeToDisk) {
            return this.getRunResultFiles(run.getSiteNumber(), run.getNumber(), judgementRecord);
        }
        if (this.singleRunResultFiles.getJudgementId().equals(judgementRecord.getJudgementId())) {
            return this.singleRunResultFiles;
        }
        return null;
    }

    public RunResultFiles[] getRunResultFiles(Run run) throws IOException, ClassNotFoundException, FileSecurityException {
        JudgementRecord[] judgementRecord = run.getAllJudgementRecords();
        RunResultFiles[] runResultFiles = new RunResultFiles[judgementRecord.length];
        int i = 0;
        while (i < judgementRecord.length) {
            runResultFiles[i] = this.getRunResultFiles(run.getSiteNumber(), run.getNumber(), judgementRecord[i]);
            ++i;
        }
        return runResultFiles;
    }

    public void clear() {
        if (this.writeToDisk) {
            File dir = new File(this.storage.getDirectoryName());
            if (dir.isDirectory()) {
                File[] entries;
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().toLowerCase().endsWith(RunResultsFileList.EXTENSION);
                    }
                };
                File[] fileArray = entries = dir.listFiles(filter);
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    try {
                        file.delete();
                        file = null;
                    }
                    catch (Exception e) {
                        StaticLog.log("Failed to remove " + file.getName(), e);
                    }
                    ++n2;
                }
                dir = null;
                Object var3_3 = null;
            }
        } else {
            this.singleRunResultFiles = null;
        }
    }

    public void clone(IStorage storage2) {
        if (this.writeToDisk) {
            File dir = new File(this.storage.getDirectoryName());
            if (dir.isDirectory()) {
                File[] entries;
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().toLowerCase().endsWith(RunResultsFileList.EXTENSION);
                    }
                };
                File[] fileArray = entries = dir.listFiles(filter);
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    try {
                        if (file.getCanonicalFile().toString().indexOf("JudgementRecord") != -1) {
                            Serializable serializable = this.storage.load(file.getCanonicalPath());
                            storage2.store(file.getName(), serializable);
                        }
                    }
                    catch (Exception e) {
                        this.logException("Unable to copy file " + file.getName() + " to " + storage2.getDirectoryName(), e);
                    }
                    ++n2;
                }
                dir = null;
                entries = null;
            }
        } else {
            this.singleRunResultFiles = null;
        }
    }

    private void logException(String string, Exception e) {
        if (StaticLog.getLog() == null) {
            StaticLog.getLog().log(Log.WARNING, string, e);
        } else {
            System.err.println(String.valueOf(string) + " " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

