/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.list;

import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Notification;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NotificationList
implements Serializable {
    private static final long serialVersionUID = -5437388419721390123L;
    private Hashtable<String, Notification> notifHash = new Hashtable();
    private boolean saveToDisk = false;
    private int nextNotificationNumber = 1;
    private IStorage storage = null;

    public NotificationList() {
        this.saveToDisk = false;
    }

    public NotificationList(IStorage storage) {
        this.storage = storage;
        this.saveToDisk = true;
    }

    public Notification addNewNotification(Notification notification) throws IOException, ClassNotFoundException, FileSecurityException {
        notification.setNumber(this.nextNotificationNumber++);
        this.add(notification);
        return notification;
    }

    public void add(Notification notification) throws IOException, ClassNotFoundException, FileSecurityException {
        this.notifHash.put(this.getNotificationKey(notification), notification);
        if (this.saveToDisk) {
            this.writeToDisk();
        }
    }

    public Notification get(Notification notification) {
        return this.notifHash.get(this.getNotificationKey(notification));
    }

    public Notification get(ElementId elementId) {
        return this.notifHash.get(elementId.toString());
    }

    public String getNotificationKey(Notification notification) {
        return notification.getElementId().toString();
    }

    public boolean delete(Notification notification) throws IOException, ClassNotFoundException, FileSecurityException {
        Notification fetchedNotification = this.get(notification);
        if (fetchedNotification != null) {
            fetchedNotification.setDeleted(true);
            this.writeToDisk();
            return true;
        }
        return false;
    }

    public void clear() throws IOException, ClassNotFoundException, FileSecurityException {
        this.notifHash = new Hashtable();
        this.nextNotificationNumber = 1;
        this.writeToDisk();
    }

    public void add(Notification[] clarList) throws IOException, ClassNotFoundException, FileSecurityException {
        Notification[] notificationArray = clarList;
        int n = clarList.length;
        int n2 = 0;
        while (n2 < n) {
            Notification notification = notificationArray[n2];
            this.add(notification);
            ++n2;
        }
    }

    public int size() {
        return this.notifHash.size();
    }

    public Notification[] getList() {
        Notification[] list = new Notification[this.notifHash.size()];
        if (this.notifHash.size() == 0) {
            return list;
        }
        return this.notifHash.values().toArray(new Notification[this.size()]);
    }

    public Notification updateNotification(Notification notification) throws IOException, ClassNotFoundException, FileSecurityException {
        Notification fetchedNotification = this.get(notification);
        if (fetchedNotification != null) {
            fetchedNotification.getElementId().incrementVersionNumber();
            this.writeToDisk();
            return fetchedNotification;
        }
        throw new SecurityException("Unable to find/update notifications " + notification);
    }

    public Enumeration<Notification> getClarList() {
        return this.notifHash.elements();
    }

    private String getFileName() {
        return String.valueOf(this.storage.getDirectoryName()) + File.separator + "notifs.dat";
    }

    public void loadFromDisk(int siteNumber) throws IOException, ClassNotFoundException, FileSecurityException {
        String filename = this.getFileName();
        if (Utilities.isFileThere(filename)) {
            this.notifHash = (Hashtable)this.storage.load(filename);
            this.nextNotificationNumber = this.lastNotificationNumber(siteNumber) + 1;
        }
    }

    private boolean writeToDisk() throws IOException, ClassNotFoundException, FileSecurityException {
        if (!this.isSaveToDisk()) {
            return false;
        }
        return this.storage.store(this.getFileName(), this.notifHash);
    }

    private int lastNotificationNumber(int siteNumber) {
        int lastNumber = 0;
        Notification[] notificationArray = this.getList();
        int n = notificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Notification notification = notificationArray[n2];
            if (notification.getSiteNumber() == siteNumber) {
                lastNumber = Math.max(lastNumber, notification.getNumber());
            }
            ++n2;
        }
        return lastNumber;
    }

    public boolean isSaveToDisk() {
        return this.saveToDisk;
    }

    public void setSaveToDisk(boolean saveToDisk) {
        this.saveToDisk = saveToDisk;
    }

    public void clone(IStorage storage2) {
        try {
            if (this.saveToDisk) {
                this.storage.store(this.getFileName(), this.notifHash);
            }
        }
        catch (Exception e) {
            this.logException("Unable to copy notification  " + this.getFileName() + " to " + storage2.getDirectoryName(), e);
        }
    }

    private void logException(String string, Exception e) {
        if (StaticLog.getLog() == null) {
            StaticLog.getLog().log(Log.WARNING, string, e);
        } else {
            System.err.println(String.valueOf(string) + " " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public int getNextNotificationNumber() {
        return this.nextNotificationNumber;
    }

    public Notification get(ClientId submitter, ElementId problemId) {
        Notification[] notificationArray = this.getList();
        int n = notificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Notification notification = notificationArray[n2];
            if (notification.getSubmitter().getClientNumber() == submitter.getClientNumber() && problemId.equals(notification.getProblemId()) && notification.getSubmitter().equals(submitter)) {
                return notification;
            }
            ++n2;
        }
        return null;
    }

    public Notification[] getList(ClientId submitter) {
        Vector<Notification> list = new Vector<Notification>();
        Notification[] notificationArray = this.getList();
        int n = notificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Notification notification = notificationArray[n2];
            if (notification.getSubmitter().equals(submitter)) {
                list.addElement(notification);
            }
            ++n2;
        }
        return list.toArray(new Notification[list.size()]);
    }
}

