/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.list;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Notification;
import edu.csus.ecs.pc2.core.model.Problem;
import java.io.Serializable;
import java.util.Comparator;

public class NotificationComparatorByTeamProblem
implements Comparator<Notification>,
Serializable {
    private static final long serialVersionUID = -5227962755821873627L;
    private IInternalContest contest = null;

    public NotificationComparatorByTeamProblem(IInternalContest contest) {
        this.contest = contest;
    }

    public int getProblemIndex(ElementId problemId) {
        Problem[] problems = this.contest.getProblems();
        int i = 0;
        while (i < problems.length) {
            if (problemId.equals(problems[i].getElementId())) {
                return i;
            }
            ++i;
        }
        return problems.length + 1;
    }

    @Override
    public int compare(Notification n1, Notification n2) {
        int site2;
        int site1 = n1.getSiteNumber();
        if (site1 == (site2 = n2.getSiteNumber())) {
            ClientId clientId1 = n1.getSubmitter();
            ClientId clientId2 = n2.getSubmitter();
            if (clientId1.getClientType().equals((Object)clientId2.getClientType())) {
                return clientId1.getClientNumber() - clientId2.getClientNumber();
            }
            int p1 = this.getProblemIndex(n1.getProblemId());
            int p2 = this.getProblemIndex(n2.getProblemId());
            return p1 - p2;
        }
        return site1 - site2;
    }
}

