/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.list;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LoginList
implements Serializable {
    private static final long serialVersionUID = -6212994169038018512L;
    public static final String SVN_ID = "$Id$";
    private Hashtable<ClientId, ConnectionHandlerID> clientHandlerHash = new Hashtable();
    private Hashtable<ConnectionHandlerID, ClientId> handlerClientHash = new Hashtable();
    private Hashtable<ClientId, Date> clientDateHash = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ClientId clientId, ConnectionHandlerID connectionHandlerID) {
        if (clientId == null) {
            throw new IllegalArgumentException("clientId is null, connectionHandlerID=" + connectionHandlerID);
        }
        if (connectionHandlerID == null) {
            throw new IllegalArgumentException("connection Id is null, clientId=" + clientId);
        }
        Hashtable<ClientId, ConnectionHandlerID> hashtable = this.clientHandlerHash;
        synchronized (hashtable) {
            this.clientHandlerHash.put(clientId, connectionHandlerID);
            this.handlerClientHash.put(connectionHandlerID, clientId);
            this.clientDateHash.put(clientId, new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ClientId clientId) {
        if (clientId == null) {
            throw new IllegalArgumentException("clientId is null");
        }
        Hashtable<ClientId, ConnectionHandlerID> hashtable = this.clientHandlerHash;
        synchronized (hashtable) {
            block5: {
                ConnectionHandlerID connectionHandlerID = this.clientHandlerHash.get(clientId);
                if (connectionHandlerID == null) break block5;
                this.handlerClientHash.remove(connectionHandlerID);
                this.clientHandlerHash.remove(clientId);
                this.clientDateHash.remove(clientId);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<ClientId> getClients(ClientType.Type type) {
        Hashtable<ClientId, ConnectionHandlerID> hashtable = this.clientHandlerHash;
        synchronized (hashtable) {
            Vector<ClientId> v = new Vector<ClientId>();
            Enumeration<ClientId> enumeration = this.clientHandlerHash.keys();
            while (enumeration.hasMoreElements()) {
                ClientId clientId = enumeration.nextElement();
                if (clientId.getClientType() != type) continue;
                v.addElement(clientId);
            }
            return v.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<ConnectionHandlerID> getHandles(ClientType.Type type) {
        Hashtable<ClientId, ConnectionHandlerID> hashtable = this.clientHandlerHash;
        synchronized (hashtable) {
            Vector<ConnectionHandlerID> v = new Vector<ConnectionHandlerID>();
            Enumeration<ClientId> enumeration = this.clientHandlerHash.keys();
            while (enumeration.hasMoreElements()) {
                ClientId clientId = enumeration.nextElement();
                if (clientId.getClientType() != type) continue;
                ConnectionHandlerID connectionHandlerID = this.clientHandlerHash.get(clientId);
                v.addElement(connectionHandlerID);
            }
            return v.elements();
        }
    }

    public ClientId getClientId(ConnectionHandlerID connectionHandlerID) {
        if (connectionHandlerID == null) {
            return null;
        }
        return this.handlerClientHash.get(connectionHandlerID);
    }

    public ConnectionHandlerID getConnectionHandleID(ClientId clientId) {
        if (clientId == null) {
            return null;
        }
        return this.clientHandlerHash.get(clientId);
    }

    public Date getLoggedInDate(ClientId clientId) {
        return this.clientDateHash.get(clientId);
    }

    public boolean isLoggedIn(ClientId clientId) {
        ConnectionHandlerID connectionHandlerID = this.getConnectionHandleID(clientId);
        return connectionHandlerID != null;
    }

    public boolean isValidConnectionID(ClientId clientId, ConnectionHandlerID connectionHandlerID) {
        ConnectionHandlerID savedConnectionHandlerID = this.getConnectionHandleID(clientId);
        return connectionHandlerID.equals(savedConnectionHandlerID);
    }

    public ConnectionHandlerID[] getHandlesList() {
        ConnectionHandlerID[] theList = new ConnectionHandlerID[this.clientHandlerHash.size()];
        if (theList.length == 0) {
            return theList;
        }
        theList = this.clientHandlerHash.values().toArray(new ConnectionHandlerID[this.clientHandlerHash.size()]);
        return theList;
    }

    public ClientId[] getClientIdList() {
        ClientId[] theList = new ClientId[this.handlerClientHash.size()];
        if (theList.length == 0) {
            return theList;
        }
        theList = this.handlerClientHash.values().toArray(new ClientId[this.handlerClientHash.size()]);
        return theList;
    }
}

