/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.list;

import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClarificationAnswer;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;

public class ClarificationList
implements Serializable {
    private static final long serialVersionUID = 8506339011148953151L;
    private Hashtable<String, Clarification> clarHash = new Hashtable();
    private boolean saveToDisk = false;
    private int nextClarificationNumber = 1;
    private IStorage storage = null;
    private LinkedList<String> backupList = new LinkedList();

    public ClarificationList() {
        this.saveToDisk = false;
    }

    public ClarificationList(IStorage storage) {
        this.storage = storage;
        this.saveToDisk = true;
    }

    public Clarification addNewClarification(Clarification clarification) throws IOException, ClassNotFoundException, FileSecurityException {
        clarification.setNumber(this.nextClarificationNumber++);
        this.add(clarification);
        return clarification;
    }

    public void add(Clarification clarification) throws IOException, ClassNotFoundException, FileSecurityException {
        this.clarHash.put(this.getClarificationKey(clarification), clarification);
        if (this.saveToDisk) {
            this.writeToDisk();
        }
    }

    public Clarification get(Clarification clarification) {
        return this.clarHash.get(this.getClarificationKey(clarification));
    }

    public Clarification get(ElementId elementId) {
        return this.clarHash.get(elementId.toString());
    }

    public String getClarificationKey(Clarification clarification) {
        return clarification.getElementId().toString();
    }

    public boolean delete(Clarification clarification) throws IOException, ClassNotFoundException, FileSecurityException {
        Clarification fetchedClarification = this.get(clarification);
        if (fetchedClarification != null) {
            fetchedClarification.setDeleted(true);
            this.writeToDisk();
            return true;
        }
        return false;
    }

    public void clear() throws IOException, ClassNotFoundException, FileSecurityException {
        this.clarHash = new Hashtable();
        this.nextClarificationNumber = 1;
        this.writeToDisk();
    }

    public void add(Clarification[] clarList) throws IOException, ClassNotFoundException, FileSecurityException {
        Clarification[] clarificationArray = clarList;
        int n = clarList.length;
        int n2 = 0;
        while (n2 < n) {
            Clarification clarification = clarificationArray[n2];
            this.add(clarification);
            ++n2;
        }
    }

    public int size() {
        return this.clarHash.size();
    }

    public Clarification[] getList() {
        Clarification[] list = new Clarification[this.clarHash.size()];
        if (this.clarHash.size() == 0) {
            return list;
        }
        return this.clarHash.values().toArray(new Clarification[this.size()]);
    }

    public void updateClarification(Clarification clarification) throws IOException, ClassNotFoundException, FileSecurityException {
        clarification.getElementId().incrementVersionNumber();
        this.clarHash.put(this.getClarificationKey(clarification), clarification);
        this.writeToDisk();
    }

    public void updateClarification(Clarification clarification, Clarification.ClarificationStates newState, ClientId sourceId) throws IOException, ClassNotFoundException, FileSecurityException {
        Clarification fetchedClarification = this.get(clarification);
        if (fetchedClarification == null) {
            throw new SecurityException("Unable to find/update clarifications " + clarification);
        }
        fetchedClarification.getElementId().incrementVersionNumber();
        fetchedClarification.setState(newState);
        this.writeToDisk();
    }

    public Clarification updateClarification(Clarification clarification, Clarification.ClarificationStates newState, ClarificationAnswer answer) throws IOException, ClassNotFoundException, FileSecurityException {
        Clarification fetchedClarification = this.get(clarification);
        if (fetchedClarification != null) {
            fetchedClarification.getElementId().incrementVersionNumber();
            fetchedClarification.setState(newState);
            if (answer != null) {
                fetchedClarification.addAnswer(answer);
            }
            this.writeToDisk();
            return fetchedClarification;
        }
        throw new SecurityException("Unable to find/update clarifications " + clarification);
    }

    public Enumeration<Clarification> getClarList() {
        return this.clarHash.elements();
    }

    private String getFileName() {
        return String.valueOf(this.storage.getDirectoryName()) + File.separator + "clarlist.dat";
    }

    public String getBackupFilename() {
        return String.valueOf(this.storage.getDirectoryName()) + File.separator + "clarlist." + Utilities.getDateTime() + "." + System.nanoTime() + ".dat";
    }

    public void loadFromDisk(int siteNumber) throws IOException, ClassNotFoundException, FileSecurityException {
        String filename = this.getFileName();
        if (Utilities.isFileThere(filename)) {
            this.clarHash = (Hashtable)this.storage.load(filename);
            this.nextClarificationNumber = this.lastClarificationNumber(siteNumber) + 1;
        }
    }

    private synchronized boolean writeToDisk() throws IOException, ClassNotFoundException, FileSecurityException {
        if (!this.isSaveToDisk()) {
            return false;
        }
        boolean stored = this.storage.store(this.getFileName(), this.clarHash);
        String backupFilename = this.getBackupFilename();
        this.storage.store(backupFilename, this.clarHash);
        this.backupList.add(backupFilename);
        while (this.backupList.size() > 100) {
            String removeBackupFile = this.backupList.removeFirst();
            File file = new File(removeBackupFile);
            if (!file.exists()) continue;
            file.delete();
        }
        return stored;
    }

    private int lastClarificationNumber(int siteNumber) {
        int lastNumber = 0;
        Clarification[] clarificationArray = this.getList();
        int n = clarificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Clarification clarification = clarificationArray[n2];
            if (clarification.getSiteNumber() == siteNumber) {
                lastNumber = Math.max(lastNumber, clarification.getNumber());
            }
            ++n2;
        }
        return lastNumber;
    }

    public boolean isSaveToDisk() {
        return this.saveToDisk;
    }

    public void setSaveToDisk(boolean saveToDisk) {
        this.saveToDisk = saveToDisk;
    }

    public void clone(IStorage storage2) {
        try {
            if (this.saveToDisk) {
                this.storage.store(this.getFileName(), this.clarHash);
            }
        }
        catch (Exception e) {
            this.logException("Unable to copy clarification  " + this.getFileName() + " to " + storage2.getDirectoryName(), e);
        }
    }

    private void logException(String string, Exception e) {
        if (StaticLog.getLog() == null) {
            StaticLog.getLog().log(Log.WARNING, string, e);
        } else {
            System.err.println(String.valueOf(string) + " " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public int getNextClarificationNumber() {
        return this.nextClarificationNumber;
    }

    public Clarification uncheckoutClarification(Clarification clarification) throws IOException, ClassNotFoundException, FileSecurityException {
        Clarification fetchedClarification = this.get(clarification);
        if (fetchedClarification != null) {
            fetchedClarification.getElementId().incrementVersionNumber();
            fetchedClarification.setState(Clarification.ClarificationStates.NEW);
            fetchedClarification.setWhoCheckedItOutId(null);
            this.writeToDisk();
            return fetchedClarification;
        }
        throw new SecurityException("Unable to find/update clarification " + clarification);
    }
}

