/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.list;

import edu.csus.ecs.pc2.core.model.BalloonDeliveryInfo;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import java.io.Serializable;
import java.util.Comparator;

public class BalloonDeliveryComparator
implements Comparator<BalloonDeliveryInfo>,
Serializable {
    private static final long serialVersionUID = 695175116577330925L;
    private IInternalContest contest = null;

    public BalloonDeliveryComparator(IInternalContest contest) {
        this.contest = contest;
    }

    @Override
    public int compare(BalloonDeliveryInfo ballD1, BalloonDeliveryInfo ballD2) {
        int site2;
        ClientId clientId1 = ballD1.getClientId();
        ClientId clientId2 = ballD2.getClientId();
        int site1 = clientId1.getSiteNumber();
        if (site1 == (site2 = clientId2.getSiteNumber())) {
            if (clientId1.getClientType().equals((Object)clientId2.getClientType())) {
                if (clientId1.getClientNumber() == clientId2.getClientNumber()) {
                    ElementId problem1Id = ballD1.getProblemId();
                    ElementId problem2Id = ballD2.getProblemId();
                    return this.getProblemIndex(problem1Id) - this.getProblemIndex(problem2Id);
                }
                return clientId1.getClientNumber() - clientId2.getClientNumber();
            }
            return clientId1.getClientType().compareTo(clientId2.getClientType());
        }
        return site1 - site2;
    }

    public int getProblemIndex(ElementId problemId) {
        Problem[] problems = this.contest.getProblems();
        int i = 0;
        while (i < problems.length) {
            if (problemId.equals(problems[i].getElementId())) {
                return i;
            }
            ++i;
        }
        return problems.length + 1;
    }
}

