/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.list;

import edu.csus.ecs.pc2.core.PermissionGroup;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.BaseElementList;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class AccountList
extends BaseElementList {
    public static final String SVN_ID = "$Id$";
    private static final long serialVersionUID = -9188551825072244360L;
    private PermissionGroup permissionGroup = new PermissionGroup();

    public Vector<Account> generateNewAccounts(ClientType.Type type, int count, PasswordType passwordType, int siteNumber, boolean isActive) {
        return this.generateNewAccounts(type, count, 1, passwordType, siteNumber, isActive);
    }

    public Vector<Account> generateNewAccounts(ClientType.Type type, int count, int startNumber, PasswordType passwordType, int siteNumber, boolean isActive) {
        Vector<Account> newAccountList = new Vector<Account>();
        int offset = startNumber - 1;
        int i = 0;
        while (i < count) {
            ClientId clientId = new ClientId(siteNumber, type, i + offset + 1);
            while (this.getAccount(clientId) != null) {
                clientId = new ClientId(siteNumber, type, i + ++offset + 1);
            }
            String newPassword = this.generatePassword(passwordType, clientId);
            Account account = new Account(clientId, newPassword, siteNumber);
            if (isActive) {
                PermissionList permissionList = this.permissionGroup.getPermissionList(type);
                if (permissionList != null) {
                    account.clearListAndLoadPermissions(permissionList);
                } else {
                    account.addPermission(Permission.Type.LOGIN);
                    account.addPermission(Permission.Type.DISPLAY_ON_SCOREBOARD);
                }
            }
            newAccountList.add(account);
            super.add(account);
            ++i;
        }
        return newAccountList;
    }

    public boolean isDefinedAccount(ClientId clientId) {
        return this.getAccount(clientId) != null;
    }

    public Account getAccount(ClientId clientId) {
        Account account = new Account(clientId, "", clientId.getSiteNumber());
        return (Account)this.get(account);
    }

    public String getTitle(ClientId id) {
        Enumeration<? extends IElementObject> enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Account account = (Account)enumeration.nextElement();
            if (!account.getClientId().equals(id)) continue;
            return account.getDisplayName();
        }
        return id.getName();
    }

    private String generatePassword(PasswordType passwordType, ClientId clientId) {
        if (passwordType == PasswordType.JOE) {
            return String.valueOf(clientId.getClientType().toString().toLowerCase()) + clientId.getClientNumber();
        }
        return String.valueOf(clientId.getClientType().toString().toLowerCase()) + clientId.getClientNumber();
    }

    public Vector<Account> getAccounts(ClientType.Type type) {
        Vector<Account> v = new Vector<Account>();
        if (type.equals((Object)ClientType.Type.ALL)) {
            Enumeration<? extends IElementObject> enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                Account account = (Account)enumeration.nextElement();
                v.addElement(account);
            }
            return v;
        }
        Enumeration<? extends IElementObject> enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Account account = (Account)enumeration.nextElement();
            if (account.getClientId().getClientType() != type) continue;
            v.addElement(account);
        }
        return v;
    }

    public Vector<Account> getAccounts(ClientType.Type type, int siteNumber) {
        Vector<Account> v = new Vector<Account>();
        Enumeration<? extends IElementObject> enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Account account = (Account)enumeration.nextElement();
            if (account.getClientId().getClientType() != type || account.getSiteNumber() != siteNumber) continue;
            v.addElement(account);
        }
        return v;
    }

    public Vector<Account> getAccounts(int siteNumber) {
        Vector<Account> v = new Vector<Account>();
        Enumeration<? extends IElementObject> enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Account account = (Account)enumeration.nextElement();
            if (account.getSiteNumber() != siteNumber) continue;
            v.addElement(account);
        }
        return v;
    }

    public Account getSiteAccountByPassword(String password) {
        for (Account siteAccount : this.getAccounts(ClientType.Type.SERVER)) {
            if (!siteAccount.getPassword().equals(password)) continue;
            return siteAccount;
        }
        return null;
    }

    public boolean isValidLoginAndPassword(ClientId clientId, String password) {
        Account account = this.getAccount(clientId);
        if (account == null || clientId.getClientType() == ClientType.Type.SERVER) {
            Account siteAccount = this.getSiteAccountByPassword(password);
            if (siteAccount != null) {
                return true;
            }
            if (account == null) {
                throw new SecurityException("No such account");
            }
            throw new SecurityException("Invalid password");
        }
        if (!account.isAllowed(Permission.Type.LOGIN)) {
            throw new SecurityException("Account inactive");
        }
        if (account.getClientId().equals(clientId)) {
            if (account.getPassword().equals(password)) {
                return true;
            }
            throw new SecurityException("Invalid password");
        }
        throw new SecurityException("No such account.");
    }

    public void addNewAccount(Account account) {
        int siteNumber = account.getSiteNumber();
        Vector<Account> accounts = this.getAccounts(account.getClientId().getClientType(), siteNumber);
        int nextClientNumber = accounts.size() + 1;
        ClientId id = new ClientId(siteNumber, account.getClientId().getClientType(), nextClientNumber);
        account.setClientId(id);
        super.add(account);
    }

    @Override
    public String getKey(IElementObject elementObject) {
        Account account = (Account)elementObject;
        return account.getClientId().getTripletKey();
    }

    public Account get(ClientId id) {
        Account account = new Account(id, "", id.getSiteNumber());
        return (Account)this.get(account);
    }

    public Account[] getList() {
        return this.values().toArray(new Account[this.size()]);
    }

    public Account assignNewTeam(int siteNumber, String teamName, String[] memberNames, String password) {
        Account newAccount = this.findOrCreateNewAccount(siteNumber, ClientType.Type.TEAM, teamName);
        newAccount.setDisplayName(teamName);
        newAccount.setMemberNames(memberNames);
        if (password != null) {
            newAccount.setPassword(password);
        }
        return newAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Account findOrCreateNewAccount(int siteNumber, ClientType.Type type, String teamName) {
        AccountList accountList = this;
        synchronized (accountList) {
            Vector<Account> vector = this.getAccounts(type, siteNumber);
            Account[] accounts = vector.toArray(new Account[vector.size()]);
            Arrays.sort(accounts, new AccountComparator());
            Account[] accountArray = accounts;
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (this.isNotAssigned(account)) {
                    return account;
                }
                ++n2;
            }
            Vector<Account> newAccounts = this.generateNewAccounts(type, 1, PasswordType.JOE, siteNumber, true);
            return newAccounts.firstElement();
        }
    }

    private boolean isNotAssigned(Account account) {
        return account.getDefaultDisplayName(account.getClientId()).equals(account.getDisplayName());
    }

    public static long generateExternalId(Account account) {
        return AccountList.generateExternalId(account.getSiteNumber(), account.getClientId().getClientNumber());
    }

    public static long generateExternalId(int siteNumber, int clientNumber) {
        return siteNumber * 1000 + clientNumber;
    }

    public static enum PasswordType {
        JOE,
        RANDOM,
        DICTIONARY_WORDS;

    }
}

