/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.execute;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Plugin;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.execute.ExecutionData;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;

public class ExecuteUtilities
extends Plugin {
    private static final long serialVersionUID = -9167576117688387694L;
    private Run run;
    private RunFiles runFiles;
    private Problem problem;
    private Language language;
    private ProblemDataFiles problemDataFiles;
    private Log log;
    private ExecutionData executionData;
    private String resultsFileName;
    private static String debugMessage = null;
    public static final String DEFAULT_PC2_JAR_PATH = "./build/prod";
    public static final String PC2_JAR_FILENAME = "pc2.jar";

    public ExecuteUtilities(IInternalContest contest, IInternalController controller, Run run, RunFiles runFiles, Problem problem, Language language) {
        this.setContestAndController(contest, controller);
        this.run = run;
        this.runFiles = runFiles;
        this.problem = problem;
        this.language = language;
        this.log = this.getController().getLog();
        if (run == null) {
            throw new IllegalArgumentException("Run is null");
        }
        this.resultsFileName = ExecuteUtilities.createResultsFileName(run);
    }

    public static String replaceString(String origString, String beforeString, String afterString) {
        debugMessage = null;
        if (origString == null) {
            return origString;
        }
        int startIdx = origString.lastIndexOf(beforeString);
        if (startIdx == -1) {
            return origString;
        }
        StringBuffer buf = new StringBuffer(origString);
        while (startIdx != -1) {
            buf.replace(startIdx, startIdx + beforeString.length(), afterString);
            startIdx = origString.lastIndexOf(beforeString, startIdx - 1);
        }
        return buf.toString();
    }

    public static String replaceString(String origString, String beforeString, int afterInt) {
        debugMessage = null;
        String afterString = new Integer(afterInt).toString();
        return ExecuteUtilities.replaceString(origString, beforeString, afterString);
    }

    public static String removeExtension(String original) {
        String outString = new String(original);
        int dotIndex = outString.lastIndexOf(46, outString.length() - 1);
        if (dotIndex != -1) {
            outString = outString.substring(0, dotIndex);
        }
        return outString;
    }

    public String substituteAllStrings(String origString) {
        String pc2home;
        String newString = "";
        String nullArgument = "-";
        if (this.run == null) {
            throw new IllegalArgumentException("Run is null");
        }
        if (this.runFiles.getMainFile() == null) {
            return origString;
        }
        newString = ExecuteUtilities.replaceString(origString, "{:mainfile}", this.runFiles.getMainFile().getName());
        newString = ExecuteUtilities.replaceString(newString, "{:basename}", ExecuteUtilities.removeExtension(this.runFiles.getMainFile().getName()));
        if (this.problem != null) {
            SerializedFile validatorFile;
            String validatorCommand = null;
            if (this.problem.getValidatorProgramName() != null) {
                validatorCommand = this.problem.getValidatorProgramName();
            }
            if (this.problemDataFiles != null && (validatorFile = this.problemDataFiles.getValidatorFile()) != null) {
                validatorCommand = validatorFile.getName();
            }
            if (validatorCommand != null) {
                newString = ExecuteUtilities.replaceString(newString, "{:validator}", validatorCommand);
            }
        } else {
            this.debugLog("Problem is null");
        }
        if (this.run.getLanguageId() != null) {
            Language[] langs = this.getContest().getLanguages();
            int index = 0;
            String displayName = "";
            int i = 0;
            while (i < langs.length) {
                if (langs[i] != null && langs[i].getElementId().equals(this.run.getLanguageId())) {
                    displayName = langs[i].getDisplayName().toLowerCase().replaceAll(" ", "_");
                    index = i + 1;
                    break;
                }
                ++i;
            }
            if (index > 0) {
                newString = ExecuteUtilities.replaceString(newString, "{:language}", index);
                newString = ExecuteUtilities.replaceString(newString, "{:languageletter}", Utilities.convertNumber(index));
                newString = ExecuteUtilities.replaceString(newString, "{:languagename}", displayName);
            } else {
                this.debugLog("No language defined for " + this.run.getLanguageId());
            }
        }
        if (this.run.getProblemId() != null) {
            Problem[] problems = this.getContest().getProblems();
            int index = 0;
            int i = 0;
            while (i < problems.length) {
                if (problems[i] != null && problems[i].getElementId().equals(this.run.getProblemId())) {
                    index = i + 1;
                    break;
                }
                ++i;
            }
            if (index > 0) {
                newString = ExecuteUtilities.replaceString(newString, "{:problem}", index);
                newString = ExecuteUtilities.replaceString(newString, "{:problemletter}", Utilities.convertNumber(index));
            } else {
                this.debugLog("No problem defined for " + this.run.getProblemId());
            }
        }
        if (this.run.getSubmitter() != null) {
            newString = ExecuteUtilities.replaceString(newString, "{:teamid}", this.run.getSubmitter().getClientNumber());
            newString = ExecuteUtilities.replaceString(newString, "{:siteid}", this.run.getSubmitter().getSiteNumber());
        }
        if (this.problem != null) {
            newString = this.problem.getDataFileName() != null && !this.problem.getDataFileName().equals("") ? ExecuteUtilities.replaceString(newString, "{:infile}", this.problem.getDataFileName()) : ExecuteUtilities.replaceString(newString, "{:infile}", nullArgument);
            newString = this.problem.getAnswerFileName() != null && !this.problem.getAnswerFileName().equals("") ? ExecuteUtilities.replaceString(newString, "{:ansfile}", this.problem.getAnswerFileName()) : ExecuteUtilities.replaceString(newString, "{:ansfile}", nullArgument);
            newString = ExecuteUtilities.replaceString(newString, "{:timelimit}", Long.toString(this.problem.getTimeOutInSeconds()));
        }
        if (this.executionData != null) {
            if (this.executionData.getExecuteProgramOutput() != null) {
                newString = this.executionData.getExecuteProgramOutput().getName() != null ? ExecuteUtilities.replaceString(newString, "{:outfile}", this.executionData.getExecuteProgramOutput().getName()) : ExecuteUtilities.replaceString(newString, "{:outfile}", nullArgument);
            }
            newString = ExecuteUtilities.replaceString(newString, "{:exitvalue}", Integer.toString(this.executionData.getExecuteExitValue()));
            newString = ExecuteUtilities.replaceString(newString, "{:executetime}", Long.toString(this.executionData.getExecuteTimeMS()));
        }
        if ((pc2home = ExecuteUtilities.getPC2Home()) != null && pc2home.length() > 0) {
            newString = ExecuteUtilities.replaceString(newString, "{:pc2home}", pc2home);
        }
        if (this.resultsFileName != null) {
            newString = ExecuteUtilities.replaceString(newString, "{:resfile}", this.resultsFileName);
        }
        return newString;
    }

    public static String getPC2Home() {
        String pc2home = new VersionInfo().locateHome();
        return pc2home;
    }

    private void debugLog(String string) {
        debugMessage = string;
        Exception ex = new Exception("ERROR " + string);
        if (this.log != null) {
            this.log.log(Log.DEBUG, ex.getMessage(), ex);
        } else {
            ex.printStackTrace(System.err);
        }
    }

    public static String createResultsFileName(Run run) {
        return ExecuteUtilities.createResultsFileName(run.getNumber());
    }

    public static String createResultsFileName(int runNumber) {
        String secs = new Long(new Date().getTime() % 100L).toString();
        String resultsFileName = String.valueOf(runNumber) + secs + "XRSAM.txt";
        return resultsFileName;
    }

    public Run getRun() {
        return this.run;
    }

    public void setRun(Run run) {
        this.run = run;
    }

    public RunFiles getRunFiles() {
        return this.runFiles;
    }

    public void setRunFiles(RunFiles runFiles) {
        this.runFiles = runFiles;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public void setProblem(Problem problem) {
        this.problem = problem;
    }

    public ProblemDataFiles getProblemDataFiles() {
        return this.problemDataFiles;
    }

    public void setProblemDataFiles(ProblemDataFiles problemDataFiles) {
        this.problemDataFiles = problemDataFiles;
    }

    public ExecutionData getExecutionData() {
        return this.executionData;
    }

    public void setExecutionData(ExecutionData executionData) {
        this.executionData = executionData;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public static String getDebugMessage() {
        return debugMessage;
    }

    @Override
    public String getPluginTitle() {
        return "Variable Substitutions";
    }

    public String getResultsFileName() {
        return this.resultsFileName;
    }

    public void setResultsFileName(String resultsFileName) {
        this.resultsFileName = resultsFileName;
    }

    public static boolean clearDirectory(String dirName) {
        File dir = null;
        boolean result = true;
        dir = new File(dirName);
        String[] filesToRemove = dir.list();
        int i = 0;
        while (i < filesToRemove.length) {
            File fn1 = new File(String.valueOf(dirName) + File.separator + filesToRemove[i]);
            if (fn1.isDirectory()) {
                result &= ExecuteUtilities.clearDirectory(String.valueOf(dirName) + File.separator + filesToRemove[i]);
            }
            result &= fn1.delete();
            ++i;
        }
        return result;
    }

    @Override
    public void dispose() {
    }

    public static boolean ensureDirectory(String directoryName) {
        File dir = new File(directoryName);
        if (!dir.exists() && !dir.mkdirs()) {
            return false;
        }
        return dir.isDirectory();
    }

    public static String findPC2JarPath() {
        String jarDir = ".";
        try {
            String[] dirlist;
            String defaultPath = new File(DEFAULT_PC2_JAR_PATH).getCanonicalPath();
            if (!new File(defaultPath).exists()) {
                defaultPath = "/software/pc2/cc/projects/pc2-9.3/build/prod";
            }
            jarDir = defaultPath;
            String cp = System.getProperty("java.class.path");
            String[] stringArray = dirlist = cp.split(":");
            int n = dirlist.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                File dir = new File(token);
                if (dir.exists() && dir.isFile() && dir.toString().endsWith(PC2_JAR_FILENAME)) {
                    jarDir = String.valueOf(new File(dir.getParent()).getCanonicalPath()) + File.separator;
                    break;
                }
                ++n2;
            }
            if (DEFAULT_PC2_JAR_PATH.equals(jarDir)) {
                File dir = new File("dist/pc2.jar");
                if (dir.isFile()) {
                    jarDir = String.valueOf(new File(dir.getParent()).getCanonicalPath()) + File.separator;
                } else {
                    dir = new File(PC2_JAR_FILENAME);
                    if (dir.isFile()) {
                        jarDir = String.valueOf(new File(dir.getParent()).getCanonicalPath()) + File.separator;
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        return jarDir;
    }

    public static boolean copyFile(String fileOne, String fileTwo, Log log) {
        try {
            Files.copy(new File(fileOne).toPath(), new File(fileTwo).toPath(), new CopyOption[0]);
            return true;
        }
        catch (Exception e) {
            if (log != null) {
                log.warning("Unable to copy file " + fileOne + " " + e.getMessage());
            }
            return false;
        }
    }

    public static boolean didTeamSolveProblem(ExecutionData executionData) {
        String results;
        if (!executionData.isCompileSuccess() || !executionData.isExecuteSucess()) {
            return false;
        }
        if (executionData.isRunTimeLimitExceeded()) {
            return false;
        }
        if (!executionData.isValidationSuccess()) {
            return false;
        }
        if (executionData.getExecutionException() != null) {
            return false;
        }
        return executionData.getValidationResults() != null && (results = executionData.getValidationResults()).trim().equalsIgnoreCase("accepted");
    }

    public static String toString(ExecutionData executionData) {
        return " compileSuccess=" + executionData.isCompileSuccess() + ", executeSucess=" + executionData.isExecuteSucess() + ", runTimeLimitExceeded=" + executionData.isRunTimeLimitExceeded() + ", validationSuccess=" + executionData.isValidationSuccess() + ", executionException=" + executionData.getExecutionException() + ", validationResults=" + executionData.getValidationResults();
    }

    public static void dump(ExecutionData executionData) {
        System.out.println(" compileSuccess=" + executionData.isCompileSuccess() + ", executeSucess=" + executionData.isExecuteSucess() + ", runTimeLimitExceeded=" + executionData.isRunTimeLimitExceeded() + ", validationSuccess=" + executionData.isValidationSuccess() + ", executionException=" + executionData.getExecutionException() + ", validationResults=" + executionData.getValidationResults());
        if (executionData.getExecutionException() != null) {
            executionData.getExecutionException().printStackTrace();
        }
    }

    public static void writeFileContents(String filename, String[] datalines) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(new FileOutputStream(filename, false), true);
        String[] stringArray = datalines;
        int n = datalines.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            writer.println(s);
            ++n2;
        }
        writer.close();
        writer = null;
    }

    public static void writeFileContents(String filename, ArrayList<String> datalines) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(new FileOutputStream(filename, false), true);
        for (String s : datalines) {
            writer.println(s);
        }
        writer.close();
        writer = null;
    }
}

