/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.util.IMemento;
import edu.csus.ecs.pc2.core.util.XMLMemento;
import edu.csus.ecs.pc2.core.util.XSLTransformer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;

public final class XMLUtilities {
    private static String styleSheetDirectoryName = null;

    private XMLUtilities() {
    }

    public static IMemento addChild(IMemento mementoRoot, String name, boolean value) {
        return XMLUtilities.addChild(mementoRoot, name, Boolean.toString(value));
    }

    public static IMemento addChild(IMemento mementoRoot, String name, long value) {
        return XMLUtilities.addChild(mementoRoot, name, Long.toString(value));
    }

    public static IMemento addChild(IMemento mementoRoot, String name, String value) {
        XMLMemento memento = (XMLMemento)mementoRoot.createChildNode(name, value);
        return memento;
    }

    public static String formatSeconds(long timeInMillis) {
        long seconds = timeInMillis / 1000L;
        long fraction = timeInMillis % 1000L;
        return String.valueOf(seconds) + "." + String.format("%03d", fraction);
    }

    public static String getTimeStamp() {
        return XMLUtilities.formatSeconds(System.currentTimeMillis());
    }

    public static String getStyleSheetDirectoryName() {
        if (styleSheetDirectoryName == null) {
            styleSheetDirectoryName = XMLUtilities.getDefaultSyleSheetDirectoryName();
        }
        return styleSheetDirectoryName;
    }

    private static String getDefaultSyleSheetDirectoryName() {
        String xslDir = "data" + File.separator + "xsl";
        File xslDirFile = new File(xslDir);
        if (!xslDirFile.canRead() || !xslDirFile.isDirectory()) {
            VersionInfo versionInfo = new VersionInfo();
            xslDir = String.valueOf(versionInfo.locateHome()) + File.separator + xslDir;
        }
        return xslDir;
    }

    public static String getXSLTFullPath(String baseFileName) {
        return String.valueOf(XMLUtilities.getStyleSheetDirectoryName()) + File.separator + baseFileName;
    }

    public static void writeFile(String xmlString, String xsltFileName, String outputFileName) throws Exception {
        String xslDir = XMLUtilities.getStyleSheetDirectoryName();
        File inputDir = new File(xslDir);
        if (!inputDir.isDirectory()) {
            throw new Exception("Can not find xslt dir: " + xslDir);
        }
        XSLTransformer xslTransformer = new XSLTransformer();
        String fullPathFileName = String.valueOf(xslDir) + File.separator + xsltFileName;
        File xslFile = new File(fullPathFileName);
        FileOutputStream outFile = new FileOutputStream(outputFileName);
        StreamSource inputXML = new StreamSource(new StringReader(xmlString));
        StreamSource inputStyleSheet = new StreamSource(xslFile);
        xslTransformer.transform(inputStyleSheet, inputXML, outFile);
    }

    public static String[] transformToArray(String xmlString, String xsltFileName) throws Exception {
        if (!new File(xsltFileName).isFile()) {
            xsltFileName = XMLUtilities.getXSLTFullPath(xsltFileName);
        }
        File xslFile = new File(xsltFileName);
        XSLTransformer xslTransformer = new XSLTransformer();
        String outString = xslTransformer.transformToString(xslFile, xmlString);
        String newline = System.getProperty("line.separator");
        return outString.split(newline);
    }
}

