/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.exception.MultipleIssuesException;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.ProblemsReport;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JOptionPane;

public final class Utilities {
    private static boolean debugMode = false;
    private static final String LETTERS = " ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String DATE_TIME_FORMAT_STRING = "yyyyddMMhhmmss.SSS";
    public static final String SECRET_DATA_DIR = "data" + File.separator + "secret";
    private static SimpleDateFormat format = new SimpleDateFormat("yyyyddMMhhmmss.SSS");

    private Utilities() {
    }

    public static String getSecretDataPath(String baseCDPPath, String problemShortName) {
        return String.valueOf(baseCDPPath) + File.separator + problemShortName + File.separator + SECRET_DATA_DIR;
    }

    public static String getSecretDataPath(String baseCDPPath, Problem problem) {
        return Utilities.getSecretDataPath(baseCDPPath, problem.getShortName());
    }

    public static boolean insureDir(String dirName) {
        File dir = null;
        dir = new File(dirName);
        if (!dir.exists() && !dir.mkdir()) {
            System.out.println("insureDir Directory " + dir.getName() + " could not be created.");
        }
        return dir.isDirectory();
    }

    public static boolean isFileThere(String filename) {
        File file = new File(filename);
        return file.isFile();
    }

    public static boolean isDirThere(String filename) {
        File file = new File(filename);
        return file.isDirectory();
    }

    public static boolean isEquals(char[] oldBuffer, char[] newBuffer) {
        if (oldBuffer == null) {
            return newBuffer == null;
        }
        if (newBuffer == null) {
            return false;
        }
        if (oldBuffer.length != newBuffer.length) {
            return false;
        }
        int i = 0;
        while (i < newBuffer.length) {
            if (newBuffer[i] != oldBuffer[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String[] loadFile(String filename) throws IOException {
        Vector<String> lines = new Vector<String>();
        if (filename == null) {
            throw new IllegalArgumentException("filename is null");
        }
        if (!new File(filename).exists()) {
            return new String[0];
        }
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF8"));
        String line = in.readLine();
        while (line != null) {
            lines.addElement(line);
            line = in.readLine();
        }
        in.close();
        in = null;
        if (lines.size() == 0) {
            return new String[0];
        }
        String[] out = new String[lines.size()];
        int i = 0;
        while (i < lines.size()) {
            out[i] = (String)lines.elementAt(i);
            ++i;
        }
        return out;
    }

    public static String getCurrentDirectory() {
        File curdir = new File(".");
        try {
            return curdir.getCanonicalPath();
        }
        catch (Exception exception) {
            return ".";
        }
    }

    public static String getL10nDateTime() {
        Locale currentLocale = Locale.getDefault();
        Date today = new Date();
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(0, 1, currentLocale);
        return dateFormatter.format(today);
    }

    public static String getL10nDateTime(int dateStyle, int timeStyle, Locale currentLocale) {
        Date today = new Date();
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(dateStyle, timeStyle, currentLocale);
        return dateFormatter.format(today);
    }

    public static String getRFC2822DateTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        return String.format("%1$ta, %1$te %1$tb %1$tY %1$tT %1$tz", calendar);
    }

    public static String yesNoString(boolean b) {
        if (b) {
            return "Yes";
        }
        return "No";
    }

    public static String trueFalseString(boolean value, String trueString, String falseString) {
        if (value) {
            return trueString;
        }
        return falseString;
    }

    public static String[] loadINIFile(String filename) {
        Vector<String> v = new Vector<String>();
        try {
            String line;
            RandomAccessFile file = new RandomAccessFile(filename, "r");
            while ((line = file.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                v.addElement(line);
            }
            file.close();
            Object var2_2 = null;
        }
        catch (Exception exception) {
            return null;
        }
        return v.toArray(new String[v.size()]);
    }

    public static String forHTML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '&') {
                result.append("&amp;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '(') {
                result.append("&#040;");
            } else if (character == ')') {
                result.append("&#041;");
            } else if (character == '#') {
                result.append("&#035;");
            } else if (character == '%') {
                result.append("&#037;");
            } else if (character == ';') {
                result.append("&#059;");
            } else if (character == '+') {
                result.append("&#043;");
            } else if (character == '-') {
                result.append("&#045;");
            } else if (character == '\n') {
                result.append("<br>");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(boolean debugMode) {
        Utilities.debugMode = debugMode;
    }

    public static String basename(String path) {
        int lastIndex = path.lastIndexOf(File.separator);
        if (lastIndex == -1) {
            return path;
        }
        return path.substring(lastIndex + 1);
    }

    public static String convertNumber(int index) {
        String letter = String.valueOf(index);
        if (index > 26) {
            int i2 = index;
            int count = 0;
            while (index > 26) {
                index -= 26;
                ++count;
            }
            int mod = i2 - count * 26;
            letter = String.valueOf(Utilities.convertBase26Number(count)) + Utilities.convertBase26Number(mod);
        } else {
            letter = Utilities.convertBase26Number(index);
        }
        return letter;
    }

    private static String convertBase26Number(int index) {
        return LETTERS.substring(index, index + 1);
    }

    public static String dirname(String path) {
        int lastIndex = path.lastIndexOf(File.separator);
        if (lastIndex == -1) {
            return path;
        }
        if (lastIndex == 0) {
            return path;
        }
        return path.substring(0, lastIndex);
    }

    public static String getReportFilename(IReport selectedReport) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.SSS");
        String reportName = selectedReport.getReportTitle();
        while (reportName.indexOf(32) > -1) {
            reportName = reportName.replace(" ", "_");
        }
        return "report." + reportName + "." + simpleDateFormat.format(new Date()) + ".txt";
    }

    public static String createReport(IReport report, IInternalContest contest, IInternalController controller, boolean printHeaderAndFooter) throws FileNotFoundException {
        String filename = Utilities.getReportFilename(report);
        report.setContestAndController(contest, controller);
        PrintWriter printWriter = null;
        printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            try {
                if (printHeaderAndFooter) {
                    Utilities.printReportHeader(printWriter, report, contest);
                }
                try {
                    report.writeReport(printWriter);
                }
                catch (Exception e) {
                    printWriter.println();
                    printWriter.println("Exception in report: " + e.getMessage());
                    e.printStackTrace(printWriter);
                }
                if (printHeaderAndFooter) {
                    report.printFooter(printWriter);
                }
            }
            catch (Exception e) {
                controller.getLog().log(Log.INFO, "Exception creating report", e);
                printWriter.println("Exception creating report " + e.getMessage());
                e.printStackTrace(printWriter);
                printWriter.close();
                printWriter = null;
            }
        }
        finally {
            printWriter.close();
            printWriter = null;
        }
        return filename;
    }

    private static void printReportHeader(PrintWriter printWriter, IReport report, IInternalContest contest) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        ContestInformation contestInformation = contest.getContestInformation();
        String contestTitle = "(Contest title not defined)";
        if (contestInformation != null) {
            contestTitle = contestInformation.getContestTitle();
        }
        printWriter.println("Contest Title: " + contestTitle);
        printWriter.println("On: " + Utilities.getL10nDateTime());
        GregorianCalendar resumeTime = null;
        if (contest.getContestTime() != null) {
            resumeTime = contest.getContestTime().getResumeTime();
        }
        if (resumeTime == null) {
            printWriter.print("  Contest date/time: never started");
        } else {
            printWriter.print("  Contest date/time: " + resumeTime.getTime());
        }
        printWriter.println();
        printWriter.println();
        printWriter.println("** " + report.getReportTitle() + " Report");
        printWriter.println("Site " + contest.getSiteNumber());
        printWriter.println();
    }

    public static void viewReport(IReport report, String title, IInternalContest contest, IInternalController controller, boolean printHeaderAndFooter) {
        block2: {
            try {
                String filename = Utilities.createReport(report, contest, controller, printHeaderAndFooter);
                MultipleFileViewer multipleFileViewer = new MultipleFileViewer(controller.getLog());
                multipleFileViewer.addFilePane(title, filename);
                multipleFileViewer.setTitle("PC^2 Report (Build " + new VersionInfo().getBuildNumber() + ")");
                FrameUtilities.centerFrameFullScreenHeight(multipleFileViewer);
                multipleFileViewer.setVisible(true);
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog(null, "Unable to show report: " + e.getMessage());
                if (StaticLog.getLog() == null) break block2;
                StaticLog.getLog().log(Log.WARNING, "Unable to show/view report", e);
            }
        }
    }

    public static void dumpStringArray(PrintStream out, String prefix, String[] lines, boolean prefixWithLineNumber) {
        int counter = 1;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            out.print(prefix);
            if (prefixWithLineNumber) {
                out.printf("%3d: ", counter);
            }
            out.println(string);
            ++counter;
            ++n2;
        }
    }

    public static void debugPrint(String s) {
        if (debugMode) {
            System.err.println(new Date() + " debug: " + s);
            System.err.flush();
        }
    }

    public static void debugPrint(Exception e) {
        if (debugMode) {
            System.err.println(new Date() + " debug: Exception " + e.getMessage());
            e.printStackTrace(System.err);
            System.err.flush();
        }
    }

    public static void viewReport(IReport report, String title, IInternalContest contest, IInternalController controller) {
        Utilities.viewReport(report, title, contest, controller, true);
    }

    public static boolean createFile(SerializedFile file, String outputFileName) throws IOException {
        if (file != null && outputFileName != null) {
            file.writeFile(outputFileName);
            return new File(outputFileName).isFile();
        }
        return false;
    }

    public static StringBuffer join(String delimiter, List<String> list) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < list.size() - 1) {
            buffer.append(list.get(i));
            buffer.append(delimiter);
            ++i;
        }
        if (list.size() > 0) {
            buffer.append(list.get(list.size() - 1));
        }
        return buffer;
    }

    public static StringBuffer join(String delimiter, String[] strings) {
        return Utilities.join(delimiter, Arrays.asList(strings));
    }

    public static String getFullPath(String relativePath) {
        if (relativePath.startsWith(".\\") || relativePath.startsWith("./")) {
            relativePath = relativePath.substring(2);
        }
        String fullpath = String.valueOf(Utilities.getCurrentDirectory()) + "/" + relativePath;
        return new File(fullpath).getAbsolutePath();
    }

    public static long convertStringToSeconds(String s) {
        if (s == null || s.trim().length() == 0) {
            return -1L;
        }
        String[] fields = s.split(":");
        long hh = 0L;
        long mm = 0L;
        long ss = 0L;
        switch (fields.length) {
            case 3: {
                hh = Utilities.stringToLong(fields[0]);
                mm = Utilities.stringToLong(fields[1]);
                ss = Utilities.stringToLong(fields[2]);
                break;
            }
            case 2: {
                mm = Utilities.stringToLong(fields[0]);
                ss = Utilities.stringToLong(fields[1]);
                break;
            }
            case 1: {
                ss = Utilities.stringToLong(fields[0]);
                break;
            }
        }
        long totsecs = 0L;
        if (hh != -1L) {
            totsecs = hh;
        }
        if (mm != -1L) {
            totsecs = totsecs * 60L + mm;
        }
        if (ss != -1L) {
            totsecs = totsecs * 60L + ss;
        }
        if (hh == -1L || mm == -1L || ss == -1L) {
            return -1L;
        }
        return totsecs;
    }

    public static long stringToLong(String s1) {
        if (s1 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(s1);
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static String getDateTime() {
        return format.format(new Date());
    }

    public long stringToLongSecs(String s) {
        if (s == null || s.trim().length() == 0) {
            return -1L;
        }
        String[] fields = s.split(":");
        long hh = 0L;
        long mm = 0L;
        long ss = 0L;
        switch (fields.length) {
            case 3: {
                hh = Utilities.stringToLong(fields[0]);
                mm = Utilities.stringToLong(fields[1]);
                ss = Utilities.stringToLong(fields[2]);
                break;
            }
            case 2: {
                mm = Utilities.stringToLong(fields[0]);
                ss = Utilities.stringToLong(fields[1]);
                break;
            }
            case 1: {
                ss = Utilities.stringToLong(fields[0]);
                break;
            }
        }
        long totsecs = 0L;
        if (hh != -1L) {
            totsecs = hh;
        }
        if (mm != -1L) {
            totsecs = totsecs * 60L + mm;
        }
        if (ss != -1L) {
            totsecs = totsecs * 60L + ss;
        }
        if (hh == -1L || mm == -1L || ss == -1L) {
            return -1L;
        }
        return totsecs;
    }

    public static String locateJudgesDataFile(Problem problem, SerializedFile serializedFile, String alternateCDPPath, DataFileType judgeDataFile) {
        if (serializedFile.isExternalFile()) {
            String testFileName;
            if (alternateCDPPath != null && alternateCDPPath.trim().length() > 0 && Utilities.fileExists(testFileName = String.valueOf(Utilities.getSecretDataPath(alternateCDPPath, problem)) + File.separator + serializedFile.getName())) {
                return testFileName;
            }
            String secretPathPattern = String.valueOf(File.separator) + SECRET_DATA_DIR + File.separator;
            String fullPathName = serializedFile.getAbsolutePath();
            if (fullPathName.matches(secretPathPattern = secretPathPattern.replace('\\', '.')) && Utilities.fileExists(testFileName = String.valueOf(Utilities.getSecretDataPath(problem.getCCSfileDirectory(), problem)) + File.separator + serializedFile.getName())) {
                return testFileName;
            }
            testFileName = String.valueOf(alternateCDPPath) + File.separator + problem.getShortName() + File.separator + serializedFile.getName();
            if (Utilities.fileExists(testFileName)) {
                return testFileName;
            }
            testFileName = String.valueOf(problem.getExternalDataFileLocation()) + File.separator + serializedFile.getName();
            if (Utilities.fileExists(testFileName)) {
                return testFileName;
            }
            testFileName = serializedFile.getAbsolutePath();
            if (Utilities.fileExists(testFileName)) {
                return testFileName;
            }
        }
        return null;
    }

    public static boolean fileExists(String filename) {
        return new File(filename).isFile();
    }

    public static void catFile(PrintWriter printWriter, String outputfilename) {
        try {
            String[] lines;
            String[] stringArray = lines = Utilities.loadFile(outputfilename);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                printWriter.println(s);
                ++n2;
            }
        }
        catch (IOException e) {
            printWriter.println("Unable to write to file " + outputfilename);
            e.printStackTrace(printWriter);
        }
    }

    public static String getJudgeCDPLocation(IInternalContest contest) {
        String value = null;
        ContestInformation info = contest.getContestInformation();
        if (info != null) {
            value = info.getJudgeCDPBasePath();
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public static String[] fullJudgesDataFilenames(IInternalContest contest, ProblemDataFiles problemDataFiles, String executableDir) {
        Problem problem = contest.getProblem(problemDataFiles.getProblemId());
        SerializedFile[] serializedFiles = problemDataFiles.getJudgesDataFiles();
        return Utilities.getProblemfullFilenames(contest, problem, serializedFiles, executableDir);
    }

    public static String[] fullJudgesAnswerFilenames(IInternalContest contest, ProblemDataFiles problemDataFiles, String executableDir) {
        Problem problem = contest.getProblem(problemDataFiles.getProblemId());
        SerializedFile[] serializedFiles = problemDataFiles.getJudgesAnswerFiles();
        return Utilities.getProblemfullFilenames(contest, problem, serializedFiles, executableDir);
    }

    public static String[] getProblemfullFilenames(IInternalContest contest, Problem problem, SerializedFile[] serializedFiles, String executableDir) {
        ArrayList<String> output = new ArrayList<String>();
        if (problem.isUsingExternalDataFiles()) {
            File judgeDir;
            ClientId id = contest.getClientId();
            if (id == null) {
                throw new RuntimeException("contest clientid is null");
            }
            String judgeDataFilesPath = Utilities.getJudgeCDPLocation(contest);
            if (!"".equals(judgeDataFilesPath) && !(judgeDir = new File(judgeDataFilesPath = String.valueOf(Utilities.getSecretDataPath(judgeDataFilesPath, problem)) + File.separator)).isDirectory()) {
                judgeDataFilesPath = judgeDataFilesPath.replaceFirst(".data.secret", "");
            }
            SerializedFile[] serializedFileArray = serializedFiles;
            int n = serializedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                SerializedFile serializedFile = serializedFileArray[n2];
                if (id.getClientType() == ClientType.Type.ADMINISTRATOR || id.getClientType() == ClientType.Type.JUDGE && "".equals(judgeDataFilesPath)) {
                    output.add(serializedFile.getAbsolutePath());
                } else if (!"".equals(judgeDataFilesPath)) {
                    String filename = String.valueOf(judgeDataFilesPath) + serializedFile.getName();
                    output.add(filename);
                } else if (executableDir == null) {
                    output.add(serializedFile.getName());
                } else {
                    output.add(String.valueOf(executableDir) + File.separator + serializedFile.getName());
                }
                ++n2;
            }
        } else {
            SerializedFile[] serializedFileArray = serializedFiles;
            int n = serializedFiles.length;
            int n3 = 0;
            while (n3 < n) {
                SerializedFile serializedFile = serializedFileArray[n3];
                if (executableDir == null) {
                    output.add(serializedFile.getName());
                } else {
                    output.add(String.valueOf(executableDir) + File.separator + serializedFile.getName());
                }
                ++n3;
            }
        }
        return output.toArray(new String[output.size()]);
    }

    public static void startExplorer(File dir) {
        String command = "explorer.exe /e," + dir.getAbsolutePath();
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception running " + command, e);
        }
    }

    public static void startExplorer(String directoryName) {
        File dir = new File(directoryName);
        Utilities.startExplorer(dir);
    }

    public static void dump(PrintWriter printWriter, ProblemDataFiles dataFiles, String message) {
        ProblemsReport report = new ProblemsReport();
        printWriter.println("dump ProblemDataFiles " + message);
        if (dataFiles == null) {
            printWriter.println("dump problem data files - no ProblemDataFiles defined");
        } else {
            printWriter.println("dump problem data files for " + dataFiles.getProblemId());
            report.writeProblemDataFiles(printWriter, dataFiles);
        }
        printWriter.println("dump done");
        printWriter.flush();
    }

    public static void dump(ProblemDataFiles dataFiles, String message) {
        PrintWriter printWriter = new PrintWriter(System.out);
        Utilities.dump(printWriter, dataFiles, message);
        printWriter = null;
    }

    public static String[] getFileNames(String directoryName, String extension) {
        ArrayList<Object> list = new ArrayList<Object>();
        File dir = new File(directoryName);
        Object[] entries = dir.list();
        if (entries == null) {
            return new String[0];
        }
        Arrays.sort(entries);
        Object[] objectArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            if (((String)name).endsWith(extension)) {
                list.add(name);
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    public static SerializedFile[] createSerializedFiles(String dataFileBaseDirectory, String[] inputFileNames, boolean externalFilesFlag) {
        ArrayList<SerializedFile> outfiles = new ArrayList<SerializedFile>();
        String[] stringArray = inputFileNames;
        int n = inputFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String filename = String.valueOf(dataFileBaseDirectory) + File.separator + name;
            outfiles.add(new SerializedFile(filename, externalFilesFlag));
            ++n2;
        }
        return outfiles.toArray(new SerializedFile[outfiles.size()]);
    }

    public static String findDataBasePath(String filePath) {
        int idx = filePath.indexOf(SECRET_DATA_DIR);
        if (idx != -1) {
            return filePath.substring(0, idx);
        }
        return filePath;
    }

    public static boolean validateCDP(IInternalContest contest, String cdpPath, Problem problem, boolean allProblemDCPFiles) throws MultipleIssuesException {
        ArrayList<String> messages = new ArrayList<String>();
        if (problem == null) {
            messages.add("problem is null (cannot validate problem)");
        } else if (problem.isUsingExternalDataFiles()) {
            String problemTitle = "(unset problem short name) ";
            if (problem.getShortName() != null) {
                problemTitle = problem.getShortName();
            }
            if (cdpPath == null) {
                messages.add(String.valueOf(problemTitle) + "\tJudge's data path not set (is null)");
            } else if (!Utilities.isDirThere(cdpPath)) {
                messages.add(String.valueOf(problemTitle) + "\tJudge's data path does not exist at \"" + cdpPath + "\"");
            } else if (problem.getShortName() == null || "".equals(problem.getShortName().trim())) {
                messages.add(String.valueOf(problemTitle) + "\tNo problem short name for problem " + problem);
            } else {
                String problemDir = String.valueOf(cdpPath) + File.separator + problem.getShortName() + File.separator;
                if (!Utilities.isDirThere(problemDir)) {
                    messages.add(String.valueOf(problemTitle) + "\tDirectory missing for " + problem + " expected at " + problemDir);
                } else {
                    String dataPath = Utilities.getSecretDataPath(cdpPath, problem);
                    if (!Utilities.isDirThere(dataPath)) {
                        dataPath = dataPath.replaceFirst(".data.secret", "");
                    }
                    if (!Utilities.isDirThere(dataPath)) {
                        messages.add(String.valueOf(problemTitle) + "\tMissing data directory, expected at: " + dataPath + " or (" + dataPath + File.separator + "data" + File.separator + "secret)");
                    } else {
                        int missingData = 0;
                        int missingAnswer = 0;
                        int i = 0;
                        while (i < problem.getNumberTestCases()) {
                            String dataFile = problem.getDataFileName(i + 1);
                            String ansFile = problem.getAnswerFileName(i + 1);
                            String judgeFileName = String.valueOf(dataPath) + File.separator + dataFile;
                            String answerFilename = String.valueOf(dataPath) + File.separator + ansFile;
                            if (dataFile != null && !Utilities.isFileThere(judgeFileName)) {
                                messages.add(String.valueOf(problemTitle) + "\tMissing judge file '" + dataFile + "' in " + dataPath);
                                ++missingData;
                            }
                            if (ansFile != null && !Utilities.isFileThere(answerFilename)) {
                                messages.add(String.valueOf(problemTitle) + "\tMissing answer file '" + ansFile + "' in " + dataPath);
                                ++missingAnswer;
                            }
                            ++i;
                        }
                        if (missingData + missingAnswer > 0) {
                            messages.add(String.valueOf(problemTitle) + "\ttotal files missing = " + (missingData + missingAnswer));
                        }
                    }
                    if (allProblemDCPFiles) {
                        String problemYamlFilename;
                        String laTextProblemFilename = String.valueOf(problemDir) + "problem.tex";
                        if (!Utilities.isFileThere(laTextProblemFilename)) {
                            messages.add(String.valueOf(problemTitle) + "\tMissing LaTex problem file, expected at " + laTextProblemFilename);
                        }
                        if (!Utilities.isFileThere(problemYamlFilename = String.valueOf(problemDir) + "problem.yaml")) {
                            messages.add(String.valueOf(problemTitle) + "\tMissing LaTex problem YAML file, expected at " + problemYamlFilename);
                        }
                    }
                }
            }
        }
        if (messages.size() == 0) {
            return true;
        }
        throw new MultipleIssuesException((String)messages.get(0), messages);
    }

    public static boolean validateCDP(IInternalContest contest, String cdpPath) throws MultipleIssuesException {
        Problem[] problems;
        ArrayList<String> messages = new ArrayList<String>();
        Problem[] problemArray = problems = contest.getProblems();
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (problem.getShortName() == null) {
                messages.add("No problem short name for problem " + problem);
            } else {
                try {
                    Utilities.validateCDP(contest, cdpPath, problem, false);
                }
                catch (MultipleIssuesException e) {
                    messages.addAll(Arrays.asList(e.getIssueList()));
                }
            }
            ++n2;
        }
        if (messages.size() == 0) {
            return true;
        }
        throw new MultipleIssuesException((String)messages.get(0), messages);
    }

    public static String getProblemLetter(int id) {
        char let = 'A';
        let = (char)(let + (id - 1));
        return Character.toString(let);
    }

    public static int getProblemNumber(IInternalContest contest, Problem problem) {
        int idx = 1;
        Problem[] problemArray = contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem2 = problemArray[n2];
            if (problem2.equals(problem)) {
                return idx;
            }
            ++idx;
            ++n2;
        }
        return 0;
    }

    public static enum DataFileType {
        JUDGE_DATA_FILE,
        JUDGE_ANSWER_FILE;

    }
}

