/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.core.XMLUtilities;
import edu.csus.ecs.pc2.core.list.ClientIdComparator;
import edu.csus.ecs.pc2.core.model.BalloonDeliveryInfo;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.util.IMemento;
import edu.csus.ecs.pc2.core.util.XMLMemento;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;

public class NotificationXML {
    public static final String NOTIFICATIONS_TAG = "notifications";
    public static final String NOTIFICATION_TAG = "notification";
    private ClientIdComparator comparator = new ClientIdComparator();

    public XMLMemento createElement(IInternalContest contest, Run run) throws Exception {
        XMLMemento memento = XMLMemento.createWriteRoot(NOTIFICATIONS_TAG);
        IMemento noteMemento = memento.createChild(NOTIFICATION_TAG);
        this.addNotificationMemento(noteMemento, contest, run);
        return memento;
    }

    private int getProblemIndex(IInternalContest contest, Problem inProblem) {
        int idx = 0;
        Problem[] problemArray = contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (problem.getElementId().equals(inProblem.getElementId())) {
                return idx;
            }
            ++idx;
            ++n2;
        }
        return -1;
    }

    public String getBalloonKey(ClientId who, ElementId problemId) {
        return String.valueOf(who.getTripletKey()) + " " + problemId.toString();
    }

    public IMemento addNotificationMemento(IMemento memento, IInternalContest contest, Run run) throws Exception {
        String balloonKey;
        XMLUtilities.addChild(memento, "team-id", run.getSubmitter().getClientNumber());
        XMLUtilities.addChild(memento, "team", contest.getAccount(run.getSubmitter()).getDisplayName());
        XMLUtilities.addChild(memento, "time", XMLUtilities.formatSeconds(contest.getContestTime().getElapsedMS()));
        XMLUtilities.addChild(memento, "contest-time", XMLUtilities.formatSeconds(run.getElapsedMS()));
        XMLUtilities.addChild(memento, "timestamp", XMLUtilities.getTimeStamp());
        XMLUtilities.addChild(memento, "nr", "TODO: nr?");
        BalloonSettings balloonSettings = contest.getBalloonSettings(contest.getSiteNumber());
        if (balloonSettings == null) {
            throw new Exception("Balloon Settings not set for site " + contest.getSiteNumber());
        }
        ClientId clientId = balloonSettings.getBalloonClient();
        ClientSettings clientSettings = contest.getClientSettings(clientId);
        if (clientSettings == null) {
            throw new Exception("No Balloon Client/Settings set/defined for site  " + contest.getSiteNumber());
        }
        Hashtable<String, BalloonDeliveryInfo> hashtable = clientSettings.getBalloonList();
        BalloonDeliveryInfo balloonDeliveryInfo = hashtable.get(balloonKey = this.getBalloonKey(run.getSubmitter(), run.getProblemId()));
        if (balloonDeliveryInfo == null) {
            throw new Exception("No notification/delivery for run " + run);
        }
        this.addMemento(memento, contest, balloonDeliveryInfo);
        XMLUtilities.addChild(memento, "first-by-team", "TODO:");
        IMemento balloonMemento = memento.createChild("balloons");
        String[] keyList = hashtable.keySet().toArray(new String[hashtable.keySet().size()]);
        Arrays.sort(keyList, new BalloonKeyComparator());
        String[] stringArray = keyList;
        int n = keyList.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            BalloonDeliveryInfo info = hashtable.get(key);
            if (run.getSubmitter().equals(info.getClientId())) {
                this.addMemento(balloonMemento, contest, info);
            }
            ++n2;
        }
        return memento;
    }

    private IMemento addMemento(IMemento mementoRoot, IInternalContest contest, BalloonDeliveryInfo balloonDeliveryInfo) {
        IMemento memento = mementoRoot.createChild("balloon");
        Problem problem = contest.getProblem(balloonDeliveryInfo.getProblemId());
        int problemIndex = this.getProblemIndex(contest, problem);
        char let = 'A';
        let = (char)(let + (problemIndex - 1));
        XMLUtilities.addChild(memento, "problem-id", "" + let);
        XMLUtilities.addChild(memento, "problem", problem.getDisplayName());
        BalloonSettings settings = contest.getBalloonSettings(contest.getSiteNumber());
        String balloonColor = settings.getColor(problem);
        XMLUtilities.addChild(memento, "rgb", settings.getColorRGB(problem));
        XMLUtilities.addChild(memento, "color", balloonColor);
        return memento;
    }

    protected class BalloonKeyComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 3204840271423881062L;

        protected BalloonKeyComparator() {
        }

        public ClientId getClientId(String clientIDString) {
            String clientTypeName = ClientType.Type.TEAM.toString();
            int teamIndex = clientIDString.indexOf(clientTypeName);
            if (teamIndex > 0) {
                int siteNumber = Integer.parseInt(clientIDString.substring(0, teamIndex));
                int teamNumber = Integer.parseInt(clientIDString.substring(teamIndex + clientTypeName.length()));
                return new ClientId(siteNumber, ClientType.Type.TEAM, teamNumber);
            }
            return new ClientId(0, ClientType.Type.TEAM, 0);
        }

        @Override
        public int compare(String key1, String key2) {
            String[] fields1 = key1.split(" ");
            String[] fields2 = key2.split(" ");
            ClientId clientId1 = this.getClientId(fields1[0]);
            ClientId clientId2 = this.getClientId(fields2[0]);
            return NotificationXML.this.comparator.compare(clientId1, clientId2);
        }
    }
}

