/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ccs;

import edu.csus.ecs.pc2.core.CommandVariableReplacer;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.execute.ExecutionData;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.io.File;
import java.io.IOException;

public class RunSubmitterInterfaceManager
implements UIPlugin {
    private static final long serialVersionUID = -7193057846912064771L;
    private IInternalContest contest;
    private IInternalController controller;
    private CommandVariableReplacer commandVariableReplacer = new CommandVariableReplacer();
    private String stagingDirectory = "rsi";

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        ContestInformation contestInformation = inContest.getContestInformation();
        if (contestInformation == null) {
            this.info("No Run Submission Interface defined");
        } else if (contestInformation.getRsiCommand() == null) {
            this.info("No Run Submission Interface defined");
        } else {
            this.info("Run Submission Interface command is: " + contestInformation.getRsiCommand());
        }
    }

    private void info(String string) {
        if (this.controller != null && this.controller.getLog() != null) {
            this.controller.getLog().info(string);
        } else if (Utilities.isDebugMode()) {
            System.err.println(string);
        }
    }

    private void warn(String string) {
        if (this.controller != null && this.controller.getLog() != null) {
            this.controller.getLog().log(Log.WARNING, string);
        } else if (Utilities.isDebugMode()) {
            System.err.println(string);
        }
    }

    private void warn(String string, Exception ex) {
        if (this.controller != null && this.controller.getLog() != null) {
            this.controller.getLog().log(Log.WARNING, string, ex);
        } else if (Utilities.isDebugMode()) {
            System.err.println(string);
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public String getPluginTitle() {
        return "Run Submitter Interface Manager";
    }

    public void sendRun(Run run, RunFiles runFiles) throws Exception {
        String command = this.contest.getContestInformation().getRsiCommand();
        if (command == null || command.trim().length() == 0) {
            return;
        }
        if (command.trim().startsWith("#")) {
            if (Utilities.isDebugMode()) {
                this.info("RSI ignoring command: " + command);
            }
            return;
        }
        this.info("RSI sending run " + run);
        this.info("RSI Command before: " + command);
        Utilities.insureDir(this.stagingDirectory);
        String runDir = String.valueOf(this.stagingDirectory) + File.separator + "rsis" + run.getSiteNumber() + "r" + run.getNumber();
        Utilities.insureDir(runDir);
        if (new File(runDir).isDirectory()) {
            try {
                String mainfileName = this.commandVariableReplacer.getMainFileName(runDir, runFiles);
                this.createFile(runFiles.getMainFile(), mainfileName);
                this.info("RSI wrote " + mainfileName);
                if (runFiles.getOtherFiles() != null) {
                    SerializedFile[] serializedFileArray = runFiles.getOtherFiles();
                    int n = serializedFileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SerializedFile file = serializedFileArray[n2];
                        String outfilename = String.valueOf(runDir) + File.separator + file.getName();
                        this.createFile(file, outfilename);
                        this.info("RSI wrote addnl file:  " + outfilename);
                        ++n2;
                    }
                }
                Problem problem = this.contest.getProblem(run.getProblemId());
                ProblemDataFiles problemDataFiles = this.contest.getProblemDataFile(problem);
                ExecutionData executionData = null;
                String newCommand = this.commandVariableReplacer.substituteVariables(command, this.contest, run, runFiles, runDir, executionData, problemDataFiles);
                this.info("RSI Command  after: " + newCommand);
                String[] env = null;
                File directory = new File(".");
                this.info("RSI execute dir: " + Utilities.getCurrentDirectory());
                this.info("RSI execute cmd: " + newCommand);
                Runtime.getRuntime().exec(newCommand, env, directory);
                this.info("RSI sent run " + run);
            }
            catch (IOException e) {
                this.info("RSI run NOT sent " + run);
                this.warn(e.getMessage(), e);
            }
        } else {
            this.warn("Unable to create directory for run " + runDir);
        }
    }

    boolean createFile(SerializedFile file, String outputFileName) throws IOException {
        if (file != null && outputFileName != null) {
            file.writeFile(outputFileName);
            return new File(outputFileName).isFile();
        }
        return false;
    }

    public String removeExtension(String original) {
        String outString = new String(original);
        int dotIndex = outString.lastIndexOf(46, outString.length() - 1);
        if (dotIndex != -1) {
            outString = outString.substring(0, dotIndex);
        }
        return outString;
    }
}

