/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.reports;

import edu.csus.ecs.pc2.api.IRun;
import edu.csus.ecs.pc2.api.IRunJudgement;
import edu.csus.ecs.pc2.api.reports.APIAbstractTest;

public class PrintRun
extends APIAbstractTest {
    @Override
    public void printTest() {
        int runNumber = this.getNumber();
        if (runNumber < 1) {
            this.println("getRun() Select a run number");
        } else {
            int siteNum = this.getSiteNumber();
            if (siteNum == 0) {
                siteNum = this.getContest().getMyClient().getSiteNumber();
            }
            boolean foundRun = false;
            IRun[] iRunArray = this.getContest().getRuns();
            int n = iRunArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRun run = iRunArray[n2];
                if (run.getNumber() == runNumber && run.getSiteNumber() == siteNum) {
                    foundRun = true;
                    this.print("   Site " + run.getSiteNumber());
                    this.print(" Run " + run.getNumber());
                    this.print(", " + run.getProblem().getName());
                    this.print(", " + run.getLanguage().getName());
                    this.print(", del=" + run.isDeleted());
                    this.print(", finalJudged=" + run.isFinalJudged());
                    this.print(", preliminaryJudged=" + run.isPreliminaryJudged());
                    this.print(", solved=" + run.isSolved());
                    this.println();
                    if (run.isFinalJudged() || run.isPreliminaryJudged()) {
                        IRunJudgement[] iRunJudgementArray = run.getRunJudgements();
                        int n3 = iRunJudgementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IRunJudgement runJudgement = iRunJudgementArray[n4];
                            this.println("     " + run.getJudgementName());
                            this.print("     ");
                            if (runJudgement.isActive()) {
                                this.print("active");
                            } else {
                                this.print("      ");
                            }
                            this.print(" " + runJudgement.getJudgement().getName());
                            this.print(", solved=" + runJudgement.isSolved());
                            this.print(", sendToTeam=" + runJudgement.isSendToTeam());
                            this.print(", computerJudged=" + runJudgement.isComputerJudgement());
                            this.print(", preliminary=" + runJudgement.isPreliminaryJudgement());
                            this.println();
                            ++n4;
                        }
                        break;
                    }
                    this.print("     ");
                    this.println("Run not judged.");
                    break;
                }
                ++n2;
            }
            if (!foundRun) {
                this.println("No such run " + runNumber + " eists at site " + siteNum);
            }
        }
    }

    @Override
    public String getTitle() {
        return "getRun";
    }
}

