/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.reports;

import edu.csus.ecs.pc2.api.IClarification;
import edu.csus.ecs.pc2.api.IClarificationComparator;
import edu.csus.ecs.pc2.api.reports.APIAbstractTest;
import edu.csus.ecs.pc2.api.reports.APIPrintReports;
import java.util.Arrays;

public class PrintClarifications
extends APIAbstractTest {
    @Override
    public void printTest() {
        IClarification[] clarifications = this.getContest().getClarifications();
        this.println("There are " + clarifications.length + " clarifications ");
        Arrays.sort(clarifications, new IClarificationComparator());
        IClarification[] iClarificationArray = clarifications;
        int n = clarifications.length;
        int n2 = 0;
        while (n2 < n) {
            IClarification clarification = iClarificationArray[n2];
            this.print("Clar " + clarification.getNumber() + " Site " + clarification.getSiteNumber());
            this.print(" @ " + clarification.getSubmissionTime() + " by " + clarification.getTeam().getLoginName());
            this.print(" problem: " + clarification.getProblem().getName());
            this.print(" " + APIPrintReports.trueFalseString(clarification.isAnswered(), "ANSWERED", "NOT ANSWERED"));
            this.print(" " + APIPrintReports.trueFalseString(clarification.isDeleted(), "DELETED", ""));
            this.print(" " + APIPrintReports.trueFalseString(clarification.isSendToAll(), "SEND TO ALL", "NOT SENT TO ALL"));
            this.println();
            this.println("  Question: " + clarification.getQuestion());
            if (clarification.isAnswered()) {
                this.println("    Answer: " + clarification.getAnswer());
            }
            ++n2;
        }
        this.println();
    }

    @Override
    public String getTitle() {
        return "getClarifications";
    }
}

