/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import edu.csus.ecs.pc2.api.IClient;
import edu.csus.ecs.pc2.api.IContest;
import edu.csus.ecs.pc2.api.IRun;
import edu.csus.ecs.pc2.api.IRunJudgement;
import edu.csus.ecs.pc2.api.listener.ContestEvent;
import edu.csus.ecs.pc2.api.listener.IConfigurationUpdateListener;
import edu.csus.ecs.pc2.api.listener.IRunEventListener;
import edu.csus.ecs.pc2.ui.AccountColumnComparator;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class RunsFrame
extends JFrame {
    private IContest contest = null;
    private static final long serialVersionUID = 2069577760789317376L;
    private JPanel mainPane = null;
    private JPanel buttonPane = null;
    private JButton closeButton = null;
    private MCLB runsListBox = null;

    public RunsFrame(IContest contest) {
        this.initialize();
        this.contest = contest;
        this.reloadRows();
        contest.addRunListener(new RunEventListenerImplementation());
        contest.addContestConfigurationUpdateListener(new ConfigurationUpdateListenerImplementation());
        IClient client = contest.getMyClient();
        this.setTitle("API Runs Frame - " + client.getLoginName() + " (Site " + client.getSiteNumber() + ")");
    }

    private void initialize() {
        this.setSize(new Dimension(575, 274));
        this.setContentPane(this.getMainPane());
        this.setTitle("Runs List");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RunsFrame.this.setVisible(false);
            }
        });
        FrameUtilities.centerFrame(this);
    }

    private JPanel getMainPane() {
        if (this.mainPane == null) {
            this.mainPane = new JPanel();
            this.mainPane.setLayout(new BorderLayout());
            this.mainPane.add((Component)this.getButtonPane(), "South");
            this.mainPane.add((Component)((Object)this.getRunsListBox()), "Center");
        }
        return this.mainPane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(new FlowLayout());
            this.buttonPane.add((Component)this.getCloseButton(), null);
        }
        return this.buttonPane;
    }

    protected Object[] buildRunRow(IRun run) {
        int cols = this.runsListBox.getColumnCount();
        Object[] s = new String[cols];
        int idx = 0;
        s[idx++] = String.valueOf(run.getSiteNumber());
        s[idx++] = run.getTeam().getLoginName();
        s[idx++] = String.valueOf(run.getNumber());
        s[idx++] = String.valueOf(run.getSubmissionTime());
        String judgementName = run.getJudgementName();
        if (judgementName.length() == 0) {
            judgementName = "NEW";
        } else if (this.isPreliminary(run)) {
            judgementName = "PRELIM (" + judgementName + ")";
        }
        s[idx++] = judgementName;
        s[idx++] = run.getProblem().getName();
        s[idx++] = run.getLanguage().getName();
        return s;
    }

    private boolean isPreliminary(IRun run) {
        IRunJudgement[] judgements = run.getRunJudgements();
        if (judgements.length > 0) {
            return judgements[judgements.length - 1].isPreliminaryJudgement();
        }
        return false;
    }

    protected String getRunKey(IRun run) {
        return String.valueOf(run.getSiteNumber()) + ":" + run.getNumber();
    }

    protected void reloadRows() {
        IRun[] iRunArray = this.contest.getRuns();
        int n = iRunArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRun run = iRunArray[n2];
            this.updateRunRow(run);
            ++n2;
        }
    }

    protected void updateRunRow(final IRun run) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] objects = RunsFrame.this.buildRunRow(run);
                int rowNumber = RunsFrame.this.runsListBox.getIndexByKey(RunsFrame.this.getRunKey(run));
                if (rowNumber == -1) {
                    RunsFrame.this.runsListBox.addRow(objects, RunsFrame.this.getRunKey(run));
                } else {
                    RunsFrame.this.runsListBox.replaceRow(objects, rowNumber);
                }
                RunsFrame.this.runsListBox.autoSizeAllColumns();
                RunsFrame.this.runsListBox.sort();
            }
        });
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RunsFrame.this.setVisible(false);
                }
            });
        }
        return this.closeButton;
    }

    private MCLB getRunsListBox() {
        if (this.runsListBox == null) {
            this.runsListBox = new MCLB();
            this.runsListBox.removeAllRows();
            Object[] cols = new Object[]{"Site", "Team", "Id", "Time", "Status", "Problem", "Language"};
            this.runsListBox.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            HeapSorter numericStringSorter = new HeapSorter();
            numericStringSorter.setComparator((Comparator)new NumericStringComparator());
            HeapSorter accountNameSorter = new HeapSorter();
            accountNameSorter.setComparator((Comparator)new AccountColumnComparator());
            int idx = 0;
            this.runsListBox.setColumnSorter(idx++, numericStringSorter, 4);
            this.runsListBox.setColumnSorter(idx++, accountNameSorter, 3);
            this.runsListBox.setColumnSorter(idx++, numericStringSorter, 1);
            this.runsListBox.setColumnSorter(idx++, numericStringSorter, 2);
            this.runsListBox.setColumnSorter(idx++, sorter, 5);
            this.runsListBox.setColumnSorter(idx++, sorter, 6);
            this.runsListBox.setColumnSorter(idx++, sorter, 7);
        }
        return this.runsListBox;
    }

    protected class ConfigurationUpdateListenerImplementation
    implements IConfigurationUpdateListener {
        protected ConfigurationUpdateListenerImplementation() {
        }

        @Override
        public void configurationItemAdded(ContestEvent contestEvent) {
            RunsFrame.this.reloadRows();
        }

        @Override
        public void configurationItemRemoved(ContestEvent contestEvent) {
            RunsFrame.this.reloadRows();
        }

        @Override
        public void configurationItemUpdated(ContestEvent contestEvent) {
            RunsFrame.this.reloadRows();
        }
    }

    protected class RunEventListenerImplementation
    implements IRunEventListener {
        protected RunEventListenerImplementation() {
        }

        @Override
        public void runCheckedOut(IRun run, boolean isFinal) {
            this.runUpdated(run, isFinal);
        }

        @Override
        public void runCompiling(IRun run, boolean isFinal) {
            this.runUpdated(run, isFinal);
        }

        @Override
        public void runDeleted(IRun run) {
            this.runUpdated(run, false);
        }

        @Override
        public void runExecuting(IRun run, boolean isFinal) {
            this.runUpdated(run, isFinal);
        }

        @Override
        public void runJudged(IRun run, boolean isFinal) {
            this.runUpdated(run, isFinal);
        }

        @Override
        public void runJudgingCanceled(IRun run, boolean isFinal) {
            this.runUpdated(run, isFinal);
        }

        @Override
        public void runSubmitted(IRun run) {
            this.runUpdated(run, false);
        }

        @Override
        public void runUpdated(IRun run, boolean isFinal) {
            RunsFrame.this.updateRunRow(run);
        }

        @Override
        public void runValidating(IRun run, boolean isFinal) {
            this.runUpdated(run, isFinal);
        }
    }
}

