/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.api.IClient;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.security.Permission;

public class ClientImplementation
implements IClient {
    private String shortName;
    private String title;
    private int number;
    private int siteNumber;
    private IClient.ClientType clientType;
    private ElementId elementId;
    private boolean displayableOnScoreboard = false;

    public ClientImplementation(ClientId clientId, IInternalContest contest) {
        Account account = contest.getAccount(clientId);
        if (account != null) {
            this.shortName = clientId.getName();
            this.title = account.getDisplayName();
            this.elementId = account.getElementId();
            this.displayableOnScoreboard = account.isAllowed(Permission.Type.DISPLAY_ON_SCOREBOARD);
        } else {
            this.elementId = new ElementId(clientId.getTripletKey());
        }
        this.number = clientId.getClientNumber();
        this.siteNumber = clientId.getSiteNumber();
        switch (clientId.getClientType()) {
            case JUDGE: {
                this.clientType = IClient.ClientType.JUDGE_CLIENT;
                break;
            }
            case SCOREBOARD: {
                this.clientType = IClient.ClientType.SCOREBOARD_CLIENT;
                break;
            }
            case ADMINISTRATOR: {
                this.clientType = IClient.ClientType.ADMIN_CLIENT;
                break;
            }
            case TEAM: {
                this.clientType = IClient.ClientType.TEAM_CLIENT;
                break;
            }
            default: {
                this.clientType = IClient.ClientType.UNKNOWN_CLIENT;
            }
        }
    }

    @Override
    public String getLoginName() {
        return this.shortName;
    }

    @Override
    public String getDisplayName() {
        return this.title;
    }

    @Override
    public int getSiteNumber() {
        return this.siteNumber;
    }

    @Override
    public int getAccountNumber() {
        return this.number;
    }

    @Override
    public IClient.ClientType getType() {
        return this.clientType;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ClientImplementation) {
            ClientImplementation clientImplementation = (ClientImplementation)obj;
            return clientImplementation.elementId.equals(this.elementId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.elementId.toString().hashCode();
    }

    @Override
    public boolean isDisplayableOnScoreboard() {
        return this.displayableOnScoreboard;
    }
}

