/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.j2mclb.util;

import com.ibm.webrunner.j2mclb.util.TableModel;
import com.ibm.webrunner.j2mclb.util.event.TableEvent;
import com.ibm.webrunner.j2mclb.util.event.TableListener;
import java.io.Serializable;
import java.util.Vector;

public class Table
extends TableModel {
    protected Vector fColumnInfo = new Vector(5, 5);
    protected Vector fRowInfo = new Vector(50, 25);
    protected Vector fColumns = new Vector(5, 5);
    protected Vector fTableListeners = new Vector();

    public Table() {
    }

    public Table(int n) {
        this(0, n);
    }

    public Table(int n, int n2) {
        this.setColumnCount(n2);
        this.setRowCount(n);
    }

    public void addColumn(Object[] objectArray, Object object) {
        int n = 0;
        Serializable serializable = this;
        synchronized (serializable) {
            n = this.fColumnInfo.size();
            Vector<Object> vector = new Vector<Object>(50, 25);
            this.fColumnInfo.addElement(object);
            this.fColumns.addElement(vector);
            int n2 = this.fRowInfo.size();
            int n3 = 0;
            while (n3 < n2) {
                if (objectArray == null || n3 >= objectArray.length) {
                    vector.addElement(null);
                } else {
                    vector.addElement(objectArray[n3]);
                }
                ++n3;
            }
        }
        serializable = new TableEvent(this, 6, -1, n);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void addRow(Object[] objectArray, Object object) {
        int n = 0;
        Serializable serializable = this;
        synchronized (serializable) {
            n = this.getRowCount();
            int n2 = this.fColumnInfo.size();
            if (n2 == 0) {
                return;
            }
            this.fRowInfo.addElement(object);
            int n3 = 0;
            while (n3 < n2) {
                Vector vector = (Vector)this.fColumns.elementAt(n3);
                if (objectArray == null || n3 >= objectArray.length) {
                    vector.addElement(null);
                } else {
                    vector.addElement(objectArray[n3]);
                }
                ++n3;
            }
        }
        serializable = new TableEvent(this, 10, n, -1);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void addTableListener(TableListener tableListener) {
        this.fTableListeners.addElement(tableListener);
    }

    public void fireTableEvent(TableEvent tableEvent) {
        Vector vector = (Vector)this.fTableListeners.clone();
        int n = vector.size();
        switch (tableEvent.getID()) {
            case 0: {
                int n2 = 0;
                while (n2 < n) {
                    ((TableListener)vector.elementAt(n2)).tableRefreshed(tableEvent);
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < n) {
                    ((TableListener)vector.elementAt(n3)).tableChanged(tableEvent);
                    ++n3;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < n) {
                    ((TableListener)vector.elementAt(n4)).columnChanged(tableEvent);
                    ++n4;
                }
                break;
            }
            case 3: {
                int n5 = 0;
                while (n5 < n) {
                    ((TableListener)vector.elementAt(n5)).rowChanged(tableEvent);
                    ++n5;
                }
                break;
            }
            case 4: {
                int n6 = 0;
                while (n6 < n) {
                    ((TableListener)vector.elementAt(n6)).elementChanged(tableEvent);
                    ++n6;
                }
                break;
            }
            case 5: {
                int n7 = 0;
                while (n7 < n) {
                    ((TableListener)vector.elementAt(n7)).columnInfoChanged(tableEvent);
                    ++n7;
                }
                break;
            }
            case 6: {
                int n8 = 0;
                while (n8 < n) {
                    ((TableListener)vector.elementAt(n8)).columnAdded(tableEvent);
                    ++n8;
                }
                break;
            }
            case 7: {
                int n9 = 0;
                while (n9 < n) {
                    ((TableListener)vector.elementAt(n9)).columnRemoved(tableEvent);
                    ++n9;
                }
                break;
            }
            case 8: {
                int n10 = 0;
                while (n10 < n) {
                    ((TableListener)vector.elementAt(n10)).columnInserted(tableEvent);
                    ++n10;
                }
                break;
            }
            case 9: {
                int n11 = 0;
                while (n11 < n) {
                    ((TableListener)vector.elementAt(n11)).rowInfoChanged(tableEvent);
                    ++n11;
                }
                break;
            }
            case 10: {
                int n12 = 0;
                while (n12 < n) {
                    ((TableListener)vector.elementAt(n12)).rowAdded(tableEvent);
                    ++n12;
                }
                break;
            }
            case 11: {
                int n13 = 0;
                while (n13 < n) {
                    ((TableListener)vector.elementAt(n13)).rowRemoved(tableEvent);
                    ++n13;
                }
                break;
            }
            case 12: {
                int n14 = 0;
                while (n14 < n) {
                    ((TableListener)vector.elementAt(n14)).rowInserted(tableEvent);
                    ++n14;
                }
                break;
            }
        }
    }

    public int getColumnCount() {
        return this.fColumnInfo.size();
    }

    public int getColumnIndex(Object object) {
        Table table = this;
        synchronized (table) {
            int n = this.fColumnInfo.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = this.fColumnInfo.elementAt(n2);
                if (object == null) {
                    if (e == null) {
                        return n2;
                    }
                } else if (e != null && e.equals(object)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public Object getColumnInfo(int n) {
        Table table = this;
        synchronized (table) {
            int n2 = this.fColumnInfo.size();
            if (n < 0 || n >= n2) {
                return null;
            }
            return this.fColumnInfo.elementAt(n);
        }
    }

    public Object getElement(int n, int n2) {
        Table table = this;
        synchronized (table) {
            int n3 = this.fColumnInfo.size();
            if (n2 < 0 || n2 >= n3) {
                return null;
            }
            int n4 = this.fRowInfo.size();
            if (n < 0 || n >= n4) {
                return null;
            }
            return ((Vector)this.fColumns.elementAt(n2)).elementAt(n);
        }
    }

    public int getRowCount() {
        Table table = this;
        synchronized (table) {
            int n = this.fColumnInfo.size();
            if (n > 0) {
                n = ((Vector)this.fColumns.elementAt(0)).size();
            }
            return n;
        }
    }

    public int getRowIndex(Object object) {
        Table table = this;
        synchronized (table) {
            int n = this.fRowInfo.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = this.fRowInfo.elementAt(n2);
                if (object == null) {
                    if (e == null) {
                        return n2;
                    }
                } else if (e != null && e.equals(object)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public Object getRowInfo(int n) {
        Table table = this;
        synchronized (table) {
            int n2 = this.fRowInfo.size();
            if (n < 0 || n >= n2) {
                return null;
            }
            return this.fRowInfo.elementAt(n);
        }
    }

    public void insertColumn(Object[] objectArray, Object object, int n) {
        int n2 = 0;
        Serializable serializable = this;
        synchronized (serializable) {
            n2 = this.fColumnInfo.size();
            if (n < 0) {
                n = 0;
            }
            if (n < n2) {
                Vector<Object> vector = new Vector<Object>(50, 25);
                this.fColumnInfo.insertElementAt(object, n);
                this.fColumns.insertElementAt(vector, n);
                int n3 = this.fRowInfo.size();
                int n4 = 0;
                while (n4 < n3) {
                    if (objectArray == null || n4 >= objectArray.length) {
                        vector.insertElementAt(null, n4);
                    } else {
                        vector.insertElementAt(objectArray[n4], n4);
                    }
                    ++n4;
                }
            }
        }
        if (n >= n2) {
            this.addColumn(objectArray, object);
            return;
        }
        serializable = new TableEvent(this, 8, -1, n);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void insertRow(Object[] objectArray, Object object, int n) {
        int n2 = 0;
        Serializable serializable = this;
        synchronized (serializable) {
            n2 = this.fRowInfo.size();
            if (n < 0) {
                n = 0;
            }
            if (n < n2) {
                this.fRowInfo.insertElementAt(object, n);
                int n3 = this.fColumnInfo.size();
                int n4 = 0;
                while (n4 < n3) {
                    Vector vector = (Vector)this.fColumns.elementAt(n4);
                    if (objectArray == null || n4 >= objectArray.length) {
                        vector.insertElementAt(null, n);
                    } else {
                        vector.insertElementAt(objectArray[n4], n);
                    }
                    ++n4;
                }
            }
        }
        if (n >= n2) {
            this.addRow(objectArray, object);
            return;
        }
        serializable = new TableEvent(this, 12, n, -1);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void removeAllColumns() {
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.fColumnInfo.size() == 0) {
                return;
            }
            this.fColumnInfo.removeAllElements();
            this.fColumns.removeAllElements();
            this.fRowInfo.removeAllElements();
        }
        serializable = new TableEvent(this, 1, -1, -2);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void removeAllRows() {
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.fRowInfo.size() == 0) {
                return;
            }
            this.fRowInfo.removeAllElements();
            int n = this.fColumns.size();
            int n2 = 0;
            while (n2 < n) {
                Vector vector = (Vector)this.fColumns.elementAt(n2);
                vector.removeAllElements();
                ++n2;
            }
        }
        serializable = new TableEvent(this, 11, -2, -1);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void removeColumn(int n) {
        Serializable serializable = this;
        synchronized (serializable) {
            if (n < 0 || n >= this.fColumnInfo.size()) {
                return;
            }
            this.fColumnInfo.removeElementAt(n);
            this.fColumns.removeElementAt(n);
            if (this.fColumns.size() == 0) {
                this.fRowInfo.removeAllElements();
            }
        }
        serializable = new TableEvent(this, 7, -1, n);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void removeRow(int n) {
        Serializable serializable = this;
        synchronized (serializable) {
            int n2 = this.fColumnInfo.size();
            if (n2 == 0) {
                return;
            }
            int n3 = ((Vector)this.fColumns.elementAt(0)).size();
            if (n < 0 || n >= n3) {
                return;
            }
            this.fRowInfo.removeElementAt(n);
            int n4 = 0;
            while (n4 < n2) {
                Vector vector = (Vector)this.fColumns.elementAt(n4);
                vector.removeElementAt(n);
                ++n4;
            }
        }
        serializable = new TableEvent(this, 11, n, -1);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void removeTableListener(TableListener tableListener) {
        this.fTableListeners.removeElement(tableListener);
    }

    public void replaceColumn(Object[] objectArray, Object object, int n) {
        Serializable serializable = this;
        synchronized (serializable) {
            int n2 = this.fColumnInfo.size();
            if (n < 0 || n >= n2) {
                return;
            }
            Vector vector = (Vector)this.fColumns.elementAt(n);
            int n3 = this.fRowInfo.size();
            int n4 = 0;
            while (n4 < n3) {
                if (objectArray == null || n4 >= objectArray.length) {
                    vector.setElementAt(null, n4);
                } else {
                    vector.setElementAt(objectArray[n4], n4);
                }
                ++n4;
            }
        }
        serializable = new TableEvent(this, 2, -1, n);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void replaceRow(Object[] objectArray, Object object, int n) {
        Serializable serializable = this;
        synchronized (serializable) {
            int n2 = this.fRowInfo.size();
            if (n < 0 || n >= n2) {
                return;
            }
            int n3 = this.fColumnInfo.size();
            int n4 = 0;
            while (n4 < n3) {
                Vector vector = (Vector)this.fColumns.elementAt(n4);
                if (objectArray == null || n4 >= objectArray.length) {
                    vector.setElementAt(null, n);
                } else {
                    vector.setElementAt(objectArray[n4], n);
                }
                ++n4;
            }
            this.fRowInfo.setElementAt(object, n);
        }
        serializable = new TableEvent(this, 3, n, -1);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void setColumnCount(int n) {
        Table table = this;
        synchronized (table) {
            if (n < 0) {
                return;
            }
            int n2 = this.fColumns.size();
            if (n == n2) {
                return;
            }
            if (n > n2) {
                int n3 = n2;
                while (n3 < n) {
                    this.addColumn(null, null);
                    ++n3;
                }
            } else {
                int n4 = n;
                while (n4 < n2) {
                    this.removeColumn(n);
                    ++n4;
                }
            }
        }
    }

    public void setColumnInfo(Object object, int n) {
        Serializable serializable = this;
        synchronized (serializable) {
            int n2 = this.fColumnInfo.size();
            if (n < 0 || n >= n2) {
                return;
            }
            this.fColumnInfo.setElementAt(object, n);
        }
        serializable = new TableEvent(this, 5, -1, n);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void setElement(Object object, int n, int n2) {
        Serializable serializable = this;
        synchronized (serializable) {
            int n3 = this.fColumns.size();
            if (n2 < 0 || n2 >= n3) {
                return;
            }
            int n4 = ((Vector)this.fColumns.elementAt(0)).size();
            if (n < 0 || n >= n4) {
                return;
            }
            ((Vector)this.fColumns.elementAt(n2)).setElementAt(object, n);
        }
        serializable = new TableEvent(this, 4, n, n2);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void setRowCount(int n) {
        Table table = this;
        synchronized (table) {
            if (this.fColumns.size() == 0 || n < 0) {
                return;
            }
            int n2 = this.fRowInfo.size();
            if (n == n2) {
                return;
            }
            if (n > n2) {
                int n3 = n2;
                while (n3 < n) {
                    this.addRow(null, null);
                    ++n3;
                }
            } else {
                int n4 = n;
                while (n4 < n2) {
                    this.removeRow(n);
                    ++n4;
                }
            }
        }
    }

    public void setRowInfo(Object object, int n) {
        Serializable serializable = this;
        synchronized (serializable) {
            int n2 = this.fRowInfo.size();
            if (n < 0 || n >= n2) {
                return;
            }
            this.fRowInfo.setElementAt(object, n);
        }
        serializable = new TableEvent(this, 9, n, -1);
        this.fireTableEvent((TableEvent)serializable);
    }
}

