/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.j2mclb;

import com.ibm.webrunner.j2mclb.Caption;
import com.ibm.webrunner.j2mclb.event.CaptionBarEvent;
import com.ibm.webrunner.j2mclb.event.CaptionBarListener;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class CaptionBar
extends JComponent {
    public static final Color DEFAULT_BACKGROUND_COLOR = UIManager.getColor("TableHeader.background");
    public static final int MINIMUM_CAPTION_LENGTH = 12;
    private static final int DRAG_AREA_OFFSET = 3;
    private static final Border CAPTION_BORDER = Caption.createDefaultBorder();
    private Vector fCaptionBarListeners = new Vector();
    private Vector fCaptions = new Vector();
    private transient boolean fDragPossible;
    private transient boolean fDragging;
    private transient int fPreviousX;
    private transient int fCaptionDragged;
    private boolean fContinuousDrag = false;
    private int fCaptionSelected = 0;
    private transient int fCaptionOn;
    private transient int fClickCount;
    private transient Image fBackgroundImage;
    private EventHandler fEventHandler = new EventHandler(this);

    public CaptionBar() {
        this.setBackground(DEFAULT_BACKGROUND_COLOR);
        this.init();
    }

    public Caption addCaption(Caption caption) {
        this.fCaptions.addElement(caption);
        if (this.fCaptions.size() == 1) {
            caption.setSelected(true);
        }
        int n = this.fCaptions.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += ((Caption)this.fCaptions.elementAt(n3)).getLength();
            ++n3;
        }
        Dimension dimension = this.getSize();
        if (n2 > dimension.width) {
            this.setSize(n2, dimension.height);
        }
        this.repaint();
        return caption;
    }

    public Caption addCaption(String string) {
        return this.addCaption(string, 50);
    }

    public Caption addCaption(String string, int n) {
        Caption caption = new Caption();
        caption.setLabel(string);
        caption.setLength(n);
        return this.addCaption(caption);
    }

    public void addCaptionBarListener(CaptionBarListener captionBarListener) {
        this.fCaptionBarListeners.addElement(captionBarListener);
    }

    protected void fireCaptionBarEvent(CaptionBarEvent captionBarEvent) {
        Vector vector = (Vector)this.fCaptionBarListeners.clone();
        int n = vector.size();
        switch (captionBarEvent.getID()) {
            case 2000: {
                int n2 = 0;
                while (n2 < n) {
                    ((CaptionBarListener)vector.elementAt(n2)).captionSelected(captionBarEvent);
                    ++n2;
                }
                break;
            }
            case 2001: {
                int n3 = 0;
                while (n3 < n) {
                    ((CaptionBarListener)vector.elementAt(n3)).captionResized(captionBarEvent);
                    ++n3;
                }
                break;
            }
        }
    }

    public Image getBackgroundImage() {
        return this.fBackgroundImage;
    }

    public Caption getCaption(int n) {
        if (n < 0 || n >= this.fCaptions.size()) {
            return null;
        }
        return (Caption)this.fCaptions.elementAt(n);
    }

    public int getCaptionCount() {
        return this.fCaptions.size();
    }

    public boolean getContinuousDrag() {
        return this.fContinuousDrag;
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 20);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public int getSelectedCaptionIndex() {
        int n = this.fCaptions.size();
        int n2 = 0;
        while (n2 < n) {
            if (((Caption)this.fCaptions.elementAt(n2)).isSelected()) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void init() {
        this.fDragPossible = false;
        this.fDragging = false;
        this.fPreviousX = 0;
        this.removeMouseListener(this.fEventHandler);
        this.addMouseListener(this.fEventHandler);
        this.removeMouseMotionListener(this.fEventHandler);
        this.addMouseMotionListener(this.fEventHandler);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        Rectangle rectangle = graphics.getClipBounds();
        Dimension dimension = this.getSize();
        if (this.fBackgroundImage == null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            int n5 = this.fBackgroundImage.getWidth(this);
            int n6 = this.fBackgroundImage.getHeight(this);
            n4 = rectangle.width / n5 + 2;
            n3 = rectangle.height / n6 + 1;
            n2 = rectangle.x / n5 * n5;
            int n7 = 0;
            while (n7 < n4) {
                n = 0;
                while (n < n3) {
                    graphics.drawImage(this.fBackgroundImage, n2 + n7 * n5, n * n6, this);
                    ++n;
                }
                ++n7;
            }
        }
        Color color = this.getBackground();
        new Rectangle();
        Vector vector = this.fCaptions;
        synchronized (vector) {
            n4 = this.fCaptions.size();
            if (n4 > 0) {
                n3 = 0;
                n2 = 0;
                while (n2 < n4) {
                    Caption caption = (Caption)this.fCaptions.elementAt(n2);
                    if (caption.isVisible()) {
                        n = caption.getLength();
                        if (n3 + n < rectangle.x) {
                            n3 += n;
                        } else {
                            Object var12_16;
                            Graphics graphics2 = graphics.create(n3, 0, n, dimension.height);
                            try {
                                graphics2.setColor(color);
                                caption.paint(graphics2);
                            }
                            catch (Throwable throwable) {
                                var12_16 = null;
                                graphics2.dispose();
                                throw throwable;
                            }
                            var12_16 = null;
                            graphics2.dispose();
                            if ((n3 += n) > dimension.width) break;
                        }
                    }
                    ++n2;
                }
                Border border = ((Caption)this.fCaptions.firstElement()).getBorder();
                border.paintBorder(this, graphics, n3, 0, dimension.width - n3, dimension.height);
            } else {
                CAPTION_BORDER.paintBorder(this, graphics, 0, 0, dimension.width, dimension.height);
            }
        }
        graphics.setClip(0, 0, dimension.width, dimension.height);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public void removeAll() {
        this.fCaptions.removeAllElements();
        this.repaint();
    }

    public void removeCaption(int n) {
        this.fCaptions.removeElementAt(n);
        this.repaint();
    }

    public void removeCaptionBarListener(CaptionBarListener captionBarListener) {
        this.fCaptionBarListeners.removeElement(captionBarListener);
    }

    public void setBackgroundImage(Image image) {
        this.fBackgroundImage = image;
        this.repaint();
    }

    public CaptionBar setContinuousDrag(boolean bl) {
        this.fContinuousDrag = bl;
        return this;
    }

    public void setHorizontalAdjuster(Adjustable adjustable) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("[");
        int n = this.fCaptions.size();
        stringBuffer.append("count=" + n);
        stringBuffer.append(",captions={");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(((Caption)this.fCaptions.elementAt(n2)).getLabel());
            if (n2 < n - 1) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        stringBuffer.append("}");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static boolean access$fContinuousDrag(CaptionBar captionBar) {
        return captionBar.fContinuousDrag;
    }

    static int access$fClickCount(CaptionBar captionBar) {
        return captionBar.fClickCount;
    }

    static boolean access$fDragPossible(CaptionBar captionBar) {
        return captionBar.fDragPossible;
    }

    static boolean access$fDragging(CaptionBar captionBar) {
        return captionBar.fDragging;
    }

    static int access$fCaptionSelected(CaptionBar captionBar) {
        return captionBar.fCaptionSelected;
    }

    static int access$fCaptionOn(CaptionBar captionBar) {
        return captionBar.fCaptionOn;
    }

    static Vector access$fCaptions(CaptionBar captionBar) {
        return captionBar.fCaptions;
    }

    static int access$fCaptionDragged(CaptionBar captionBar) {
        return captionBar.fCaptionDragged;
    }

    static int access$fPreviousX(CaptionBar captionBar) {
        return captionBar.fPreviousX;
    }

    static void access$fClickCount(CaptionBar captionBar, int n) {
        captionBar.fClickCount = n;
    }

    static void access$fDragPossible(CaptionBar captionBar, boolean bl) {
        captionBar.fDragPossible = bl;
    }

    static void access$fDragging(CaptionBar captionBar, boolean bl) {
        captionBar.fDragging = bl;
    }

    static void access$fCaptionSelected(CaptionBar captionBar, int n) {
        captionBar.fCaptionSelected = n;
    }

    static void access$fPreviousX(CaptionBar captionBar, int n) {
        captionBar.fPreviousX = n;
    }

    static void access$fCaptionOn(CaptionBar captionBar, int n) {
        captionBar.fCaptionOn = n;
    }

    static void access$fCaptionDragged(CaptionBar captionBar, int n) {
        captionBar.fCaptionDragged = n;
    }

    class EventHandler
    implements MouseListener,
    MouseMotionListener,
    Serializable {
        /* synthetic */ CaptionBar this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            if (CaptionBar.access$fDragPossible(this.this$0)) {
                CaptionBar.access$fDragging(this.this$0, true);
            }
            int n2 = CaptionBar.access$fCaptions(this.this$0).size();
            int n3 = 0;
            CaptionBar.access$fCaptionOn(this.this$0, -1);
            int n4 = 0;
            while (n4 < n2) {
                Caption caption = (Caption)CaptionBar.access$fCaptions(this.this$0).elementAt(n4);
                if (caption.isVisible()) {
                    int n5 = caption.getLength();
                    if (n >= n3 && n < n3 + n5) {
                        CaptionBar.access$fCaptionOn(this.this$0, n4);
                        CaptionBar.access$fClickCount(this.this$0, mouseEvent.getClickCount());
                        break;
                    }
                    n3 += n5;
                }
                ++n4;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (CaptionBar.access$fDragging(this.this$0)) {
                int n = mouseEvent.getClickCount();
                this.this$0.setCursor(Cursor.getDefaultCursor());
                CaptionBar.access$fDragging(this.this$0, false);
                if (!CaptionBar.access$fContinuousDrag(this.this$0) || n > 1) {
                    CaptionBarEvent captionBarEvent = new CaptionBarEvent(this.this$0, 2001, CaptionBar.access$fCaptionDragged(this.this$0), n, mouseEvent.getModifiers());
                    this.this$0.fireCaptionBarEvent(captionBarEvent);
                    return;
                }
            } else if (CaptionBar.access$fCaptionOn(this.this$0) != -1) {
                int n = mouseEvent.getX();
                int n2 = CaptionBar.access$fCaptions(this.this$0).size();
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    Caption caption = (Caption)CaptionBar.access$fCaptions(this.this$0).elementAt(n4);
                    if (caption.isVisible()) {
                        int n5 = caption.getLength();
                        if (n >= n3 && n < n3 + n5) {
                            if (n4 != CaptionBar.access$fCaptionOn(this.this$0) || n4 == CaptionBar.access$fCaptionSelected(this.this$0)) break;
                            ((Caption)CaptionBar.access$fCaptions(this.this$0).elementAt(CaptionBar.access$fCaptionSelected(this.this$0))).setSelected(false);
                            caption.setSelected(true);
                            CaptionBar.access$fCaptionSelected(this.this$0, n4);
                            break;
                        }
                        n3 += n5;
                    }
                    ++n4;
                }
                this.this$0.repaint();
                CaptionBarEvent captionBarEvent = new CaptionBarEvent(this.this$0, 2000, CaptionBar.access$fCaptionSelected(this.this$0), CaptionBar.access$fClickCount(this.this$0), mouseEvent.getModifiers());
                this.this$0.fireCaptionBarEvent(captionBarEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!CaptionBar.access$fDragging(this.this$0)) {
                this.this$0.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (CaptionBar.access$fDragging(this.this$0)) {
                int n = mouseEvent.getX();
                Caption caption = (Caption)CaptionBar.access$fCaptions(this.this$0).elementAt(CaptionBar.access$fCaptionDragged(this.this$0));
                int n2 = n - CaptionBar.access$fPreviousX(this.this$0);
                int n3 = caption.getLength();
                if (n2 > 0) {
                    caption.setLength(n3 + n2);
                    CaptionBar.access$fPreviousX(this.this$0, n);
                    this.this$0.repaint();
                } else if (n2 < 0 && n3 > 12) {
                    if (n3 + n2 >= 10) {
                        caption.setLength(n3 + n2);
                        CaptionBar.access$fPreviousX(this.this$0, n);
                    } else {
                        caption.setLength(12);
                    }
                    this.this$0.repaint();
                }
                if (CaptionBar.access$fContinuousDrag(this.this$0)) {
                    CaptionBarEvent captionBarEvent = new CaptionBarEvent(this.this$0, 2001, CaptionBar.access$fCaptionDragged(this.this$0), CaptionBar.access$fClickCount(this.this$0), mouseEvent.getModifiers());
                    this.this$0.fireCaptionBarEvent(captionBarEvent);
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = CaptionBar.access$fCaptions(this.this$0).size();
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                Caption caption = (Caption)CaptionBar.access$fCaptions(this.this$0).elementAt(n4);
                if (caption.isVisible() && caption.isResizable() && n >= (n3 += caption.getLength()) - 3 && n <= n3 + 3) {
                    this.this$0.setCursor(Cursor.getPredefinedCursor(11));
                    CaptionBar.access$fDragPossible(this.this$0, true);
                    CaptionBar.access$fCaptionDragged(this.this$0, n4);
                    CaptionBar.access$fPreviousX(this.this$0, n3);
                    return;
                }
                ++n4;
            }
            if (CaptionBar.access$fDragPossible(this.this$0)) {
                this.this$0.setCursor(Cursor.getDefaultCursor());
                CaptionBar.access$fDragPossible(this.this$0, false);
            }
        }

        EventHandler(CaptionBar captionBar) {
            this.this$0 = captionBar;
        }
    }
}

