/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ws;

import com.json.parsers.JSONParser;
import com.json.parsers.JsonParserFactory;
import edu.csus.ecs.pc2.ws.ResponseHandler;
import edu.csus.ecs.pc2.ws.WebServer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

class Worker
extends WebServer
implements Runnable {
    static final int BUF_SIZE = 2048;
    static final byte[] EOL = new byte[]{13, 10};
    private byte[] buf = new byte[2048];
    private Socket s = null;
    private ResponseHandler responseHandler;
    private static Hashtable<String, String> map = new Hashtable();

    static {
        Worker.fillMap();
    }

    static void setSuffix(String k, String v) {
        map.put(k, v);
    }

    protected Worker() {
        System.out.println("debug 22 Starting worker");
    }

    Worker(ResponseHandler responseHandler) {
        this();
        this.responseHandler = responseHandler;
    }

    synchronized void setSocket(Socket socket) {
        this.s = socket;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        while (true) {
            Vector<Worker> pool;
            if (this.s == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            try {
                this.handleClient();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.s = null;
            Vector<Worker> vector = pool = WebServer.threads;
            synchronized (vector) {
                if (pool.size() >= WebServer.workers) {
                    return;
                }
                pool.addElement(this);
            }
        }
    }

    void handleClient() throws IOException {
        System.out.println("debug 22 handleClient");
        BufferedInputStream is = new BufferedInputStream(this.s.getInputStream());
        PrintStream ps = new PrintStream(this.s.getOutputStream());
        this.s.setSoTimeout(WebServer.timeout);
        int i = 0;
        while (i < this.buf.length) {
            this.buf[i] = 0;
            ++i;
        }
        try {
            int index;
            boolean doingGet;
            int nread = 0;
            int r = 0;
            block6: while (nread < 2048) {
                r = ((InputStream)is).read(this.buf, nread, 2048 - nread);
                if (r == -1) {
                    return;
                }
                int i2 = nread;
                nread += r;
                while (i2 < nread) {
                    if (this.buf[i2] == 10 || this.buf[i2] == 13) break block6;
                    ++i2;
                }
            }
            String httpCommand = new String(this.buf);
            System.out.println("debug 22 http <" + httpCommand + "> http end");
            if (httpCommand.startsWith("GET ")) {
                doingGet = true;
                index = 4;
            } else if (httpCommand.startsWith("HEAD ")) {
                doingGet = false;
                index = 5;
            } else if (httpCommand.startsWith("PUT ")) {
                doingGet = true;
                index = 4;
            } else {
                ps.print("HTTP/1.0 405 unsupported method type: ");
                ps.write(this.buf, 0, 5);
                ps.write(EOL);
                ps.flush();
                this.s.close();
                return;
            }
            int i3 = 0;
            i3 = index;
            while (i3 < nread) {
                if (this.buf[i3] == 32) break;
                ++i3;
            }
            boolean ok = this.printHeaders(ps);
            if (doingGet) {
                if (ok) {
                    this.postResponse(httpCommand, ps);
                } else {
                    this.send404(ps);
                }
            }
        }
        finally {
            this.s.close();
        }
    }

    private void postResponse(String httpCommand, PrintStream ps) throws IOException {
        ps.write(EOL);
        String[] requestParts = this.parseHttpCommand(httpCommand);
        String path = requestParts[1];
        Map<String, String> parameters = this.mapParams(requestParts[2]);
        try {
            String response = this.responseHandler.getResponse(path, parameters);
            ps.println(response);
        }
        catch (Exception e) {
            try {
                this.sendErrorResponse(ps, e);
            }
            catch (Exception exception) {
                e.printStackTrace(System.err);
            }
        }
    }

    void sendErrorResponse(PrintStream ps, Exception e) throws IOException {
        ps.write(EOL);
        ps.write(EOL);
        ps.println("<h3><b>Internal Error</b><P>");
        if (e != null) {
            ps.println(e.getLocalizedMessage());
            e.printStackTrace(System.err);
        }
    }

    private String[] parseHttpCommand(String httpCommand) {
        String[] fields = httpCommand.split(" ", 2);
        String path = fields[1];
        String parameters = null;
        int questIndex = path.indexOf(63);
        if (questIndex > -1) {
            int endSpace = path.indexOf(32);
            try {
                parameters = URLDecoder.decode(path.substring(questIndex + 1, endSpace), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            path = path.substring(0, questIndex);
        } else if (fields[0].startsWith("PUT")) {
            int httpIndex = path.indexOf("HTTP");
            int bodyIndex = path.indexOf("\r\n\r\n");
            int curlyIndex = path.indexOf(125);
            try {
                parameters = URLDecoder.decode(path.substring(bodyIndex + 4, curlyIndex + 1), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            path = path.substring(0, httpIndex - 1);
        }
        String[] outFields = new String[]{fields[0], path, parameters};
        return outFields;
    }

    private Map<String, String> mapParams(String string) {
        JsonParserFactory factory = JsonParserFactory.getInstance();
        JSONParser parser = factory.newJsonParser();
        Map aMap = parser.parseJson(string);
        return aMap;
    }

    boolean printHeaders(PrintStream ps) throws IOException {
        boolean ret = false;
        ps.print("HTTP/1.0 200 OK");
        ps.write(EOL);
        ret = true;
        if (ret) {
            ps.print("Content-type: text/html");
            ps.write(EOL);
        }
        return ret;
    }

    void send404(File targ, PrintStream ps) throws IOException {
        ps.write(EOL);
        ps.write(EOL);
        ps.println("<h3><b>404 Error</b><P>Resource not found ");
        if (targ != null) {
            ps.write(EOL);
            ps.println("File: '" + targ.getAbsolutePath() + "'");
        }
    }

    void send404(PrintStream ps) throws IOException {
        ps.write(EOL);
        ps.write(EOL);
        ps.println("<h3><b>404 Error</b><P>Nothing found that matches stuff. ");
    }

    public String leftPad(String string, int minLength) {
        if (string.length() >= minLength) {
            return string;
        }
        int numPad = minLength - string.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        int i = 0;
        while (i < numPad) {
            stringBuffer.append(' ');
            ++i;
        }
        return new String(stringBuffer);
    }

    static void fillMap() {
        Worker.setSuffix("", "content/unknown");
        Worker.setSuffix(".uu", "application/octet-stream");
        Worker.setSuffix(".exe", "application/octet-stream");
        Worker.setSuffix(".ps", "application/postscript");
        Worker.setSuffix(".zip", "application/zip");
        Worker.setSuffix(".sh", "application/x-shar");
        Worker.setSuffix(".tar", "application/x-tar");
        Worker.setSuffix(".snd", "audio/basic");
        Worker.setSuffix(".au", "audio/basic");
        Worker.setSuffix(".wav", "audio/x-wav");
        Worker.setSuffix(".gif", "image/gif");
        Worker.setSuffix(".jpg", "image/jpeg");
        Worker.setSuffix(".jpeg", "image/jpeg");
        Worker.setSuffix(".htm", "text/html");
        Worker.setSuffix(".html", "text/html");
        Worker.setSuffix(".text", "text/plain");
        Worker.setSuffix(".c", "text/plain");
        Worker.setSuffix(".cc", "text/plain");
        Worker.setSuffix(".c++", "text/plain");
        Worker.setSuffix(".h", "text/plain");
        Worker.setSuffix(".pl", "text/plain");
        Worker.setSuffix(".txt", "text/plain");
        Worker.setSuffix(".java", "text/plain");
    }
}

