/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui.team;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.ClarificationsPane;
import edu.csus.ecs.pc2.ui.ContestClockDisplay;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.OptionsPane;
import edu.csus.ecs.pc2.ui.PluginLoadPane;
import edu.csus.ecs.pc2.ui.RunsPane;
import edu.csus.ecs.pc2.ui.SubmitClarificationPane;
import edu.csus.ecs.pc2.ui.SubmitRunPane;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class TeamView
extends JFrame
implements UIPlugin {
    private IInternalContest contest = null;
    private IInternalController teamController = null;
    private static final long serialVersionUID = 8225187691479543638L;
    private JPanel mainViewPane = null;
    private JTabbedPane mainTabbedPane = null;
    private JPanel northPane = null;
    private JPanel exitPane = null;
    private JPanel messagePane = null;
    private JPanel clockPane = null;
    private JLabel clockLabel = null;
    private JLabel messageLabel = null;
    private JButton exitButton = null;
    private ContestClockDisplay contestClockDisplay = null;

    public TeamView() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(556, 521));
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getMainViewPane());
        this.setTitle("The TeamView");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TeamView.this.promptAndExit();
            }
        });
        this.overRideLookAndFeel();
        FrameUtilities.centerFrame(this);
        this.setTitle("PC^2 Team - Not Logged In ");
        FrameUtilities.waitCursor(this);
    }

    private void overRideLookAndFeel() {
        String value = IniFile.getValue("client.plaf");
        if (value != null && value.equalsIgnoreCase("java")) {
            FrameUtilities.setJavaLookAndFeel();
        }
        if (value != null && value.equalsIgnoreCase("native")) {
            FrameUtilities.setNativeLookAndFeel();
        }
    }

    protected void promptAndExit() {
        int result = FrameUtilities.yesNoCancelDialog(null, "Are you sure you want to exit PC^2?", "Exit PC^2");
        if (result == 0) {
            System.exit(0);
        }
    }

    private boolean isThisSite(int siteNumber) {
        return siteNumber == this.contest.getSiteNumber();
    }

    private void updateFrameTitle(final boolean turnButtonsOn) {
        final TeamView thisFrame = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrameUtilities.setFrameTitle(thisFrame, TeamView.this.contest.getTitle(), turnButtonsOn, new VersionInfo());
                if (TeamView.this.contestClockDisplay.getClientFrame() == null) {
                    TeamView.this.contestClockDisplay.setClientFrame(TeamView.this.getThisFrame());
                }
                TeamView.this.contestClockDisplay.fireClockStateChange(TeamView.this.contest.getContestTime());
            }
        });
        if (turnButtonsOn) {
            this.updateClockLabel("");
        } else {
            this.updateClockLabel("STOPPED");
        }
        FrameUtilities.regularCursor(this);
    }

    private JPanel getMainViewPane() {
        if (this.mainViewPane == null) {
            this.mainViewPane = new JPanel();
            this.mainViewPane.setLayout(new BorderLayout());
            this.mainViewPane.add((Component)this.getMainTabbedPane(), "Center");
            this.mainViewPane.add((Component)this.getNorthPane(), "North");
        }
        return this.mainViewPane;
    }

    private JTabbedPane getMainTabbedPane() {
        if (this.mainTabbedPane == null) {
            this.mainTabbedPane = new JTabbedPane();
        }
        return this.mainTabbedPane;
    }

    protected TeamView getThisFrame() {
        return this;
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.teamController = inController;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TeamView.this.teamController.startLogWindow(TeamView.this.contest);
                TeamView.this.contest.addContestTimeListener(new ContestTimeListenerImplementation());
                SubmitRunPane submitRunPane = new SubmitRunPane();
                TeamView.this.addUIPlugin(TeamView.this.getMainTabbedPane(), "Submit Run", submitRunPane);
                RunsPane runsPanel = new RunsPane();
                runsPanel.setShowJudgesInfo(false);
                TeamView.this.addUIPlugin(TeamView.this.getMainTabbedPane(), "View Runs", runsPanel);
                SubmitClarificationPane submitClarificationPane = new SubmitClarificationPane();
                TeamView.this.addUIPlugin(TeamView.this.getMainTabbedPane(), "Request Clarification", submitClarificationPane);
                ClarificationsPane clarificationsPane = new ClarificationsPane();
                TeamView.this.addUIPlugin(TeamView.this.getMainTabbedPane(), "View Clarifications", clarificationsPane);
                OptionsPane optionsPanel = new OptionsPane();
                TeamView.this.addUIPlugin(TeamView.this.getMainTabbedPane(), "Options", optionsPanel);
                if (Utilities.isDebugMode()) {
                    try {
                        PluginLoadPane pane = new PluginLoadPane();
                        pane.setParentTabbedPane(TeamView.this.getMainTabbedPane());
                        TeamView.this.addUIPlugin(TeamView.this.getMainTabbedPane(), "Plugin Load", pane);
                    }
                    catch (Exception e) {
                        if (StaticLog.getLog() != null) {
                            StaticLog.getLog().log(Log.WARNING, "Exception", e);
                            e.printStackTrace(System.err);
                        }
                        e.printStackTrace(System.err);
                    }
                }
                TeamView.this.updateFrameTitle(TeamView.this.contest.getContestTime().isContestRunning());
                TeamView.this.contestClockDisplay = new ContestClockDisplay(TeamView.this.teamController.getLog(), TeamView.this.contest.getContestTime(), TeamView.this.contest.getSiteNumber(), TeamView.this.isTeam(), null);
                TeamView.this.contestClockDisplay.addLabeltoUpdateList(TeamView.this.clockLabel, ContestClockDisplay.DisplayTimes.REMAINING_TIME, TeamView.this.contest.getSiteNumber());
                TeamView.this.teamController.register(TeamView.this.contestClockDisplay);
                TeamView.this.setVisible(true);
            }
        });
    }

    private boolean isTeam(ClientId id) {
        return id != null && id.getClientType().equals((Object)ClientType.Type.TEAM);
    }

    private boolean isTeam() {
        return this.isTeam(this.contest.getClientId());
    }

    @Override
    public String getPluginTitle() {
        return "Team Main GUI";
    }

    protected void addUIPlugin(JTabbedPane tabbedPane, String tabTitle, JPanePlugin plugin) {
        this.teamController.register(plugin);
        plugin.setParentFrame(this);
        plugin.setContestAndController(this.contest, this.teamController);
        tabbedPane.add((Component)plugin, tabTitle);
    }

    private JPanel getNorthPane() {
        if (this.northPane == null) {
            this.northPane = new JPanel();
            this.northPane.setLayout(new BorderLayout());
            this.northPane.setPreferredSize(new Dimension(40, 40));
            this.northPane.add((Component)this.getExitPane(), "East");
            this.northPane.add((Component)this.getMessagePane(), "Center");
            this.northPane.add((Component)this.getClockPane(), "West");
        }
        return this.northPane;
    }

    private JPanel getExitPane() {
        if (this.exitPane == null) {
            this.exitPane = new JPanel();
            this.exitPane.add((Component)this.getExitButton(), null);
        }
        return this.exitPane;
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private JPanel getClockPane() {
        if (this.clockPane == null) {
            this.clockLabel = new JLabel();
            this.clockLabel.setText("STOPPED");
            this.clockLabel.setForeground(Color.red);
            this.clockLabel.setFont(new Font("Dialog", 1, 16));
            this.clockLabel.setPreferredSize(new Dimension(82, 21));
            this.clockLabel.setHorizontalAlignment(0);
            this.clockPane = new JPanel();
            this.clockPane.setLayout(new BorderLayout());
            this.clockPane.setPreferredSize(new Dimension(85, 34));
            this.clockPane.add((Component)this.clockLabel, "Center");
        }
        return this.clockPane;
    }

    private JButton getExitButton() {
        if (this.exitButton == null) {
            this.exitButton = new JButton();
            this.exitButton.setText("Exit");
            this.exitButton.setToolTipText("Click here to Shutdown PC^2");
            this.exitButton.setMnemonic(88);
            this.exitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TeamView.this.promptAndExit();
                }
            });
        }
        return this.exitButton;
    }

    private void updateClockLabel(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TeamView.this.clockLabel.setText(string);
                TeamView.this.clockLabel.setToolTipText(string);
            }
        });
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TeamView.this.messageLabel.setText(string);
                TeamView.this.messageLabel.setToolTipText(string);
            }
        });
    }

    private class ContestTimeListenerImplementation
    implements IContestTimeListener {
        private ContestTimeListenerImplementation() {
        }

        @Override
        public void contestTimeAdded(ContestTimeEvent event) {
            if (TeamView.this.isThisSite(event.getSiteNumber())) {
                TeamView.this.updateFrameTitle(event.getContestTime().isContestRunning());
            }
        }

        @Override
        public void contestTimeRemoved(ContestTimeEvent event) {
        }

        @Override
        public void contestTimeChanged(ContestTimeEvent event) {
            if (TeamView.this.isThisSite(event.getSiteNumber())) {
                TeamView.this.updateFrameTitle(event.getContestTime().isContestRunning());
            }
        }

        @Override
        public void contestStarted(ContestTimeEvent event) {
            if (TeamView.this.isThisSite(event.getSiteNumber())) {
                TeamView.this.updateFrameTitle(event.getContestTime().isContestRunning());
            }
        }

        @Override
        public void contestStopped(ContestTimeEvent event) {
            if (TeamView.this.isThisSite(event.getSiteNumber())) {
                TeamView.this.updateFrameTitle(event.getContestTime().isContestRunning());
            }
        }

        @Override
        public void refreshAll(ContestTimeEvent event) {
            if (TeamView.this.isThisSite(event.getSiteNumber())) {
                TeamView.this.updateFrameTitle(event.getContestTime().isContestRunning());
            }
        }
    }
}

