/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.api.IContest;
import edu.csus.ecs.pc2.api.ServerConnection;
import edu.csus.ecs.pc2.core.InternalController;
import edu.csus.ecs.pc2.core.ParseArguments;
import edu.csus.ecs.pc2.core.exception.CommandLineErrorException;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.ws.ResponseHandler;
import edu.csus.ecs.pc2.ws.WebServer;

public class WebServerModule {
    private ServerConnection serverConnection = null;
    private int port = 80;
    private boolean debugMode = false;
    private String login;
    private String password;
    private IContest contest;

    public WebServerModule(String[] args) throws CommandLineErrorException {
        this.loadVariables(args);
    }

    public void startWebServer() {
        try {
            this.serverConnection = new ServerConnection();
            this.contest = this.serverConnection.login(this.login, this.password);
            System.out.println("For: " + this.contest.getMyClient().getDisplayName() + " (" + this.contest.getMyClient().getLoginName() + ")");
            System.out.println();
            WebServer webServer = new WebServer();
            ResponseHandler responseHandler = new ResponseHandler();
            responseHandler.setContestAndServerConnection(this.serverConnection, this.contest);
            webServer.setResponseHandler(responseHandler);
            webServer.startServer(this.port);
        }
        catch (Exception e) {
            System.err.println("Error - " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    protected void loadVariables(String[] args) throws CommandLineErrorException {
        if (args.length == 0 || args[0].equals("--help")) {
            this.usage();
            System.exit(4);
        }
        String[] opts = new String[]{"--login", "--password", "--port"};
        ParseArguments arguments = new ParseArguments(args, opts);
        this.debugMode = arguments.isOptPresent("--debug");
        if (this.debugMode) {
            arguments.dumpArgs(System.err);
        }
        String cmdLineLogin = null;
        String cmdLinePassword = null;
        if (arguments.isOptPresent("--login")) {
            cmdLineLogin = arguments.getOptValue("--login");
        }
        if (arguments.isOptPresent("--port")) {
            this.port = arguments.getLongOptionValue("--port").intValue();
        }
        if (arguments.isOptPresent("--password")) {
            cmdLinePassword = arguments.getOptValue("--password");
        }
        this.setLoginPassword(cmdLineLogin, cmdLinePassword);
    }

    private void setLoginPassword(String loginName, String inPassword) {
        ClientId id = InternalController.loginShortcutExpansion(1, loginName);
        if (id != null) {
            this.login = id.getName();
            this.password = inPassword;
            if (this.password == null) {
                this.password = this.login;
            }
        }
    }

    private void usage() {
        String[] usage;
        String[] stringArray = usage = new String[]{"Usage WebServer [--help] ", "Usage WebServer [-F propfile] [--port ##] --login login --password password", "", "--help   this listing", "", "$Id$"};
        int n = usage.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            System.out.println(s);
            ++n2;
        }
    }

    protected void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public static void main(String[] args) {
        try {
            WebServerModule webModule = new WebServerModule(args);
            webModule.startWebServer();
        }
        catch (Exception e) {
            System.err.println("Error " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

