/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.ICountDownMessage;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.RomanNumeral;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class TextCountDownMessage
extends TimerTask
implements ICountDownMessage {
    private static final long serialVersionUID = -1864153362739487599L;
    private static final long ONE_SECOND_IN_MS = 1000L;
    private boolean exitOnClose = false;
    private int inputRemainingSeconds = 10;
    private Timer timer = null;
    private long endMilliSeconds;
    private String prefixToTime = "";

    @Override
    public void start(String prefixForCount, int seconds) {
        this.setRemainingSeconds(seconds);
        String remainSring = String.valueOf(this.prefixToTime) + new RomanNumeral(seconds).toString() + " seconds";
        this.output(remainSring);
        this.setPrefixToTime(prefixForCount);
        this.endMilliSeconds = new Date().getTime() + (long)this.inputRemainingSeconds * 1000L;
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)this, 0L, 1000L);
    }

    public void actionOnClose() {
        if (this.exitOnClose) {
            System.exit(4);
        } else {
            this.timer.cancel();
        }
    }

    public boolean isExitOnClose() {
        return this.exitOnClose;
    }

    @Override
    public void setExitOnClose(boolean exitOnClose) {
        this.exitOnClose = exitOnClose;
    }

    public int getRemainingSeconds() {
        return this.inputRemainingSeconds;
    }

    public void setRemainingSeconds(int remainingSeconds) {
        this.inputRemainingSeconds = remainingSeconds;
    }

    private void output(String message) {
        System.out.println(message);
    }

    public String getPrefixToTime() {
        return this.prefixToTime;
    }

    public void setPrefixToTime(String prefixToTime) {
        if (prefixToTime != null) {
            this.prefixToTime = prefixToTime;
        }
    }

    @Override
    public void setTitle(String string) {
    }

    public void setVisible(boolean b) {
    }

    @Override
    public void run() {
        long remainingSeconds = (this.endMilliSeconds - new Date().getTime()) / 1000L;
        String message = null;
        message = remainingSeconds >= 1L ? String.valueOf(this.prefixToTime) + new RomanNumeral(remainingSeconds).toString() + " seconds" : String.valueOf(this.prefixToTime) + "0 seconds";
        this.output(message);
        if (remainingSeconds < 1L) {
            this.actionOnClose();
        }
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
    }

    @Override
    public String getPluginTitle() {
        return "Text Countdown timer";
    }
}

