/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.execute.Executable;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.SelectJudgementPaneNew;
import edu.csus.ecs.pc2.ui.UIPlugin;
import edu.csus.ecs.pc2.ui.judge.JudgeView;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SelectJudgementFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = 6532349396307812235L;
    private IInternalContest contest;
    private IInternalController controller;
    private Run run = null;
    private SelectJudgementPaneNew selectJudgementPane = null;
    private Log log = null;

    public SelectJudgementFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getSelectJudgementPane());
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(800, 400));
        this.setSize(new Dimension(800, 400));
        this.setTitle("Select Run Judgement");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectJudgementFrame.this.getSelectJudgementPane().handleCancelButton();
            }
        });
        FrameUtilities.centerFrame(this);
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        if (!inContest.getAccount(inContest.getClientId()).getPermissionList().isAllowed(Permission.Type.JUDGE_RUN)) {
            throw new SecurityException("SelectJudgementFame requires JUDGE_RUN permission");
        }
        this.getSelectJudgementPane().setContestAndController(this.contest, this.controller);
        this.getSelectJudgementPane().setParentFrame(this);
        this.contest.addRunListener(new RunListenerImplementation());
        this.log = this.controller.getLog();
    }

    public void setRun(Run theRun, boolean rejudgeRun) {
        Executable tempEexecutable = new Executable(this.contest, this.controller, theRun, null);
        String temporaryExecuteableDirectory = tempEexecutable.getExecuteDirectoryName();
        if (!new File(temporaryExecuteableDirectory).isDirectory()) {
            this.log.info("Creating directory " + temporaryExecuteableDirectory);
            Utilities.insureDir(temporaryExecuteableDirectory);
        }
        tempEexecutable.clearDirectory(temporaryExecuteableDirectory);
        this.getSelectJudgementPane().setRun(theRun);
        if (theRun == null) {
            this.setTitle("Run not loaded");
        } else {
            this.setTitle("Select Judgement for run " + theRun.getNumber() + " (Site " + theRun.getSiteNumber() + ")");
            this.run = theRun;
            this.getSelectJudgementPane().setRunFiles(null);
            if (rejudgeRun) {
                this.controller.checkOutRejudgeRun(theRun);
            } else {
                this.controller.checkOutRun(theRun, false, false);
            }
        }
    }

    @Override
    public String getPluginTitle() {
        return "Edit Run Frame";
    }

    private SelectJudgementPaneNew getSelectJudgementPane() {
        if (this.selectJudgementPane == null) {
            this.selectJudgementPane = new SelectJudgementPaneNew();
            this.selectJudgementPane.setPreferredSize(new Dimension(800, 400));
        }
        return this.selectJudgementPane;
    }

    public class RunListenerImplementation
    implements IRunListener {
        @Override
        public void runAdded(RunEvent event) {
        }

        @Override
        public void refreshRuns(RunEvent event) {
        }

        @Override
        public void runChanged(RunEvent event) {
            if (SelectJudgementFrame.this.run != null && event.getRun().getElementId().equals(SelectJudgementFrame.this.run.getElementId())) {
                if (event.getAction().equals((Object)RunEvent.Action.RUN_NOT_AVAILABLE)) {
                    SelectJudgementFrame.this.getSelectJudgementPane().setRun(SelectJudgementFrame.this.run);
                    SelectJudgementFrame.this.getSelectJudgementPane().regularCursor();
                    JOptionPane.showMessageDialog(null, "Run " + SelectJudgementFrame.this.run.getNumber() + " (Site " + SelectJudgementFrame.this.run.getSiteNumber() + ") is not available.");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SelectJudgementFrame.this.getSelectJudgementPane().enableUpdateButtons(false);
                        }
                    });
                    JudgeView.setAlreadyJudgingRun(false);
                    SelectJudgementFrame.this.setVisible(false);
                } else if (event.getSentToClientId() != null && event.getSentToClientId().equals(SelectJudgementFrame.this.contest.getClientId())) {
                    SelectJudgementFrame.this.getSelectJudgementPane().setRunAndFiles(event.getRun(), event.getRunFiles(), event.getRunResultFiles());
                    SelectJudgementFrame.this.run = null;
                }
            }
        }

        @Override
        public void runRemoved(RunEvent event) {
        }
    }
}

