/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.ui.IFileViewer;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class RunResultsPane
extends JPanePlugin
implements Serializable {
    private static final long serialVersionUID = 2702736596302432093L;
    private final String defaultTitle = "Run Results";
    private JPanel compilationPanel = null;
    private JPanel executionPanel = null;
    private JPanel validationPanel = null;
    private RunResultFiles theRunResults;
    private JLabel compileSuccessLabel = null;
    private JLabel compileResultCodeLabel = null;
    private JButton showCompilerOutputButton = null;
    private JLabel executionSuccessLabel = null;
    private JLabel executionResultCodeLabel = null;
    private JButton showExecutionOutputButton = null;
    private JLabel validationSuccessLabel = null;
    private JLabel validationResultCodeLabel = null;
    private JButton showValidationOutputButton = null;
    private JLabel validationAnswerLabel = null;
    private JLabel compileTimeLabel = null;
    private JLabel executionTimeLabel = null;
    private JLabel validationTimeLabel = null;
    private MultipleFileViewer compileFileviewer = null;
    private MultipleFileViewer executeFileviewer = null;
    private MultipleFileViewer validateFileviewer = null;

    public RunResultsPane() {
        this.initialize();
        this.setTitle("Run Results");
    }

    public RunResultsPane(RunResultFiles rrf) {
        this();
        this.theRunResults = rrf;
        if (rrf == null) {
            this.clear();
        } else {
            this.populatePane(this.theRunResults, "Run Results");
        }
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
    }

    public void populatePane(RunResultFiles runResults, String title) {
        this.theRunResults = runResults;
        this.populateCompilerResults(runResults);
        this.populateExecutionResults(runResults);
        this.populateValidationResults(runResults);
        this.setTitle(title);
    }

    private void setTitle(String title) {
        ((TitledBorder)this.getBorder()).setTitle(title);
    }

    private void populateCompilerResults(RunResultFiles runResults) {
        String successMsg = "<HTML>Success: <FONT COLOR=BLUE>";
        String resultCode = "<HTML>Result code: <FONT COLOR=BLUE>";
        String compileTime = "<HTML>Compile time (ms): <FONT COLOR=BLUE>";
        if (runResults != null) {
            successMsg = String.valueOf(successMsg) + this.getYesNo(!runResults.failedInCompile());
            resultCode = String.valueOf(resultCode) + runResults.getCompileResultCode();
            compileTime = String.valueOf(compileTime) + runResults.getCompileTimeMS();
        } else {
            successMsg = String.valueOf(successMsg) + " -- ";
            resultCode = String.valueOf(resultCode) + " -- ";
            compileTime = String.valueOf(compileTime) + " -- ";
        }
        successMsg = String.valueOf(successMsg) + "</FONT></HTML>";
        resultCode = String.valueOf(resultCode) + "</FONT></HTML>";
        compileTime = String.valueOf(compileTime) + "</FONT></HTML>";
        this.compileSuccessLabel.setText(successMsg);
        this.compileResultCodeLabel.setText(resultCode);
        this.compileTimeLabel.setText(compileTime);
        if (runResults != null) {
            this.showCompilerOutputButton.setEnabled(true);
        } else {
            this.showCompilerOutputButton.setEnabled(false);
        }
    }

    private String getYesNo(boolean b) {
        if (b) {
            return "Yes";
        }
        return "No";
    }

    private void populateExecutionResults(RunResultFiles runResults) {
        String successMsg = "<HTML>Success: <FONT COLOR=BLUE>";
        String resultCode = "<HTML>Result code: <FONT COLOR=BLUE>";
        String executeTime = "<HTML>Execution time (ms): <FONT COLOR=BLUE>";
        if (runResults != null) {
            successMsg = String.valueOf(successMsg) + this.getYesNo(!runResults.failedInExecute());
            resultCode = String.valueOf(resultCode) + runResults.getExecutionResultCode();
            executeTime = String.valueOf(executeTime) + runResults.getExecuteTimeMS();
        } else {
            successMsg = String.valueOf(successMsg) + " -- ";
            resultCode = String.valueOf(resultCode) + " -- ";
            executeTime = String.valueOf(executeTime) + " -- ";
        }
        successMsg = String.valueOf(successMsg) + "</FONT></HTML>";
        resultCode = String.valueOf(resultCode) + "</FONT></HTML>";
        executeTime = String.valueOf(executeTime) + "</FONT></HTML>";
        this.executionSuccessLabel.setText(successMsg);
        this.executionResultCodeLabel.setText(resultCode);
        this.executionTimeLabel.setText(executeTime);
        if (runResults != null) {
            this.showExecutionOutputButton.setEnabled(true);
        } else {
            this.showExecutionOutputButton.setEnabled(false);
        }
    }

    private void populateValidationResults(RunResultFiles runResults) {
        if (runResults == null) {
            this.validationPanel.setVisible(false);
            return;
        }
        if (!this.getContest().getProblem(runResults.getProblemId()).isValidatedProblem()) {
            this.validationPanel.setVisible(false);
        } else {
            this.validationPanel.setVisible(true);
        }
        String successMsg = "<HTML>Success: <FONT COLOR=BLUE>";
        String resultCode = "<HTML>Result code: <FONT COLOR=BLUE>";
        String validationTime = "<HTML>Validation time (ms): <FONT COLOR=BLUE>";
        String validationAnswer = "<HTML>Judgement: <FONT COLOR=BLUE>";
        successMsg = String.valueOf(successMsg) + this.getYesNo(!runResults.failedInValidating());
        resultCode = String.valueOf(resultCode) + runResults.getValidationResultCode();
        validationTime = String.valueOf(validationTime) + runResults.getValidateTimeMS();
        validationAnswer = String.valueOf(validationAnswer) + this.getJudgement(runResults);
        successMsg = String.valueOf(successMsg) + "</FONT></HTML>";
        resultCode = String.valueOf(resultCode) + "</FONT></HTML>";
        validationTime = String.valueOf(validationTime) + "</FONT></HTML>";
        validationAnswer = String.valueOf(validationAnswer) + "</FONT></HTML>";
        this.validationSuccessLabel.setText(successMsg);
        this.validationResultCodeLabel.setText(resultCode);
        this.validationTimeLabel.setText(validationTime);
        this.validationAnswerLabel.setText(validationAnswer);
        this.showValidationOutputButton.setEnabled(true);
    }

    private String getJudgement(RunResultFiles runResult) {
        try {
            String results = runResult.getValidationResults();
            if (results == null || results.trim().length() == 0) {
                results = this.getContest().getJudgement(runResult.getJudgementId()).toString();
            }
            return results;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void clear() {
        this.closeViewerWindows();
        this.populatePane(null, "Run Results");
    }

    private void initialize() {
        TitledBorder titledBorder1 = BorderFactory.createTitledBorder(null, "Run Results", 1, 0, new Font("Dialog", 1, 14), Color.red);
        titledBorder1.setTitleFont(new Font("Dialog", 1, 16));
        titledBorder1.setBorder(BorderFactory.createEtchedBorder(0));
        this.setLayout(new BoxLayout(this, 0));
        this.setSize(new Dimension(600, 220));
        this.setMinimumSize(new Dimension(100, 200));
        this.setPreferredSize(new Dimension(200, 300));
        this.setBorder(titledBorder1);
        this.add((Component)this.getCompilationPanel(), null);
        this.add((Component)this.getExecutionPanel(), null);
        this.add((Component)this.getValidationPanel(), null);
    }

    @Override
    public String getPluginTitle() {
        return "Run Results Pane";
    }

    private JPanel getCompilationPanel() {
        if (this.compilationPanel == null) {
            this.compileTimeLabel = new JLabel();
            this.compileTimeLabel.setMaximumSize(new Dimension(180, 30));
            this.compileTimeLabel.setMinimumSize(new Dimension(120, 20));
            this.compileTimeLabel.setText("Compile Time (ms): ");
            this.compileTimeLabel.setHorizontalAlignment(10);
            this.compileTimeLabel.setPreferredSize(new Dimension(120, 20));
            this.compileResultCodeLabel = new JLabel();
            this.compileResultCodeLabel.setText("Result Code: ");
            this.compileResultCodeLabel.setMinimumSize(new Dimension(100, 20));
            this.compileResultCodeLabel.setPreferredSize(new Dimension(100, 20));
            this.compileResultCodeLabel.setText("Result Code: ");
            this.compileResultCodeLabel.setHorizontalAlignment(10);
            this.compileResultCodeLabel.setMaximumSize(new Dimension(150, 30));
            this.compileSuccessLabel = new JLabel();
            this.compileSuccessLabel.setText("Successful:  ");
            this.compileSuccessLabel.setHorizontalTextPosition(0);
            this.compileSuccessLabel.setMinimumSize(new Dimension(100, 20));
            this.compileSuccessLabel.setPreferredSize(new Dimension(100, 20));
            this.compileSuccessLabel.setText("Successful: ");
            this.compileSuccessLabel.setMaximumSize(new Dimension(150, 30));
            this.compileSuccessLabel.setHorizontalAlignment(10);
            this.compilationPanel = new JPanel();
            this.compilationPanel.setLayout(new BoxLayout(this.getCompilationPanel(), 1));
            this.compilationPanel.setBorder(BorderFactory.createTitledBorder(null, " Compilation ", 0, 0, new Font("Dialog", 1, 14), Color.blue));
            this.compilationPanel.setPreferredSize(new Dimension(150, 150));
            this.compilationPanel.add((Component)this.compileSuccessLabel, null);
            this.compilationPanel.add((Component)this.compileResultCodeLabel, null);
            this.compilationPanel.add((Component)this.compileTimeLabel, null);
            this.compilationPanel.add((Component)this.getShowCompilerOutputButton(), null);
            this.compilationPanel.setAlignmentY(1.0f);
        }
        return this.compilationPanel;
    }

    private JPanel getExecutionPanel() {
        if (this.executionPanel == null) {
            this.executionTimeLabel = new JLabel();
            this.executionTimeLabel.setText("Execution time (ms): ");
            this.executionTimeLabel.setMinimumSize(new Dimension(110, 20));
            this.executionTimeLabel.setMaximumSize(new Dimension(140, 30));
            this.executionTimeLabel.setText("ExecuteTime (ms): ");
            this.executionTimeLabel.setHorizontalAlignment(10);
            this.executionTimeLabel.setPreferredSize(new Dimension(100, 20));
            this.executionResultCodeLabel = new JLabel();
            this.executionResultCodeLabel.setText("Result Code: ");
            this.executionResultCodeLabel.setMaximumSize(new Dimension(150, 30));
            this.executionResultCodeLabel.setMinimumSize(new Dimension(100, 20));
            this.executionResultCodeLabel.setText("Result Code: ");
            this.executionResultCodeLabel.setPreferredSize(new Dimension(100, 20));
            this.executionResultCodeLabel.setHorizontalAlignment(10);
            this.executionSuccessLabel = new JLabel();
            this.executionSuccessLabel.setText("Successful: ");
            this.executionSuccessLabel.setMinimumSize(new Dimension(100, 20));
            this.executionSuccessLabel.setPreferredSize(new Dimension(100, 20));
            this.executionSuccessLabel.setHorizontalAlignment(10);
            this.executionSuccessLabel.setMaximumSize(new Dimension(150, 30));
            this.executionPanel = new JPanel();
            this.executionPanel.setLayout(new BoxLayout(this.getExecutionPanel(), 1));
            this.executionPanel.setBorder(BorderFactory.createTitledBorder(null, " Execution ", 0, 0, new Font("Dialog", 1, 14), Color.blue));
            this.executionPanel.setPreferredSize(new Dimension(150, 150));
            this.executionPanel.add((Component)this.executionSuccessLabel, null);
            this.executionPanel.add((Component)this.executionResultCodeLabel, null);
            this.executionPanel.add((Component)this.executionTimeLabel, null);
            this.executionPanel.add((Component)this.getShowExecutionOutputButton(), null);
            this.executionPanel.setAlignmentY(1.0f);
        }
        return this.executionPanel;
    }

    private JPanel getValidationPanel() {
        if (this.validationPanel == null) {
            this.validationTimeLabel = new JLabel();
            this.validationTimeLabel.setText("Validation time (ms): ");
            this.validationTimeLabel.setMinimumSize(new Dimension(100, 20));
            this.validationTimeLabel.setMaximumSize(new Dimension(150, 30));
            this.validationTimeLabel.setText("Validation Time (ms): ");
            this.validationTimeLabel.setHorizontalAlignment(10);
            this.validationTimeLabel.setPreferredSize(new Dimension(100, 20));
            this.validationAnswerLabel = new JLabel();
            this.validationAnswerLabel.setText("Judgement: ");
            this.validationAnswerLabel.setMinimumSize(new Dimension(100, 20));
            this.validationAnswerLabel.setPreferredSize(new Dimension(100, 20));
            this.validationAnswerLabel.setHorizontalAlignment(10);
            this.validationAnswerLabel.setMaximumSize(new Dimension(150, 30));
            this.validationResultCodeLabel = new JLabel();
            this.validationResultCodeLabel.setText("Result Code: ");
            this.validationResultCodeLabel.setMinimumSize(new Dimension(100, 20));
            this.validationResultCodeLabel.setPreferredSize(new Dimension(100, 20));
            this.validationResultCodeLabel.setHorizontalAlignment(10);
            this.validationResultCodeLabel.setMaximumSize(new Dimension(150, 30));
            this.validationSuccessLabel = new JLabel();
            this.validationSuccessLabel.setText("Successful: ");
            this.validationSuccessLabel.setMinimumSize(new Dimension(100, 20));
            this.validationSuccessLabel.setPreferredSize(new Dimension(100, 20));
            this.validationSuccessLabel.setHorizontalAlignment(10);
            this.validationSuccessLabel.setMaximumSize(new Dimension(150, 30));
            this.validationPanel = new JPanel();
            this.validationPanel.setLayout(new BoxLayout(this.getValidationPanel(), 1));
            this.validationPanel.setPreferredSize(new Dimension(150, 150));
            this.validationPanel.setComponentOrientation(ComponentOrientation.UNKNOWN);
            this.validationPanel.setBorder(BorderFactory.createTitledBorder(null, " Validation ", 0, 0, new Font("Dialog", 1, 14), Color.blue));
            this.validationPanel.add((Component)this.validationSuccessLabel, null);
            this.validationPanel.add((Component)this.validationResultCodeLabel, null);
            this.validationPanel.add((Component)this.validationTimeLabel, null);
            this.validationPanel.add((Component)this.validationAnswerLabel, null);
            this.validationPanel.add((Component)this.getShowValidationOutputButton(), null);
            this.validationPanel.setAlignmentY(0.84f);
        }
        return this.validationPanel;
    }

    public void closeViewerWindows() {
        this.closeViewer(this.compileFileviewer);
        this.closeViewer(this.executeFileviewer);
        this.closeViewer(this.validateFileviewer);
    }

    private void closeViewer(IFileViewer fileViewer) {
        if (fileViewer != null) {
            fileViewer.dispose();
        }
    }

    private JButton getShowCompilerOutputButton() {
        if (this.showCompilerOutputButton == null) {
            this.showCompilerOutputButton = new JButton();
            this.showCompilerOutputButton.setText("Show");
            this.showCompilerOutputButton.setEnabled(false);
            this.showCompilerOutputButton.setPreferredSize(new Dimension(40, 20));
            this.showCompilerOutputButton.setMaximumSize(new Dimension(100, 30));
            this.showCompilerOutputButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RunResultsPane.this.closeViewer(RunResultsPane.this.compileFileviewer);
                    RunResultsPane.this.compileFileviewer = new MultipleFileViewer(StaticLog.getLog(), "Compiler Output");
                    if (RunResultsPane.this.emptyFile(RunResultsPane.this.theRunResults.getCompilerStderrFile()) && RunResultsPane.this.emptyFile(RunResultsPane.this.theRunResults.getCompilerStdoutFile())) {
                        RunResultsPane.this.compileFileviewer.addTextPane("No output", "***** No output was generated *****");
                    } else {
                        RunResultsPane.this.compileFileviewer.addFilePane("Standard Out", RunResultsPane.this.theRunResults.getCompilerStdoutFile());
                        RunResultsPane.this.compileFileviewer.addFilePane("Standard Error", RunResultsPane.this.theRunResults.getCompilerStderrFile());
                    }
                    RunResultsPane.this.compileFileviewer.setVisible(true);
                }
            });
        }
        return this.showCompilerOutputButton;
    }

    protected boolean emptyFile(SerializedFile file) {
        if (file == null) {
            return true;
        }
        return file.getBuffer().length == 0;
    }

    private JButton getShowExecutionOutputButton() {
        if (this.showExecutionOutputButton == null) {
            this.showExecutionOutputButton = new JButton();
            this.showExecutionOutputButton.setMaximumSize(new Dimension(100, 30));
            this.showExecutionOutputButton.setPreferredSize(new Dimension(40, 20));
            this.showExecutionOutputButton.setText("Show");
            this.showExecutionOutputButton.setEnabled(false);
            this.showExecutionOutputButton.setMinimumSize(new Dimension(40, 20));
            this.showExecutionOutputButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RunResultsPane.this.closeViewer(RunResultsPane.this.executeFileviewer);
                    RunResultsPane.this.executeFileviewer = new MultipleFileViewer(StaticLog.getLog(), "Execution Output");
                    if (RunResultsPane.this.emptyFile(RunResultsPane.this.theRunResults.getExecuteStdoutFile()) && RunResultsPane.this.emptyFile(RunResultsPane.this.theRunResults.getExecuteStderrFile())) {
                        RunResultsPane.this.executeFileviewer.addTextPane("No output", "***** No output was generated *****");
                    } else {
                        RunResultsPane.this.executeFileviewer.addFilePane("Standard Out", RunResultsPane.this.theRunResults.getExecuteStdoutFile());
                        RunResultsPane.this.executeFileviewer.addFilePane("Standard Error", RunResultsPane.this.theRunResults.getExecuteStderrFile());
                    }
                    RunResultsPane.this.executeFileviewer.setVisible(true);
                }
            });
        }
        return this.showExecutionOutputButton;
    }

    private JButton getShowValidationOutputButton() {
        if (this.showValidationOutputButton == null) {
            this.showValidationOutputButton = new JButton();
            this.showValidationOutputButton.setText("Show");
            this.showValidationOutputButton.setMaximumSize(new Dimension(100, 30));
            this.showValidationOutputButton.setMinimumSize(new Dimension(40, 20));
            this.showValidationOutputButton.setEnabled(false);
            this.showValidationOutputButton.setPreferredSize(new Dimension(40, 20));
            this.showValidationOutputButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RunResultsPane.this.closeViewer(RunResultsPane.this.validateFileviewer);
                    RunResultsPane.this.validateFileviewer = new MultipleFileViewer(StaticLog.getLog(), "Validation Output");
                    if (RunResultsPane.this.emptyFile(RunResultsPane.this.theRunResults.getValidatorStdoutFile()) && RunResultsPane.this.emptyFile(RunResultsPane.this.theRunResults.getValidatorStderrFile())) {
                        RunResultsPane.this.validateFileviewer.addTextPane("No output", "***** No output was generated *****");
                    } else {
                        RunResultsPane.this.validateFileviewer.addFilePane("Standard Out", RunResultsPane.this.theRunResults.getValidatorStdoutFile());
                        RunResultsPane.this.validateFileviewer.addFilePane("Standard Error", RunResultsPane.this.theRunResults.getValidatorStderrFile());
                    }
                    RunResultsPane.this.validateFileviewer.setVisible(true);
                }
            });
        }
        return this.showValidationOutputButton;
    }
}

