/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.profile.ProfileCloneSettings;
import edu.csus.ecs.pc2.ui.InvalidFieldValue;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ProfileSavePane
extends JPanePlugin {
    private static final long serialVersionUID = -6767667140640583963L;
    public static final String CLONE_BUTTON_NAME = "Clone";
    public static final String EXPORT_BUTTON_NAME = "Export";
    public static final String CREATE_BUTTON_NAME = "Ok";
    private JPanel buttonPanel = null;
    private JButton saveButton = null;
    private JButton cancelButton = null;
    private JPanel centerPane = null;
    private JCheckBox resetContestTimeCheckBox = null;
    private JLabel profileNameLabel = null;
    private JLabel contestTitleLabel = null;
    private JTextField profileNameTextField = null;
    private JTextField contestTitleTextField = null;
    private JCheckBox copyRunsCheckBox = null;
    private JCheckBox copyLanguagesCheckBox = null;
    private JCheckBox copyProblemsCheckBox = null;
    private JPasswordField contestPasswordTextField = null;
    private JLabel contestPasswordLabel = null;
    private JTextField profileDescriptionTextField = null;
    private JLabel profileDescriptonLabel = null;
    private JPasswordField contestPasswordConfirmTextField = null;
    private JLabel confirmPasswordLabel = null;
    private JCheckBox copyClarificationsCheckBox = null;
    private JCheckBox copyAccountsCheckBox = null;
    private JCheckBox copyGroupsCheckBox = null;
    private JCheckBox copyJudgementsCheckbox = null;
    private JCheckBox copyContestSettingsCheckBox = null;
    private JPanel checkBoxPane = null;
    private JCheckBox copyNotificationsCheckBox = null;
    private JCheckBox copyCategoriesCheckBox = null;

    public ProfileSavePane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(526, 524));
        this.add((Component)this.getButtonPanel(), "South");
        this.add((Component)this.getCenterPane(), "Center");
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(45);
            flowLayout.setVgap(5);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getSaveButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setText(CLONE_BUTTON_NAME);
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfileSavePane.this.processSaveButton();
                }
            });
        }
        return this.saveButton;
    }

    protected void processSaveButton() {
        try {
            this.takeProfileAction(this.saveButton.getText());
        }
        catch (InvalidFieldValue e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage());
        }
    }

    public void setSaveButtonName(String buttonNameText) {
        this.getSaveButton().setText(buttonNameText);
        this.populateGUI(this.getContest().getProfile());
    }

    private void clearAllSettings() {
        this.getProfileNameTextField().setText("");
        this.getProfileDescriptionTextField().setText("");
        this.getContestTitleTextField().setText("");
        this.getContestPasswordTextField().setText("");
        this.getContestPasswordConfirmTextField().setText("");
        this.setCheckBoxesSelected(false);
    }

    private void setCheckBoxesSelected(boolean selected) {
        this.getCopyAccountsCheckBox().setSelected(selected);
        this.getCopyCategoriesCheckBox().setSelected(selected);
        this.getCopyClarificationsCheckBox().setSelected(!selected);
        this.getCopyContestSettingsCheckBox().setSelected(selected);
        this.getCopyGroupsCheckBox().setSelected(selected);
        this.getCopyJudgementsCheckbox().setSelected(selected);
        this.getCopyLanguagesCheckBox().setSelected(selected);
        this.getCopyProblemsCheckBox().setSelected(!selected);
        this.getCopyRunsCheckBox().setSelected(!selected);
        this.getCopyNotificationsCheckBox().setSelected(selected);
        this.getResetContestTimeCheckBox().setSelected(selected);
        this.getResetContestTimeCheckBox().setSelected(selected);
    }

    private void setDefaultCloneSetting() {
        this.setCheckBoxesSelected(true);
    }

    protected void takeProfileAction(String actionText) {
        if (actionText.equalsIgnoreCase(CLONE_BUTTON_NAME)) {
            this.cloneProfile();
        } else if (actionText.equalsIgnoreCase(EXPORT_BUTTON_NAME)) {
            this.exportProfile();
        } else if (actionText.equalsIgnoreCase(CREATE_BUTTON_NAME)) {
            this.createNewProfile();
        } else {
            throw new InvalidFieldValue("Unknown Save button name: " + actionText);
        }
    }

    private void createNewProfile() {
        ProfileCloneSettings settings = this.getProfileCloneSettingsFromFields();
        settings.setCopyLanguages(false);
        settings.setCopyProblems(false);
        settings.setResetContestTimes(false);
        settings.setCopyAccounts(false);
        settings.setCopyContestSettings(false);
        settings.setCopyGroups(false);
        settings.setCopyJudgements(false);
        settings.setCopyNotifications(false);
        settings.setCopyRuns(false);
        settings.setCopyClarifications(false);
        settings.setCopyCategories(false);
        this.getController().cloneProfile(this.getContest().getProfile(), settings, false);
        this.closeWindow();
    }

    private void exportProfile() {
        throw new InvalidFieldValue("Export not implemented");
    }

    private void cloneProfile() {
        ProfileCloneSettings settings = this.getProfileCloneSettingsFromFields();
        if (this.isDupProfileName(settings.getName())) {
            throw new InvalidFieldValue("Profile named " + settings.getName() + " already exists");
        }
        if (settings.isCopyRuns()) {
            this.requireSetting(settings.isCopyProblems(), "Must copy problems to copy runs");
            this.requireSetting(settings.isCopyLanguages(), "Must copy languages to copy runs");
            this.requireSetting(settings.isCopyAccounts(), "Must copy accounts to copy runs");
            this.requireSetting(settings.isCopyJudgements(), "Must copy judgements to copy runs");
        }
        if (settings.isCopyClarifications()) {
            this.requireSetting(settings.isCopyProblems(), "Must copy problems to copy clarifications");
            this.requireSetting(settings.isCopyAccounts(), "Must copy accounts to copy clarifications");
        }
        this.getController().cloneProfile(this.getContest().getProfile(), settings, false);
        this.closeWindow();
    }

    private boolean isDupProfileName(String name) {
        Profile[] profileArray = this.getContest().getProfiles();
        int n = profileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            if (name.trim().equals(profile.getName().trim())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void requireSetting(boolean found, String message) {
        if (!found) {
            throw new InvalidFieldValue(message);
        }
    }

    private ProfileCloneSettings getProfileCloneSettingsFromFields() {
        String name = this.getProfileNameTextField().getText();
        this.checkField(name, "Enter a profile name");
        String description = this.getProfileDescriptionTextField().getText();
        this.checkField(description, "Enter a profile description");
        String title = this.getContestTitleTextField().getText();
        this.checkField(title, "Enter a contest title");
        char[] password = this.getContestPasswordTextField().getPassword();
        char[] confirmPassword = this.getContestPasswordConfirmTextField().getPassword();
        if (password.length == 0) {
            throw new InvalidFieldValue("Contest password must be set");
        }
        if (password.length != confirmPassword.length) {
            throw new InvalidFieldValue("Contest password does not match");
        }
        if (!new String(password).equals(new String(confirmPassword))) {
            throw new InvalidFieldValue("Contest password and Confirm password do not match.");
        }
        ProfileCloneSettings settings = new ProfileCloneSettings(name, description, password, this.getContest().getProfile());
        settings.setContestTitle(title);
        settings.setCopyAccounts(this.getCopyAccountsCheckBox().isSelected());
        settings.setCopyClarifications(this.getCopyClarificationsCheckBox().isSelected());
        settings.setCopyCategories(this.getCopyCategoriesCheckBox().isSelected());
        settings.setCopyContestSettings(this.getCopyContestSettingsCheckBox().isSelected());
        settings.setCopyGroups(this.getCopyGroupsCheckBox().isSelected());
        settings.setCopyJudgements(this.getCopyJudgementsCheckbox().isSelected());
        settings.setCopyLanguages(this.getCopyLanguagesCheckBox().isSelected());
        settings.setCopyNotifications(this.getCopyNotificationsCheckBox().isSelected());
        settings.setCopyProblems(this.getCopyProblemsCheckBox().isSelected());
        settings.setCopyRuns(this.getCopyRunsCheckBox().isSelected());
        settings.setResetContestTimes(this.getResetContestTimeCheckBox().isSelected());
        return settings;
    }

    private void checkField(String string, String comment) {
        if (string == null || string.trim().length() == 0) {
            throw new InvalidFieldValue(comment);
        }
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfileSavePane.this.closeWindow();
                }
            });
        }
        return this.cancelButton;
    }

    protected void closeWindow() {
        this.getParentFrame().setVisible(false);
    }

    @Override
    public String getPluginTitle() {
        return "ProfileSavePane";
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.confirmPasswordLabel = new JLabel();
            this.confirmPasswordLabel.setText("Confirm Password");
            this.confirmPasswordLabel.setBounds(new Rectangle(19, 152, 147, 23));
            this.confirmPasswordLabel.setHorizontalAlignment(4);
            this.profileDescriptonLabel = new JLabel();
            this.profileDescriptonLabel.setBounds(new Rectangle(19, 47, 147, 23));
            this.profileDescriptonLabel.setText("Description");
            this.profileDescriptonLabel.setHorizontalAlignment(4);
            this.contestPasswordLabel = new JLabel();
            this.contestPasswordLabel.setBounds(new Rectangle(19, 117, 147, 23));
            this.contestPasswordLabel.setText("Contest Password");
            this.contestPasswordLabel.setHorizontalAlignment(4);
            this.contestTitleLabel = new JLabel();
            this.contestTitleLabel.setBounds(new Rectangle(19, 82, 147, 23));
            this.contestTitleLabel.setHorizontalAlignment(4);
            this.contestTitleLabel.setText("Contest Title");
            this.profileNameLabel = new JLabel();
            this.profileNameLabel.setBounds(new Rectangle(19, 12, 147, 23));
            this.profileNameLabel.setHorizontalAlignment(4);
            this.profileNameLabel.setText("Profile Name");
            this.centerPane = new JPanel();
            this.centerPane.setLayout(null);
            this.centerPane.add((Component)this.profileNameLabel, null);
            this.centerPane.add((Component)this.contestTitleLabel, null);
            this.centerPane.add((Component)this.getProfileNameTextField(), null);
            this.centerPane.add((Component)this.getContestTitleTextField(), null);
            this.centerPane.add((Component)this.getContestPasswordTextField(), null);
            this.centerPane.add((Component)this.contestPasswordLabel, null);
            this.centerPane.add((Component)this.getProfileDescriptionTextField(), null);
            this.centerPane.add((Component)this.profileDescriptonLabel, null);
            this.centerPane.add((Component)this.getContestPasswordConfirmTextField(), null);
            this.centerPane.add((Component)this.confirmPasswordLabel, null);
            this.centerPane.add((Component)this.getCheckBoxPane(), null);
            this.centerPane.add((Component)this.getResetContestTimeCheckBox(), null);
        }
        return this.centerPane;
    }

    private JCheckBox getResetContestTimeCheckBox() {
        if (this.resetContestTimeCheckBox == null) {
            this.resetContestTimeCheckBox = new JCheckBox();
            this.resetContestTimeCheckBox.setToolTipText("Set elapsed time to zero");
            this.resetContestTimeCheckBox.setSelected(true);
            this.resetContestTimeCheckBox.setSize(new Dimension(192, 21));
            this.resetContestTimeCheckBox.setLocation(new Point(28, 451));
            this.resetContestTimeCheckBox.setText("Reset Contest Times");
        }
        return this.resetContestTimeCheckBox;
    }

    private JTextField getProfileNameTextField() {
        if (this.profileNameTextField == null) {
            this.profileNameTextField = new JTextField();
            this.profileNameTextField.setPreferredSize(new Dimension(6, 22));
            this.profileNameTextField.setSize(new Dimension(273, 25));
            this.profileNameTextField.setLocation(new Point(184, 11));
        }
        return this.profileNameTextField;
    }

    private JTextField getContestTitleTextField() {
        if (this.contestTitleTextField == null) {
            this.contestTitleTextField = new JTextField();
            this.contestTitleTextField.setBounds(new Rectangle(184, 81, 273, 25));
        }
        return this.contestTitleTextField;
    }

    private JCheckBox getCopyRunsCheckBox() {
        if (this.copyRunsCheckBox == null) {
            this.copyRunsCheckBox = new JCheckBox();
            this.copyRunsCheckBox.setSelected(true);
            this.copyRunsCheckBox.setBounds(new Rectangle(33, 56, 132, 21));
            this.copyRunsCheckBox.setText("Runs");
        }
        return this.copyRunsCheckBox;
    }

    private JCheckBox getCopyLanguagesCheckBox() {
        if (this.copyLanguagesCheckBox == null) {
            this.copyLanguagesCheckBox = new JCheckBox();
            this.copyLanguagesCheckBox.setSelected(true);
            this.copyLanguagesCheckBox.setBounds(new Rectangle(264, 19, 160, 21));
            this.copyLanguagesCheckBox.setText("Languages");
        }
        return this.copyLanguagesCheckBox;
    }

    private JCheckBox getCopyProblemsCheckBox() {
        if (this.copyProblemsCheckBox == null) {
            this.copyProblemsCheckBox = new JCheckBox();
            this.copyProblemsCheckBox.setSelected(false);
            this.copyProblemsCheckBox.setBounds(new Rectangle(33, 25, 132, 21));
            this.copyProblemsCheckBox.setText("Problems");
        }
        return this.copyProblemsCheckBox;
    }

    public void populateGUI(Profile profile) {
        this.getProfileNameTextField().setText("Copy of " + profile.getName());
        this.getProfileDescriptionTextField().setText(profile.getDescription());
        ContestInformation contestInformation = this.getContest().getContestInformation();
        String title = contestInformation.getContestTitle();
        if (title == null) {
            title = "";
        }
        this.getContestTitleTextField().setText(title);
        this.getContestPasswordTextField().setText("");
        this.getContestPasswordConfirmTextField().setText("");
        this.getCheckBoxPane().setVisible(true);
        this.getResetContestTimeCheckBox().setVisible(true);
        String buttonNameText = this.getSaveButton().getText();
        if (buttonNameText.equalsIgnoreCase(CLONE_BUTTON_NAME)) {
            this.setDefaultCloneSetting();
        } else if (buttonNameText.equalsIgnoreCase(EXPORT_BUTTON_NAME)) {
            this.setDefaultCloneSetting();
        } else if (buttonNameText.equalsIgnoreCase(CREATE_BUTTON_NAME)) {
            this.clearAllSettings();
            this.getCheckBoxPane().setVisible(false);
            this.getResetContestTimeCheckBox().setVisible(false);
        } else {
            this.showMessage("Unable to take action: " + buttonNameText);
        }
    }

    private JPasswordField getContestPasswordTextField() {
        if (this.contestPasswordTextField == null) {
            this.contestPasswordTextField = new JPasswordField();
            this.contestPasswordTextField.setBounds(new Rectangle(184, 116, 124, 25));
        }
        return this.contestPasswordTextField;
    }

    protected void changeEchoChar(boolean hideText) {
        if (hideText) {
            this.getContestPasswordTextField().setEchoChar('*');
        } else {
            this.getContestPasswordTextField().setEchoChar('\u0000');
        }
    }

    private JTextField getProfileDescriptionTextField() {
        if (this.profileDescriptionTextField == null) {
            this.profileDescriptionTextField = new JTextField();
            this.profileDescriptionTextField.setBounds(new Rectangle(184, 46, 273, 25));
        }
        return this.profileDescriptionTextField;
    }

    private JPasswordField getContestPasswordConfirmTextField() {
        if (this.contestPasswordConfirmTextField == null) {
            this.contestPasswordConfirmTextField = new JPasswordField();
            this.contestPasswordConfirmTextField.setBounds(new Rectangle(184, 151, 124, 25));
            this.contestPasswordConfirmTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ProfileSavePane.this.processSaveButton();
                    }
                }
            });
        }
        return this.contestPasswordConfirmTextField;
    }

    private JCheckBox getCopyClarificationsCheckBox() {
        if (this.copyClarificationsCheckBox == null) {
            this.copyClarificationsCheckBox = new JCheckBox();
            this.copyClarificationsCheckBox.setText("Clarifications");
            this.copyClarificationsCheckBox.setBounds(new Rectangle(33, 84, 132, 24));
            this.copyClarificationsCheckBox.setSelected(true);
        }
        return this.copyClarificationsCheckBox;
    }

    private JCheckBox getCopyAccountsCheckBox() {
        if (this.copyAccountsCheckBox == null) {
            this.copyAccountsCheckBox = new JCheckBox();
            this.copyAccountsCheckBox.setText("Accounts");
            this.copyAccountsCheckBox.setBounds(new Rectangle(264, 50, 160, 24));
            this.copyAccountsCheckBox.setSelected(true);
        }
        return this.copyAccountsCheckBox;
    }

    private JCheckBox getCopyGroupsCheckBox() {
        if (this.copyGroupsCheckBox == null) {
            this.copyGroupsCheckBox = new JCheckBox();
            this.copyGroupsCheckBox.setText("Groups");
            this.copyGroupsCheckBox.setBounds(new Rectangle(264, 84, 160, 24));
            this.copyGroupsCheckBox.setSelected(true);
        }
        return this.copyGroupsCheckBox;
    }

    private JCheckBox getCopyJudgementsCheckbox() {
        if (this.copyJudgementsCheckbox == null) {
            this.copyJudgementsCheckbox = new JCheckBox();
            this.copyJudgementsCheckbox.setText("Judgements");
            this.copyJudgementsCheckbox.setBounds(new Rectangle(264, 118, 160, 24));
            this.copyJudgementsCheckbox.setSelected(true);
        }
        return this.copyJudgementsCheckbox;
    }

    private JCheckBox getCopyContestSettingsCheckBox() {
        if (this.copyContestSettingsCheckBox == null) {
            this.copyContestSettingsCheckBox = new JCheckBox();
            this.copyContestSettingsCheckBox.setText("Contest settings");
            this.copyContestSettingsCheckBox.setBounds(new Rectangle(264, 186, 160, 24));
            this.copyContestSettingsCheckBox.setSelected(true);
        }
        return this.copyContestSettingsCheckBox;
    }

    private JPanel getCheckBoxPane() {
        if (this.checkBoxPane == null) {
            this.checkBoxPane = new JPanel();
            this.checkBoxPane.setLayout(null);
            this.checkBoxPane.setBounds(new Rectangle(3, 186, 477, 255));
            this.checkBoxPane.setBorder(BorderFactory.createTitledBorder(null, "Copy:", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.checkBoxPane.add((Component)this.getCopyLanguagesCheckBox(), null);
            this.checkBoxPane.add((Component)this.getCopyProblemsCheckBox(), null);
            this.checkBoxPane.add((Component)this.getCopyClarificationsCheckBox(), null);
            this.checkBoxPane.add((Component)this.getCopyRunsCheckBox(), null);
            this.checkBoxPane.add((Component)this.getCopyContestSettingsCheckBox(), null);
            this.checkBoxPane.add((Component)this.getCopyJudgementsCheckbox(), null);
            this.checkBoxPane.add((Component)this.getCopyGroupsCheckBox(), null);
            this.checkBoxPane.add((Component)this.getCopyAccountsCheckBox(), null);
            this.checkBoxPane.add((Component)this.getCopyNotificationsCheckBox(), null);
            this.checkBoxPane.add((Component)this.getCopyCategoriesCheckBox(), null);
        }
        return this.checkBoxPane;
    }

    private JCheckBox getCopyNotificationsCheckBox() {
        if (this.copyNotificationsCheckBox == null) {
            this.copyNotificationsCheckBox = new JCheckBox();
            this.copyNotificationsCheckBox.setBounds(new Rectangle(264, 152, 160, 24));
            this.copyNotificationsCheckBox.setText("Notifications");
            this.copyNotificationsCheckBox.setSelected(true);
        }
        return this.copyNotificationsCheckBox;
    }

    private JCheckBox getCopyCategoriesCheckBox() {
        if (this.copyCategoriesCheckBox == null) {
            this.copyCategoriesCheckBox = new JCheckBox();
            this.copyCategoriesCheckBox.setBounds(new Rectangle(264, 220, 160, 21));
            this.copyCategoriesCheckBox.setSelected(true);
            this.copyCategoriesCheckBox.setText("Categories");
        }
        return this.copyCategoriesCheckBox;
    }
}

