/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.core.report.ProblemsReport;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.EditJudgesDataFilePathFrame;
import edu.csus.ecs.pc2.ui.EditProblemFrame;
import edu.csus.ecs.pc2.ui.EditProblemFrameNew;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ProblemsPane
extends JPanePlugin {
    private static final long serialVersionUID = -7483784815760107250L;
    private JPanel problemButtonPane = null;
    private MCLB problemListBox = null;
    private JButton addButton = null;
    private JButton copyButton = null;
    private JButton editButton = null;
    private JPanel messagePanel = null;
    private JLabel messageLabel = null;
    private Log log = null;
    private EditProblemFrame editProblemFrame = null;
    private EditProblemFrameNew editProblemFrameNew = null;
    private JButton reportButton = null;
    private JPanel centerPanel;
    private JButton setJudgesDataPathButton;
    private EditJudgesDataFilePathFrame editCDPPathFrame;

    public ProblemsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(564, 229));
        this.add((Component)this.getMessagePanel(), "North");
        this.add((Component)this.getCenterPanel(), "Center");
        this.add((Component)this.getProblemButtonPane(), "South");
        this.editProblemFrame = new EditProblemFrame();
        this.editProblemFrameNew = new EditProblemFrameNew();
    }

    @Override
    public String getPluginTitle() {
        return "Problems Pane";
    }

    private JPanel getProblemButtonPane() {
        if (this.problemButtonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.problemButtonPane = new JPanel();
            this.problemButtonPane.setLayout(flowLayout);
            this.problemButtonPane.setPreferredSize(new Dimension(35, 35));
            this.problemButtonPane.add((Component)this.getAddButton(), null);
            this.problemButtonPane.add((Component)this.getCopyButton(), null);
            this.problemButtonPane.add((Component)this.getEditButton(), null);
            this.problemButtonPane.add((Component)this.getReportButton(), null);
            this.problemButtonPane.add(this.getSetJudgesDataPathButton());
        }
        return this.problemButtonPane;
    }

    private MCLB getProblemListBox() {
        if (this.problemListBox == null) {
            this.problemListBox = new MCLB();
            Object[] cols = new Object[]{"Problem Name", "Data File", "Answer File", "Input Method", "Judging Type", "short", "Time Limit", "SVTJ", "Validator"};
            this.problemListBox.addColumns(cols);
            this.problemListBox.autoSizeAllColumns();
        }
        return this.problemListBox;
    }

    public void updateProblemRow(final Problem problem) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] objects = ProblemsPane.this.buildProblemRow(problem);
                int rowNumber = ProblemsPane.this.problemListBox.getIndexByKey(problem.getElementId());
                if (rowNumber == -1) {
                    ProblemsPane.this.problemListBox.addRow(objects, problem.getElementId());
                } else {
                    ProblemsPane.this.problemListBox.replaceRow(objects, rowNumber);
                }
                ProblemsPane.this.problemListBox.autoSizeAllColumns();
            }
        });
    }

    private String yesNoString(boolean b) {
        if (b) {
            return "Yes";
        }
        return "No";
    }

    protected Object[] buildProblemRow(Problem problem) {
        int numberColumns = this.problemListBox.getColumnCount();
        Object[] c = new String[numberColumns];
        int i = 0;
        String name = problem.getDisplayName();
        if (!problem.isActive()) {
            name = "[HIDDEN] " + name;
        }
        c[i++] = name;
        c[i++] = problem.getDataFileName();
        c[i++] = problem.getAnswerFileName();
        String inputMethod = "";
        inputMethod = problem.isReadInputDataFromSTDIN() ? "STDIN" : (problem.getDataFileName() != null ? "File I/O" : "(none)");
        c[i++] = inputMethod;
        String judgingType = "";
        if (problem.isComputerJudged()) {
            judgingType = "Computer";
            if (problem.isManualReview()) {
                judgingType = "Computer+Manual";
                if (problem.isPrelimaryNotification()) {
                    judgingType = "Computer+Manual/Notify";
                }
            }
        } else {
            judgingType = problem.isValidatedProblem() ? "Manual w/Val." : "Manual";
        }
        c[i++] = judgingType;
        c[i++] = problem.getShortName();
        c[i++] = Integer.toString(problem.getTimeOutInSeconds());
        c[i++] = this.yesNoString(problem.isShowValidationToJudges());
        String validatorName = problem.getValidatorProgramName();
        if (problem.isValidatedProblem() && !problem.isUsingPC2Validator()) {
            validatorName = problem.getValidatorCommandLine();
        }
        c[i++] = validatorName;
        return c;
    }

    protected void copySelectedProblem() {
        int selectedIndex = this.problemListBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("Select a problem to copy");
            return;
        }
        try {
            this.problemListBox.deselectAllRows();
            ElementId elementId = (ElementId)this.problemListBox.getKeys()[selectedIndex];
            Problem sourceProblem = this.getContest().getProblem(elementId);
            String newProblemName = this.promptForProblemName(sourceProblem.getDisplayName());
            if (newProblemName == null || newProblemName.trim().length() == 0) {
                this.showMessage("Copy Aborted.");
            } else {
                Problem newProblem = sourceProblem.copy(newProblemName);
                ProblemDataFiles pdf = this.getController().getProblemDataFiles(sourceProblem);
                ProblemDataFiles newProblemDataFiles = null;
                if (pdf != null) {
                    newProblemDataFiles = pdf.copy(newProblem);
                }
                this.editProblemFrame.setProblemCopy(newProblem, newProblemDataFiles);
                this.editProblemFrame.setVisible(true);
            }
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to clone problem, check log (" + e.getMessage() + ")");
        }
    }

    private String promptForProblemName(String problemName) {
        String s = (String)JOptionPane.showInputDialog(this, "Enter new name:\n", "Copying problem '" + problemName + "'", 3, null, null, null);
        return s;
    }

    private void reloadListBox() {
        Problem[] problems;
        this.problemListBox.removeAllRows();
        Problem[] problemArray = problems = this.getContest().getProblems();
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            this.addProblemRow(problem);
            ++n2;
        }
    }

    private void addProblemRow(Problem problem) {
        Object[] objects = this.buildProblemRow(problem);
        this.problemListBox.addRow(objects, problem.getElementId());
        this.problemListBox.autoSizeAllColumns();
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.editProblemFrame.setContestAndController(inContest, inController);
        this.editProblemFrameNew.setContestAndController(inContest, inController);
        this.getContest().addProblemListener(new ProblemListenerImplementation());
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.getContest().addContestInformationListener(new ContestInformationListenerImplementation());
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProblemsPane.this.updateGUIperPermissions();
                ProblemsPane.this.populateGUI();
                ProblemsPane.this.enableUpdateButtons();
            }
        });
    }

    protected void enableUpdateButtons() {
    }

    private void updateGUIperPermissions() {
        this.getAddButton().setVisible(this.isAllowed(Permission.Type.ADD_PROBLEM));
        this.getEditButton().setVisible(this.isAllowed(Permission.Type.EDIT_PROBLEM));
        this.getCopyButton().setVisible(this.isAllowed(Permission.Type.EDIT_PROBLEM));
        this.getSetJudgesDataPathButton().setVisible(this.isAllowed(Permission.Type.EDIT_PROBLEM));
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setMnemonic(65);
            this.addButton.setToolTipText("Add new Problem definition");
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProblemsPane.this.addProblem();
                }
            });
        }
        return this.addButton;
    }

    protected void addProblem() {
        if (Utilities.isDebugMode()) {
            int result = FrameUtilities.yesNoCancelDialog(this, "Do you want to use  EditProblemFrameNew ? ", "TEMPORARY DEBUGGING THING. debug 22");
            if (result == 0) {
                this.editProblemFrameNew.setProblem(null);
                this.editProblemFrameNew.setVisible(true);
            } else {
                this.editProblemFrame.setProblem(null);
                this.editProblemFrame.setVisible(true);
            }
        } else {
            this.editProblemFrame.setProblem(null);
            this.editProblemFrame.setVisible(true);
        }
    }

    private JButton getCopyButton() {
        if (this.copyButton == null) {
            this.copyButton = new JButton();
            this.copyButton.setText("Copy");
            this.copyButton.setMnemonic(67);
            this.copyButton.setToolTipText("Copy settings from an existing problem to a new problem");
            this.copyButton.setActionCommand("Copy");
            this.copyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProblemsPane.this.copySelectedProblem();
                }
            });
        }
        return this.copyButton;
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit");
            this.editButton.setMnemonic(69);
            this.editButton.setToolTipText("Edit existing Problem definition");
            this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProblemsPane.this.editSelectedProblem();
                }
            });
        }
        return this.editButton;
    }

    protected void editSelectedProblem() {
        int selectedIndex = this.problemListBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("Select a problem to edit");
            return;
        }
        try {
            ElementId elementId = (ElementId)this.problemListBox.getKeys()[selectedIndex];
            Problem problemToEdit = this.getContest().getProblem(elementId);
            ProblemDataFiles newProblemDataFiles = this.getController().getProblemDataFiles(problemToEdit);
            if (Utilities.isDebugMode()) {
                int result = FrameUtilities.yesNoCancelDialog(this, "Do you want to use  EditProblemFrameNew ? ", "TEMPORARY DEBUGGING THING. debug 22");
                if (result == 0) {
                    this.editProblemFrameNew.setProblemCopy(problemToEdit, newProblemDataFiles);
                    if (problemToEdit.isUsingExternalDataFiles()) {
                        this.editProblemFrameNew.setTitle("Edit Problem " + problemToEdit.getDisplayName() + " (" + problemToEdit.getExternalDataFileLocation() + ")");
                    } else {
                        this.editProblemFrameNew.setTitle("Edit Problem " + problemToEdit.getDisplayName());
                    }
                    this.editProblemFrameNew.setVisible(true);
                } else {
                    this.editProblemFrame.setProblemCopy(problemToEdit, newProblemDataFiles);
                    if (problemToEdit.isUsingExternalDataFiles()) {
                        this.editProblemFrame.setTitle("Edit Problem " + problemToEdit.getDisplayName() + " (" + problemToEdit.getExternalDataFileLocation() + ")");
                    } else {
                        this.editProblemFrame.setTitle("Edit Problem " + problemToEdit.getDisplayName());
                    }
                    this.editProblemFrame.setVisible(true);
                }
            } else {
                this.editProblemFrame.setProblemCopy(problemToEdit, newProblemDataFiles);
                if (problemToEdit.isUsingExternalDataFiles()) {
                    this.editProblemFrame.setTitle("Edit Problem " + problemToEdit.getDisplayName() + " (" + problemToEdit.getExternalDataFileLocation() + ")");
                } else {
                    this.editProblemFrame.setTitle("Edit Problem " + problemToEdit.getDisplayName());
                }
                this.editProblemFrame.setVisible(true);
            }
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to edit problem, check log (" + e.getMessage() + ")");
        }
    }

    private JPanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePanel = new JPanel();
            this.messagePanel.setLayout(new BorderLayout());
            this.messagePanel.setPreferredSize(new Dimension(25, 25));
            this.messagePanel.add((Component)this.messageLabel, "Center");
        }
        return this.messagePanel;
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string, "Problems pane message", 1);
    }

    protected void populateGUI() {
        this.reloadListBox();
    }

    private JButton getReportButton() {
        if (this.reportButton == null) {
            this.reportButton = new JButton();
            this.reportButton.setText("Report");
            this.reportButton.setMnemonic(82);
            this.reportButton.setToolTipText("View Problems Report");
            this.reportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProblemsPane.this.viewReports();
                }
            });
        }
        return this.reportButton;
    }

    protected void viewReports() {
        Utilities.viewReport(new ProblemsReport(), "Problems Report ", this.getContest(), this.getController());
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BorderLayout(0, 0));
            this.centerPanel.add((Component)((Object)this.getProblemListBox()), "Center");
        }
        return this.centerPanel;
    }

    private JButton getSetJudgesDataPathButton() {
        if (this.setJudgesDataPathButton == null) {
            this.setJudgesDataPathButton = new JButton("Set Judge's Data Path");
            this.setJudgesDataPathButton.setMnemonic(83);
            this.setJudgesDataPathButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProblemsPane.this.editJudgesDataFilePath();
                }
            });
            this.setJudgesDataPathButton.setToolTipText("Specify a path to external data files on the Judge machines");
        }
        return this.setJudgesDataPathButton;
    }

    private void editJudgesDataFilePath() {
        this.getEditCDPFrame().setContestAndController(this.getContest(), this.getController());
        this.getEditCDPFrame().loadCurrentCDPPathsIntoGUI();
        this.getEditCDPFrame().setVisible(true);
    }

    private EditJudgesDataFilePathFrame getEditCDPFrame() {
        if (this.editCDPPathFrame == null) {
            this.editCDPPathFrame = new EditJudgesDataFilePathFrame();
        }
        return this.editCDPPathFrame;
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        @Override
        public void accountAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountModified(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (ProblemsPane.this.getContest().getClientId().equals(account.getClientId())) {
                ProblemsPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProblemsPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        @Override
        public void accountsAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            Account[] accountArray = accounts = accountEvent.getAccounts();
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (ProblemsPane.this.getContest().getClientId().equals(account.getClientId())) {
                    ProblemsPane.this.initializePermissions();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProblemsPane.this.updateGUIperPermissions();
                        }
                    });
                }
                ++n2;
            }
        }

        @Override
        public void accountsRefreshAll(AccountEvent accountEvent) {
            ProblemsPane.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProblemsPane.this.updateGUIperPermissions();
                }
            });
        }
    }

    class ContestInformationListenerImplementation
    implements IContestInformationListener {
        ContestInformationListenerImplementation() {
        }

        @Override
        public void finalizeDataChanged(ContestInformationEvent contestInformationEvent) {
        }

        @Override
        public void contestInformationRemoved(ContestInformationEvent event) {
        }

        @Override
        public void contestInformationRefreshAll(ContestInformationEvent contestInformationEvent) {
        }

        @Override
        public void contestInformationChanged(ContestInformationEvent event) {
        }

        @Override
        public void contestInformationAdded(ContestInformationEvent event) {
        }
    }

    private class ProblemListenerImplementation
    implements IProblemListener {
        private ProblemListenerImplementation() {
        }

        @Override
        public void problemAdded(final ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProblemsPane.this.updateProblemRow(event.getProblem());
                }
            });
        }

        @Override
        public void problemChanged(final ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProblemsPane.this.updateProblemRow(event.getProblem());
                }
            });
        }

        @Override
        public void problemRemoved(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProblemsPane.this.populateGUI();
                }
            });
        }

        @Override
        public void problemRefreshAll(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProblemsPane.this.populateGUI();
                }
            });
        }
    }
}

