/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IPlayBackEventListener;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.PlayBackEvent;
import edu.csus.ecs.pc2.core.model.PlaybackInfo;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.model.playback.PlaybackManager;
import edu.csus.ecs.pc2.core.model.playback.PlaybackRecord;
import edu.csus.ecs.pc2.core.model.playback.ReplayEvent;
import edu.csus.ecs.pc2.core.model.playback.ReplayEventDetails;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.AccountColumnComparator;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IntegerDocument;
import edu.csus.ecs.pc2.ui.JFramePlugin;
import edu.csus.ecs.pc2.ui.JFramePluginImpl;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import edu.csus.ecs.pc2.ui.MessageMonitorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PlaybackPane
extends JPanePlugin {
    private static final long serialVersionUID = -1344873174060871842L;
    private JPanel centerPane = null;
    private JPanel buttonPane = null;
    private MCLB eventsListBox = null;
    private JButton startButton = null;
    private JButton stopButton = null;
    private JButton resetButton = null;
    private JPanel topPane = null;
    private JTextField timeWarpTextField = null;
    private JLabel msLabel = null;
    private JLabel stopAtLabel = null;
    private JTextField stopEventNumberTextField = null;
    private JRadioButton everyMSEventPacing = null;
    private ButtonGroup timeWarpButtonGroup = null;
    private JButton stepButton = null;
    private JButton loadButton = null;
    private JLabel currentEventLabel = null;
    private JTextField minEventsTextField = null;
    private JLabel iterateTitleLabel = null;
    private PlaybackManager manager = new PlaybackManager();
    private JFramePlugin messageFrame = null;
    private JButton reportButton = null;
    private PlaybackRecord currentRecord;

    public PlaybackPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(594, 304));
        this.add((Component)this.getCenterPane(), "West");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getTopPane(), "North");
        this.add((Component)((Object)this.getEventsListBox()), "Center");
        this.currentEventLabel.setText("At (start)");
    }

    @Override
    public String getPluginTitle() {
        return "Contest Playback";
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.centerPane = new JPanel();
            this.centerPane.setLayout(new GridBagLayout());
        }
        return this.centerPane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getStartButton(), null);
            this.buttonPane.add((Component)this.getStopButton(), null);
            this.buttonPane.add((Component)this.getResetButton(), null);
            this.buttonPane.add((Component)this.getReportButton(), null);
            this.buttonPane.add((Component)this.getLoadButton(), null);
        }
        return this.buttonPane;
    }

    private MCLB getEventsListBox() {
        if (this.eventsListBox == null) {
            this.eventsListBox = new MCLB();
            Object[] cols = new Object[]{"Seq", "Site", "Who", "Event", "Id", "When", "State", "Details"};
            this.eventsListBox.addColumns(cols);
            cols = null;
            HeapSorter sorter = new HeapSorter();
            HeapSorter numericStringSorter = new HeapSorter();
            numericStringSorter.setComparator((Comparator)new NumericStringComparator());
            HeapSorter accountNameSorter = new HeapSorter();
            accountNameSorter.setComparator((Comparator)new AccountColumnComparator());
            int idx = 0;
            this.eventsListBox.setColumnSorter(idx++, numericStringSorter, 1);
            this.eventsListBox.setColumnSorter(idx++, sorter, 2);
            this.eventsListBox.setColumnSorter(idx++, accountNameSorter, 3);
            this.eventsListBox.setColumnSorter(idx++, sorter, 4);
            this.eventsListBox.setColumnSorter(idx++, numericStringSorter, 5);
            this.eventsListBox.setColumnSorter(idx++, numericStringSorter, 6);
            this.eventsListBox.setColumnSorter(idx++, sorter, 7);
            this.eventsListBox.setColumnSorter(idx++, sorter, 8);
        }
        return this.eventsListBox;
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.initializePermissions();
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.getContest().addPlayBackEventListener(new PlayBackEventListener());
        this.getContest().addRunListener(new RunListenerImplementation());
        this.manager = this.getContest().getPlaybackManager();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlaybackPane.this.updateGUIperPermissions();
                PlaybackInfo[] infos = PlaybackPane.this.getContest().getPlaybackInfos();
                if (infos.length > 0) {
                    PlaybackPane.this.updatePlaybackInfo(PlaybackPane.this.getContest().getPlaybackInfos()[0]);
                }
            }
        });
    }

    public String[] buildPlayBackRow(PlaybackRecord playbackRecord) {
        Object[] strings = new String[this.eventsListBox.getColumnCount()];
        ReplayEvent replayEvent = playbackRecord.getReplayEvent();
        ReplayEventDetails details = replayEvent.getEventDetails();
        strings[0] = "" + playbackRecord.getSequenceNumber();
        strings[1] = Integer.toString(replayEvent.getClientId().getSiteNumber());
        Site site = this.getContest().getSite(replayEvent.getClientId().getSiteNumber());
        if (site != null) {
            String name = site.getDisplayName();
            strings[1] = String.valueOf(Integer.toString(replayEvent.getClientId().getSiteNumber())) + " " + this.stringElipsis(name, 11) + " ";
        }
        strings[2] = replayEvent.getClientId().getName();
        strings[3] = replayEvent.getEventType().toString();
        strings[4] = Integer.toString(playbackRecord.getId());
        strings[5] = Long.toString(replayEvent.getEventTime());
        strings[6] = "" + (Object)((Object)playbackRecord.getEventStatus());
        switch (playbackRecord.getReplayEvent().getEventType()) {
            case RUN_SUBMIT: {
                strings[7] = this.getDetails(playbackRecord);
                break;
            }
            case RUN_JUDGEMENT: {
                JudgementRecord judgementRecord = details.getJudgementRecord();
                ElementId id = judgementRecord.getJudgementId();
                if (id != null) {
                    Judgement judgement = this.getContest().getJudgement(id);
                    strings[7] = judgement.getDisplayName();
                    break;
                }
                strings[7] = "Undefined judgement: " + id;
                break;
            }
            default: {
                Arrays.fill(strings, "");
                strings[0] = "" + playbackRecord.getSequenceNumber();
                strings[3] = ReplayEvent.EventType.UNDEFINED.toString();
            }
        }
        return strings;
    }

    protected String stringElipsis(String name, int maxlen) {
        if (name.length() > maxlen + 2 && name.length() > 4) {
            return String.valueOf(name.substring(0, maxlen - 3)) + "...";
        }
        return name;
    }

    private String getDetails(PlaybackRecord record) {
        Language language;
        Problem problem;
        ReplayEvent event = record.getReplayEvent();
        Run run = event.getEventDetails().getRun();
        String probName = "?";
        ElementId problemId = run.getProblemId();
        if (problemId != null && (problem = this.getContest().getProblem(problemId)) != null) {
            probName = problem.getDisplayName();
        }
        String langName = "?";
        ElementId languageId = run.getLanguageId();
        if (languageId != null && (language = this.getContest().getLanguage(languageId)) != null) {
            langName = language.getDisplayName();
        }
        return String.valueOf(probName) + ", " + langName;
    }

    public void addSampleEventRows() {
        ClientId clientId = new ClientId(2, ClientType.Type.TEAM, 22);
        ReplayEvent playbackEvent = new ReplayEvent(ReplayEvent.EventType.UNDEFINED, clientId);
        PlaybackRecord record = this.createNewPlayback(playbackEvent, this.eventsListBox.getRowCount());
        Object[] row = this.buildPlayBackRow(record);
        this.eventsListBox.addRow(row);
        this.eventsListBox.autoSizeAllColumns();
        int i = 0;
        while (i < this.eventsListBox.getColumnCount()) {
            this.eventsListBox.autoSizeColumn(i);
            ++i;
        }
    }

    private PlaybackRecord createNewPlayback(ReplayEvent replayEvent, int sequenceNumber) {
        return new PlaybackRecord(replayEvent, sequenceNumber);
    }

    private JButton getStartButton() {
        if (this.startButton == null) {
            this.startButton = new JButton();
            this.startButton.setText("Start");
            this.startButton.setMnemonic(83);
            this.startButton.setToolTipText("Start running events");
            this.startButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlaybackPane.this.startRunningEvents();
                }
            });
        }
        return this.startButton;
    }

    protected void startRunningEvents() {
        int currentEventNumber;
        if (!this.isAllowed(Permission.Type.START_PLAYBACK)) {
            this.logMessage("Not allowed to start playback");
            JOptionPane.showMessageDialog(this, "Not allowed to start playback");
            return;
        }
        final PlaybackInfo playbackInfo = this.manager.getPlaybackInfo();
        playbackInfo.setStarted(true);
        String intValueString = this.getMinEventsTextField().getText();
        int minEvents = 0;
        if (intValueString.length() > 0) {
            minEvents = Integer.parseInt(intValueString);
        }
        playbackInfo.setMinimumPlaybackRecords(minEvents);
        if (ClientType.isAdmin(this.getContest().getClientId())) {
            this.getController().startPlayback(playbackInfo);
            System.err.println("debug 22 started " + playbackInfo);
            return;
        }
        try {
            this.getController().startPlayback(playbackInfo);
            System.err.println("debug 22 started " + playbackInfo);
        }
        catch (Exception e1) {
            e1.printStackTrace(System.err);
            this.logMessage("Unable to start playback " + e1.getMessage(), e1);
            JOptionPane.showMessageDialog(this, "Unable to start playback " + e1.getMessage());
        }
        if (this.eventsListBox.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No events defined");
            return;
        }
        if (this.manager.allEventsExecuted()) {
            JOptionPane.showMessageDialog(this, "All events executed");
            return;
        }
        String lastEventString = this.getStopEventNumberTextField().getText();
        int lastEventToRunTo = Integer.MAX_VALUE;
        if (lastEventString.trim().length() > 0) {
            lastEventToRunTo = Integer.parseInt(lastEventString);
        }
        if ((currentEventNumber = this.manager.getSequenceNumber()) == lastEventToRunTo) {
            JOptionPane.showMessageDialog(this, "Already before event " + lastEventToRunTo);
            return;
        }
        if (currentEventNumber > lastEventToRunTo) {
            JOptionPane.showMessageDialog(this, "Way after event " + lastEventToRunTo + " dude (at event " + (currentEventNumber - 1) + ")");
            return;
        }
        int waitTime = Integer.parseInt(this.getTimeWarpTextField().getText());
        playbackInfo.setWaitBetweenEventsMS(waitTime);
        if (lastEventToRunTo > this.manager.getPlaybackRecords().length) {
            lastEventToRunTo = this.manager.getPlaybackRecords().length;
        }
        this.setRunningButtons(true);
        this.getContest().getPlaybackManager().startPlayback(this.getContest(), this.getController(), new Runnable(){

            @Override
            public void run() {
                PlaybackPane.this.updatePlaybackInfo(playbackInfo);
            }
        });
    }

    protected void populateGUI(PlaybackInfo info) {
        this.populateGUI(info, false);
    }

    protected void populateGUI(PlaybackInfo info, boolean forcePlaybackGridRefresh) {
        this.getTimeWarpTextField().setText(Integer.toString(info.getWaitBetweenEventsMS()));
        this.getMinEventsTextField().setText(Integer.toString(info.getMinimumPlaybackRecords()));
        this.setRunningButtons(this.manager.isPlaybackRunning());
        Object[] records = this.manager.getPlaybackRecords();
        if (records.length > 0 && this.getEventsListBox().getRowCount() < records.length || forcePlaybackGridRefresh) {
            int rowCount = records.length;
            Object[][] rowValues = new Object[rowCount][this.eventsListBox.getColumnCount()];
            int i = 0;
            while (i < rowCount) {
                PlaybackRecord record = records[i];
                rowValues[i] = this.buildPlayBackRow(record);
                ++i;
            }
            this.getEventsListBox().removeAllRows();
            this.getEventsListBox().addRows(rowValues, records);
            this.getEventsListBox().autoSizeAllColumns();
            this.getEventsListBox().sort();
        }
    }

    protected void updatePlaybackInfo(PlaybackInfo info) {
        this.populateGUI(info);
        this.currentRecord = null;
        String eventInfo = "";
        if (info.getSequenceNumber() > 0) {
            this.currentRecord = this.manager.getPlaybackRecords()[info.getSequenceNumber() - 1];
            eventInfo = " status=" + (Object)((Object)this.currentRecord.getEventStatus()) + " " + this.currentRecord.getReplayEvent();
        }
        this.getController().getLog().info("Playback running=" + this.manager.isPlaybackRunning() + " sequence " + info.getSequenceNumber() + eventInfo);
        int numleft = this.manager.getPlaybackInfo().getMinimumPlaybackRecords() - this.manager.getSequenceNumber();
        this.currentEventLabel.setText(String.valueOf(numleft) + " events left");
        if (this.currentRecord != null) {
            int rowNumber = info.getSequenceNumber() - 1;
            Object[] row = this.buildPlayBackRow(this.currentRecord);
            this.getEventsListBox().replaceRow(row, rowNumber);
            this.getEventsListBox().autoSizeAllColumns();
        }
        this.setRunningButtons(info.isStarted());
    }

    private void logMessage(String string) {
        this.getController().getLog().info(string);
    }

    private void logMessage(String string, Exception exception) {
        this.getController().getLog().log(Log.WARNING, string, exception);
    }

    protected void resetAllEventsAndWait() {
        Exception ex = null;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    PlaybackPane.this.resetAllEvents();
                }
            });
        }
        catch (InterruptedException e) {
            this.logException("Exception resettting replay", e);
            ex = e;
        }
        catch (InvocationTargetException e) {
            this.logException("Exception resettting replay", e);
            ex = e;
        }
        if (ex != null) {
            final Exception throwed = ex;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlaybackPane.this.showMessage(null, "Exception resetting replay", "Exception resetting replay: " + throwed.getMessage());
                }
            });
        }
    }

    private void setRunningButtons(boolean running) {
        this.startButton.setEnabled(this.isAllowed(Permission.Type.START_PLAYBACK));
        this.stopButton.setEnabled(this.isAllowed(Permission.Type.STOP_PLAYBACK));
        this.resetButton.setEnabled(this.isAllowed(Permission.Type.EDIT_PLAYBACK));
        this.loadButton.setEnabled(this.isAllowed(Permission.Type.EDIT_PLAYBACK));
        if (this.isAllowed(Permission.Type.START_PLAYBACK)) {
            this.getStartButton().setEnabled(!running);
        }
        if (this.isAllowed(Permission.Type.STOP_PLAYBACK)) {
            this.getStopButton().setEnabled(running);
        }
        if (this.isAllowed(Permission.Type.EDIT_PLAYBACK)) {
            this.getResetButton().setEnabled(this.getContest().getPlaybackManager().getPlaybackInfo().getReplayList().length > 0);
        }
    }

    private JButton getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new JButton();
            this.stopButton.setText("Stop");
            this.stopButton.setEnabled(false);
            this.stopButton.setMnemonic(0);
            this.stopButton.setToolTipText("Stop running events");
            this.stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlaybackPane.this.stopEventsRunning();
                }
            });
        }
        return this.stopButton;
    }

    protected void stopEventsRunning() {
        if (!this.isAllowed(Permission.Type.STOP_PLAYBACK)) {
            this.logMessage("Not allowed to stop playback");
            JOptionPane.showMessageDialog(this, "Not allowed to stop playback");
            return;
        }
        PlaybackInfo playbackInfo = this.manager.getPlaybackInfo();
        playbackInfo.setStarted(false);
        String intValueString = this.getMinEventsTextField().getText();
        int minEvents = 0;
        if (intValueString.length() > 0) {
            minEvents = Integer.parseInt(intValueString);
        }
        playbackInfo.setMinimumPlaybackRecords(minEvents);
        this.getController().startPlayback(playbackInfo);
        System.err.println("debug 22 stopped " + playbackInfo);
    }

    private JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton();
            this.resetButton.setText("Reset");
            this.resetButton.setEnabled(false);
            this.resetButton.setToolTipText("Reset (erase or clear) events");
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlaybackPane.this.resetAllEvents();
                }
            });
        }
        return this.resetButton;
    }

    protected void resetAllEvents() {
        if (!this.isAllowed(Permission.Type.START_PLAYBACK)) {
            this.logMessage("Not allowed to start playback");
            JOptionPane.showMessageDialog(this, "Not allowed to start playback");
            return;
        }
        PlaybackInfo playbackInfo = this.manager.getPlaybackInfo();
        playbackInfo.setStarted(false);
        String intValueString = this.getMinEventsTextField().getText();
        int minEvents = 0;
        if (intValueString.length() > 0) {
            minEvents = Integer.parseInt(intValueString);
        }
        playbackInfo.setMinimumPlaybackRecords(minEvents);
        if (ClientType.isAdmin(this.getContest().getClientId())) {
            this.getController().startPlayback(playbackInfo);
            System.err.println("debug 22 started " + playbackInfo);
            return;
        }
    }

    private JPanel getTopPane() {
        if (this.topPane == null) {
            this.iterateTitleLabel = new JLabel();
            this.iterateTitleLabel.setText("Minimum Number of events");
            this.iterateTitleLabel.setBounds(new Rectangle(26, 85, 202, 24));
            this.iterateTitleLabel.setHorizontalAlignment(4);
            this.currentEventLabel = new JLabel();
            this.currentEventLabel.setHorizontalAlignment(0);
            this.currentEventLabel.setFont(new Font("Dialog", 1, 16));
            this.currentEventLabel.setBounds(new Rectangle(356, 22, 115, 38));
            this.currentEventLabel.setText("Not started");
            this.stopAtLabel = new JLabel();
            this.stopAtLabel.setHorizontalAlignment(4);
            this.stopAtLabel.setBounds(new Rectangle(26, 48, 202, 24));
            this.stopAtLabel.setText("Stop before event");
            this.msLabel = new JLabel();
            this.msLabel.setText("ms");
            this.msLabel.setBounds(new Rectangle(294, 15, 32, 24));
            this.topPane = new JPanel();
            this.topPane.setLayout(null);
            this.topPane.setPreferredSize(new Dimension(160, 160));
            this.topPane.add((Component)this.getTimeWarpTextField(), null);
            this.topPane.add((Component)this.msLabel, null);
            this.topPane.add((Component)this.stopAtLabel, null);
            this.topPane.add((Component)this.getStopEventNumberTextField(), null);
            this.topPane.add((Component)this.getEveryMSEventPacing(), null);
            this.topPane.add((Component)this.getStepButton(), null);
            this.topPane.add((Component)this.currentEventLabel, null);
            this.topPane.add((Component)this.getMinEventsTextField(), null);
            this.topPane.add((Component)this.iterateTitleLabel, null);
        }
        return this.topPane;
    }

    private JTextField getTimeWarpTextField() {
        if (this.timeWarpTextField == null) {
            this.timeWarpTextField = new JTextField();
            this.timeWarpTextField.setBounds(new Rectangle(252, 13, 33, 24));
            this.timeWarpTextField.setDocument(new IntegerDocument());
            this.timeWarpTextField.setText("1000");
        }
        return this.timeWarpTextField;
    }

    private JTextField getStopEventNumberTextField() {
        if (this.stopEventNumberTextField == null) {
            this.stopEventNumberTextField = new JTextField();
            this.stopEventNumberTextField.setBounds(new Rectangle(252, 48, 33, 24));
            this.stopEventNumberTextField.setDocument(new IntegerDocument());
            this.stopEventNumberTextField.setText("");
        }
        return this.stopEventNumberTextField;
    }

    private JRadioButton getEveryMSEventPacing() {
        if (this.everyMSEventPacing == null) {
            this.everyMSEventPacing = new JRadioButton();
            this.everyMSEventPacing.setSelected(true);
            this.everyMSEventPacing.setHorizontalAlignment(4);
            this.everyMSEventPacing.setBounds(new Rectangle(15, 13, 216, 24));
            this.everyMSEventPacing.setText("Execute each event every");
        }
        return this.everyMSEventPacing;
    }

    public ButtonGroup getTimeWarpButtonGroup() {
        if (this.timeWarpButtonGroup == null) {
            this.timeWarpButtonGroup = new ButtonGroup();
            this.timeWarpButtonGroup.add(this.getEveryMSEventPacing());
        }
        return this.timeWarpButtonGroup;
    }

    private JButton getStepButton() {
        if (this.stepButton == null) {
            this.stepButton = new JButton();
            this.stepButton.setMnemonic(82);
            this.stepButton.setBounds(new Rectangle(252, 120, 141, 25));
            this.stepButton.setText("Run one event");
            this.stepButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlaybackPane.this.executeNextStep();
                }
            });
        }
        return this.stepButton;
    }

    protected void executeNextStep() {
        if (this.eventsListBox.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No events defined");
            return;
        }
        if (this.manager.allEventsExecuted()) {
            JOptionPane.showMessageDialog(this, "All events executed");
            return;
        }
        int currentEventNumber = this.manager.getSequenceNumber();
        try {
            PlaybackRecord record = this.manager.executeNextEvent(this.getContest(), this.getController());
            int numleft = this.manager.getPlaybackInfo().getMinimumPlaybackRecords() - this.manager.getSequenceNumber();
            this.currentEventLabel.setText(String.valueOf(numleft) + " events left");
            Object[] row = this.buildPlayBackRow(record);
            this.getEventsListBox().replaceRow(row, currentEventNumber - 1);
            this.getEventsListBox().autoSizeAllColumns();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = new JButton();
            this.loadButton.setText("Load");
            this.loadButton.setMnemonic(76);
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlaybackPane.this.loadReplayFile();
                }
            });
        }
        return this.loadButton;
    }

    protected void loadReplayFile() {
        String filename = null;
        try {
            filename = this.getFileName();
            if (filename != null) {
                if (ClientType.isAdmin(this.getContest().getClientId())) {
                    PlaybackInfo playbackInfo = this.getPlaybackInfo();
                    playbackInfo.setFilename(filename);
                    int waitTime = Integer.parseInt(this.getTimeWarpTextField().getText());
                    playbackInfo.setWaitBetweenEventsMS(waitTime);
                    playbackInfo.setStarted(false);
                    this.getController().startPlayback(playbackInfo);
                    System.err.println("debug 22 started " + playbackInfo);
                    return;
                }
                PlaybackManager playbackManager = this.getContest().getPlaybackManager();
                playbackManager.createPlaybackInfo(filename, this.getContest());
                PlaybackRecord[] records = playbackManager.getPlaybackRecords();
                if (records.length == 0) {
                    JOptionPane.showMessageDialog(this, "No events found in " + filename);
                } else {
                    PlaybackRecord[] playbackRecordArray = records;
                    int n = records.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PlaybackRecord record = playbackRecordArray[n2];
                        Object[] row = this.buildPlayBackRow(record);
                        this.getEventsListBox().addRow(row, record);
                        ++n2;
                    }
                    this.getEventsListBox().autoSizeAllColumns();
                    this.setRunningButtons(false);
                    JOptionPane.showMessageDialog(this, "Loaded " + records.length + " events from " + filename);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "No such file: " + filename);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Unable to load file: " + filename + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    private PlaybackInfo getPlaybackInfo() {
        PlaybackInfo[] infos = this.getContest().getPlaybackInfos();
        if (infos.length > 0) {
            return infos[0];
        }
        return new PlaybackInfo();
    }

    private String getFileName() throws IOException {
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            return chooser.getSelectedFile().getCanonicalFile().toString();
        }
        chooser = null;
        return null;
    }

    private JTextField getMinEventsTextField() {
        if (this.minEventsTextField == null) {
            this.minEventsTextField = new JTextField();
            this.minEventsTextField.setBounds(new Rectangle(252, 85, 73, 24));
            this.minEventsTextField.setDocument(new IntegerDocument());
            this.minEventsTextField.setText("");
        }
        return this.minEventsTextField;
    }

    private void updateGUIperPermissions() {
        this.setRunningButtons(this.manager.isPlaybackRunning());
    }

    public JFramePlugin getMessageFrame() {
        if (this.messageFrame == null) {
            this.messageFrame = new JFramePluginImpl(new MessageMonitorPane());
        }
        return this.messageFrame;
    }

    private JButton getReportButton() {
        if (this.reportButton == null) {
            this.reportButton = new JButton();
            this.reportButton.setText("Messages");
            this.reportButton.setMnemonic(77);
            this.reportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlaybackPane.this.showMessageFrame();
                }
            });
        }
        return this.reportButton;
    }

    protected void showMessageFrame() {
        JFramePlugin frame = this.getMessageFrame();
        frame.setLocation(this.getX(), this.getY());
        FrameUtilities.setFramePosition(frame, FrameUtilities.HorizontalPosition.LEFT, FrameUtilities.VerticalPosition.NO_CHANGE);
        frame.setVisible(true);
    }

    public void updateAtEvent(int playbackSequenceNumber) {
        final int numleft = this.manager.getPlaybackInfo().getMinimumPlaybackRecords() - playbackSequenceNumber;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlaybackPane.this.currentEventLabel.setText(String.valueOf(numleft) + " events left");
            }
        });
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        @Override
        public void accountAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountModified(AccountEvent event) {
            Account account = event.getAccount();
            if (PlaybackPane.this.getContest().getClientId().equals(account.getClientId())) {
                PlaybackPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PlaybackPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        @Override
        public void accountsAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountsModified(AccountEvent accountEvent) {
            boolean theyModifiedUs = false;
            Account[] accountArray = accountEvent.getAccounts();
            int n = accountArray.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (PlaybackPane.this.getContest().getClientId().equals(account.getClientId())) {
                    theyModifiedUs = true;
                    PlaybackPane.this.initializePermissions();
                }
                ++n2;
            }
            final boolean finalTheyModifiedUs = theyModifiedUs;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (finalTheyModifiedUs) {
                        PlaybackPane.this.updateGUIperPermissions();
                    }
                }
            });
        }

        @Override
        public void accountsRefreshAll(AccountEvent accountEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlaybackPane.this.updateGUIperPermissions();
                }
            });
        }
    }

    protected class PlayBackEventListener
    implements IPlayBackEventListener {
        protected PlayBackEventListener() {
        }

        @Override
        public void playbackChanged(final PlayBackEvent playBackEvent) {
            System.out.println("PlayBackEvent " + (Object)((Object)playBackEvent.getAction()) + " " + playBackEvent.getPlaybackInfo());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlaybackPane.this.updatePlaybackInfo(playBackEvent.getPlaybackInfo());
                }
            });
        }

        @Override
        public void playbackRefreshAll(PlayBackEvent playBackEvent) {
            this.playbackChanged(playBackEvent);
        }

        @Override
        public void playbackAdded(PlayBackEvent playBackEvent) {
            this.playbackChanged(playBackEvent);
        }

        @Override
        public void playbackReset(PlayBackEvent playBackEvent) {
        }
    }

    public class RunListenerImplementation
    implements IRunListener {
        @Override
        public void runAdded(RunEvent event) {
            PlaybackPane.this.updateAtEvent(event.getRun().getPlaybackSequenceNumber());
        }

        @Override
        public void runChanged(RunEvent event) {
            PlaybackPane.this.updateAtEvent(event.getRun().getPlaybackSequenceNumber());
        }

        @Override
        public void runRemoved(RunEvent event) {
        }

        @Override
        public void refreshRuns(RunEvent event) {
        }
    }
}

