/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import com.ibm.webrunner.j2mclb.util.Sorter;
import com.ibm.webrunner.j2mclb.util.TableModel;
import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.archive.PacketFormatter;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IPacketListener;
import edu.csus.ecs.pc2.core.model.PacketEvent;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.packet.PacketFactory;
import edu.csus.ecs.pc2.core.util.ReverseNumericStringComparator;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import edu.csus.ecs.pc2.ui.PacketViewerFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class PacketMonitorPane
extends JPanePlugin {
    private static final long serialVersionUID = 1276113801345035959L;
    private JPanel buttonPane = null;
    private JButton detailsButton = null;
    private JButton reportButton = null;
    private MCLB packetListBox = null;
    private JButton clearButton = null;
    private long sequenceNumber = 1L;
    private int maxLines = 500;
    private Log packetLog = null;
    private IPacketListener listener = null;

    public PacketMonitorPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(662, 169));
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)((Object)this.getPacketListBox()), "Center");
    }

    @Override
    public String getPluginTitle() {
        return "Packet Monitor";
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(35);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.setPreferredSize(new Dimension(40, 40));
            this.buttonPane.add((Component)this.getClearButton(), null);
            this.buttonPane.add((Component)this.getDetailsButton(), null);
            this.buttonPane.add((Component)this.getReportButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getDetailsButton() {
        if (this.detailsButton == null) {
            this.detailsButton = new JButton();
            this.detailsButton.setText("Details");
            this.detailsButton.setMnemonic(68);
            this.detailsButton.setToolTipText("Show Details about Selected Packet");
            this.detailsButton.setVisible(false);
            this.detailsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PacketMonitorPane.this.printDetails();
                }
            });
        }
        return this.detailsButton;
    }

    protected void printDetails() {
        JOptionPane.showMessageDialog(this, "Show Details");
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        String moduleInfo = inContest.getTitle();
        this.getParentFrame().setTitle(String.valueOf(this.getParentFrame().getTitle()) + " " + moduleInfo);
        if (this.packetLog == null) {
            System.err.println("debug 22 - started log: packetMonitorPane." + inContest.getClientId().getName());
            this.getController().getLog().info("debug 22 - started log: packetMonitorPane." + inContest.getClientId().getName());
            this.packetLog = new Log("packetMonitorPane." + inContest.getClientId().getName());
            this.packetLog.info("");
            this.packetLog.info(new VersionInfo().getSystemVersionInfo());
            this.packetLog.info("");
        }
        if (this.listener == null) {
            this.listener = new PacketListenerImplementation();
            inController.addPacketListener(this.listener);
        }
    }

    protected String formatLogLine(String direction, Packet packet) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.sequenceNumber);
        buf.append(' ');
        buf.append(direction);
        buf.append(' ');
        buf.append(packet.getPacketNumber());
        buf.append(' ');
        buf.append(packet.getOriginalPacketNumber());
        buf.append(' ');
        buf.append(packet.getType().toString());
        buf.append(' ');
        buf.append(this.getClientName(packet.getSourceId()));
        buf.append(' ');
        buf.append(this.getClientName(packet.getDestinationId()));
        return new String(buf);
    }

    private JButton getReportButton() {
        if (this.reportButton == null) {
            this.reportButton = new JButton();
            this.reportButton.setText("Report");
            this.reportButton.setMnemonic(82);
            this.reportButton.setVisible(false);
            this.reportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PacketMonitorPane.this.printReport();
                }
            });
        }
        return this.reportButton;
    }

    protected void printReport() {
        JOptionPane.showMessageDialog(this, "Show Reports");
    }

    private MCLB getPacketListBox() {
        if (this.packetListBox == null) {
            this.packetListBox = new MCLB();
            Object[] cols = new Object[]{"Seq", "Type", "##", "Orig", "Time", "From", "To", "Contents"};
            this.packetListBox.addColumns(cols);
            this.packetListBox.setRowHeight(this.packetListBox.getRowHeight() * 4);
            HeapSorter sorter = new HeapSorter();
            HeapSorter numericStringSorter = new HeapSorter();
            numericStringSorter.setComparator((Comparator)new NumericStringComparator());
            HeapSorter reverseNumericSorter = new HeapSorter();
            reverseNumericSorter.setComparator((Comparator)new ReverseNumericStringComparator());
            int idx = 0;
            this.setColumnSorter(this.packetListBox, idx++, reverseNumericSorter, 1);
            this.setColumnSorter(this.packetListBox, idx++, sorter, 2);
            this.setColumnSorter(this.packetListBox, idx++, numericStringSorter, 3);
            this.setColumnSorter(this.packetListBox, idx++, numericStringSorter, 4);
            this.setColumnSorter(this.packetListBox, idx++, numericStringSorter, 5);
            this.setColumnSorter(this.packetListBox, idx++, sorter, 6);
            this.setColumnSorter(this.packetListBox, idx++, sorter, 7);
            this.setColumnSorter(this.packetListBox, idx++, sorter, 8);
            this.packetListBox.autoSizeAllColumns();
            cols = null;
            this.packetListBox.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        PacketMonitorPane.this.showSelectedRowsPacket();
                    }
                }
            });
        }
        return this.packetListBox;
    }

    protected void showSelectedRowsPacket() {
        try {
            int selectedRow = this.getPacketListBox().getSelectedIndex();
            Packet packet = (Packet)this.getPacketListBox().getKeys()[selectedRow];
            Object[] selectedColumns = this.getPacketListBox().getSelectedRow();
            JScrollPane scroll = (JScrollPane)selectedColumns[7];
            PacketViewerFrame frame = new PacketViewerFrame(packet, scroll);
            frame.setVisible(true);
        }
        catch (Exception e) {
            this.getController().logWarning("Unable to show packet ", e);
        }
    }

    void addRow(final Packet packet) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] row = PacketMonitorPane.this.buildPacketRow(packet);
                PacketMonitorPane.this.truncateTo(PacketMonitorPane.this.maxLines);
                PacketMonitorPane.this.packetListBox.insertRow(row, packet, 0);
                PacketMonitorPane.this.packetListBox.autoSizeAllColumns();
            }
        });
    }

    Object[] buildPacketRow(Packet packet) {
        Clarification clarification;
        Object[] objArray = new Object[this.packetListBox.getColumnCount()];
        objArray[0] = new Long(this.sequenceNumber++).toString();
        long elapsed = 0L;
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        if (run != null) {
            elapsed = run.getElapsedMins();
        }
        if ((clarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION")) != null) {
            elapsed = clarification.getElapsedMins();
        }
        objArray[1] = packet.getType().toString();
        objArray[2] = Integer.toString(packet.getPacketNumber());
        objArray[3] = Integer.toString(packet.getOriginalPacketNumber());
        objArray[4] = Long.toString(elapsed);
        objArray[5] = this.getClientName(packet.getSourceId());
        objArray[6] = this.getClientName(packet.getDestinationId());
        objArray[7] = this.getPacketTree(packet);
        return objArray;
    }

    private JScrollPane getPacketTree(Packet packet) {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Packet " + (Object)((Object)packet.getType()));
        PacketFormatter.buildContentTree(top, packet);
        JTree tree = new JTree(top, true);
        tree.getSelectionModel().setSelectionMode(1);
        JScrollPane treeView = new JScrollPane(tree);
        treeView.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        return treeView;
    }

    protected Object getClientName(ClientId clientId) {
        if (clientId == null) {
            return "<null>";
        }
        if (clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
            if (clientId.equals(PacketFactory.ALL_SERVERS)) {
                return "All Servers";
            }
            return "Site " + clientId.getSiteNumber();
        }
        return clientId.getName();
    }

    private void setColumnSorter(MCLB listBox, int columnNumber, HeapSorter sorter, int sortRank) {
        listBox.getColumnInfo(columnNumber).setSorter((Sorter)sorter);
        listBox.getColumnInfo(columnNumber).getSorter().setSortOrder(sortRank);
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton();
            this.clearButton.setText("Clear");
            this.clearButton.setToolTipText("Remove all packets in list");
            this.clearButton.setMnemonic(67);
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PacketMonitorPane.this.getPacketListBox().removeAllRows();
                    PacketMonitorPane.this.sequenceNumber = 1L;
                }
            });
        }
        return this.clearButton;
    }

    private void truncateTo(int numLines) {
        TableModel tableModel = this.getPacketListBox().getModel();
        if (tableModel.getRowCount() > numLines) {
            int lastRow;
            int i = lastRow = tableModel.getRowCount();
            while (i >= numLines) {
                tableModel.removeRow(i);
                --i;
            }
        }
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        if (maxLines < 10) {
            throw new IllegalArgumentException("Max lines must be 10 or greater " + maxLines + " invalid)");
        }
        this.maxLines = maxLines;
    }

    protected class PacketListenerImplementation
    implements IPacketListener {
        protected PacketListenerImplementation() {
        }

        @Override
        public void packetReceived(PacketEvent event) {
            PacketMonitorPane.this.packetLog.info(PacketMonitorPane.this.formatLogLine("in ", event.getPacket()));
            PacketMonitorPane.this.addRow(event.getPacket());
        }

        @Override
        public void packetSent(PacketEvent event) {
            PacketMonitorPane.this.packetLog.info(PacketMonitorPane.this.formatLogLine("out", event.getPacket()));
            PacketMonitorPane.this.addRow(event.getPacket());
        }
    }
}

