/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.model.JudgementNotification;
import edu.csus.ecs.pc2.ui.IEditChangeCallback;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class NotificationPane
extends JPanel {
    private static final long serialVersionUID = 2315599651968166483L;
    private JTextField stopYesMinTextField = null;
    private JLabel minFromEndYesLabel = null;
    private JLabel minFromEndNoLabel = null;
    private JTextField stopNoMinTextField = null;
    private JCheckBox stopSendingYesCheckBox = null;
    private JCheckBox stopSendingNoCheckBox = null;
    private JudgementNotification judgementNotificationYes = new JudgementNotification();
    private JudgementNotification judgementNotificationNo = new JudgementNotification();
    private IEditChangeCallback callback = null;

    public NotificationPane() {
        this.initialize();
    }

    public void setCallback(IEditChangeCallback callback) {
        this.callback = callback;
    }

    private void initialize() {
        this.minFromEndNoLabel = new JLabel();
        this.minFromEndNoLabel.setBounds(new Rectangle(305, 62, 237, 18));
        this.minFromEndNoLabel.setText("mins from end of contest");
        this.minFromEndYesLabel = new JLabel();
        this.minFromEndYesLabel.setBounds(new Rectangle(305, 16, 237, 18));
        this.minFromEndYesLabel.setText("mins from end of contest");
        this.setLayout(null);
        this.setSize(new Dimension(572, 100));
        this.add((Component)this.getStopYesMinTextField(), null);
        this.add((Component)this.minFromEndYesLabel, null);
        this.add((Component)this.minFromEndNoLabel, null);
        this.add((Component)this.getStopNoMinTextField(), null);
        this.add((Component)this.getStopSendingYesCheckBox(), null);
        this.add((Component)this.getStopSendingNoCheckBox(), null);
    }

    private JTextField getStopYesMinTextField() {
        if (this.stopYesMinTextField == null) {
            this.stopYesMinTextField = new JTextField();
            this.stopYesMinTextField.setBounds(new Rectangle(257, 17, 39, 21));
            this.stopYesMinTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    NotificationPane.this.callback.itemChanged(NotificationPane.this.stopYesMinTextField);
                }
            });
        }
        return this.stopYesMinTextField;
    }

    private JTextField getStopNoMinTextField() {
        if (this.stopNoMinTextField == null) {
            this.stopNoMinTextField = new JTextField();
            this.stopNoMinTextField.setBounds(new Rectangle(257, 61, 39, 21));
            this.stopNoMinTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    NotificationPane.this.callback.itemChanged(NotificationPane.this.stopNoMinTextField);
                }
            });
        }
        return this.stopNoMinTextField;
    }

    private JCheckBox getStopSendingYesCheckBox() {
        if (this.stopSendingYesCheckBox == null) {
            this.stopSendingYesCheckBox = new JCheckBox();
            this.stopSendingYesCheckBox.setBounds(new Rectangle(10, 16, 237, 23));
            this.stopSendingYesCheckBox.setName("");
            this.stopSendingYesCheckBox.setText("Stop Sending Yes judgements at");
            this.stopSendingYesCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationPane.this.callback.itemChanged(NotificationPane.this.stopSendingYesCheckBox);
                }
            });
        }
        return this.stopSendingYesCheckBox;
    }

    private JCheckBox getStopSendingNoCheckBox() {
        if (this.stopSendingNoCheckBox == null) {
            this.stopSendingNoCheckBox = new JCheckBox();
            this.stopSendingNoCheckBox.setBounds(new Rectangle(10, 62, 237, 18));
            this.stopSendingNoCheckBox.setText("Stop Sending No judgements at");
            this.stopSendingNoCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationPane.this.callback.itemChanged(NotificationPane.this.stopSendingNoCheckBox);
                }
            });
        }
        return this.stopSendingNoCheckBox;
    }

    public JudgementNotification getNoJudgementNotificationFromFields() {
        JudgementNotification newJudgementNotification = new JudgementNotification();
        newJudgementNotification.setCuttoffMinutes(NotificationPane.getIntegerValue(this.getStopNoMinTextField().getText()));
        newJudgementNotification.setNotificationSupressed(this.getStopSendingNoCheckBox().isSelected());
        return newJudgementNotification;
    }

    public JudgementNotification getYesJudgementNotificationFromFields() {
        JudgementNotification newJudgementNotification = new JudgementNotification();
        newJudgementNotification.setCuttoffMinutes(NotificationPane.getIntegerValue(this.getStopYesMinTextField().getText()));
        newJudgementNotification.setNotificationSupressed(this.getStopSendingYesCheckBox().isSelected());
        return newJudgementNotification;
    }

    public void setJudgementNotifications(JudgementNotification yesJudgementNotification, JudgementNotification noJudgementNotification) {
        this.judgementNotificationYes = yesJudgementNotification;
        this.judgementNotificationNo = noJudgementNotification;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotificationPane.this.getStopYesMinTextField().setText(Integer.toString(NotificationPane.this.judgementNotificationYes.getCuttoffMinutes()));
                NotificationPane.this.getStopSendingYesCheckBox().setSelected(NotificationPane.this.judgementNotificationYes.isNotificationSupressed());
                NotificationPane.this.getStopNoMinTextField().setText(Integer.toString(NotificationPane.this.judgementNotificationNo.getCuttoffMinutes()));
                NotificationPane.this.getStopSendingNoCheckBox().setSelected(NotificationPane.this.judgementNotificationNo.isNotificationSupressed());
            }
        });
    }

    private static int getIntegerValue(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

