/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.ui.FileDiffPanel;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IDiffPanel;
import edu.csus.ecs.pc2.ui.IFileViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class MultipleFileViewer
extends JFrame
implements IFileViewer {
    private static final String NL = System.getProperty("line.separator");
    private static final long serialVersionUID = -3837495960973474113L;
    private JButton closeButton = null;
    private IInternalContest contest;
    private IInternalController controller;
    private IDiffPanel fileDiffPanel;
    private JLabel informationLabel = null;
    private JPanel ivjButtonFrame = null;
    private JPanel ivjCenterFrame = null;
    private JButton compareButton = null;
    private JTabbedPane ivjFileTabbedPane = null;
    private JPanel ivjJFrameContentPane = null;
    private String judgeOutputFileName = null;
    private Log log = null;
    private JPanel soutPane = null;
    private String teamOutputFileName = null;
    private JButton saveButton;
    private String lastDirectory = ".";
    private String viewerCommand = "";
    private String viewerFile = "";
    private Process process = null;

    public String getViewerCommand() {
        return this.viewerCommand;
    }

    public MultipleFileViewer(Log log) {
        this.log = log;
        this.initialize();
    }

    public MultipleFileViewer(Log log, String title) {
        super(title);
        this.log = log;
        this.initialize();
        this.setTitle(title);
        this.getCompareButton().setVisible(false);
    }

    public MultipleFileViewer(Log log, String windowTitle, String paneTitle, String messageData, boolean isFile) {
        super(windowTitle);
        this.log = log;
        this.initialize();
        this.setTitle(windowTitle);
        if (isFile) {
            this.addFilePane(paneTitle, messageData);
        } else {
            this.addTextPane(paneTitle, messageData);
        }
        this.getCompareButton().setVisible(false);
    }

    public boolean addFilePane(String title, SerializedFile inFile) {
        if (inFile == null) {
            return false;
        }
        if (inFile.getBuffer().length < 1) {
            return false;
        }
        String filename = inFile.getName();
        if (title == null) {
            title = filename;
        }
        if (title.length() < 1) {
            title = filename;
        }
        int numtabs = this.getFileTabbedPane().getTabCount() + 1;
        JTextArea textArea = new JTextArea();
        textArea.setName("JTextPane" + numtabs);
        textArea.setBounds(0, 0, 11, 6);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setName("JScrollPane" + numtabs);
        scrollPane.setViewportView(textArea);
        JPanel jPanel = new JPanel();
        jPanel.setName("JPanel" + numtabs);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)scrollPane, "Center");
        this.ivjFileTabbedPane.insertTab(title, null, jPanel, null, 0);
        return this.loadFile(textArea, inFile);
    }

    @Override
    public boolean addFilePane(String title, String filename) {
        if (title == null) {
            title = filename;
        }
        if (title.length() < 1) {
            title = filename;
        }
        int numtabs = this.getFileTabbedPane().getTabCount() + 1;
        JTextArea textArea = new JTextArea();
        textArea.setName("JTextPane" + numtabs);
        textArea.setBounds(0, 0, 11, 6);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setName("JScrollPane" + numtabs);
        scrollPane.setViewportView(textArea);
        JPanel jPanel = new JPanel();
        jPanel.setName("JPanel" + numtabs);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)scrollPane, "Center");
        this.ivjFileTabbedPane.insertTab(title, null, jPanel, null, 0);
        return this.loadFile(textArea, filename);
    }

    public boolean addTextintoPane(String title, String[] lines) {
        int numtabs = this.getFileTabbedPane().getTabCount() + 1;
        JTextArea textArea = new JTextArea();
        textArea.setName("JTextPane" + numtabs);
        textArea.setBounds(0, 0, 11, 6);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setName("JScrollPane" + numtabs);
        scrollPane.setViewportView(textArea);
        JPanel jPanel = new JPanel();
        jPanel.setName("JPanel" + numtabs);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)scrollPane, "Center");
        this.ivjFileTabbedPane.insertTab(title, null, jPanel, null, 0);
        return this.loadText(textArea, lines);
    }

    private boolean loadText(JTextArea textArea, String[] lines) {
        try {
            textArea.setFont(new Font("Courier", 0, 12));
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                textArea.append(line);
                textArea.append("\n");
                ++n2;
            }
            textArea.setCaretPosition(0);
            return true;
        }
        catch (Exception e) {
            System.out.println("MultipleFileViewer loadText exception " + e);
            return false;
        }
    }

    @Override
    public boolean addTextPane(String title, String inMessage) {
        if (inMessage.length() < 1) {
            return false;
        }
        if (title == null) {
            title = "Message";
        }
        if (title.length() < 1) {
            title = "Message";
        }
        int numtabs = this.getFileTabbedPane().getTabCount() + 1;
        JTextArea textArea = new JTextArea();
        textArea.setName("JTextPane" + numtabs);
        textArea.setBounds(0, 0, 11, 6);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setName("JScrollPane" + numtabs);
        scrollPane.setViewportView(textArea);
        JPanel jPanel = new JPanel();
        jPanel.setName("JPanel" + numtabs);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)scrollPane, "Center");
        this.ivjFileTabbedPane.insertTab(title, null, jPanel, null, 0);
        return this.loadText(textArea, inMessage);
    }

    public String checkNPCharacters(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            int x = new Character(c).hashCode();
            if (!(Character.isWhitespace(c) || x >= 32 && x <= 126)) {
                return "***** NOTE: This output contains non-printable characters *****" + NL + s;
            }
            ++i;
        }
        return s;
    }

    public void closeTheWindow() {
        if (this.fileDiffPanel != null) {
            this.fileDiffPanel.dispose();
            this.fileDiffPanel = null;
        }
        this.dispose();
    }

    public void compareFiles() {
        if (this.judgeOutputFileName == null && this.teamOutputFileName == null) {
            this.log.config("compareButtonActionPerformed:  judge and team files are null");
            return;
        }
        if (this.judgeOutputFileName == null) {
            this.log.config("compareButtonActionPerformed:  judge file is null");
        }
        if (this.teamOutputFileName == null) {
            this.log.config("compareButtonActionPerformed:  team file is null");
        }
        try {
            if (this.fileDiffPanel == null) {
                this.fileDiffPanel = new FileDiffPanel(this.log);
                this.fileDiffPanel.showFiles(this.teamOutputFileName, "Team's Output", this.judgeOutputFileName, "Judge's Answer");
            } else {
                this.fileDiffPanel.show();
            }
        }
        catch (Throwable exception) {
            this.log.log(Log.CONFIG, "compareButton_ActionEvents:  Error in creating fileDiffViewer", exception);
        }
    }

    @Override
    public void enableCompareButton(boolean value) {
        this.getCompareButton().setVisible(value);
    }

    private JPanel getButtonFrame() {
        if (this.ivjButtonFrame == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(35);
            this.ivjButtonFrame = new JPanel();
            this.ivjButtonFrame.setLayout(flowLayout);
            this.ivjButtonFrame.setName("ButtonFrame");
            this.ivjButtonFrame.setPreferredSize(new Dimension(35, 35));
            this.getButtonFrame().add((Component)this.getCompareButton(), this.getCompareButton().getName());
            this.ivjButtonFrame.add(this.getBtnNewButton());
            this.getButtonFrame().add((Component)this.getCloseButton(), this.getCloseButton().getName());
        }
        return this.ivjButtonFrame;
    }

    private JPanel getCenterFrame() {
        if (this.ivjCenterFrame == null) {
            this.ivjCenterFrame = new JPanel();
            this.ivjCenterFrame.setName("CenterFrame");
            this.ivjCenterFrame.setLayout(new BorderLayout());
            this.getCenterFrame().add((Component)this.getFileTabbedPane(), "Center");
        }
        return this.ivjCenterFrame;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setName("CloseButton");
            this.closeButton.setMnemonic(67);
            this.closeButton.setText("Close");
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultipleFileViewer.this.closeTheWindow();
                }
            });
        }
        return this.closeButton;
    }

    private JButton getCompareButton() {
        if (this.compareButton == null) {
            this.compareButton = new JButton();
            this.compareButton.setName("CompareButton");
            this.compareButton.setMnemonic('p');
            this.compareButton.setText("Compare");
            this.compareButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultipleFileViewer.this.compareFiles();
                }
            });
        }
        return this.compareButton;
    }

    private JTabbedPane getFileTabbedPane() {
        if (this.ivjFileTabbedPane == null) {
            this.ivjFileTabbedPane = new JTabbedPane();
            this.ivjFileTabbedPane.setName("FileTabbedPane");
        }
        return this.ivjFileTabbedPane;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            this.ivjJFrameContentPane = new JPanel();
            this.ivjJFrameContentPane.setName("JFrameContentPane");
            this.ivjJFrameContentPane.setLayout(new BorderLayout());
            this.getJFrameContentPane().add((Component)this.getCenterFrame(), "Center");
            this.ivjJFrameContentPane.add((Component)this.getSouthPane(), "South");
        }
        return this.ivjJFrameContentPane;
    }

    @Override
    public String getPluginTitle() {
        return "Multi File Viewer";
    }

    private JPanel getSouthPane() {
        if (this.soutPane == null) {
            this.informationLabel = new JLabel();
            this.informationLabel.setText("");
            this.informationLabel.setHorizontalAlignment(0);
            this.informationLabel.setPreferredSize(new Dimension(10, 30));
            this.soutPane = new JPanel();
            this.soutPane.setLayout(new BorderLayout());
            this.soutPane.add((Component)this.getButtonFrame(), "South");
            this.soutPane.add((Component)this.informationLabel, "Center");
        }
        return this.soutPane;
    }

    private void initialize() {
        this.setName("MultipleFileViewer");
        this.setDefaultCloseOperation(2);
        this.setState(0);
        this.setSize(594, 546);
        this.setTitle("Information");
        this.setContentPane(this.getJFrameContentPane());
        FrameUtilities.centerFrame(this);
        this.getCompareButton().setVisible(false);
        this.getBtnNewButton().setVisible(true);
    }

    public boolean loadFile(JTextArea jPane, SerializedFile inFile) {
        try {
            String filename = inFile.getName();
            jPane.setFont(new Font("Courier", 0, 12));
            String s = new String(inFile.getBuffer());
            String oldTitle = this.getTitle();
            this.setTitle("Loading " + filename + " ... ");
            jPane.append(this.checkNPCharacters(s));
            jPane.setCaretPosition(0);
            this.setTitle(oldTitle);
            return true;
        }
        catch (Exception e) {
            System.out.println("MultipleFileViewer class: exception " + e);
            return false;
        }
    }

    public boolean loadFile(JTextArea jPane, String filename) {
        File viewFile;
        String oldTitle;
        FileReader fileReader;
        block4: {
            this.viewerFile = filename;
            fileReader = null;
            jPane.setFont(new Font("Courier", 0, 12));
            oldTitle = this.getTitle();
            this.setTitle("Loading " + filename + " ... ");
            viewFile = new File(filename);
            if (viewFile.exists()) break block4;
            return false;
        }
        try {
            fileReader = new FileReader(viewFile);
            BufferedReader in = new BufferedReader(fileReader);
            String line = in.readLine();
            while (line != null) {
                jPane.append(line);
                jPane.append("\n");
                line = in.readLine();
            }
            in.close();
            jPane.setCaretPosition(0);
            this.setTitle(oldTitle);
            return true;
        }
        catch (Exception e) {
            System.out.println("MultipleFileViewer class: exception " + e);
            return false;
        }
    }

    public boolean loadText(JTextArea jPane, String inMessage) {
        try {
            jPane.setFont(new Font("Courier", 0, 12));
            jPane.append(inMessage);
            jPane.setCaretPosition(0);
            return true;
        }
        catch (Exception e) {
            System.out.println("MultipleFileViewer class: exception " + e);
            return false;
        }
    }

    public void resizeToParentFrame(JFrame frame) {
        this.setSize(frame.getSize());
        this.setLocation(frame.getLocation());
    }

    public void resizeToThirdScreen() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameDim = this.getSize();
        int thirdHeight = screenDim.height / 2;
        int thirdWidth = screenDim.width / 2;
        frameDim.height = Math.max(frameDim.height, thirdHeight);
        frameDim.width = Math.max(frameDim.height, thirdWidth);
        this.setSize(frameDim);
        FrameUtilities.centerFrame(this);
    }

    @Override
    public void setCompareFileNames(String incomingJudgeOutputFileName, String incomingTeamOutputFileName) {
        this.judgeOutputFileName = incomingJudgeOutputFileName;
        this.teamOutputFileName = incomingTeamOutputFileName;
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
    }

    @Override
    public void setInformationLabelText(String text) {
        if (text.equals("")) {
            this.informationLabel.setPreferredSize(new Dimension(0, 0));
        } else {
            this.informationLabel.setPreferredSize(new Dimension(10, 30));
        }
        this.informationLabel.setText(text);
    }

    @Override
    public void setSelectedIndex(int index) {
        this.ivjFileTabbedPane.setSelectedIndex(index);
    }

    @Override
    public void showMessage(String inMessage) {
        this.setTitle("Message");
        this.addTextPane("Message", inMessage);
        this.setVisible(true);
    }

    private JButton getBtnNewButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton("Save");
            this.saveButton.setToolTipText("Save current buffer to file");
            this.saveButton.setMnemonic(83);
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultipleFileViewer.this.saveActiveBuffer();
                }
            });
        }
        return this.saveButton;
    }

    protected void saveActiveBuffer() {
        int idx = this.getFileTabbedPane().getSelectedIndex();
        JTextArea area = this.getTabTextArea(idx);
        String fileNameFromPane = this.getFileTabbedPane().getTitleAt(idx);
        File file = this.saveAsFileDialog(this, this.lastDirectory, fileNameFromPane);
        if (file != null) {
            int result;
            if (file.isFile() && (result = FrameUtilities.yesNoCancelDialog(this, "Overwrite " + file.getName() + " ?", "Overwrite File?")) != 0) {
                return;
            }
            String string = area.getText();
            this.writeFile(file, string);
        }
    }

    private void writeFile(File file, String string) {
        try {
            FileOutputStream fis = new FileOutputStream(file.getAbsolutePath(), false);
            fis.write(string.getBytes());
            fis.close();
            fis = null;
        }
        catch (Exception e) {
            if (this.controller != null) {
                this.log.log(Log.DEBUG, "Unable to write to file " + file.getAbsolutePath(), e);
            }
            this.showMessage("Unable to write file " + e.getMessage());
        }
    }

    private JTextArea getTabTextArea(int idx) {
        Component component = this.getFileTabbedPane().getComponentAt(idx);
        JPanel panel = (JPanel)component;
        component = panel.getComponent(0);
        JScrollPane scrolly = (JScrollPane)component;
        component = scrolly.getViewport().getComponent(0);
        JTextArea textArea = (JTextArea)component;
        return textArea;
    }

    public File saveAsFileDialog(Component parent, String startDirectory, String defaultFileName) {
        File inFile = new File(String.valueOf(startDirectory) + File.separator + defaultFileName);
        JFileChooser chooser = new JFileChooser(startDirectory);
        chooser.setSelectedFile(inFile);
        chooser.setFileSelectionMode(0);
        int action = chooser.showSaveDialog(parent);
        switch (action) {
            case 0: {
                File file = chooser.getSelectedFile();
                this.lastDirectory = chooser.getCurrentDirectory().toString();
                return file;
            }
        }
        return null;
    }

    public void setViewerCommand(String lastViewer) {
        this.viewerCommand = lastViewer == null ? "" : lastViewer;
    }

    @Override
    public void dispose() {
        if (this.process != null) {
            this.process.destroy();
        }
        super.dispose();
    }

    @Override
    public void setVisible(boolean arg0) {
        if (this.viewerCommand.equals("")) {
            super.setVisible(arg0);
        } else if (arg0) {
            String[] env = null;
            try {
                this.process = Runtime.getRuntime().exec(String.valueOf(this.viewerCommand) + " " + this.viewerFile, env, new File("."));
            }
            catch (IOException e) {
                this.log.warning("setVisible() " + e.getMessage());
                JOptionPane.showMessageDialog(this, "System Error: " + e.getMessage(), "System Error", 0);
            }
        } else if (this.process != null) {
            this.process.destroy();
        }
    }
}

