/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.ui.EditJudgesDataFilePathFrame;
import edu.csus.ecs.pc2.ui.EditProblemPane;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.TestCaseTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class MultipleDataSetPane
extends JPanePlugin {
    private static final long serialVersionUID = -5975163495479418935L;
    private JScrollPane listBoxScrollPane = null;
    private TestCaseTableModel tableModel = new TestCaseTableModel();
    private JTable testDataSetsListBox = null;
    private ProblemDataFiles problemDataFiles;
    private JButton btnDelete;
    private JButton btnLoad;
    private EditProblemPane editProblemPane = null;
    private Problem problem;
    private JPanel inputDataStoragePanel;
    private JRadioButton rdbtnCopyDataFiles;
    private JRadioButton rdBtnKeepDataFilesExternal;
    private JPanel buttonPanel;
    private Component horizontalStrut;
    private final ButtonGroup inputStorageButtonGroup = new ButtonGroup();
    private String loadDirectory;
    private Component verticalStrut;
    private Component verticalStrut_1;
    private Component verticalStrut_2;
    private JLabel lblWhatsThis;
    private String whatsThisMessage = "PC2 has two different ways of handling data files: Internal and External.  \n\n'Internal' means that PC2 will load the file data internally into PC2 memory.  \nThe advantage of this is that it allows PC2 to automatically transmit the file data to a Judge each time the Judge requests to judge a submission.\nThe drawback of this approach is that it does not work well for large data files, because it requires substantial system memory and large\namounts of network traffic.\n\n'External' means that PC2 keeps track of the file names, but that the files themselves remain outside the PC2 system and hence do not use \nsystem memory or require network bandwidth for transmission.  \nThe advantage of this approach is that it allows the use of arbitrarily large data files for a contest problem.\nThe drawback of this approach is that it requires you to insure that a copy of the data files is placed on the Judge's machines.  This \nmust be done externally to the PC2 system, and the files must be placed at the exact location specified by the value \nof the 'Judges Data Path' setting (see the 'Set Judge's Data Path' button on the Contest Configuration->Problems tab).\n\nYou must choose which type of data storage you want to use for each contest problem prior to loading the data for that problem.  ";

    public MultipleDataSetPane() {
        this.setMinimumSize(new Dimension(10, 500));
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(766, 526));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getVerticalStrut_2());
        this.add(this.getInputDataStoragePanel());
        this.add(this.getVerticalStrut());
        this.add(this.getListBoxScrollPane());
        this.add(this.getVerticalStrut_1());
        this.add(this.getButtonPanel());
    }

    @Override
    public String getPluginTitle() {
        return "Mulitple Data Set Pane";
    }

    public void setProblemDataFiles(Problem aProblem, ProblemDataFiles aProblemDataFiles) throws CloneNotSupportedException {
        this.problem = aProblem;
        if (aProblem != null) {
            this.setProblemDataFiles(aProblemDataFiles.copy(aProblem));
        } else {
            this.getRdbtnCopyDataFiles().setSelected(true);
            this.clearDataFiles();
        }
    }

    public void setProblemDataFiles(ProblemDataFiles datafiles) {
        this.problemDataFiles = datafiles;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultipleDataSetPane.this.populateUI();
            }
        });
    }

    private void enableInputDataStoragePanel(boolean enable) {
        this.getInputDataStoragePanel().setEnabled(enable);
        this.getRdbtnCopyDataFiles().setEnabled(enable);
        this.getRdBtnKeepDataFilesExternal().setEnabled(enable);
    }

    protected void populateUI() {
        this.tableModel.setFiles(this.problemDataFiles);
        this.tableModel.fireTableDataChanged();
        if (this.problem != null) {
            this.getRdBtnKeepDataFilesExternal().setSelected(this.problem.isUsingExternalDataFiles());
            boolean enable = true;
            if (this.problemDataFiles != null) {
                SerializedFile[] dataFiles = this.problemDataFiles.getJudgesDataFiles();
                SerializedFile[] answerFiles = this.problemDataFiles.getJudgesAnswerFiles();
                if (dataFiles != null && dataFiles.length > 0) {
                    enable = false;
                }
                if (answerFiles != null && answerFiles.length > 0) {
                    enable = false;
                }
            }
            this.enableInputDataStoragePanel(enable);
        }
        this.resizeColumnWidth(this.getTestDataSetsListBox());
    }

    public void resizeColumnWidth(JTable table) {
        int col = 0;
        while (col < table.getColumnCount()) {
            int width = 10;
            switch (col) {
                case 0: {
                    width = 100;
                    break;
                }
                case 1: {
                    width = 300;
                    break;
                }
                case 2: {
                    width = 300;
                    break;
                }
                default: {
                    System.err.println("MultipleDataSetPane.resizeColumnWidthUnhandled col " + col);
                }
            }
            TableColumn column = table.getColumnModel().getColumn(col);
            column.setPreferredWidth(width);
            ++col;
        }
    }

    private void dump(ProblemDataFiles problemDataFiles2, String string) {
        Utilities.dump(problemDataFiles2, string);
    }

    private JScrollPane getListBoxScrollPane() {
        if (this.listBoxScrollPane == null) {
            this.listBoxScrollPane = new JScrollPane(this.getTestDataSetsListBox());
            this.listBoxScrollPane.setBorder(new LineBorder(Color.RED));
        }
        return this.listBoxScrollPane;
    }

    private JTable getTestDataSetsListBox() {
        if (this.testDataSetsListBox == null) {
            this.testDataSetsListBox = new JTable(this.tableModel);
            DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
            centerRenderer.setHorizontalAlignment(0);
            int i = 0;
            while (i < this.testDataSetsListBox.getColumnCount()) {
                this.testDataSetsListBox.getColumnModel().getColumn(i).setCellRenderer(centerRenderer);
                ++i;
            }
            ((DefaultTableCellRenderer)this.testDataSetsListBox.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
            JTableHeader header = this.testDataSetsListBox.getTableHeader();
            header.setFont(new Font("Dialog", 1, 12));
        }
        return this.testDataSetsListBox;
    }

    public ProblemDataFiles getProblemDataFiles() {
        this.dump(this.tableModel.getFiles(), "populateUI debug 22 C");
        return this.tableModel.getFiles();
    }

    public void clearDataFiles() {
        this.problemDataFiles = null;
        this.tableModel.setFiles(null);
        this.tableModel.fireTableDataChanged();
    }

    boolean hasChanged(ProblemDataFiles originalFiles) {
        if (originalFiles == null && this.problemDataFiles == null) {
            return false;
        }
        if (originalFiles == null || this.problemDataFiles == null) {
            return true;
        }
        int comp = this.compare(originalFiles.getJudgesDataFiles(), this.problemDataFiles.getJudgesDataFiles());
        if (comp != 0) {
            return true;
        }
        comp = this.compare(originalFiles.getJudgesAnswerFiles(), this.problemDataFiles.getJudgesAnswerFiles());
        if (comp != 0) {
            return true;
        }
        System.out.println("debug 22 Are problemId's identical ?" + this.problemDataFiles.getProblemId().equals(originalFiles.getProblemId()));
        return false;
    }

    private int compare(SerializedFile[] listOne, SerializedFile[] listTwo) {
        if (listOne == null || listTwo == null) {
            return 2;
        }
        if (listOne.length != listTwo.length) {
            return listTwo.length - listOne.length;
        }
        int i = 0;
        while (i < listTwo.length) {
            if (!listOne[i].equals(listTwo[i])) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton("Delete");
            this.btnDelete.setToolTipText("Delete selected data sets");
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rowNumber = MultipleDataSetPane.this.testDataSetsListBox.getSelectedRow();
                    if (rowNumber != -1) {
                        MultipleDataSetPane.this.removeRow(rowNumber);
                    }
                    MultipleDataSetPane.this.getEditProblemPane().enableUpdateButton();
                }
            });
        }
        return this.btnDelete;
    }

    protected void removeRow(int rowNumber) {
        if (this.tableModel.getRowCount() == 1) {
            this.editProblemPane.setJudgingTestSetOne(null);
        }
        this.tableModel.removeRow(rowNumber);
    }

    public boolean isUsingExternalDataFiles() {
        return this.rdBtnKeepDataFilesExternal.isSelected();
    }

    private String selectDirectory(String dialogTitle) {
        String directory = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (dialogTitle != null) {
            chooser.setDialogTitle(dialogTitle);
        }
        try {
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.loadDirectory = directory = chooser.getSelectedFile().toString();
            }
        }
        catch (Exception e) {
            this.getController().getLog().log(Log.INFO, "Error getting selected file, try again.", e);
        }
        chooser = null;
        return directory;
    }

    protected void loadDataFiles() {
        String shortProblemName = this.getEditProblemPane().getShortNameTextfield().getText();
        if (shortProblemName == null || shortProblemName.trim().length() == 0) {
            this.showMessage(this, "Missing Problem Short Name", "You must define a 'Short Name' for the problem (on the 'General' tab) before you can load data files.");
            return;
        }
        String baseDirectoryName = this.selectDirectory("Select directory where data files are located");
        if (baseDirectoryName == null) {
            return;
        }
        boolean externalFiles = this.isUsingExternalDataFiles();
        if (this.problem == null) {
            this.problem = new Problem(shortProblemName);
        }
        this.problem.setUsingExternalDataFiles(externalFiles);
        this.dump(this.problemDataFiles, "debug 22 before load");
        try {
            this.problemDataFiles = this.loadDataFiles(this.problem, this.problemDataFiles, baseDirectoryName, ".in", ".ans", externalFiles);
        }
        catch (Exception e) {
            this.getController().getLog().log(Log.INFO, e.getMessage(), e);
            this.showMessage(this, "Import Failed", e.getMessage());
        }
        this.dump(this.problemDataFiles, "debug 22 after load");
        this.populateUI();
        this.editProblemPane.setJudgingTestSetOne(this.tableModel.getFiles());
        this.getEditProblemPane().enableUpdateButton();
    }

    private JButton getBtnLoad() {
        if (this.btnLoad == null) {
            this.btnLoad = new JButton("Load");
            this.btnLoad.setToolTipText("Load data sets from directory");
            this.btnLoad.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultipleDataSetPane.this.loadDataFiles();
                }
            });
        }
        return this.btnLoad;
    }

    public void setParentPane(EditProblemPane pane) {
        this.editProblemPane = pane;
    }

    public ProblemDataFiles loadDataFiles(Problem aProblem, ProblemDataFiles files, String dataFileBaseDirectory, String dataExtension, String answerExtension, boolean externalDataFiles) {
        if (files == null) {
            files = new ProblemDataFiles(aProblem);
        } else if (aProblem != null && !files.getProblemId().equals(aProblem.getElementId())) {
            throw new RuntimeException("problem and data files are not for the same problem " + aProblem.getElementId() + " vs " + files.getProblemId());
        }
        String[] inputFileNames = Utilities.getFileNames(dataFileBaseDirectory, dataExtension);
        String[] answerFileNames = Utilities.getFileNames(dataFileBaseDirectory, answerExtension);
        if (inputFileNames.length == 0) {
            throw new RuntimeException("No input data files with required  '" + dataExtension + "'  extension found in " + dataFileBaseDirectory);
        }
        if (answerFileNames.length == 0) {
            throw new RuntimeException("No Judge's answer files with required  '" + answerExtension + "'  extension found in " + dataFileBaseDirectory);
        }
        if (answerFileNames.length != inputFileNames.length) {
            throw new RuntimeException("Mismatch: expecting the same number of  '" + dataExtension + "'  and  '" + answerExtension + "'  files in " + dataFileBaseDirectory + "\n (found " + inputFileNames.length + "  '" + dataExtension + "'  files vs. " + answerFileNames.length + "  '" + answerExtension + "'  files)");
        }
        SerializedFile[] inputFiles = Utilities.createSerializedFiles(dataFileBaseDirectory, inputFileNames, externalDataFiles);
        SerializedFile[] answertFiles = Utilities.createSerializedFiles(dataFileBaseDirectory, answerFileNames, externalDataFiles);
        files.setJudgesDataFiles(inputFiles);
        files.setJudgesAnswerFiles(answertFiles);
        return files;
    }

    public EditProblemPane getEditProblemPane() {
        return this.editProblemPane;
    }

    public JPanel getInputDataStoragePanel() {
        if (this.inputDataStoragePanel == null) {
            this.inputDataStoragePanel = new JPanel();
            this.inputDataStoragePanel.setPreferredSize(new Dimension(470, 100));
            this.inputDataStoragePanel.setMaximumSize(new Dimension(500, 200));
            this.inputDataStoragePanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Choose storage option before loading data files:", 4, 2, new Font("Dialog", 1, 12), new Color(0, 0, 0)));
            this.inputDataStoragePanel.setAlignmentX(0.0f);
            this.inputDataStoragePanel.setLayout(new BoxLayout(this.inputDataStoragePanel, 1));
            this.inputDataStoragePanel.add(this.getRdbtnCopyDataFiles());
            this.inputDataStoragePanel.add(this.getRdBtnKeepDataFilesExternal());
            this.inputDataStoragePanel.add(this.getLblWhatsThis());
        }
        return this.inputDataStoragePanel;
    }

    public JRadioButton getRdbtnCopyDataFiles() {
        if (this.rdbtnCopyDataFiles == null) {
            this.rdbtnCopyDataFiles = new JRadioButton("Copy Data Files into PC2 (more efficient, but limited to 5MB total per problem)");
            this.inputStorageButtonGroup.add(this.rdbtnCopyDataFiles);
            this.rdbtnCopyDataFiles.setSelected(true);
            this.rdbtnCopyDataFiles.setPreferredSize(new Dimension(550, 30));
            this.rdbtnCopyDataFiles.setMinimumSize(new Dimension(550, 30));
            this.rdbtnCopyDataFiles.setMaximumSize(new Dimension(550, 30));
            this.rdbtnCopyDataFiles.setBorder(new EmptyBorder(0, 15, 0, 0));
        }
        return this.rdbtnCopyDataFiles;
    }

    public JRadioButton getRdBtnKeepDataFilesExternal() {
        if (this.rdBtnKeepDataFilesExternal == null) {
            this.rdBtnKeepDataFilesExternal = new JRadioButton("Keep Data Files external to PC2 (requires you to copy files to Judge's machines)");
            this.rdBtnKeepDataFilesExternal.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (MultipleDataSetPane.this.rdBtnKeepDataFilesExternal.isSelected()) {
                        MultipleDataSetPane.this.verifyJudgeDataPathIsSet();
                    }
                }
            });
            this.inputStorageButtonGroup.add(this.rdBtnKeepDataFilesExternal);
            this.rdBtnKeepDataFilesExternal.setPreferredSize(new Dimension(550, 30));
            this.rdBtnKeepDataFilesExternal.setMinimumSize(new Dimension(550, 30));
            this.rdBtnKeepDataFilesExternal.setMaximumSize(new Dimension(550, 30));
            this.rdBtnKeepDataFilesExternal.setBorder(new EmptyBorder(0, 15, 0, 0));
        }
        return this.rdBtnKeepDataFilesExternal;
    }

    protected void verifyJudgeDataPathIsSet() {
        ContestInformation ci = this.getContest().getContestInformation();
        String judgeCDPBasePath = ci.getJudgeCDPBasePath();
        if (judgeCDPBasePath == null || judgeCDPBasePath.trim().equals("")) {
            EditJudgesDataFilePathFrame frame = new EditJudgesDataFilePathFrame();
            frame.setContestAndController(this.getContest(), this.getController());
            frame.loadCurrentCDPPathsIntoGUI();
            frame.setVisible(true);
        }
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setPreferredSize(new Dimension(10, 30));
            this.buttonPanel.add(this.getBtnLoad());
            this.buttonPanel.add(this.getHorizontalStrut());
            this.buttonPanel.add(this.getBtnDelete());
        }
        return this.buttonPanel;
    }

    private Component getHorizontalStrut() {
        if (this.horizontalStrut == null) {
            this.horizontalStrut = Box.createHorizontalStrut(20);
            this.horizontalStrut.setPreferredSize(new Dimension(30, 0));
            this.horizontalStrut.setMinimumSize(new Dimension(30, 0));
        }
        return this.horizontalStrut;
    }

    public void setLoadDirectory(String externalDataFileLocation) {
        this.loadDirectory = externalDataFileLocation;
    }

    public String getLoadDirectory() {
        return this.loadDirectory;
    }

    private Component getVerticalStrut() {
        if (this.verticalStrut == null) {
            this.verticalStrut = Box.createVerticalStrut(20);
        }
        return this.verticalStrut;
    }

    private Component getVerticalStrut_1() {
        if (this.verticalStrut_1 == null) {
            this.verticalStrut_1 = Box.createVerticalStrut(20);
        }
        return this.verticalStrut_1;
    }

    private Component getVerticalStrut_2() {
        if (this.verticalStrut_2 == null) {
            this.verticalStrut_2 = Box.createVerticalStrut(20);
        }
        return this.verticalStrut_2;
    }

    private JLabel getLblWhatsThis() {
        if (this.lblWhatsThis == null) {
            this.lblWhatsThis = new JLabel("<What's This?>");
            this.lblWhatsThis.setForeground(Color.blue);
            this.lblWhatsThis.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    JOptionPane.showMessageDialog(null, MultipleDataSetPane.this.whatsThisMessage, "Internal vs. External Files", 1, null);
                }
            });
            this.lblWhatsThis.setBorder(new EmptyBorder(0, 15, 0, 0));
        }
        return this.lblWhatsThis;
    }
}

