/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILanguageListener;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LanguageEvent;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.EditLanguageFrame;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LanguagesPane
extends JPanePlugin {
    private static final long serialVersionUID = -5837850150714301616L;
    private JPanel languageButtonPane = null;
    private MCLB languageListBox = null;
    private JButton addButton = null;
    private JButton editButton = null;
    private JPanel messagePane = null;
    private JLabel messageLabel = null;
    private EditLanguageFrame editLanguageFrame = null;
    private Log log;

    public LanguagesPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(564, 229));
        this.add((Component)((Object)this.getLanguageListBox()), "Center");
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getLanguageButtonPane(), "South");
        this.editLanguageFrame = new EditLanguageFrame();
    }

    @Override
    public String getPluginTitle() {
        return "Languages Pane";
    }

    private JPanel getLanguageButtonPane() {
        if (this.languageButtonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.languageButtonPane = new JPanel();
            this.languageButtonPane.setLayout(flowLayout);
            this.languageButtonPane.setPreferredSize(new Dimension(35, 35));
            this.languageButtonPane.add((Component)this.getAddButton(), null);
            this.languageButtonPane.add((Component)this.getEditButton(), null);
        }
        return this.languageButtonPane;
    }

    private MCLB getLanguageListBox() {
        if (this.languageListBox == null) {
            this.languageListBox = new MCLB();
            Object[] cols = new Object[]{"Display Name", "Compiler Command Line", "Exe Name", "Execute Command Line", "Interpreted", "Use Judges", "Judges Command Line"};
            this.languageListBox.addColumns(cols);
            this.languageListBox.autoSizeAllColumns();
        }
        return this.languageListBox;
    }

    public void updateLanguageRow(final Language language) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] objects = LanguagesPane.this.buildLanguageRow(language);
                int rowNumber = LanguagesPane.this.languageListBox.getIndexByKey(language.getElementId());
                if (rowNumber == -1) {
                    LanguagesPane.this.languageListBox.addRow(objects, language.getElementId());
                } else {
                    LanguagesPane.this.languageListBox.replaceRow(objects, rowNumber);
                }
                LanguagesPane.this.languageListBox.autoSizeAllColumns();
            }
        });
    }

    protected Object[] buildLanguageRow(Language language) {
        int numberColumns = this.languageListBox.getColumnCount();
        Object[] c = new String[numberColumns];
        c[0] = language.toString();
        if (!language.isActive()) {
            c[0] = "[HIDDEN] " + language.toString();
        }
        c[1] = language.getCompileCommandLine();
        c[2] = language.getExecutableIdentifierMask();
        c[3] = language.getProgramExecuteCommandLine();
        c[4] = Utilities.yesNoString(language.isInterpreted());
        c[5] = Utilities.yesNoString(language.isUsingJudgeProgramExecuteCommandLine());
        c[6] = language.getJudgeProgramExecuteCommandLine();
        return c;
    }

    private void reloadListBox() {
        Language[] languages;
        this.languageListBox.removeAllRows();
        Language[] languageArray = languages = this.getContest().getLanguages();
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = languageArray[n2];
            this.addLanguageRow(language);
            ++n2;
        }
    }

    private void addLanguageRow(Language language) {
        Object[] objects = this.buildLanguageRow(language);
        this.languageListBox.addRow(objects, language.getElementId());
        this.languageListBox.autoSizeAllColumns();
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.editLanguageFrame.setContestAndController(inContest, inController);
        this.getContest().addLanguageListener(new LanguageListenerImplementation());
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.log = this.getController().getLog();
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LanguagesPane.this.updateGUIperPermissions();
                LanguagesPane.this.reloadListBox();
            }
        });
    }

    private void updateGUIperPermissions() {
        this.addButton.setVisible(this.isAllowed(Permission.Type.ADD_LANGUAGE));
        this.editButton.setVisible(this.isAllowed(Permission.Type.EDIT_LANGUAGE));
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setMnemonic(65);
            this.addButton.setToolTipText("Add a new Language definition");
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LanguagesPane.this.addNewLanguage();
                }
            });
        }
        return this.addButton;
    }

    protected void addNewLanguage() {
        this.editLanguageFrame.setLanguage(null);
        this.editLanguageFrame.setVisible(true);
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit");
            this.editButton.setMnemonic(69);
            this.editButton.setToolTipText("Edit existing Language definition");
            this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LanguagesPane.this.editSelectedLanguage();
                }
            });
        }
        return this.editButton;
    }

    protected void editSelectedLanguage() {
        int selectedIndex = this.languageListBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("Select a language to edit");
            return;
        }
        try {
            ElementId elementId = (ElementId)this.languageListBox.getKeys()[selectedIndex];
            Language languageToEdit = this.getContest().getLanguage(elementId);
            this.editLanguageFrame.setLanguage(languageToEdit);
            this.editLanguageFrame.setVisible(true);
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to edit language, check log");
        }
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LanguagesPane.this.messageLabel.setText(string);
            }
        });
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        @Override
        public void accountAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountModified(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (LanguagesPane.this.getContest().getClientId().equals(account.getClientId())) {
                LanguagesPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LanguagesPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        @Override
        public void accountsAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            Account[] accountArray = accounts = accountEvent.getAccounts();
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (LanguagesPane.this.getContest().getClientId().equals(account.getClientId())) {
                    LanguagesPane.this.initializePermissions();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LanguagesPane.this.updateGUIperPermissions();
                        }
                    });
                }
                ++n2;
            }
        }

        @Override
        public void accountsRefreshAll(AccountEvent accountEvent) {
            LanguagesPane.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LanguagesPane.this.updateGUIperPermissions();
                }
            });
        }
    }

    public class LanguageListenerImplementation
    implements ILanguageListener {
        @Override
        public void languageAdded(LanguageEvent event) {
            LanguagesPane.this.updateLanguageRow(event.getLanguage());
        }

        @Override
        public void languageChanged(LanguageEvent event) {
            LanguagesPane.this.updateLanguageRow(event.getLanguage());
        }

        @Override
        public void languageRemoved(LanguageEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LanguagesPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void languageRefreshAll(LanguageEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LanguagesPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void languagesAdded(LanguageEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LanguagesPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void languagesChanged(LanguageEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LanguagesPane.this.reloadListBox();
                }
            });
        }
    }
}

