/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.EventFeedDefinition;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.exports.ccs.EventFeedXML;
import edu.csus.ecs.pc2.exports.ccs.ResolverEventFeedXML;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class EventFeedViewerFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -4525283106661014975L;
    private JPanel contentPanel = null;
    private JPanel buttonPane = null;
    private JButton closeButton = null;
    private JScrollPane jScrollPane = null;
    private JTextArea eventFeedTextArea = null;
    private IInternalContest contest;

    public EventFeedViewerFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(488, 247));
        this.setTitle("View Event Feed ");
        this.setContentPane(this.getContentPanel());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EventFeedViewerFrame.this.closeWindow();
            }
        });
        FrameUtilities.centerFrame(this);
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
    }

    public void setEventFeed(EventFeedXML xml) {
    }

    @Override
    public String getPluginTitle() {
        return "Event Feed Viewer";
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new BorderLayout());
            this.contentPanel.add((Component)this.getButtonPane(), "South");
            this.contentPanel.add((Component)this.getJScrollPane(), "Center");
        }
        return this.contentPanel;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(new FlowLayout());
            this.buttonPane.add((Component)this.getCloseButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.setMnemonic(67);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventFeedViewerFrame.this.closeWindow();
                }
            });
        }
        return this.closeButton;
    }

    protected void closeWindow() {
        this.setVisible(false);
        this.dispose();
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getEventFeedTextArea());
        }
        return this.jScrollPane;
    }

    private JTextArea getEventFeedTextArea() {
        if (this.eventFeedTextArea == null) {
            this.eventFeedTextArea = new JTextArea();
        }
        return this.eventFeedTextArea;
    }

    public void setEventFeedDefinition(EventFeedDefinition definition) {
        try {
            this.setTitle("Event Feed: " + definition.getDisplayName());
            ResolverEventFeedXML eventFeedXML = new ResolverEventFeedXML();
            String xml = eventFeedXML.toXML(this.contest);
            this.getEventFeedTextArea().setText(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

