/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.StringUtilities;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.exception.MultipleIssuesException;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class EditJudgesDataFilePathFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -8570718182014642771L;
    private static final String NULL_STRING_VALUE = "<null>";
    private IInternalContest contest;
    private IInternalController controller;
    private JTextField adminCDPPathTextField;
    private JTextField judgeCDPPathTextField;
    private JButton cancelButton;
    private JButton updateButton = null;
    private Log log;

    public EditJudgesDataFilePathFrame() {
        this.initialize();
    }

    protected void handleUpdateDataPathButton() {
        if (this.getContest() != null) {
            String curJudgePath;
            ContestInformation ci = this.getContestInformation();
            if (ci == null) {
                this.log.warning("Initializing ContestInformation in Contest, should have already been initialized");
                ci = new ContestInformation();
            }
            if ((curJudgePath = this.getJudgeDataPathTextField().getText()) != null && curJudgePath.equals(NULL_STRING_VALUE)) {
                curJudgePath = null;
            }
            ci.setJudgeCDPBasePath(curJudgePath);
            this.getController().updateContestInformation(ci);
            this.setVisible(false);
        } else {
            IInternalController contr = this.getController();
            if (contr != null) {
                this.getController().getLog().log(Log.SEVERE, "EditCDPPathFrame.handleUpdateDataPathButton(): getContest() returned null");
            } else {
                System.err.println("EditCDPPathFrame.handleUpdateDataPathButton(): getContest() or getController() returned null");
            }
        }
    }

    private ContestInformation getContestInformation() {
        return this.getContest().getContestInformation();
    }

    /*
     * Unable to fully structure code
     */
    private boolean validateCDP(String path) {
        block3: {
            System.err.println("TODO EditCDPPathFrame.validateCDP(): missing code; would have checked for a CDP at '" + path + "'; assuming valid and returning true");
            try {
                Utilities.validateCDP(this.getContest(), path);
                break block3;
            }
            catch (MultipleIssuesException e) {
                this.showMessage("Not valid CDP for path " + path, "Invalid CDP");
                messages = e.getIssueList();
                System.err.println("Errors in CDP at path '" + path + "'");
                var7_4 = messages;
                var6_5 = messages.length;
                var5_6 = 0;
                ** while (var5_6 < var6_5)
            }
lbl-1000:
            // 1 sources

            {
                message = var7_4[var5_6];
                System.err.println(message);
                this.log.warning(message);
                ++var5_6;
                continue;
            }
lbl19:
            // 1 sources

            result = FrameUtilities.yesNoCancelDialog(this, "TEMPORARY DEBUGGING THING. CDP is invalid - save anyways?", "TEMPORARY DEBUGGING THING. debug 22");
            return result == 0;
        }
        return true;
    }

    private void showMessage(String string, String title) {
        JOptionPane.showMessageDialog(null, string, title, 2);
    }

    private void initialize() {
        this.setSize(new Dimension(549, 312));
        this.setDefaultCloseOperation(0);
        this.setTitle("Set External Data File Path");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EditJudgesDataFilePathFrame.this.handleCancelButton();
            }
        });
        FrameUtilities.centerFrame(this);
        JPanel mainPanel = new JPanel();
        this.getContentPane().add((Component)mainPanel, "North");
        mainPanel.setLayout(new BorderLayout(0, 0));
        Component verticalStrut = Box.createVerticalStrut(20);
        mainPanel.add(verticalStrut, "North");
        JPanel textPanel = new JPanel();
        mainPanel.add((Component)textPanel, "Center");
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        JPanel adminCDPPathPanel = new JPanel();
        adminCDPPathPanel.setEnabled(false);
        adminCDPPathPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        textPanel.add(adminCDPPathPanel);
        JLabel lblAdminCDPPath = new JLabel("Full Path to Admin machine CDP Root:  ");
        lblAdminCDPPath.setEnabled(false);
        adminCDPPathPanel.add(lblAdminCDPPath);
        this.adminCDPPathTextField = this.getAdminCDPPathTextField();
        this.adminCDPPathTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                EditJudgesDataFilePathFrame.this.enableUpdateButton();
            }
        });
        adminCDPPathPanel.add(this.adminCDPPathTextField);
        JPanel judgesCDPPathPanel = new JPanel();
        judgesCDPPathPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        textPanel.add(judgesCDPPathPanel);
        JLabel lblJudgesDataPath = new JLabel("Full path to data files on Judge machines:  ");
        judgesCDPPathPanel.add(lblJudgesDataPath);
        this.judgeCDPPathTextField = this.getJudgeDataPathTextField();
        this.judgeCDPPathTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                EditJudgesDataFilePathFrame.this.enableUpdateButton();
            }
        });
        judgesCDPPathPanel.add(this.judgeCDPPathTextField);
        JPanel buttonPanel = new JPanel();
        mainPanel.add((Component)buttonPanel, "South");
        buttonPanel.add(this.getUpdateButton());
        buttonPanel.add(this.getCancelButton());
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditJudgesDataFilePathFrame.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    private JTextField getAdminCDPPathTextField() {
        if (this.adminCDPPathTextField == null) {
            this.adminCDPPathTextField = new JTextField();
            this.adminCDPPathTextField.setEnabled(false);
            this.adminCDPPathTextField.setColumns(20);
        }
        return this.adminCDPPathTextField;
    }

    private JTextField getJudgeDataPathTextField() {
        if (this.judgeCDPPathTextField == null) {
            this.judgeCDPPathTextField = new JTextField();
            this.judgeCDPPathTextField.setColumns(20);
        }
        return this.judgeCDPPathTextField;
    }

    protected void handleCancelButton() {
        if (this.updateButton.isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this, "Data path modified, save changes?", "Confirm Choice");
            if (result == 0) {
                this.handleUpdateDataPathButton();
                this.dispose();
            } else if (result == 1) {
                this.dispose();
            }
        } else {
            this.setVisible(false);
        }
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = inController.getLog();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditJudgesDataFilePathFrame.this.populateUI();
                EditJudgesDataFilePathFrame.this.enableUpdateButtons(false);
            }
        });
    }

    protected void populateUI() {
        String adminCDP;
        ContestInformation info = this.getContestInformation();
        String judgeCDP = info.getJudgeCDPBasePath();
        if (judgeCDP == null) {
            judgeCDP = NULL_STRING_VALUE;
        }
        if ((adminCDP = info.getAdminCDPBasePath()) == null) {
            adminCDP = NULL_STRING_VALUE;
        }
        this.getAdminCDPPathTextField().setText(adminCDP);
        this.getJudgeDataPathTextField().setText(judgeCDP);
    }

    public IInternalContest getContest() {
        return this.contest;
    }

    public IInternalController getController() {
        return this.controller;
    }

    public void loadCurrentCDPPathsIntoGUI() {
        if (this.getContest() != null) {
            ContestInformation ci = this.getContest().getContestInformation();
            String curAdminPath = ci.getAdminCDPBasePath();
            if (curAdminPath == null) {
                curAdminPath = "";
            }
            this.getAdminCDPPathTextField().setText(curAdminPath);
            String curJudgePath = ci.getJudgeCDPBasePath();
            if (curJudgePath == null) {
                curJudgePath = "";
            }
            this.getJudgeDataPathTextField().setText(curJudgePath);
        } else {
            IInternalController contr = this.getController();
            if (contr != null) {
                this.getController().getLog().log(Log.SEVERE, "EditCDPPathFrame.loadCurrentCDPPathsIntoGUI(): getContest() returned null");
            } else {
                System.err.println("EditCDPPathFrame.loadCurrentCDPPathsIntoGUI(): getContest() or getController() returned null");
            }
        }
    }

    public void enableUpdateButton() {
        boolean enableButton = false;
        ContestInformation information = this.getContest().getContestInformation();
        if (information != null) {
            String fieldValue = this.getTextFieldValue(this.adminCDPPathTextField);
            if (!StringUtilities.stringSame(information.getAdminCDPBasePath(), fieldValue)) {
                enableButton = true;
            }
            String judgeFieldValue = this.getTextFieldValue(this.judgeCDPPathTextField);
            if (!StringUtilities.stringSame(information.getJudgeCDPBasePath(), judgeFieldValue)) {
                enableButton = true;
            }
        } else {
            enableButton = true;
        }
        this.enableUpdateButtons(enableButton);
    }

    private String getTextFieldValue(JTextField textField) {
        String fieldValue = textField.getText();
        if (fieldValue.equalsIgnoreCase(NULL_STRING_VALUE)) {
            fieldValue = null;
        }
        return fieldValue;
    }

    public JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton("Update");
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditJudgesDataFilePathFrame.this.handleUpdateDataPathButton();
                }
            });
        }
        return this.updateButton;
    }

    protected void enableUpdateButtons(boolean editedText) {
        this.getUpdateButton().setEnabled(editedText);
        if (editedText) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
    }

    @Override
    public String getPluginTitle() {
        return "Edit CDP Frame";
    }
}

