/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.PermissionByDescriptionComparator;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Category;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.DisplayTeamName;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.FilterFormatter;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.IntegerDocument;
import edu.csus.ecs.pc2.ui.JCheckBoxJList;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class EditFilterPane
extends JPanePlugin {
    private static final long serialVersionUID = 1866852944568248601L;
    private JCheckBox filterOnCheckBox = null;
    private JPanel problemsPane = null;
    private JPanel bottomPanel = null;
    private JPanel languagesPane = null;
    private JPanel teamsPane = null;
    private JPanel judgementsPane = null;
    private JPanel listsPanel = null;
    private JPanel mainPane = null;
    private JScrollPane judgementsScroll = null;
    private JScrollPane teamsScroll = null;
    private JScrollPane problemsScroll = null;
    private JScrollPane languagesScroll = null;
    private JCheckBoxJList judgementListBox = null;
    private DefaultListModel<WrapperJCheckBox> judgementListModel = new DefaultListModel();
    private JCheckBoxJList teamListBox = null;
    private DefaultListModel<WrapperJCheckBox> teamListModel = new DefaultListModel();
    private JCheckBoxJList problemsListBox = null;
    private DefaultListModel<WrapperJCheckBox> problemListModel = new DefaultListModel();
    private JCheckBoxJList languagesListBox = null;
    private DefaultListModel<WrapperJCheckBox> languageListModel = new DefaultListModel();
    private Filter filter = new Filter();
    private JScrollPane jScrollPane = null;
    private JPanel runStatesPane = null;
    private JCheckBoxJList runStatesListBox = null;
    private DefaultListModel<WrapperJCheckBox> runStatesListModel = new DefaultListModel();
    private DefaultListModel<WrapperJCheckBox> clarificationStatesListModel = new DefaultListModel();
    private DefaultListModel<WrapperJCheckBox> sitesListModel = new DefaultListModel();
    private DefaultListModel<WrapperJCheckBox> permissionsListModel = new DefaultListModel();
    private JPanel timeRangePane = null;
    private JLabel fromTimeLabel = null;
    private JTextField fromTimeTextField = null;
    private JLabel toTimeLabel = null;
    private JTextField toTimeTextField = null;
    private DisplayTeamName displayTeamName = null;
    private boolean isJudgeModule = false;
    private boolean filteringClarifications = false;
    private JPanel clarificationStatesPane = null;
    private JScrollPane clarificationStateScrollPane = null;
    private JList<?> clarificationStatesListBox = null;
    private JPanel sitesPane = null;
    private JPanel permissionsPane = null;
    private JScrollPane sitesScroll = null;
    private JScrollPane permissionScroll = null;
    private JCheckBoxJList siteListBox = null;
    private JCheckBoxJList permissionListBox = null;
    private JPanel accountsPane = null;
    private DefaultListModel<WrapperJCheckBox> accountListModel = new DefaultListModel();
    private JCheckBoxJList accountListBox = null;
    private JScrollPane accountScroll = null;
    private JPanel clientTypePane = null;
    private JScrollPane clientTypeScroll = null;
    private DefaultListModel<WrapperJCheckBox> clientTypeListModel = new DefaultListModel();
    private JCheckBoxJList clientTypesListBox;
    private Permission permission = new Permission();

    public EditFilterPane() {
        this.initialize();
    }

    public EditFilterPane(Filter filter) {
        this.initialize();
        this.filter = filter;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(493, 337));
        this.add((Component)this.getMainPane(), "Center");
    }

    @Override
    public String getPluginTitle() {
        return "Edit Filter";
    }

    private JCheckBox getFilterOnCheckBox() {
        if (this.filterOnCheckBox == null) {
            this.filterOnCheckBox = new JCheckBox();
            this.filterOnCheckBox.setText("Filter On");
            this.filterOnCheckBox.setMnemonic(70);
        }
        return this.filterOnCheckBox;
    }

    private JPanel getProblemsPane() {
        if (this.problemsPane == null) {
            this.problemsPane = new JPanel();
            this.problemsPane.setLayout(new BorderLayout());
            this.problemsPane.setBorder(BorderFactory.createTitledBorder(null, "Problems", 0, 0, null, null));
            this.problemsPane.setName("problemFrame");
            this.problemsPane.add((Component)this.getProblemsScroll(), "Center");
        }
        return this.problemsPane;
    }

    private JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
            this.bottomPanel.add((Component)this.getFilterOnCheckBox(), null);
        }
        return this.bottomPanel;
    }

    private JPanel getLanguagesPane() {
        if (this.languagesPane == null) {
            this.languagesPane = new JPanel();
            this.languagesPane.setLayout(new BorderLayout());
            this.languagesPane.setBorder(BorderFactory.createTitledBorder(null, "Languages", 0, 0, null, null));
            this.languagesPane.setName("languagePane");
            this.languagesPane.add((Component)this.getLanguagesScroll(), "Center");
        }
        return this.languagesPane;
    }

    private JPanel getTeamsPane() {
        if (this.teamsPane == null) {
            this.teamsPane = new JPanel();
            this.teamsPane.setLayout(new BorderLayout());
            this.teamsPane.setBorder(BorderFactory.createTitledBorder(null, "Teams", 0, 0, null, null));
            this.teamsPane.setName("teamFrame");
            this.teamsPane.add((Component)this.getTeamsScroll(), "Center");
        }
        return this.teamsPane;
    }

    private JPanel getAccountsPane() {
        if (this.accountsPane == null) {
            this.accountsPane = new JPanel();
            this.accountsPane.setLayout(new BorderLayout());
            this.accountsPane.setBorder(BorderFactory.createTitledBorder(null, "Accounts", 0, 0, null, null));
            this.accountsPane.setName("accountFrame");
            this.accountsPane.add((Component)this.getAccountScroll(), "Center");
        }
        return this.accountsPane;
    }

    private JPanel getJudgementsPane() {
        if (this.judgementsPane == null) {
            this.judgementsPane = new JPanel();
            this.judgementsPane.setLayout(new BorderLayout());
            this.judgementsPane.setBorder(BorderFactory.createTitledBorder(null, "Judgements", 0, 0, null, null));
            this.judgementsPane.setName("judgementFrame");
            this.judgementsPane.add((Component)this.getJudgementsScroll(), "Center");
        }
        return this.judgementsPane;
    }

    private JPanel getListsPanel() {
        if (this.listsPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            this.listsPanel = new JPanel();
            this.listsPanel.setLayout(gridLayout);
        }
        return this.listsPanel;
    }

    private JPanel getMainPane() {
        if (this.mainPane == null) {
            this.mainPane = new JPanel();
            this.mainPane.setLayout(new BorderLayout());
            this.mainPane.add((Component)this.getBottomPanel(), "South");
            this.mainPane.add((Component)this.getListsPanel(), "Center");
        }
        return this.mainPane;
    }

    private JScrollPane getJudgementsScroll() {
        if (this.judgementsScroll == null) {
            this.judgementsScroll = new JScrollPane();
            this.judgementsScroll.setViewportView(this.getJudgementListBox());
        }
        return this.judgementsScroll;
    }

    private JScrollPane getTeamsScroll() {
        if (this.teamsScroll == null) {
            this.teamsScroll = new JScrollPane();
            this.teamsScroll.setViewportView(this.getTeamListBox());
        }
        return this.teamsScroll;
    }

    private JScrollPane getAccountScroll() {
        if (this.accountScroll == null) {
            this.accountScroll = new JScrollPane();
            this.accountScroll.setViewportView(this.getAccountListBox());
        }
        return this.accountScroll;
    }

    private JScrollPane getProblemsScroll() {
        if (this.problemsScroll == null) {
            this.problemsScroll = new JScrollPane();
            this.problemsScroll.setViewportView(this.getProblemsListBox());
        }
        return this.problemsScroll;
    }

    private JScrollPane getLanguagesScroll() {
        if (this.languagesScroll == null) {
            this.languagesScroll = new JScrollPane();
            this.languagesScroll.setViewportView(this.getLanguagesListBox());
        }
        return this.languagesScroll;
    }

    private JCheckBoxJList getJudgementListBox() {
        if (this.judgementListBox == null) {
            this.judgementListBox = new JCheckBoxJList((ListModel<?>)this.judgementListModel);
        }
        return this.judgementListBox;
    }

    private JCheckBoxJList getTeamListBox() {
        if (this.teamListBox == null) {
            this.teamListBox = new JCheckBoxJList((ListModel<?>)this.teamListModel);
        }
        return this.teamListBox;
    }

    private JCheckBoxJList getAccountListBox() {
        if (this.accountListBox == null) {
            this.accountListBox = new JCheckBoxJList((ListModel<?>)this.accountListModel);
        }
        return this.accountListBox;
    }

    private JCheckBoxJList getProblemsListBox() {
        if (this.problemsListBox == null) {
            this.problemsListBox = new JCheckBoxJList((ListModel<?>)this.problemListModel);
        }
        return this.problemsListBox;
    }

    private JCheckBoxJList getLanguagesListBox() {
        if (this.languagesListBox == null) {
            this.languagesListBox = new JCheckBoxJList((ListModel<?>)this.languageListModel);
        }
        return this.languagesListBox;
    }

    public void populateFields() {
        Clarification.ClarificationStates[] clarificationStates;
        Run.RunStates[] runStates;
        WrapperJCheckBox wrapperJCheckBox;
        Site[] wrapperJCheckBox2;
        Object wrapperJCheckBox222;
        int i;
        this.getFilterOnCheckBox().setSelected(this.filter.isFilterOn());
        this.problemListModel.removeAllElements();
        if (this.isFilteringClarifications()) {
            Category[] categories = this.getContest().getCategories();
            i = 0;
            while (i < categories.length) {
                Category category = categories[i];
                wrapperJCheckBox222 = new WrapperJCheckBox(category);
                if (this.filter.isFilteringProblems()) {
                    ((AbstractButton)wrapperJCheckBox222).setSelected(this.filter.matches(category));
                }
                this.problemListModel.addElement((WrapperJCheckBox)wrapperJCheckBox222);
                ++i;
            }
        }
        wrapperJCheckBox222 = this.getContest().getProblems();
        int category = ((Problem[])wrapperJCheckBox222).length;
        i = 0;
        while (i < category) {
            Problem problem = wrapperJCheckBox222[i];
            wrapperJCheckBox2 = new WrapperJCheckBox(problem);
            if (this.filter.isFilteringProblems()) {
                wrapperJCheckBox2.setSelected(this.filter.matches(problem));
            }
            this.problemListModel.addElement((WrapperJCheckBox)wrapperJCheckBox2);
            ++i;
        }
        this.languageListModel.removeAllElements();
        wrapperJCheckBox222 = this.getContest().getLanguages();
        category = ((Language[])wrapperJCheckBox222).length;
        i = 0;
        while (i < category) {
            Object language = wrapperJCheckBox222[i];
            wrapperJCheckBox2 = new WrapperJCheckBox(language);
            if (this.filter.isFilteringLanguages()) {
                wrapperJCheckBox2.setSelected(this.filter.matches((Language)language));
            }
            this.languageListModel.addElement((WrapperJCheckBox)wrapperJCheckBox2);
            ++i;
        }
        this.sitesListModel.removeAllElements();
        Site[] sites = this.getContest().getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        wrapperJCheckBox2 = sites;
        int wrapperJCheckBox222 = sites.length;
        category = 0;
        while (category < wrapperJCheckBox222) {
            Site site = wrapperJCheckBox2[category];
            WrapperJCheckBox wrapperJCheckBox3 = new WrapperJCheckBox(site, String.valueOf(site.getSiteNumber()) + " " + site.getDisplayName());
            if (this.filter.isFilteringSites()) {
                wrapperJCheckBox3.setSelected(this.filter.matches(site));
            }
            this.sitesListModel.addElement(wrapperJCheckBox3);
            ++category;
        }
        this.permissionsListModel.removeAllElements();
        Permission.Type[] types = Permission.Type.values();
        Arrays.sort(types, new PermissionByDescriptionComparator());
        Object[] objectArray = types;
        int wrapperJCheckBox3 = types.length;
        wrapperJCheckBox222 = 0;
        while (wrapperJCheckBox222 < wrapperJCheckBox3) {
            Permission.Type type = objectArray[wrapperJCheckBox222];
            wrapperJCheckBox = new WrapperJCheckBox((Object)type, this.permission.getDescription(type));
            if (this.filter.isFilteringPermissions()) {
                wrapperJCheckBox.setSelected(this.filter.matches(type));
            }
            this.permissionsListModel.addElement(wrapperJCheckBox);
            ++wrapperJCheckBox222;
        }
        this.clientTypeListModel.removeAllElements();
        objectArray = ClientType.Type.values();
        wrapperJCheckBox3 = objectArray.length;
        wrapperJCheckBox222 = 0;
        while (wrapperJCheckBox222 < wrapperJCheckBox3) {
            Enum type = objectArray[wrapperJCheckBox222];
            wrapperJCheckBox = new WrapperJCheckBox(type);
            if (this.filter.isFilteringAccounts()) {
                wrapperJCheckBox.setSelected(this.filter.matches((ClientType.Type)type));
            }
            this.clientTypeListModel.addElement(wrapperJCheckBox);
            ++wrapperJCheckBox222;
        }
        this.judgementListModel.removeAllElements();
        objectArray = this.getContest().getJudgements();
        wrapperJCheckBox3 = objectArray.length;
        wrapperJCheckBox222 = 0;
        while (wrapperJCheckBox222 < wrapperJCheckBox3) {
            Object judgement = objectArray[wrapperJCheckBox222];
            wrapperJCheckBox = new WrapperJCheckBox(judgement);
            if (this.filter.isFilteringJudgements()) {
                wrapperJCheckBox.setSelected(this.filter.matches((Judgement)judgement));
            }
            this.judgementListModel.addElement(wrapperJCheckBox);
            ++wrapperJCheckBox222;
        }
        this.loadTeamNames(this.filter);
        this.loadAccountNames(this.filter);
        this.runStatesListModel.removeAllElements();
        Run.RunStates[] runStatesArray = runStates = Run.RunStates.values();
        int n = runStates.length;
        wrapperJCheckBox3 = 0;
        while (wrapperJCheckBox3 < n) {
            Run.RunStates runState = runStatesArray[wrapperJCheckBox3];
            WrapperJCheckBox wrapperJCheckBox4 = new WrapperJCheckBox((Object)runState);
            if (this.filter.isFilteringRunStates()) {
                wrapperJCheckBox4.setSelected(this.filter.matches(runState));
            }
            this.runStatesListModel.addElement(wrapperJCheckBox4);
            ++wrapperJCheckBox3;
        }
        this.clarificationStatesListModel.removeAllElements();
        Clarification.ClarificationStates[] clarificationStatesArray = clarificationStates = Clarification.ClarificationStates.values();
        int n2 = clarificationStates.length;
        n = 0;
        while (n < n2) {
            Clarification.ClarificationStates clarificationState = clarificationStatesArray[n];
            WrapperJCheckBox wrapperJCheckBox5 = new WrapperJCheckBox((Object)clarificationState);
            if (this.filter.isFilteringClarificationStates()) {
                wrapperJCheckBox5.setSelected(this.filter.matches(clarificationState));
            }
            this.clarificationStatesListModel.addElement(wrapperJCheckBox5);
            ++n;
        }
        this.getFromTimeTextField().setText("");
        this.getToTimeTextField().setText("");
        if (this.filter.isFilteringElapsedTime()) {
            if (this.filter.getStartElapsedTime() >= 0L) {
                this.getFromTimeTextField().setText("" + this.filter.getStartElapsedTime());
            }
            if (this.filter.getEndElapsedTime() >= 0L) {
                this.getToTimeTextField().setText("" + this.filter.getEndElapsedTime());
            }
        }
    }

    protected void populateTeamNamesWithDisplayMask() {
        if (this.isJudgeModule) {
            ContestInformation contestInformation = this.getContest().getContestInformation();
            if (this.displayTeamName == null) {
                this.displayTeamName = new DisplayTeamName();
            }
            this.displayTeamName.setTeamDisplayMask(contestInformation.getTeamDisplayMode());
            Filter teamsFilter = new Filter();
            teamsFilter.clearAccountList();
            Enumeration<WrapperJCheckBox> enumeration = this.teamListModel.elements();
            while (enumeration.hasMoreElements()) {
                WrapperJCheckBox element = enumeration.nextElement();
                if (!element.isSelected()) continue;
                Object object = element.getContents();
                teamsFilter.addAccount((ClientId)object);
            }
            this.loadTeamNames(teamsFilter);
        }
    }

    private void loadTeamNames(Filter inFilter) {
        Vector<Account> vector = this.getContest().getAccounts(ClientType.Type.TEAM);
        Account[] accounts = vector.toArray(new Account[vector.size()]);
        Arrays.sort(accounts, new AccountComparator());
        this.teamListModel.removeAllElements();
        WrapperJCheckBox wrapperJCheckBox = null;
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            wrapperJCheckBox = this.displayTeamName != null ? new WrapperJCheckBox(account.getClientId(), this.displayTeamName) : new WrapperJCheckBox(account.getClientId());
            if (inFilter.isFilteringAccounts()) {
                wrapperJCheckBox.setSelected(inFilter.matches(account));
            }
            this.teamListModel.addElement(wrapperJCheckBox);
            ++n2;
        }
    }

    private void loadAccountNames(Filter inFilter) {
        Account[] accounts = this.getContest().getAccounts();
        Arrays.sort(accounts, new AccountComparator());
        this.accountListModel.removeAllElements();
        WrapperJCheckBox wrapperJCheckBox = null;
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            wrapperJCheckBox = this.displayTeamName != null ? new WrapperJCheckBox(account.getClientId(), this.displayTeamName) : new WrapperJCheckBox(account.getClientId());
            if (inFilter.isFilteringAccounts()) {
                wrapperJCheckBox.setSelected(inFilter.matches(account));
            }
            this.accountListModel.addElement(wrapperJCheckBox);
            ++n2;
        }
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getContest().addContestInformationListener(new ContestInformationListenerImplementation());
        this.isJudgeModule = this.getContest().getClientId().getClientType().equals((Object)ClientType.Type.JUDGE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditFilterPane.this.populateFields();
            }
        });
    }

    public Filter getFilter() {
        Object object;
        WrapperJCheckBox element;
        this.filter.setFilter(this.getFilterOnCheckBox().isSelected());
        this.filter.clearProblemList();
        Enumeration<WrapperJCheckBox> enumeration = this.problemListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addProblem((Problem)object);
        }
        this.filter.clearLanguageList();
        enumeration = this.languageListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addLanguage((Language)object);
        }
        this.filter.clearAccountList();
        enumeration = this.teamListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addAccount((ClientId)object);
        }
        enumeration = this.accountListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addAccount((ClientId)object);
        }
        this.filter.clearRunStatesList();
        enumeration = this.runStatesListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addRunState((Run.RunStates)((Object)object));
        }
        this.filter.clearClarificationStateList();
        enumeration = this.clarificationStatesListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addClarificationState((Clarification.ClarificationStates)((Object)object));
        }
        this.filter.clearJudgementList();
        enumeration = this.judgementListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addJudgement((Judgement)object);
        }
        this.filter.clearSiteList();
        enumeration = this.sitesListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addSite((Site)object);
        }
        this.filter.clearPermissionsList();
        enumeration = this.permissionsListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addPermission((Permission.Type)((Object)object));
        }
        this.filter.clearClientTypesList();
        enumeration = this.clientTypeListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addClientType((ClientType.Type)((Object)object));
        }
        this.filter.clearElapsedTimeRange();
        if (this.getFromTimeTextField().getText().length() > 0) {
            this.filter.setStartElapsedTime(Long.parseLong(this.getFromTimeTextField().getText()));
        }
        if (this.getToTimeTextField().getText().length() > 0) {
            this.filter.setEndElapsedTime(Long.parseLong(this.getToTimeTextField().getText()));
        }
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditFilterPane.this.populateFields();
            }
        });
    }

    protected void printAllSpecifiers(String prefix, IInternalContest contest, Filter inFilter) {
        Object[] names = new String[]{"%T", "%J", "%L", "%#T", "%#J", "%#L", "%#P", "%P", "%n", "%t", "%C", "%s", "%e"};
        Arrays.sort(names);
        FilterFormatter filterFormatter = new FilterFormatter();
        Object[] objectArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            Object string = objectArray[n2];
            System.out.println(String.valueOf(prefix) + " " + (String)string + " '" + filterFormatter.format((String)string, contest, inFilter) + "'");
            ++n2;
        }
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getRunStatesListBox());
        }
        return this.jScrollPane;
    }

    private JPanel getRunStatesPane() {
        if (this.runStatesPane == null) {
            this.runStatesPane = new JPanel();
            this.runStatesPane.setLayout(new BorderLayout());
            this.runStatesPane.setBorder(BorderFactory.createTitledBorder(null, "Run States", 0, 0, null, null));
            this.runStatesPane.add((Component)this.getJScrollPane(), "Center");
        }
        return this.runStatesPane;
    }

    private JCheckBoxJList getRunStatesListBox() {
        if (this.runStatesListBox == null) {
            this.runStatesListBox = new JCheckBoxJList((ListModel<?>)this.runStatesListModel);
        }
        return this.runStatesListBox;
    }

    public void addList(ListNames listName) {
        switch (listName) {
            case ALL_ACCOUNTS: {
                this.listsPanel.add((Component)this.getAccountsPane(), 0);
                break;
            }
            case TEAM_ACCOUNTS: {
                this.listsPanel.add((Component)this.getTeamsPane(), 0);
                break;
            }
            case LANGUAGES: {
                this.listsPanel.add((Component)this.getLanguagesPane(), 0);
                break;
            }
            case PROBLEMS: {
                this.listsPanel.add((Component)this.getProblemsPane(), 0);
                break;
            }
            case JUDGEMENTS: {
                this.listsPanel.add((Component)this.getJudgementsPane(), 0);
                break;
            }
            case RUN_STATES: {
                this.listsPanel.add((Component)this.getRunStatesPane(), 0);
                break;
            }
            case CLARIFICATION_STATES: {
                this.listsPanel.add((Component)this.getClarificationStatesPane(), 0);
                break;
            }
            case TIME_RANGE: {
                this.listsPanel.add((Component)this.getTimeRangePane(), 0);
                break;
            }
            case SITES: {
                this.listsPanel.add((Component)this.getSitesPane(), 0);
                break;
            }
            case PERMISSIONS: {
                this.listsPanel.add((Component)this.getPermissionsPane(), 0);
                break;
            }
            case CLIENT_TYPES: {
                this.listsPanel.add((Component)this.getClientTypePane(), 0);
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid listNames: " + (Object)((Object)listName));
            }
        }
    }

    private JPanel getTimeRangePane() {
        if (this.timeRangePane == null) {
            this.toTimeLabel = new JLabel();
            this.toTimeLabel.setText("To");
            this.fromTimeLabel = new JLabel();
            this.fromTimeLabel.setText("From");
            this.timeRangePane = new JPanel();
            this.timeRangePane.setBorder(BorderFactory.createTitledBorder(null, "Time Range", 0, 0, null, null));
            this.timeRangePane.add((Component)this.fromTimeLabel, null);
            this.timeRangePane.add((Component)this.getFromTimeTextField(), null);
            this.timeRangePane.add((Component)this.toTimeLabel, null);
            this.timeRangePane.add((Component)this.getToTimeTextField(), null);
        }
        return this.timeRangePane;
    }

    private JTextField getFromTimeTextField() {
        if (this.fromTimeTextField == null) {
            this.fromTimeTextField = new JTextField();
            this.fromTimeTextField.setDocument(new IntegerDocument());
            this.fromTimeTextField.setPreferredSize(new Dimension(60, 20));
        }
        return this.fromTimeTextField;
    }

    private JTextField getToTimeTextField() {
        if (this.toTimeTextField == null) {
            this.toTimeTextField = new JTextField();
            this.toTimeTextField.setDocument(new IntegerDocument());
            this.toTimeTextField.setPreferredSize(new Dimension(60, 20));
        }
        return this.toTimeTextField;
    }

    public DisplayTeamName getDisplayTeamName() {
        return this.displayTeamName;
    }

    public void setDisplayTeamName(DisplayTeamName displayTeamName) {
        this.displayTeamName = displayTeamName;
    }

    private JPanel getClarificationStatesPane() {
        if (this.clarificationStatesPane == null) {
            this.clarificationStatesPane = new JPanel();
            this.clarificationStatesPane.setLayout(new BorderLayout());
            this.clarificationStatesPane.setBorder(BorderFactory.createTitledBorder(null, "Clar States", 0, 0, null, null));
            this.clarificationStatesPane.setVisible(true);
            this.clarificationStatesPane.add((Component)this.getClarificationStateScrollPane(), "Center");
        }
        return this.clarificationStatesPane;
    }

    private JScrollPane getClarificationStateScrollPane() {
        if (this.clarificationStateScrollPane == null) {
            this.clarificationStateScrollPane = new JScrollPane();
            this.clarificationStateScrollPane.setViewportView(this.getClarificationStatesListBox());
        }
        return this.clarificationStateScrollPane;
    }

    private JList<?> getClarificationStatesListBox() {
        if (this.clarificationStatesListBox == null) {
            this.clarificationStatesListBox = new JCheckBoxJList((ListModel<?>)this.clarificationStatesListModel);
        }
        return this.clarificationStatesListBox;
    }

    public boolean isFilteringClarifications() {
        return this.filteringClarifications;
    }

    public void setFilteringClarifications(boolean filteringClarifications) {
        this.filteringClarifications = filteringClarifications;
    }

    private JPanel getSitesPane() {
        if (this.sitesPane == null) {
            this.sitesPane = new JPanel();
            this.sitesPane.setLayout(new BorderLayout());
            this.sitesPane.setName("sitesPane");
            this.sitesPane.setBorder(BorderFactory.createTitledBorder(null, "Sites", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.sitesPane.setSize(new Dimension(251, 151));
            this.sitesPane.add((Component)this.getSitesScroll(), "Center");
        }
        return this.sitesPane;
    }

    public JPanel getClientTypePane() {
        if (this.clientTypePane == null) {
            this.clientTypePane = new JPanel();
            this.clientTypePane.setLayout(new BorderLayout());
            this.clientTypePane.setName("clientTypePane");
            this.clientTypePane.setBorder(BorderFactory.createTitledBorder(null, "ClientType", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.clientTypePane.setSize(new Dimension(251, 151));
            this.clientTypePane.add((Component)this.getClientTypeScroll(), "Center");
        }
        return this.clientTypePane;
    }

    private JScrollPane getClientTypeScroll() {
        if (this.clientTypeScroll == null) {
            this.clientTypeScroll = new JScrollPane();
            this.clientTypeScroll.setViewportView(this.getClientTypesListBox());
        }
        return this.clientTypeScroll;
    }

    private JCheckBoxJList getClientTypesListBox() {
        if (this.clientTypesListBox == null) {
            this.clientTypesListBox = new JCheckBoxJList((ListModel<?>)this.clientTypeListModel);
        }
        return this.clientTypesListBox;
    }

    public JPanel getPermissionsPane() {
        if (this.permissionsPane == null) {
            this.permissionsPane = new JPanel();
            this.permissionsPane.setLayout(new BorderLayout());
            this.permissionsPane.setName("permissionsPane");
            this.permissionsPane.setBorder(BorderFactory.createTitledBorder(null, "Permissions", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.permissionsPane.setSize(new Dimension(251, 151));
            this.permissionsPane.add((Component)this.getPermissionsScroll(), "Center");
        }
        return this.permissionsPane;
    }

    private JScrollPane getPermissionsScroll() {
        if (this.permissionScroll == null) {
            this.permissionScroll = new JScrollPane();
            this.permissionScroll.setViewportView(this.getPermissionsListBox());
        }
        return this.permissionScroll;
    }

    private JCheckBoxJList getPermissionsListBox() {
        if (this.permissionListBox == null) {
            this.permissionListBox = new JCheckBoxJList((ListModel<?>)this.permissionsListModel);
        }
        return this.permissionListBox;
    }

    private JScrollPane getSitesScroll() {
        if (this.sitesScroll == null) {
            this.sitesScroll = new JScrollPane();
            this.sitesScroll.setViewportView(this.getSiteListBox());
        }
        return this.sitesScroll;
    }

    private JCheckBoxJList getSiteListBox() {
        if (this.siteListBox == null) {
            this.siteListBox = new JCheckBoxJList((ListModel<?>)this.sitesListModel);
        }
        return this.siteListBox;
    }

    public class ContestInformationListenerImplementation
    implements IContestInformationListener {
        @Override
        public void contestInformationAdded(ContestInformationEvent event) {
            EditFilterPane.this.populateTeamNamesWithDisplayMask();
        }

        @Override
        public void contestInformationChanged(ContestInformationEvent event) {
            EditFilterPane.this.populateTeamNamesWithDisplayMask();
        }

        @Override
        public void contestInformationRemoved(ContestInformationEvent event) {
            EditFilterPane.this.populateTeamNamesWithDisplayMask();
        }

        @Override
        public void contestInformationRefreshAll(ContestInformationEvent contestInformationEvent) {
            EditFilterPane.this.populateTeamNamesWithDisplayMask();
        }

        @Override
        public void finalizeDataChanged(ContestInformationEvent contestInformationEvent) {
        }
    }

    public static enum ListNames {
        LANGUAGES,
        PROBLEMS,
        JUDGEMENTS,
        RUN_STATES,
        CLARIFICATION_STATES,
        ALL_ACCOUNTS,
        TEAM_ACCOUNTS,
        TIME_RANGE,
        SITES,
        PERMISSIONS,
        CLIENT_TYPES;

    }

    protected class WrapperJCheckBox
    extends JCheckBox {
        private static final long serialVersionUID = 991427730095971274L;
        private Object contents;

        public WrapperJCheckBox(Object object) {
            this(object, object.toString());
        }

        public WrapperJCheckBox(Object object, String text) {
            this.contents = object;
            this.setText(text);
        }

        public WrapperJCheckBox(ClientId clientId, DisplayTeamName displayTeamName) {
            this.contents = clientId;
            this.setText(displayTeamName.getDisplayName(clientId));
        }

        public Object getContents() {
            return this.contents;
        }
    }
}

