/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.Category;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class EditCategoryPane
extends JPanePlugin {
    private static final long serialVersionUID = 6229906311932197623L;
    private JPanel buttonPane = null;
    private JButton addButton = null;
    private JButton updateButton = null;
    private JButton cancelButton = null;
    private JPanel centerPane = null;
    private JLabel jLabel2 = null;
    private JTextField displayNameTextField = null;
    private JTextField jTextField3 = null;
    private Category category = null;
    private boolean populatingGUI = true;
    private JCheckBox deleteCheckBox = null;
    private JLabel categoryNameTitle = null;

    public EditCategoryPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(422, 144));
        this.add((Component)this.getCenterPane(), "Center");
        this.add((Component)this.getButtonPane(), "South");
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.addWindowCloserListener();
    }

    private void addWindowCloserListener() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EditCategoryPane.this.getParentFrame() != null) {
                    EditCategoryPane.this.getParentFrame().addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            EditCategoryPane.this.handleCancelButton();
                        }
                    });
                }
            }
        });
    }

    @Override
    public String getPluginTitle() {
        return "Edit Category Pane";
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(15);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getAddButton(), null);
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setEnabled(false);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditCategoryPane.this.addCategory();
                }
            });
        }
        return this.addButton;
    }

    protected void addCategory() {
        Category newCategory = this.getCategoryFromFields();
        String name = newCategory.getDisplayName().trim();
        if (name.length() < 1) {
            JOptionPane.showMessageDialog(this, "Enter a category", "Missing category information", 0);
            return;
        }
        newCategory.setDisplayName(name);
        this.getController().addNewCategory(newCategory);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private Category getCategoryFromFields() {
        Category category2;
        if (this.category == null) {
            category2 = new Category(this.displayNameTextField.getText());
        } else {
            category2 = this.category;
            category2.setDisplayName(this.displayNameTextField.getText());
        }
        category2.setActive(!this.getDeleteCheckBox().isSelected());
        return category2;
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setEnabled(false);
            this.updateButton.setMnemonic(85);
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditCategoryPane.this.updateCategory();
                }
            });
        }
        return this.updateButton;
    }

    protected void updateCategory() {
        Category newCategory = this.getCategoryFromFields();
        String name = newCategory.getDisplayName().trim();
        if (name.length() < 1) {
            JOptionPane.showMessageDialog(this, "Enter a category", "Missing category information", 0);
            return;
        }
        newCategory.setDisplayName(name);
        this.getController().updateCategory(newCategory);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditCategoryPane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    protected void handleCancelButton() {
        if (this.getAddButton().isEnabled() || this.getUpdateButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Category modified, save changes?", "Confirm Choice");
            if (result == 0) {
                if (this.getAddButton().isEnabled()) {
                    this.addCategory();
                } else {
                    this.updateCategory();
                }
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            } else if (result == 1 && this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.categoryNameTitle = new JLabel();
            this.categoryNameTitle.setBounds(new Rectangle(14, 18, 99, 24));
            this.categoryNameTitle.setHorizontalAlignment(4);
            this.categoryNameTitle.setText("Category");
            this.jLabel2 = new JLabel();
            this.jLabel2.setBounds(new Rectangle(0, 0, 0, 0));
            this.jLabel2.setName("SourceExtLabel");
            this.jLabel2.setForeground(Color.black);
            this.jLabel2.setHorizontalAlignment(4);
            this.jLabel2.setText("Source Extensions");
            this.jLabel2.setVisible(false);
            this.centerPane = new JPanel();
            this.centerPane.setLayout(null);
            this.centerPane.setName("advancedEdit");
            this.centerPane.add((Component)this.jLabel2, this.jLabel2.getName());
            this.centerPane.add((Component)this.getDisplayNameTextField(), this.getDisplayNameTextField().getName());
            this.centerPane.add((Component)this.getJTextField3(), this.getJTextField3().getName());
            this.centerPane.add((Component)this.getDeleteCheckBox(), null);
            this.centerPane.add((Component)this.categoryNameTitle, null);
        }
        return this.centerPane;
    }

    private JTextField getDisplayNameTextField() {
        if (this.displayNameTextField == null) {
            this.displayNameTextField = new JTextField();
            this.displayNameTextField.setBounds(new Rectangle(126, 20, 263, 20));
            this.displayNameTextField.setToolTipText("Name to display to users");
            this.displayNameTextField.setName("displayNameTextField");
            this.displayNameTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    EditCategoryPane.this.enableUpdateButton();
                }
            });
        }
        return this.displayNameTextField;
    }

    private JTextField getJTextField3() {
        if (this.jTextField3 == null) {
            this.jTextField3 = new JTextField();
            this.jTextField3.setBounds(new Rectangle(0, 0, 0, 0));
            this.jTextField3.setName("sourceExtTextField");
            this.jTextField3.setToolTipText("Form: *.cpp;*.c");
            this.jTextField3.setVisible(false);
        }
        return this.jTextField3;
    }

    public void enableUpdateButton() {
        if (this.populatingGUI) {
            return;
        }
        boolean enableButton = false;
        if (this.category != null) {
            Category category2 = new Category(this.displayNameTextField.getText());
            category2.setDisplayName(this.displayNameTextField.getText());
            category2.setActive(!this.getDeleteCheckBox().isSelected());
            enableButton = !category2.isSameAs(this.category);
        } else if (this.getAddButton().isVisible()) {
            enableButton = true;
        }
        this.enableUpdateButtons(enableButton);
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(final Category category) {
        this.category = category;
        if (category == null) {
            this.setDeleteCheckBoxEnabled(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditCategoryPane.this.populateGUI(category);
                EditCategoryPane.this.enableUpdateButtons(false);
            }
        });
    }

    public void setDeleteCheckBoxEnabled(boolean enabled) {
        this.getDeleteCheckBox().setEnabled(enabled);
    }

    private void populateGUI(Category category2) {
        this.populatingGUI = true;
        if (category2 != null) {
            this.displayNameTextField.setText(category2.getDisplayName());
            this.getAddButton().setVisible(false);
            this.getUpdateButton().setVisible(true);
            this.getDeleteCheckBox().setSelected(!category2.isActive());
        } else {
            this.displayNameTextField.setText("");
            this.getAddButton().setVisible(true);
            this.getUpdateButton().setVisible(false);
            this.getDeleteCheckBox().setSelected(false);
        }
        this.populatingGUI = false;
    }

    protected void enableUpdateButtons(boolean changed) {
        if (changed) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
        if (this.getUpdateButton().isVisible()) {
            this.getUpdateButton().setEnabled(changed);
        } else {
            this.getAddButton().setEnabled(changed);
        }
    }

    private JCheckBox getDeleteCheckBox() {
        if (this.deleteCheckBox == null) {
            this.deleteCheckBox = new JCheckBox();
            this.deleteCheckBox.setBounds(new Rectangle(124, 61, 208, 21));
            this.deleteCheckBox.setText("Hide Category");
            this.deleteCheckBox.setActionCommand("Hide Category");
            this.deleteCheckBox.setToolTipText("Hide this Category");
            this.deleteCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditCategoryPane.this.enableUpdateButton();
                }
            });
        }
        return this.deleteCheckBox;
    }
}

