/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.Category;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.EditCategoryPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Dimension;
import javax.swing.JFrame;

public class EditCategoryFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -6248957592340866836L;
    private IInternalContest contest;
    private IInternalController controller;
    private EditCategoryPane categoryPane = null;

    public EditCategoryFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(549, 242));
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getCategoryPane());
        this.setTitle("New Category");
        FrameUtilities.centerFrame(this);
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.getCategoryPane().setContestAndController(this.contest, this.controller);
        this.getCategoryPane().setParentFrame(this);
    }

    public void setCategory(Category category) {
        if (category == null) {
            this.setTitle("Add New Category");
        } else {
            this.setTitle("Edit Category " + category);
        }
        this.getCategoryPane().setCategory(category);
    }

    public void setDeleteCheckBoxEnabled(boolean enabled) {
        this.getCategoryPane().setDeleteCheckBoxEnabled(enabled);
    }

    @Override
    public String getPluginTitle() {
        return "Edit Category Frame";
    }

    private EditCategoryPane getCategoryPane() {
        if (this.categoryPane == null) {
            this.categoryPane = new EditCategoryPane();
        }
        return this.categoryPane;
    }
}

