/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.AutoJudgeSettingsPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Dimension;
import javax.swing.JFrame;

public class EditAutoJudgeSettingFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = 7466524895460714723L;
    private IInternalContest contest;
    private IInternalController controller;
    private AutoJudgeSettingsPane autoJudgeSettingsPane = null;

    public EditAutoJudgeSettingFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(551, 280));
        this.setContentPane(this.getAutoJudgeSettingsPane());
        FrameUtilities.centerFrame(this);
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.getAutoJudgeSettingsPane().setContestAndController(this.contest, this.controller);
        this.getAutoJudgeSettingsPane().setParentFrame(this);
    }

    @Override
    public String getPluginTitle() {
        return "Edit Auto Judge Settings Frame";
    }

    public void setClientSetting(ClientId clientId, ClientSettings clientSettings) {
        if (clientId == null) {
            throw new IllegalArgumentException("client id is null");
        }
        if (clientSettings == null) {
            clientSettings = new ClientSettings(clientId);
        }
        this.getAutoJudgeSettingsPane().setClientSettings(clientSettings);
        this.getAutoJudgeSettingsPane().setVisible(true);
    }

    private AutoJudgeSettingsPane getAutoJudgeSettingsPane() {
        if (this.autoJudgeSettingsPane == null) {
            this.autoJudgeSettingsPane = new AutoJudgeSettingsPane();
        }
        return this.autoJudgeSettingsPane;
    }
}

