/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.api.exceptions.LoadContestDataException;
import edu.csus.ecs.pc2.core.ContestImporter;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.ContestComparison;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.imports.ccs.ContestYAMLLoader;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ContestPreloadPane
extends JPanePlugin {
    private static final long serialVersionUID = -8095817498502202588L;
    private JPanel buttonPanel = null;
    private MCLB contestsListbox = null;
    private JButton loadButton = null;
    private static final String NL = System.getProperty("line.separator");

    public ContestPreloadPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(502, 207));
        this.add((Component)this.getButtonPanel(), "South");
        this.add((Component)((Object)this.getContestsListbox()), "Center");
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.populateGUI();
    }

    private void populateGUI() {
        this.loadContestListBox();
    }

    private MCLB getContestsListbox() {
        if (this.contestsListbox == null) {
            this.contestsListbox = new MCLB();
            Object[] cols = new String[]{"Description", "Directory"};
            this.contestsListbox.addColumns(cols);
        }
        return this.contestsListbox;
    }

    private String[] buildContestRow(String contestFilename, String name) {
        String[] obj = new String[this.contestsListbox.getColumnCount()];
        ContestYAMLLoader loader = new ContestYAMLLoader();
        try {
            String description;
            obj[0] = description = loader.getContestTitle(contestFilename);
            obj[1] = name;
            return obj;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void loadContestListBox() {
        String dirname = String.valueOf(new VersionInfo().locateHome()) + File.separator + "samps" + File.separator + "contests";
        File dir = new File(dirname);
        if (dir.isDirectory()) {
            Object[] filenames = dir.list();
            Arrays.sort(filenames);
            Object[] objectArray = filenames;
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                Object name = objectArray[n2];
                String contestFilename = String.valueOf(dirname) + File.separator + (String)name + File.separator + "contest.yaml";
                if (new File(contestFilename).isFile()) {
                    String[] cols = this.buildContestRow(contestFilename, (String)name);
                    this.updateContestRow(cols, contestFilename);
                }
                ++n2;
            }
        } else {
            this.getLog().info("Could not load preconfigured contests from " + dirname);
        }
    }

    private void startExplorer() {
        String dirname = String.valueOf(new VersionInfo().locateHome()) + File.separator + "samps" + File.separator + "contests";
        Utilities.startExplorer(dirname);
    }

    private void updateContestRow(String[] cols, String contestFilename) {
        if (cols == null || cols.length == 0) {
            this.getLog().info("No contest definition in file: " + contestFilename);
            return;
        }
        int row = this.contestsListbox.getIndexByKey(contestFilename);
        if (row == -1) {
            Object[] objects = cols;
            this.contestsListbox.addRow(objects, contestFilename);
        } else {
            Object[] objects = cols;
            this.contestsListbox.replaceRow(objects, row);
        }
        this.contestsListbox.autoSizeAllColumns();
    }

    @Override
    public String getPluginTitle() {
        return "Contest Preconfigured Loader Pane";
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout());
            this.buttonPanel.setPreferredSize(new Dimension(35, 35));
            this.buttonPanel.add((Component)this.getLoadButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = new JButton();
            this.loadButton.setText("Load");
            this.loadButton.setMnemonic(76);
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContestPreloadPane.this.loadSelectedContest();
                }
            });
        }
        return this.loadButton;
    }

    protected void loadSelectedContest() {
        if (this.getContestsListbox().getRowCount() < 1) {
            this.showMessage("No contests defined");
            return;
        }
        int selectedIndex = this.getContestsListbox().getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("Select a contest to load");
            return;
        }
        String filename = (String)this.getContestsListbox().getKeys()[selectedIndex];
        this.getController().getLog().info("Loading contest.yaml from " + filename);
        File file = new File(filename);
        String directoryName = file.getParent();
        IInternalContest newContest = null;
        String contestSummary = null;
        int result = 1;
        try {
            ContestYAMLLoader loader = new ContestYAMLLoader();
            newContest = loader.fromYaml(null, directoryName);
            contestSummary = new ContestComparison().getContestLoadSummary(newContest);
            result = FrameUtilities.yesNoCancelDialog(this, "Import" + NL + contestSummary, "Import Contest Settings");
        }
        catch (Exception e) {
            this.logException("Unable to load contest YAML from " + filename, e);
            e.printStackTrace();
            this.showMessage("Problem loading contest data file(s) - " + e.getMessage());
        }
        if (result != 0) {
            this.getLog().info("No YAML loaded from " + directoryName);
            return;
        }
        if (newContest != null) {
            ContestImporter contestImporter = new ContestImporter();
            try {
                contestImporter.sendContestSettingsToServer(this.getController(), this.getContest(), newContest);
            }
            catch (LoadContestDataException e) {
                this.logException("LoadContestDataException for " + filename, e);
                this.logNoteList(contestImporter.getNoteList());
                this.showMessage("Problem loading contest data file(s) - " + e.getMessage());
            }
        }
        this.showMessage("All contest settings sent to server" + NL + contestSummary);
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string, "Contest Load", 1);
    }
}

